/*  $Id: getconfig.c,v 1.5 1998/09/14 06:07:16 src Exp $
 *
 *  extracted from INN version 2.0
 *  Revision: 1.22
 *
 *  $Log: getconfig.c,v $
 *  Revision 1.5  1998/09/14 06:07:16  src
 *  Cleaned up dbz -Wall
 *
 *  Revision 1.4  1998/09/06 06:38:59  src
 *  Moved HAVE_LIBINN to Makefile.am, where it belongs
 *
 *  Revision 1.3  1998/07/12 09:39:19  src
 *  NewsX version 1.0
 */

#include <stdio.h>
#include <sys/types.h>
#include "configdata.h"

#if DBZ_VERSION==6 /*EK*/

#include "clibrary.h"
/* #include "paths.h" */
#include "libinn.h"
#include "macros.h"

/*  paths.h */
#define NAME_CONFIG             "/inn.conf"

#define _CONF_EXTENDEDDBZ       "extendeddbz"
#define _CONF_STORAGEAPI        "storageapi"

/* Global and initialized; to work around SunOS -Bstatic bug, sigh. */
STATIC char             ConfigBuff[SMBUF] = "";

struct conf_vars        *innconf = NULL;
char                    *innconffile = NULL;

void SetDefaults()
{
    innconf->storageapi = FALSE;
    innconf->extendeddbz = FALSE;
}

/*
   Make sure some compulsory inn.conf values are set and set them
   to defaults if possible 
*/
int CheckInnConf()
{
    return(0);
}

int ReadInnConf(void)
{
    FILE                *F;
    char                *p;
    int                 boolval;

    if (!innconffile) {
	char *s1 = NEWSLIB;
	char *s2 = NAME_CONFIG;
	innconffile = xmalloc(strlen(s1)+strlen(s2)+1);
	strcpy(innconffile,s1);
	strcat(innconffile,s2);
    }
    if (innconf != NULL) {
	 DISPOSE(innconf);
    }
    innconf = NEW(struct conf_vars, 1);
    SetDefaults();
    log_msg(L_DEBUGMORE, "reading INN config from %s", innconffile);
    /* Read the config file. */
    if ((F = fopen(innconffile, "r")) != NULL) {
	while (fgets(ConfigBuff, sizeof ConfigBuff, F) != NULL) {
	    if ((p = strchr(ConfigBuff, '\n')) != NULL)
		*p = '\0';
	    else
		ConfigBuff[sizeof(ConfigBuff)-1] = '\0';
	    if (ConfigBuff[0] == '\0' || ConfigBuff[0] == COMMENT_CHAR)
		continue;
	    if ((p = strchr(ConfigBuff, ':')) != NULL)
		*p++ = '\0';
	    else
		continue;
	    for ( ; ISWHITE(*p); p++)
		continue;
	    boolval = -1;
	    if (caseEQ(p, "on") || caseEQ(p, "true") || caseEQ(p, "yes"))
		boolval = TRUE;
	    if (caseEQ(p, "off") || caseEQ(p, "false") || caseEQ(p, "no"))
		boolval = FALSE;

	    if (EQ(ConfigBuff,_CONF_STORAGEAPI)) {
		if (boolval != -1) innconf->storageapi = boolval;
	    } else
	    if (EQ(ConfigBuff,_CONF_EXTENDEDDBZ)) {
		if (boolval != -1) innconf->extendeddbz = boolval;
	    }
	}
	if (innconf->storageapi != TRUE) innconf->extendeddbz = FALSE;
	log_msg(L_DEBUG, "INN extendeddbz == %d", innconf->extendeddbz);
	(void)fclose(F);
    } else {
	log_msg(L_ERR, "cannot open INN configuration in %s", innconffile); /*EK*/
	return(-1);
    }
    return(CheckInnConf());
}

#endif /* DBZ_VERSION==6 *EK*/
