/*
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "xchat.h"

void close_rawlog(GtkWidget *wid, struct server *serv)
{
   gtk_widget_destroy(serv->rawlog_window);
   serv->rawlog_window = 0;
}

void open_rawlog(struct server *serv)
{
   GtkWidget *hbox, *vscrollbar;
   
   if(serv->rawlog_window)
   {
      gtk_widget_destroy(serv->rawlog_window);
      serv->rawlog_window = 0;
      return;
   }
   
   serv->rawlog_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_usize(GTK_WIDGET(serv->rawlog_window), 450, 100);
   gtk_window_set_title(GTK_WINDOW(serv->rawlog_window), "X-Chat: Raw Log");
   gtk_signal_connect(GTK_OBJECT(serv->rawlog_window), "destroy",
                             GTK_SIGNAL_FUNC(close_rawlog), serv);
   
   hbox = gtk_hbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(serv->rawlog_window), hbox);
   gtk_widget_show(hbox);

   serv->rawlog_textlist = gtk_text_new(0, 0);
   gtk_text_set_word_wrap (GTK_TEXT(serv->rawlog_textlist), TRUE);
   gtk_text_set_editable (GTK_TEXT (serv->rawlog_textlist), FALSE);
   gtk_container_add(GTK_CONTAINER(hbox), serv->rawlog_textlist);
   gtk_widget_show(serv->rawlog_textlist); 

   vscrollbar = gtk_vscrollbar_new (GTK_TEXT(serv->rawlog_textlist)->vadj);
   gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);
   gtk_widget_show (vscrollbar);
   
   gtk_widget_show(serv->rawlog_window);
}

void add_rawlog(struct server *serv, char *text)
{
   if(serv->rawlog_window)
   {
      gtk_text_insert(GTK_TEXT(serv->rawlog_textlist), 0, 0, 0,  text, -1);
      gtk_text_insert(GTK_TEXT(serv->rawlog_textlist), 0, 0, 0,  "\n", 1);
   }
}
