/* filename: rlpr-rlpr.h
 * project: rlpr
 * author: meem  --  meem@sherilyn.wustl.edu
 * version: $Id: rlpr-rlpr.h,v 1.1 1997/02/22 08:59:22 meem Exp meem $
 * contents: headers for the `rlpr' client of the rlpr package
 *
 * Time-stamp: <1997/04/12 21:26:43 cdt -- meem@sherilyn.wustl.edu>
 */

#ifndef RLPR_RLPR_H
#define RLPR_RLPR_H

typedef struct rlpr_rlpr_info {
  char         filetype;             /* format of file to print            */
  int          fflag:1;              /* form feed after printing?          */
  int          mflag:1;              /* mail after printing?               */
  int          rflag:1;              /* remove file after printing?        */
  int          bflag:1;              /* burst page flag (1 = print it)     */
  int          wflag:1;              /* windows flag (for braindead lpd's) */
  char *       indent_cols;          /* # of columns to indent by (string) */
  char *       width;                /* width, also stored as a string     */
  unsigned int copies;               /* number of copies to print          */
  char *       class;                /* job classification on burst page   */
  char *       user;                 /* user name to print on burst page   */
  char *       job;                  /* job name to print on burst page    */
  char *       title;                /* title (optional for pr)            */
  char *       tmpdir;               /* this DOESN'T belong here...        */
} rlpr_rlpr_info;

/* exported functions */

/* control file routines */
void       rlpr_cf_add(char op, const char *s, int cfd);
void      rlpr_cf_init(int cfd, const char *filename);
void      rlpr_cf_send(int sockfd, int cfd, const char *cfname);

/* general */
int     rlpr_rlpr_args(int argc, char *argv[]);
void      rlpr_df_send(int sockfd, char *fname, const char *dfname);
void rlpr_send_job_req(int sockfd); 

#define DEFAULT_TMP_DIR        "/tmp"

#endif /* RLPR_RLPR_H */

