/*
 * Copyright (c) 1990,1994 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#ifndef VOLUME_H
#define VOLUME_H 1

#include <sys/cdefs.h>
#include <sys/types.h>
#include <netatalk/endian.h>

struct vol {
    struct vol		*v_next;
    char		*v_name;
    char		*v_path;
    struct dir		*v_dir, *v_did;
    int			v_flags;
#ifdef __svr4__
    int			v_qfd;
#endif /*__svr4__*/
    void		*v_gvs;
    u_int32_t		v_time;
    int			v_lastdid;
    u_int16_t		v_vid;
    void                *v_nfsclient;
    int                 v_nfs;
};

#ifdef NO_LARGE_VOL_SUPPORT
typedef u_int32_t VolSpace;
#else
typedef u_int64_t VolSpace;
#endif

extern struct vol	*getvolbyvid();
extern int              ustatfs_getvolspace __P((struct vol *, VolSpace *,
						 VolSpace *, u_int32_t *));
extern int              uquota_getvolspace __P((struct vol *, VolSpace *,
						VolSpace *, const u_int32_t));

#define AFPVOL_OPEN	(1<<0)
#define AFPVOL_DT	(1<<1)

#define AFPVOL_GVSMASK	(7<<2)
#define AFPVOL_NONE	(0<<2)
#define AFPVOL_AFSGVS	(1<<2)
#define AFPVOL_USTATFS	(2<<2)
#define AFPVOL_UQUOTA	(4<<2)

/* If I may be so bold...  Grab some unused flag bits to control
   behavior towards Apple 2 clients.  These are configured by placing
   a digit in [0..3] after the exported Apple name in AppleVolumes -
   delimited with whitespace.
 
   0 or none = Normal netatalk defaults
   1         = This volume to be compatible with ProDOS-8
   2         = Force all file and directory names to uppercase
               from clients point of view.  Note that this
 	       only really makes sense when the volume will
 	       not be shared with GSOS or Mac.
   3         = Both of the above..
 
   <shirsch@ibm.net> */
#define AFPVOL_A2MASK   (3<<5)
#define AFPVOL_A2VOL    (1<<5)
#define AFPVOL_TOUPPER  (2<<5)
 
/* the signature should be 3 for variable dids and not 2. (fyi, 1 is
 * for a flat filesystem) */
#define AFPVOLSIG_FLAT          0x0001
#define AFPVOLSIG_FIX	        0x0002
#define AFPVOLSIG_VAR           0x0003
#define AFPVOLSIG_DEFAULT       AFPVOLSIG_FIX

/* volume attributes */
#define VOLPBIT_ATTR_RO           (1 << 0)
#define VOLPBIT_ATTR_PASSWD       (1 << 1)
#define VOLPBIT_ATTR_FILEID       (1 << 2)
#define VOLPBIT_ATTR_CATSEARCH    (1 << 3)
#define VOLPBIT_ATTR_BLANKACCESS  (1 << 4)

#define VOLPBIT_ATTR	0
#define VOLPBIT_SIG	1
#define VOLPBIT_CDATE	2
#define VOLPBIT_MDATE	3
#define VOLPBIT_BDATE	4
#define VOLPBIT_VID	5
#define VOLPBIT_BFREE	6
#define VOLPBIT_BTOTAL	7
#define VOLPBIT_NAME	8
/* handle > 4GB volumes */
#define VOLPBIT_XBFREE  9
#define VOLPBIT_XBTOTAL 10
#define VOLPBIT_BSIZE   11        /* block size */

#endif
