#include <nwcalls.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifndef A_DONT_SUBALLOCATE
#define A_DONT_SUBALLOCATE  0x00000800L
#endif

#ifdef N_PLAT_DOS
#ifndef NTYPES_H
typedef unsigned int   nuint16;
#endif
typedef unsigned long  nuint32;
typedef unsigned int   nuint;
#define P08X	"(%08lX)"
#define P32U	"lu"
#else
#define stricmp(A,B) strcasecmp(A,B)
#define P08X	"(%08X)"
#define P32U	"u"
#endif

int opt_t = 0;
int opt_l = 0;
int opt_v = 0;

#ifdef N_PLAT_DOS
nuint32 ntohl(nuint32 v) {
  return ((v&0xFF)<<24) | ((v&0xFF00)<<8) | ((v>>8)&0xFF00) | ((v>>24)&0xFF);
}

void DSET_LH(unsigned char* ptr, int pos, nuint32 val) {
  *(nuint32*)(ptr+pos) = val;
}

void WSET_LH(unsigned char* ptr, int pos, nuint16 val) {
  *(nuint16*)(ptr+pos) = val;
}

nuint32 DVAL_LH(unsigned char* ptr, int pos) {
  return *(nuint32*)(ptr+pos);
}

nuint32 DVAL_HL(unsigned char* ptr, int pos) {
  return ntohl(*(nuint32*)(ptr+pos));
}

nuint16 WVAL_LH(unsigned char* ptr, int pos) {
  return *(nuint16*)(ptr+pos);
}
#endif

nuint32 read_dlh(void* ptr) {
  return DVAL_LH(ptr, 0);
}

nuint32 read_dhl(void* ptr) {
  return DVAL_HL(ptr, 0);
}

nuint16 read_wlh(void* ptr) {
  return WVAL_LH(ptr, 0);
}

void ncpb_add_byte(unsigned char** c, int v) {
  *(*c)++ = v;
}

void ncpb_add_word_lh(unsigned char** c, nuint v) {
  WSET_LH(*c, 0, v);
  (*c)+=2;
}

void ncpb_add_dword_lh(unsigned char** c, nuint32 v) {
  DSET_LH(*c, 0, v);
  (*c)+=4;
}

void ncpb_add_mem(unsigned char** c, void* s, size_t l) {
  memcpy(*c, s, l);
  *c+=l;
}

nuint16 ncpb_get_word_lh(unsigned char** c) {
  nuint16 tmp;
  tmp = WVAL_LH(*c, 0);
  (*c)+=2;
  return tmp;
}

nuint32 ncpb_get_dword_lh(unsigned char** c) {
  nuint32 tmp;
  tmp = DVAL_LH(*c, 0);
  (*c)+=4;
  return tmp;
}

nuint32 ncpb_get_dword_hl(unsigned char** c) {
  nuint32 ret = DVAL_HL(*c, 0);
  (*c) += sizeof(nuint32);
  return ret;
}

NW_ENTRY_INFO dosNS;
NW_ENTRY_INFO os2NS;
int os2Valid;
NW_ENTRY_INFO macNS;
int macValid;
NW_ENTRY_INFO nfsNS;
int nfsValid;

unsigned char buf[1024];
unsigned char buf2[1024];

NWCCODE NWNSEntryInfo2(NWCONN_HANDLE conn, nuint32 vol, nuint32 dosdir, nuint ns, nuint32 rim, NW_ENTRY_INFO* data) {
  unsigned char* c=buf2;
  NW_FRAGMENT rq;
  NW_FRAGMENT rp;
  NWCCODE err;

  ncpb_add_byte(&c, 0x06);	/* get NS entry info */
  ncpb_add_byte(&c, NW_NS_DOS);	/* namespace */
  ncpb_add_byte(&c, ns);		/* reserved */
  ncpb_add_word_lh(&c, SA_ALL);
  ncpb_add_dword_lh(&c, rim);
  ncpb_add_byte(&c, vol);
  ncpb_add_dword_lh(&c, dosdir);
  ncpb_add_byte(&c, 1);
  ncpb_add_byte(&c, 0);
  rq.fragAddress = buf2;		/* no path */
  rq.fragSize = c-buf2;
  rp.fragAddress = data;
  rp.fragSize = sizeof(*data);
  err = NWRequest(conn, 0x57, 1, &rq, 1, &rp);
  return err;
}

NWCCODE NWNSScanForTrustees(NWCONN_HANDLE conn, nuint32 vol, nuint32 dosdir, nuint32* iter, nuint* no_tstees, TRUSTEE_INFO* tstees) {
  unsigned char* c=buf2;
  NW_FRAGMENT rq;
  NW_FRAGMENT rp;
  NWCCODE err;
  nuint cnt;

  ncpb_add_byte(&c, 0x05);
  ncpb_add_byte(&c, NW_NS_DOS);
  ncpb_add_byte(&c, 0);		/* ?? */
  ncpb_add_word_lh(&c, SA_ALL);
  ncpb_add_dword_lh(&c, *iter);
  ncpb_add_byte(&c, vol);
  ncpb_add_dword_lh(&c, dosdir);
  ncpb_add_byte(&c, 1);
  ncpb_add_byte(&c, 0);
  rq.fragAddress = buf2;
  rq.fragSize = c-buf2;
  rp.fragAddress = buf;
  rp.fragSize = sizeof(buf);
  err = NWRequest(conn, 0x57, 1, &rq, 1, &rp);
  if (err) return err;
  c = buf;
  *iter = ncpb_get_dword_lh(&c);
  cnt = ncpb_get_word_lh(&c);
  if (cnt > *no_tstees)
    cnt=*no_tstees;	/* fault, too many trustees returned in one packet */
  else
    *no_tstees = cnt;
  while (cnt--) {
    tstees->objectID = ncpb_get_dword_hl(&c);
    tstees->objectRights = ncpb_get_word_lh(&c);
    tstees++;
  }
  return 0;
}

NWCCODE NWNSGetEffectiveRights(NWCONN_HANDLE conn, nuint32 vol, nuint32 dosdir, nuint16* eff) {
  unsigned char* c=buf2;
  NW_FRAGMENT rq;
  NW_FRAGMENT rp;
  NWCCODE err;

  ncpb_add_byte(&c, 0x1D);
  ncpb_add_byte(&c, NW_NS_DOS);
  ncpb_add_byte(&c, 0);		/* ?? */
  ncpb_add_word_lh(&c, SA_ALL);
  ncpb_add_dword_lh(&c, 0);	/* ReturnInfoMask=0, we are not interested in anything */
  ncpb_add_byte(&c, vol);
  ncpb_add_dword_lh(&c, dosdir);
  ncpb_add_byte(&c, 1);
  ncpb_add_byte(&c, 0);
  rq.fragAddress = buf2;
  rq.fragSize = c-buf2;
  rp.fragAddress = buf;
  rp.fragSize = sizeof(buf);
  err = NWRequest(conn, 0x57, 1, &rq, 1, &rp);
  if (err) return err;
  c = buf;
  *eff = ncpb_get_word_lh(&c);
  return 0;
}

char* createMask311(nuint mask) {
  static char r[9];

  r[0] = (mask&TR_SUPERVISOR) ?'S':'-';
  r[1] = (mask&TR_READ)       ?'R':'-',
  r[2] = (mask&TR_WRITE)      ?'W':'-',
  r[3] = (mask&TR_CREATE)     ?'C':'-',
  r[4] = (mask&TR_ERASE)      ?'E':'-',
  r[5] = (mask&TR_MODIFY)     ?'M':'-',
  r[6] = (mask&TR_SEARCH)     ?'F':'-',
  r[7] = (mask&TR_ACCESS_CTRL)?'A':'-',
  r[8] = 0;
  return r;
}

void doID(NWCONN_HANDLE conn, nuint32 id) {
  NWCCODE err;
  char user[256];	/* 49 is good enough */
  nuint16 type;

  if (opt_t) printf(P08X " ", id);
  if (!id) {
    printf("Nobody");
  } else {
#ifdef N_PLAT_DOS
    id = ntohl(id);
#endif
    err = NWGetObjectName(conn, id, user, &type);
    if (err) printf("Unknown:N/A");
    else {
      switch (type) {
	case OT_USER:       printf("User:");break;
	case OT_USER_GROUP: printf("Group:");break;
	case OT_FILE_SERVER:printf("FileServer:");break;
	default:            printf("Unknown(%04X):", type);break;
      }
      printf("%s", user);
    }
  }
}

void dodate(nuint date) {
  printf("%2u.%02u.%04u",
    date&0x1F,
    (date>>5)&0xF,
    (date>>9)+1980);
}

void dotime(nuint time) {
  printf("%2u:%02u:%02u",
    (time>>11),
    (time>>5)&0x3F,
    (time&0x1F)<<1);
}

void dodatesTimesID(NWCONN_HANDLE conn, nuint time, nuint date, nuint32 id) {
  dodate(date);
  printf(" ");
  dotime(time);
  printf(" ");
  doID(conn, id);
  printf("\n");
}

void dumpit(NWCONN_HANDLE conn, NW_ENTRY_INFO* info) {
  NWCCODE err;
  nuint32 dosNSattr;

  memcpy(&dosNS, info, sizeof(dosNS));
  if (read_dlh(&dosNS.attributes) & A_DIRECTORY) {
    printf("Directory:\n");
  } else {
    printf("File:\n");
  }
  dosNS.entryName[dosNS.nameLength] = 0;
  if (opt_v || opt_l) {
    err = NWNSEntryInfo2(conn, read_dlh(&dosNS.volNumber), read_dlh(&dosNS.DosDirNum), NW_NS_OS2, IM_NAME | IM_DIRECTORY, &os2NS);
    os2Valid = err==0;
    err = NWNSEntryInfo2(conn, read_dlh(&dosNS.volNumber), read_dlh(&dosNS.DosDirNum), NW_NS_MAC, IM_NAME | IM_DIRECTORY, &macNS);
    macValid = err==0;
    err = NWNSEntryInfo2(conn, read_dlh(&dosNS.volNumber), read_dlh(&dosNS.DosDirNum), NW_NS_NFS, IM_NAME | IM_DIRECTORY, &nfsNS);
    nfsValid = err==0;
  } else {
    os2Valid = 0;
    macValid = 0;
    nfsValid = 0;
  }
  if (os2Valid) {
    os2NS.entryName[os2NS.nameLength] = 0;
  }
  if (macValid) {
    macNS.entryName[macNS.nameLength] = 0;
  }
  if (nfsValid) {
    nfsNS.entryName[nfsNS.nameLength] = 0;
  }
  dosNSattr = read_dlh(&dosNS.attributes);
  printf("  DOS:  ");
  if (opt_t) printf(P08X " ", read_dlh(&dosNS.dirEntNum));
  printf("%s\n", dosNS.entryName);
  if (os2Valid) {
    printf(" OS/2:  ");
    if (opt_t) printf(P08X " ", read_dlh(&os2NS.dirEntNum));
    printf("%s\n", os2NS.entryName);
  }
  if (nfsValid) {
    printf("  NFS:  ");
    if (opt_t) printf(P08X " ", read_dlh(&nfsNS.dirEntNum));
    printf("%s\n", nfsNS.entryName);
  }
  if (macValid) {
    printf("  MAC:  ");
    if (opt_t) printf(P08X " ", read_dlh(&macNS.dirEntNum));
    printf("%s\n", macNS.entryName);
  }
  printf("\n");
  if (opt_v) {
    printf("Rights:\n");
    printf("  Inherited: ");
    if (opt_t) printf("(%04X) ", read_wlh(&dosNS.inheritedRightsMask));
    printf("[%s]\n", createMask311(read_wlh(&dosNS.inheritedRightsMask)));
    { nuint16 eff;

      if (!NWNSGetEffectiveRights(conn, read_dlh(&dosNS.volNumber), read_dlh(&dosNS.DosDirNum), &eff)) {
        printf("  Effective: ");
        if (opt_t) printf("(%04X) ", eff);
        printf("[%s]\n", createMask311(eff));
      }
    }
    printf("\n");
  }
  if (opt_l || opt_v) {
    printf("Owning namespace: ");
    if (opt_t) printf("(%" P32U ") ", read_dlh(&dosNS.NSCreator));
    switch (dosNS.NSCreator) {
      case NW_NS_DOS: printf("DOS\n"); break;
      case NW_NS_OS2: printf("OS/2\n"); break;
      case NW_NS_NFS: printf("NFS\n"); break;
      case NW_NS_MAC: printf("MAC\n"); break;
      case NW_NS_FTAM:printf("FTAM\n"); break;
      default:        printf("Unknown\n"); break;
    }
    printf("\n");
  }
  if (opt_v) {
    printf("Miscellaneous NetWare Information:\n");
    printf("  Last update:    ");
    dodatesTimesID(conn, read_wlh(&dosNS.modifyTime), read_wlh(&dosNS.modifyDate), read_dhl(&dosNS.modifierID));
    printf("  Last archived:  ");
    if (read_wlh(&dosNS.archiveTime) || read_wlh(&dosNS.archiveDate) || read_dhl(&dosNS.archiverID))
      dodatesTimesID(conn, read_wlh(&dosNS.archiveTime), read_wlh(&dosNS.archiveDate), read_dhl(&dosNS.archiverID));
    else
      printf("never\n");
    if (!(dosNSattr&A_DIRECTORY)) {
      printf("  Last accessed:  ");
      dodate(read_wlh(&dosNS.lastAccessDate));
      printf("\n");
    }
    printf("  Created/Copied: ");
    dodatesTimesID(conn, read_wlh(&dosNS.creationTime), read_wlh(&dosNS.creationDate), read_dhl(&dosNS.creatorID));
    printf("  Flags:          [%s%s%s%s]",
  	(dosNSattr&A_READ_ONLY     )?"Ro":"Rw",
  	(dosNSattr&A_SYSTEM        )?"Sy":"--",
  	(dosNSattr&A_HIDDEN        )?"H" :"-",
	(dosNSattr&A_NEEDS_ARCHIVED)?"A" :"-");
    printf(" [%s%s%s%s" "%s%s%s" "%s" "%s%s%s%s%s]",
	(dosNSattr&A_EXECUTE_ONLY  )?"X" :"-",
	(dosNSattr&A_TRANSACTIONAL )?"T" :"-",
	(dosNSattr&A_IMMEDIATE_PURGE)?"P":"-",
	(dosNSattr&A_SHAREABLE     )?"Sh":"--",

	(dosNSattr&A_DELETE_INHIBIT)?"Di":"--",
	(dosNSattr&A_COPY_INHIBIT  )?"Ci":"--",
	(dosNSattr&A_RENAME_INHIBIT)?"Ri":"--",

	(dosNSattr&A_DONT_COMPRESS )?"Dc":
	  (dosNSattr&A_IMMEDIATE_COMPRESS)?"Ic":"--",

	(dosNSattr&A_DONT_MIGRATE  )?"Dm":"--",
	(dosNSattr&A_DONT_SUBALLOCATE)?"Ds":"--",
	(dosNSattr&A_INDEXED       )?"I":"--",
	(dosNSattr&A_READ_AUDIT    )?"Ra":"--",
	(dosNSattr&A_WRITE_AUDIT   )?"Wa":"--");
    printf(" [%s%s]",
	(dosNSattr&A_FILE_COMPRESSED)?"Co":
	   (dosNSattr&A_CANT_COMPRESS)?"Cc":"--",
	(dosNSattr&A_FILE_MIGRATED )?"M":"-");
    if (opt_t) printf(" " P08X, dosNSattr);
    printf("\n");
    if (!(dosNSattr&A_DIRECTORY)) {
      printf("  File size:       %10" P32U, read_dlh(&dosNS.dataStreamSize));
      printf(" (allocated %" P32U ")\n", read_dlh(&dosNS.spaceAlloc));
    }
    printf("\n");
    {
      nuint32 iter = 0;
      int first = 1;

      while (1) {
        nuint tcount;
        nuint i;
        TRUSTEE_INFO tstees[40];
        tcount = 40;
        err = NWNSScanForTrustees(conn, read_dlh(&dosNS.volNumber), read_dlh(&dosNS.DosDirNum),
				&iter, &tcount, tstees);
        if (err) break;
        for (i=0; i<tcount; i++) {
  	  if (first) printf("Trustees:\n");
  	  first = 0;
	  printf("  [%s] ", createMask311(tstees[i].objectRights));
	  doID(conn, tstees[i].objectID);
	  printf("\n");
        }
        if (!first) printf("\n");
      } 
    }
  }
}

void listdir(NWCONN_HANDLE conn, nuint32 volume, nuint32 dirent, char* mask) {
  unsigned char* c=buf2;
  NW_FRAGMENT rq;
  NW_FRAGMENT rp;
  char xinfo[9];		/* key for findnext */
  NWCCODE err;
  size_t maskl = strlen(mask);

  ncpb_add_byte(&c, 0x02);	/* initialize NS search */
  ncpb_add_byte(&c, NW_NS_DOS);	/* namespace */
  ncpb_add_byte(&c, 0);		/* reserved */
  ncpb_add_byte(&c, volume);
  ncpb_add_dword_lh(&c, dirent);
  ncpb_add_byte(&c, 1);
  ncpb_add_byte(&c, 0);
  rq.fragAddress = buf2;		/* no path */
  rq.fragSize = c-buf2;
  rp.fragAddress = buf;
  rp.fragSize = sizeof(buf);
  err = NWRequest(conn, 0x57, 1, &rq, 1, &rp);
  if (err) {
    fprintf(stderr, "Unable to begin scandir: 0x%04X\n", err);
    return;
  }
  memcpy(xinfo, buf, sizeof(xinfo));
  while (1) {
    c=buf2;
    ncpb_add_byte(&c, 0x03);
    ncpb_add_byte(&c, NW_NS_DOS);
    ncpb_add_byte(&c, 0);
    ncpb_add_word_lh(&c, SA_ALL);
    ncpb_add_dword_lh(&c, IM_ALL);
    ncpb_add_mem(&c, xinfo, 9);
    ncpb_add_byte(&c, maskl);
    ncpb_add_mem(&c, mask, maskl);
    rq.fragSize = c-buf2;
    rp.fragSize = sizeof(buf);
    err = NWRequest(conn, 0x57, 1, &rq, 1, &rp);
    if (err) {
      if (err == 0x89FF) return;	/* end of directory */
      fprintf(stderr, "Unexpected error in NextDir: 0x%04X\n", err);
      return;
    }
    memcpy(xinfo, buf, sizeof(xinfo));
    dumpit(conn, (NW_ENTRY_INFO*)(buf+10));
  }
}

char volname[17];
char dirpath[512];
char fullpath[600];

NW_ENTRY_INFO dosNS2;

void usage(void) {
  fprintf(stderr, "NWDIR [options] [path]\n"
		  "\n"
		  "      -d    List information about directory itself instead\n"
		  "            of directory content\n"
                  "      -l    List namespace informations\n"
		  "      -v    Verbose listing\n"
		  "      -t    Technical - show values and their meaning\n"
		  "      -h    This help\n"
		  "      path  Path to list, can contain wildcards\n"
		  "\n"
		  "(c) 1998 Milan Vandrovec for ncpfs-2.0.12.8\n");
}

char dwild[200];

void makewild(char* wildout, const char* wildin) {
  unsigned char c;

  while ((c=*wildin++)!=0) {
    switch (c) {
#ifdef N_PLAT_DOS
      case '.':
#endif
      case '*':
      case '?':*wildout++ = '\377';
#ifdef N_PLAT_DOS
	       *wildout++ = c | 0x80;
#else
	       *wildout++ = c;
#endif
	       break;
     case 0xFF:*wildout++ = 0xFF;
       default:*wildout++ =c;
	       break;
    }
  }
  *wildout=0;
}

int main(int argc, char* argv[]) {
  NWCCODE err;
  NWCONN_HANDLE conn;
  char* path;
  char* xpath;
  char* lst;
  char* dpath;
  int wild;
  int opt_d = 0;
  int i;

  for (i=1; i<argc; i++) {
    if ((argv[i][0] != '-')
#ifdef N_PLAT_DOS
	 && (argv[i][0] != '/')
#endif
		) break;
    if (!stricmp(argv[i]+1, "d")) opt_d=1;
    else if (!stricmp(argv[i]+1, "l")) opt_l=1;
    else if (!stricmp(argv[i]+1, "t")) opt_t=1;
    else if (!stricmp(argv[i]+1, "v")) opt_v=1;
    else if (!stricmp(argv[i]+1, "h")) {
      usage();
      return 123;
    } else fprintf(stderr, "Warning: Unknown option `%s'\n", argv[i]);
  }
  if (i < argc) {
    path = argv[i++];
  } else {
    path = ".";
  }
  err = NWCallsInit(NULL, NULL);
  if (err) {
    fprintf(stderr, "Unable to initialize: 0x%04X\n", err);
    return 123;
  }
  xpath = path;
  lst = xpath;
  wild = 0;
  for (path=xpath; *path; path++) {
    switch (*path) {
#ifdef N_PLAT_DOS
      case '\\':
#endif
      case '/': lst=path; wild=0; break;
      case '?':
      case '*': wild=1; break;
      default:  break;
    }
  }
  if (wild) {
    if (lst == xpath) {
      makewild(dwild, lst);
      dpath = ".";
    } else {
      makewild(dwild, lst+1);
      dpath = xpath;
      lst[1] = 0;
    }
    opt_d = 0;
  } else {
    dpath = xpath;
    strcpy(dwild, "\377*");
  }
  err = NWParsePath(dpath, NULL, &conn, volname, dirpath);
  if (err) {
    if (err == 0x880F) {
      fprintf(stderr, "You are not attached to specified server\n");
    } else {
      fprintf(stderr, "Unable to parse path: 0x%04X\n", err);
    }
    return 123;
  }
  if (!conn) {
    fprintf(stderr, "Specified path is not remote\n");
    return 123;
  }
#ifdef N_PLAT_DOS
  xpath = (dirpath[0] == '\\')?dirpath+1:dirpath;
#else
  xpath = (dirpath[0] == '/')?dirpath+1:dirpath;
#endif
  for (path=xpath; *path; path++) {
    *path = toupper(*path);
  }
  sprintf(fullpath, "%s:%s", volname, xpath);
  printf("Directory %s\n", fullpath);

  err = NWGetNSEntryInfo(conn, 0, fullpath, NW_NS_DOS, NW_NS_DOS, SA_ALL, IM_ALL, &dosNS2);
  if (err) {
    fprintf(stderr, "Path does not exist: 0x%04X\n", err);
    return 123;
  }
  if ((read_dlh(&dosNS2.attributes)&A_DIRECTORY)&&(!opt_d)) {
    listdir(conn, read_dlh(&dosNS2.volNumber), read_dlh(&dosNS2.DosDirNum), dwild);
  } else {
    dumpit(conn, &dosNS2);
  }
  return 0;
}
