/* syshdrs.h
 * 
 * Copyright (c) 1992-1998 by Mike Gleason, NCEMRSoft.
 * All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 */

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#if defined(AIX) || defined(_AIX)
#	define _ALL_SOURCE 1
#endif

#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <netinet/in.h>
#include <arpa/inet.h>
#include <arpa/telnet.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <stdlib.h>
#include <ctype.h>
#include <signal.h>
#include <setjmp.h>
#include <stdarg.h>
#include <time.h>
#include <pwd.h>
#include <dirent.h>
#include <fcntl.h>

#ifdef HAVE_NET_ERRNO_H
#	include <net/errno.h>
#endif
#ifdef HAVE_ARPA_NAMESER_H
#	include <arpa/nameser.h>
#endif
#ifdef HAVE_RESOLV_H
#	include <resolv.h>
#endif
#ifdef CAN_USE_SYS_SELECT_H
#	include <sys/select.h>
#endif
#ifdef HAVE_UTIME_H
#	include <utime.h>
#else
	struct utimbuf { time_t actime, modtime; };
#endif

#ifdef HAVE_GETCWD
#	ifndef HAVE_UNISTD_H
		extern char *getcwd();
#	endif
#else
#	ifdef HAVE_GETWD
#		include <sys/param.h>
#		ifndef MAXPATHLEN
#			define MAXPATHLEN 1024
#		endif
		extern char *getwd(char *);
#	endif
#endif

#ifdef HAVE_LIBSOCKS5
#	define SOCKS 5
#	include <socks.h>
#endif

#include <Strn.h>			/* Library header. */
#include <ncftp.h>			/* Library header. */

/* eof */
