/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
*/

#include <stdio.h>
#include <string.h>
#include <syslog.h>

#include "mserver.h"

extern FILE *outsock;

void mserver_cinfo (char *name)
{
	int i, n;
	int found;

	char temp[1024];
	char value[1024];
	char cname[1024];

	fprintf (outsock,"BEGIN\n");

	found = false;
	config_getvalue("cname", temp, 1024);

	for (i = 0, n = 0; i < strlen(temp); i++, n++)
	{
		if (temp[i] == ',')
		{
			cname[n] = '\0';
			if (!strncmp(cname, name, 1024))
			{
				found = true;	
				break;
			}
			n = -1;
		}
		else
		{
			cname[n] = temp[i];
		}
	}
	cname[n] = '\0';
	if (!strncmp(cname, name, 1024))
		found = true;		

	if (!found)
	{
		fprintf(outsock, "ERROR: Unknown connection!\n");
		return;
	}

	fprintf(outsock, "NAME: %s\n", cname);
	snprintf(temp, 1024, "%s_info", cname);
	config_getvalue(temp, value, 1024);
	fprintf(outsock, "INFO: %s\n", value);
	snprintf(temp, 1024, "%s_script", cname);
	config_getvalue(temp, value, 1024);
	fprintf(outsock, "SCRIPT: %s\n", value);
	snprintf(temp, 1024, "%s_ipallow", cname);
	config_getvalue(temp, value, 1024);
	fprintf(outsock, "VALID ADDRESSES: %s\n", value);
	snprintf(temp, 1024, "%s_userallow", cname);
	config_getvalue(temp, value, 1024);
	fprintf(outsock, "VALID USERS: %s\n", value);
	
	fprintf(outsock,"END\n");
}
