/***

instances.c - handler routines for multiple IPTraf instances

Copyright (c) Gerard Paul Java 1998

This software is open source; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License in the included COPYING file for
details.

***/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "error.h"

void mark_facility(char *tagfile, char *facility)
{
    int fd;
    int resp;
    char errstring[80];
        
    fd = open(tagfile, O_CREAT | O_WRONLY | O_TRUNC, S_IRUSR | S_IWUSR);
    if (fd < 0) {
        sprintf(errstring, "Warning: unable to tag %s", facility);
        errbox(errstring, ANYKEY_MSG, &resp);
    }
    close(fd);
}

int facility_active(char *tagfile)
{
    int fd;
    
    fd = open(tagfile, O_RDONLY);
    
    if (fd < 0)
        return 0;
    else {
        close(fd);
        return 1;
    }
}
            
