/***

deskman.c - desktop management routines

Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997, 1998

This software is open source; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License in the included COPYING file for
details.

***/

#include <curses.h>
#include <panel.h>
#include <string.h>
#include "stdwinset.h"
#include "deskman.h"
#include "error.h"

/* Attribute variables */

int STDATTR;
int HIGHATTR;
int BOXATTR;
int BARSTDATTR;
int BARHIGHATTR;
int DESCATTR;
int PTRATTR;
int FIELDATTR;
int ERRBOXATTR;
int ERRTXTATTR;
int OSPFATTR;
int UDPATTR;
int IGPATTR;
int IGMPATTR;
int IGRPATTR;
int UNKNATTR;


/*  draw the basic desktop common to my screen-oriented programs */

void draw_desktop(void)
{
    int row;			/* counter for desktop construction */

    attrset(STDATTR);
    move(0, 0);
    printw("%80c", 32);		/* these two print the top n' bottom */
    move(LINES - 1, 0);
    printw("%80c", 32);		/* lines */

    attrset(FIELDATTR);

    for (row = 1; row <= LINES - 2; row++) {	/* draw the background */
	move(row, 0);
	printw("%80c", ' ');
    }

    refresh();
}

/* for some reason, the ncurses box routine does not color
   its inside.  it would therefore be better to call this
   routine before drawing the box.
 */

void colorwin(WINDOW * win)
{
    int ctr;
    char blankpad[81];

    strcpy(blankpad, "");

    for (ctr = 0; ctr <= win->_maxx; ctr++) {
	strcat(blankpad, " ");
    }

    scrollok(win, 0);
    for (ctr = 0; ctr <= win->_maxy; ctr++) {
	wmove(win, ctr, 0);
	wprintw(win, "%s", blankpad);
    }
    scrollok(win, 1);
}

void coloreol()
{
    char blankpad[81];
    int y, x;
    int i;

    strcpy(blankpad, "");
    getyx(stdscr, y, x);

    for (i = x; i <= 79; i++)
	strcat(blankpad, " ");

    printw(blankpad);
}

void about()
{
    WINDOW *win;
    PANEL *panel;
    int ch;

    win = newwin(15, 50, 5, 15);
    panel = new_panel(win);

    stdwinset(win);
    wtimeout(win, -1);
    wattrset(win, BOXATTR);
    colorwin(win);
    box(win, ACS_VLINE, ACS_HLINE);
    wattrset(win, STDATTR);
    wmove(win, 1, 2);
    wprintw(win, "IPTraf");
    wmove(win, 2, 2);
    wprintw(win, "An IP Network Statistics Utility");
    wmove(win, 3, 2);
    wprintw(win, "Version %s", VERSION);
    wmove(win, 5, 2);
    wprintw(win, "Written by Gerard Paul Java");
    wmove(win, 6, 2);
    wprintw(win, "Copyright (c) Gerard Paul Java 1997, 1998");
    wmove(win, 8, 2);
    wprintw(win, "This program is distributed under the terms of");
    wmove(win, 9, 2);
    wprintw(win, "the GNU General Public License Version 2 or");
    wmove(win, 10, 2);
    wprintw(win, "any later version. See the included COPYING");
    wmove(win, 11, 2);
    wprintw(win, "file for details.");

    wattrset(win, HIGHATTR);
    wmove(win, 13, 2);
    wprintw(win, "Press any key to continue.");

    update_panels();
    doupdate();

    ch = wgetch(win);

    del_panel(panel);
    delwin(win);
    update_panels();
    doupdate();
}

void masq_warning(void)
{
    WINDOW *win;
    PANEL *panel;

    win = newwin(11, 50, 7, 15);
    panel = new_panel(win);

    stdwinset(win);
    wtimeout(win, -1);
    wattrset(win, ERRBOXATTR);
    colorwin(win);
    box(win, ACS_VLINE, ACS_HLINE);
    wattrset(win, ERRTXTATTR);
    mvwprintw(win, 1, 2, "This computer is running with IP Masquerading");
    mvwprintw(win, 2, 2, "enabled.  The various facilities may give");
    mvwprintw(win, 3, 2, "strange results because of the translation of");
    mvwprintw(win, 4, 2, "the packets' IP addresses.  You will get");
    mvwprintw(win, 5, 2, "better results if you run IPTraf on the");
    mvwprintw(win, 6, 2, "network segments connected to this machine,");
    mvwprintw(win, 7, 2, "but not on this machine itself.");
    wattrset(win, ERRBOXATTR);
    mvwprintw(win, 9, 2, ANYKEY_MSG);

    wgetch(win);
    
    del_panel(panel);
    delwin(win);
    update_panels(); doupdate();
}

void printnomem()
{
    move(0, 68);
    attrset(ERRTXTATTR);
    printw(" Memory Low ");
}

void printipcerr()
{
    move(0, 68);
    attrset(ERRTXTATTR);
    printw("  IPC Error ");
}

void printkeyhelp(char *keytext, char *desc, WINDOW * win)
{
    wattrset(win, HIGHATTR);
    wprintw(win, "%s", keytext);
    wattrset(win, STDATTR);
    wprintw(win, "%s", desc);
}

void stdkeyhelp(WINDOW * win)
{
    printkeyhelp("Enter", "-accept  ", win);
    printkeyhelp("Ctrl+X", "-cancel", win);
}

void stdexitkeyhelp()
{
    printkeyhelp("X/Ctrl+X", "-Exit", stdscr);
    coloreol(stdscr);
}

void scrollkeyhelp()
{
    printkeyhelp("Up/Down/PgUp/PgDn", "-scroll window  ", stdscr);
}

void menukeyhelp()
{
    move(LINES - 1, 1);
    printkeyhelp("Up/Down", "-Move selector  ", stdscr);
    printkeyhelp("Enter", "-execute", stdscr);
    coloreol(stdscr);
}

void listkeyhelp()
{
    move(LINES - 1, 1);
    printkeyhelp("Up/Down", "-Move pointer  ", stdscr);
    printkeyhelp("Enter", "-Select  ", stdscr);
    stdexitkeyhelp();
}

void tabkeyhelp(WINDOW * win)
{
    printkeyhelp("Tab", "-next field  ", win);
}

void indicate(char *message)
{
    move(LINES - 1, 1);
    attrset(STDATTR);
    printw("%79c", ' ');
    move(LINES - 1, 1);
    printw(message);
    refresh();
}

void printlargenum(unsigned long long i, WINDOW *win)
{
    if (i < 100000000)              /* less than 100 million */
        wprintw(win, "%9llu", i);
    else if (i < 1000000000)	   /* less than 1 billion */
        wprintw(win, "%8lluK", i / 1000);
    else if (i < 100000000000ULL)     /* less than 100 billion */
        wprintw(win, "%8lluM", i / 1000000);
    else if (i < 100000000000000ULL)  /* less than 100 trillion */
        wprintw(win, "%8lluG", i / 1000000000ULL);
    else
        wprintw(win, "%8lluT", i / 1000000000000ULL);
}
        
void standardcolors(int color)
{
    if ((color) && (has_colors())) {
	init_pair(1, COLOR_BLUE, COLOR_WHITE);
	init_pair(2, COLOR_BLACK, COLOR_CYAN);
	init_pair(3, COLOR_CYAN, COLOR_BLUE);
	init_pair(4, COLOR_YELLOW, COLOR_RED);
	init_pair(5, COLOR_WHITE, COLOR_RED);
	init_pair(6, COLOR_BLUE, COLOR_CYAN);
	init_pair(7, COLOR_BLUE, COLOR_WHITE);
	init_pair(9, COLOR_RED, COLOR_WHITE);
	init_pair(10, COLOR_GREEN, COLOR_BLUE);
	init_pair(11, COLOR_CYAN, COLOR_BLACK);
	init_pair(12, COLOR_RED, COLOR_CYAN);
	init_pair(14, COLOR_YELLOW, COLOR_BLUE);
	init_pair(15, COLOR_YELLOW, COLOR_BLACK);
	init_pair(16, COLOR_WHITE, COLOR_CYAN);
	init_pair(17, COLOR_YELLOW, COLOR_CYAN);

	STDATTR = COLOR_PAIR(14) | A_BOLD;
	HIGHATTR = COLOR_PAIR(3) | A_BOLD;
	BOXATTR = COLOR_PAIR(3);
	BARSTDATTR = COLOR_PAIR(15) | A_BOLD;
	BARHIGHATTR = COLOR_PAIR(11) | A_BOLD;
	DESCATTR = COLOR_PAIR(2);
	PTRATTR = COLOR_PAIR(10) | A_BOLD;
	FIELDATTR = COLOR_PAIR(1);
	ERRBOXATTR = COLOR_PAIR(5) | A_BOLD;
	ERRTXTATTR = COLOR_PAIR(4) | A_BOLD;
	OSPFATTR = COLOR_PAIR(2);
	UDPATTR = COLOR_PAIR(9);
	IGPATTR = COLOR_PAIR(12);
	IGMPATTR = COLOR_PAIR(10) | A_BOLD;
	IGRPATTR = COLOR_PAIR(16) | A_BOLD;
	UNKNATTR = COLOR_PAIR(4) | A_BOLD;
    } else {
	STDATTR = A_NORMAL;
	HIGHATTR = A_REVERSE;
	BOXATTR = A_NORMAL;
	BARSTDATTR = A_REVERSE;
	BARHIGHATTR = A_BOLD;
	DESCATTR = A_NORMAL;
	PTRATTR = A_BOLD;
	FIELDATTR = A_REVERSE;
	ERRBOXATTR = A_BOLD;
	ERRTXTATTR = A_NORMAL;
	OSPFATTR = A_REVERSE;
	UDPATTR = A_BOLD;
	IGPATTR = A_REVERSE;
	IGMPATTR = A_REVERSE;
	IGRPATTR = A_REVERSE;
	UNKNATTR = A_BOLD;
    }
}
