/*
 * rtm_map.c
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *
 * Authors:	Alexey Kuznetsov, <kuznet@ms2.inr.ac.ru>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>

#include "utils.h"

char *rttable_name(int id)
{
	static char buf[64];
	switch (id) {
	case RT_TABLE_UNSPEC:
		return "none";
	case RT_TABLE_MAIN:
		return "main";
	case RT_TABLE_LOCAL:
		return "local";
	case RT_TABLE_DEFAULT:
		return "default";
	default:
		sprintf(buf, "%d", id);
		return buf;
	}
}

char *rtprot_name(int id)
{
	static char buf[64];
	switch (id) {
	case RTPROT_UNSPEC:
		return "none";
	case RTPROT_REDIRECT:
		return "redirect";
	case RTPROT_STATIC:
		return "static";
	case RTPROT_KERNEL:
		return "kernel";
	case RTPROT_BOOT:
		return "remnant";
	case RTPROT_RA:
		return "ra";
	case RTPROT_GATED:
		return "gated";
	case RTPROT_MRT:
		return "mrt";
	case RTPROT_ZEBRA:
		return "zebra";
	default:
		sprintf(buf, "%d", id);
		return buf;
	}
}

char *rtscope_name(int id)
{
	static char buf[64];
	switch (id) {
	case RT_SCOPE_UNIVERSE:
		return "universe";
	case RT_SCOPE_SITE:
		return "site";
	case RT_SCOPE_LINK:
		return "link";
	case RT_SCOPE_HOST:
		return "host";
	case RT_SCOPE_NOWHERE:
		return "nowhere";
	default:
		sprintf(buf, "%d", id);
		return buf;
	}
}

char *rtntype_name(int id)
{
	static char buf[64];
	switch (id) {
	case RTN_UNSPEC:
		return "none";
	case RTN_UNICAST:
		return "unicast";
	case RTN_LOCAL:
		return "local";
	case RTN_BROADCAST:
		return "broadcast";
	case RTN_ANYCAST:
		return "anycast";
	case RTN_MULTICAST:
		return "multicast";
	case RTN_BLACKHOLE:
		return "blackhole";
	case RTN_UNREACHABLE:
		return "unreachable";
	case RTN_PROHIBIT:
		return "prohibit";
	case RTN_THROW:
		return "throw";
	case RTN_NAT:
		return "nat";
	case RTN_XRESOLVE:
		return "xresolve";
	default:
		sprintf(buf, "%d", id);
		return buf;
	}
}
