/*
 * ip.c		"ip" utility frontend.
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *
 * Authors:	Alexey Kuznetsov, <kuznet@ms2.inr.ac.ru>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>

#include "utils.h"

int preferred_family = AF_UNSPEC;
int show_stats = 0;

static void usage(void)
{
	fprintf(stderr, "Usage: ip [ OPTIONS ] OBJECT { COMMAND | help }\n"
	                "where  OBJECT := { link | addr | route | rule | neigh | tunnel }\n"
	                "       OPTIONS := { -s[tatistics] | -f[amily] { inet | inet6 }}\n");
	exit(-1);
}

int main(int argc, char **argv)
{
	char *basename;

	basename = strrchr(argv[0], '/');
	if (basename == NULL)
		basename = argv[0];
	else
		basename++;
	
	while (argc > 1) {
		if (argv[1][0] != '-')
			break;
		if (matches(argv[1], "-family") == 0) {
			argc--;
			argv++;
			if (argc <= 1)
				usage();
			if (strcmp(argv[1], "inet") == 0)
				preferred_family = AF_INET;
			else if (strcmp(argv[1], "inet6") == 0)
				preferred_family = AF_INET6;
			else
				usage();
		} else if (matches(argv[1], "-stats") == 0 ||
			   matches(argv[1], "-statistics") == 0) {
			++show_stats;
		} else
			usage();
		argc--;	argv++;
	}

	if (argc > 1) {
		if (matches(argv[1], "address") == 0)
			return do_ipaddr(argc-2, argv+2);
		if (matches(argv[1], "route") == 0)
			return do_iproute(argc-2, argv+2);
		if (matches(argv[1], "rule") == 0)
			return do_iprule(argc-2, argv+2);
		if (matches(argv[1], "neighbor") == 0 ||
		    matches(argv[1], "neighbour") == 0)
			return do_ipneigh(argc-2, argv+2);
		if (matches(argv[1], "link") == 0)
			return do_iplink(argc-2, argv+2);
		if (matches(argv[1], "tunnel") == 0)
			return do_iptunnel(argc-2, argv+2);
		if (matches(argv[1], "monitor") == 0)
			return do_ipmonitor(argc-2, argv+2);
		if (matches(argv[1], "help") == 0)
			usage();
	}

	if (strcmp(basename, "ipaddr") == 0)
		return do_ipaddr(argc-1, argv+1);
	if (strcmp(basename, "iproute") == 0)
		return do_iproute(argc-1, argv+1);
	if (strcmp(basename, "iprule") == 0)
		return do_iprule(argc-1, argv+1);
	if (strcmp(basename, "ipneigh") == 0)
		return do_ipneigh(argc-1, argv+1);
	if (strcmp(basename, "iplink") == 0)
		return do_iplink(argc-1, argv+1);
	if (strcmp(basename, "iptunnel") == 0)
		return do_iptunnel(argc-1, argv+1);
	if (strcmp(basename, "ipmonitor") == 0)
		return do_ipmonitor(argc-1, argv+1);

	usage();
}
