#include "tcplog.h"
#ifndef NOFILE
#define NOFILE 1024
#endif

int     go_background(void);
char   *hostlookup(__u32);
char   *servlookup(unsigned short);
extern char *get_rfc1413_data(int, int, __u32, char *);

struct ippkt {
	struct iphdr ip;
	struct tcphdr tcp;
	char    buffer[10000];
};

int     main(void)
{
	int     s;
	int     i, status;
	char    tmpbuff[1024];
	int     forkstat;
	char    remote_addr[1024];
	struct ippkt pkt, opkt;

	setuid(0);
	if (geteuid() != 0) {
		printf("This program requires root privledges\n");
		exit(0);
	}
	go_background();
	s = socket(AF_INET, SOCK_RAW, 6);

	while (1) {
		read(s, (struct ippkt *) &pkt, 9999);
		if (pkt.tcp.syn == 1 && pkt.tcp.ack == 0) {
			if (!fork()) { /* double fork()    */
				if (!fork()) {	/* to avoid zombies */
					openlog("tcplogd", 0, LOG_DAEMON);
					strcpy(remote_addr, hostlookup(pkt.ip.saddr));
					if (ntohs(pkt.tcp.dest) != 113)
						ident_user = get_rfc1413_data(ntohs(pkt.tcp.source), ntohs(pkt.tcp.dest), pkt.ip.saddr, hostlookup(pkt.ip.daddr));
					else
						ident_user = remote_addr;

					if (ntohs(pkt.tcp.source) == 20 && ntohs(pkt.tcp.dest) < 1024)
						syslog(LOG_NOTICE, "FTPBounce attack detected from %s", ident_user);
					syslog(LOG_NOTICE, "%s connection attempt from %s", servlookup(pkt.tcp.dest), ident_user);
					free(ident_user);
					closelog();
					exit(0);
				}
				exit(0);
			} else
				wait(&status);
		}
	}
}

int     go_background(void)
{
	int     fd;
	int     fs;

	if (getppid() != 1) {
		signal(SIGTTOU, SIG_IGN);
		signal(SIGTTIN, SIG_IGN);
		signal(SIGTSTP, SIG_IGN);
		fs = fork();
		if (fs < 0) {
			perror("fork");
			exit(1);
		}
		if (fs > 0)
			exit(0);
		setpgrp();
		fd = open("/dev/tty", O_RDWR);
		if (fd >= 0) {
			ioctl(fd, TIOCNOTTY, (char *) NULL);
			close(fd);
		}
	}
	for (fd = 0; fd < NOFILE; fd++)
		close(fd);
	errno = 0;
	chdir("/");
	umask(0);
}

char   *
        hostlookup(__u32 in)
{
	static char blah[1024];
	struct in_addr i;
	struct hostent *he;

	i.s_addr = in;
	he = gethostbyaddr((char *) &i, sizeof(struct in_addr), AF_INET);

	if (he == NULL)
		strcpy(blah, inet_ntoa(i));
	else
		strcpy(blah, he->h_name);
	return blah;
}

char   *
        servlookup(unsigned short port)
{
	struct servent *se;
	static char buff[1024];

	se = getservbyport(port, "tcp");
	if (se == NULL)
		sprintf(buff, "port %d", ntohs(port));
	else
		sprintf(buff, "%s", se->s_name);
	return buff;
}
