/*
 * CFGFILE	A configuration file reading module used by the DLCI and FRAD
 *              setup programs.
 *
 * Version:	@(#)cfgfile.c	0.25	11 Mar 1996
 *
 * Author:	Mike McLagan <mike.mclagan@linux.org>
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <malloc.h>
#include <ctype.h>

#include "cfgfile.h"

typedef struct _key
{
   char        *key;
   char        *value;
   struct _key *next;
} KEYS;

typedef struct _conf
{
   char         *app;
   KEYS         *keys;
   struct _conf *next;
}
CONF;

int isnumeric(char *line)
{
   int iRet;

   iRet = 0;

   if (*line)
   {
      if ((*line == '-') || (*line == '+'))
         line++;

      while (isdigit(*line))
         line++;

      iRet = *line == 0;
   }

   return(iRet);
}

int ishex(char *line)
{
   int iRet;

   iRet = 0;

   if (*line)
   {
      while (isxdigit(*line))
         line++;

      iRet = *line == 0;
   }

   return(iRet);
}

void *config_read(char *filename)
{
   FILE *cf;
   CONF *conf;
   CONF *cnode, *clast;
   KEYS *knode, *klast;
   char line[257], *temp, *temp2, *temp3;
   int  num;

   conf  = NULL;
   cnode = clast = NULL;
   knode = klast = NULL;

   cf = fopen(filename, "r");
   if (!cf)
   { 
      printf("Can't find config file %s.\n", filename);
      return(NULL);
   }
 
   num = 0;
   line[0] = '*';  /* this stops the space searchers from going too far */

   while (fgets(&line[1], sizeof(line) - 1, cf) != NULL)
   {
      num++;
      temp = &line[1];

      if (*temp == '#')
         continue;

      temp = strchr(temp, '#');
      if (temp)
         *temp = 0;
 
      temp = &line[1];
      while ((*temp == ' ') || (*temp == '\t'))
         temp++;

      temp2 = temp + strlen(temp) - 1;
      while ((*temp2 == ' ') || (*temp2 == '\t') || (*temp2 == '\n'))
          *temp2-- = 0;

      if (!*temp)		/* ignore blanks */
         continue;
      
      if (*temp == '[')
      {
         temp++;
         temp2 = strchr(temp, ']');
         if (!temp2)
         {
            printf("Config line #%i missing ].\n", num);
            return(NULL);
         }
         *temp2-- = 0;
         if (*(temp2 + 2))
         {
            printf("Junk after ] in line #%i.\n", num);
            return(NULL);
         }

         while ((*temp2 == ' ') || (*temp2 == '\t'))
            *temp2-- = 0;

         if (!*temp)
         {
            printf("Missing APP on line #%i.\n", num);
            return(NULL);
         }

         for(cnode = conf;cnode;cnode=cnode->next)
            if (strcasecmp(cnode->app, temp) == 0)
            {
               printf("Duplicate APP values in line #%i.\n", num);
               return(NULL);
            }

         cnode = malloc(sizeof(CONF));
         memset(cnode, 0, sizeof(CONF));

         cnode->app = malloc(strlen(temp) + 1);
         strcpy(cnode->app, temp);

         if (!clast)
            conf = clast = cnode;
         else
         {
            clast->next = cnode;
            clast = cnode;
         }

         klast = knode = NULL;
      }
      else
         if ((temp2 = strchr(temp, '=')) != NULL)
         {
            if (!cnode)
            {
               printf("No APP value specified by line #%i.\n", num);
               return(NULL);
            }

            temp3 = temp2 - 1;
            while ((*temp3 == ' ') || (*temp3 == '\t'))
               *temp3-- = 0;

            *temp2++ = 0;
            while ((*temp2 == ' ') || (*temp2 == '\t'))
              temp2++;

            if (!*temp)
            {
               printf("Missing KEY on line #%i.\n", num);
               return(NULL);
            }

            if (!*temp2)
            {
               printf("Missing VALUE on line #%i.\n", num);
               return(NULL);
            }

            for(knode=cnode->keys;knode;knode=knode->next)
               if (strcasecmp(knode->key, temp) == 0)
               {
                  printf("Duplicate KEY on line #%i.\n", num);
                  return(NULL);
               }

            knode = malloc(sizeof(KEYS));
            memset(knode, 0, sizeof(KEYS));
            knode->key = malloc(strlen(temp) + 1);
            strcpy(knode->key, temp);
            knode->value = malloc(strlen(temp2) + 1);
            strcpy(knode->value, temp2);

            if (!klast)
               cnode->keys = klast = knode;
            else
            {
               klast->next = knode;
               klast = knode;
            }
         }
         else
         {
            printf("Invalid config line #%i.\n", num);
            return(NULL);
         }
   }

   fclose(cf);

   if (!conf)
      printf("Invalid config file %s.\n", filename);

   return(conf);
}

void config_clean(void *param)
{
   CONF *conf;
   CONF *cnode;
   KEYS *knode;

   conf = param;
   while (conf)
   {
      while(conf->keys)
      {
         knode = conf->keys;
         conf->keys = knode->next;
         free(knode);
      }
      cnode = conf;
      conf = conf->next;
      free(cnode);
   }
}

CONF *config_find(CONF *conf, char *app)
{
   CONF *cnode;

   for (cnode = conf; cnode; cnode=cnode->next)
      if (strcasecmp(app, cnode->app) == 0)
         break;

   return(cnode);
}

KEYS *config_lookup(CONF *conf, char *app, char *key)
{
   CONF *cnode;
   KEYS *knode;

   knode = NULL;
   cnode = config_find(conf, app);
   if (cnode)
      for (knode = cnode->keys; knode; knode=knode->next)
         if (strcasecmp(key, knode->key) == 0)
            break;

   return(knode);
}

char *config_value(void *param, char *app, char *key)
{
   CONF *conf;
   KEYS *knode;
 
   conf = param;
   knode = config_lookup(conf, app, key);

   return(knode ? knode->value : NULL);
}
