/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */


#include "myheader.h"
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include "myerrors.h"
 
char *gs_err_msgs[] = {
   "Completed Successfully",
   "Hey! I can't create any temporary files! I'm outta here...",
   "Hey! I can't create any new chart files! I'm outta here...",
   "Hey! There were some errors during the import. Check the error log for the details pal..",
   "Hey! I can't open my error log! I'm outta here...",
   "Hey! I can't open the file to import! I'm outta here...",
   "You gotta select something first pal...",
   "Nope, try another selection...",
   "No way, that selection is already there...",
   "You gotta enter something first pal...",
   "Whatever you entered was bogus, try again pal...",
   "You gotta select something to insert first pal...",
   "You gotta select a place to insert pal...",
   "Whoa! For some reason, I can't open that group...",
   "The group you selected is empty, there's nothing to see here...",
   "Hey! For some reason, I can't open that chart...",
   "Whoa! For some reason, I can't create that file...",
   "Whatever you entered for date has got some bogus stuff in there...",
   "You gotta have at least 8 characters for the date pal...",
   "You gotta put a date in there first pal...",
   "Hey, my data directory is either empty or mising! That's it, I'm outta here...",
   "Hey, my group directory is either empty or missing! That's it, I'm outta here...",
   "Whatever you entered for moving average value was bogus, try again pal...",
   "Whatever you entered for net change was bogus, try again pal...",
   "Whatever you entered for volume net change was bogus, try again pal...",
   "Whatever you entered for threshold was bogus, try again pal...",
   "Can't delete the only record left.",
   "Export complete.",
   "Indicator already exists, only one of each alowed.",
   "Sorry, the indicator limit has been reached.",
   "LAST ERROR MESSAGE, you should never see this!"};

	

/*** help messages ***/
char *text1 =
"Main Screen:\n"
"============\n"
"\n"
"When you start gstalker, you are presented with the main screen. It will try to load the\n"
"the group that was active the last time you used gstalker, if there was none, then no charts\n"
"will be displayed on start up. The main screen consists of from top to bottom,\n"
"pulldown menus, buttonbar, chart stats bar, the chart area, chart data bar.\n"
"\n"
"Pulldown Menu:\n"
"--------------\n"
"The pulldown menus gives mouse access to all of the functions available in gstalker.\n"
"\n"
"Buttonbar:\n"
"----------\n"
"The buttonbar gives quick access to most of the major functions in gstalker. Briefly they are\n"
"from left to right;\n"
"\n"
"Work with Charts\n"
"Work with Groups\n"
"Previous Chart\n"
"Goto Chart\n"
"Next Chart\n"
"Compress Chart\n"
"Expand Chart\n"
"Edit Chart Indicators\n"
"Edit Alerts\n"
"Alert Scan\n"
"Update Quotes\n"
"View Data Window\n"
"Toggle Chart Grid\n"
"Toggle Chart Style\n"
"Toggle Volume Indicator\n"
"\n"
"Chart Stats:\n"
"------------\n"
"This area gives some details on the currently loaded chart. They are;\n"
"CH= is the all time high for the data contained in the chart.\n"
"CL= is the all time low for the data contained in the chart.\n"
"LD= is the last date for the chart.\n"
"LC= is the last close value for the chart.\n"
"NC= is the net change in value since the previous close.\n"
"\n"
"Chart Area:\n"
"-----------\n"
"This is where all the chart indicators and plots will be drawn.\n"
"\n"
"Chart Data:\n"
"-----------\n"
"This is an updated display of the data contained in the chart relative to the position\n"
"of the mouse inside the chart area. If the volume indicator is active, and the mouse\n"
"enters the volume area, you will see the data be displayed for volume. Another feature\n"
"is if you left click and hold with the mouse anywhere in the chart area, you will see\n"
"the exact price level be displayed in the data display and not the actual close data.\n"
"This is useful for gauging the scale of moves on the chart so that you can note stops\n"
"and trendlines.\n\n";

char *text2 =
"File Menu:\n"
"==========\n"
"\n"
"New Group:\n"
"----------\n"
"This will create a new group in which to associate individual charts. Just enter the name\n"
"of the group you would like to create and pressing ok will do it.\n"
"\n"
"Work With Groups:\n"
"---------------\n"
"This window gives the ability to perform functions that apply to chart groups. There is\n"
"a button on the button bar for this function. By highlighting a group from the list you can:\n"
"\n"
"Open:\n"
"Open a chart group for viewing. This will load all the charts that are associated with\n"
"a group you have created. By default, the first chart in the group will be displayed.\n"
"If the group has no charts associated, then an message will be displayed warning you.\n"
"The [group name], chart symbol and (chart name) will be displayed in the titlebar window that\n"
"gstalker is running in. eg [nasdaq] - redhat (Red Hat Software).\n"
"\n"
"Edit:\n"
"This gives you the ability to edit an existing chart group. By clicking this button\n"
"an edit window will appear. The edit group window displays on the left, a list of all the\n"
"charts in the gstalker database. The list on the right displays the current contents of\n"
"the group being edited. The buttons in the middle allow for editing functions. The insert\n"
"button will insert the highlighted selection from the chart list and place it above the\n"
"highlighted selection in the group contents list. The add button will append the highlighted\n"
"selection in the chart list to the end of the group contents list. The delete button will\n"
"delete the highlighted selection from the group contents list. The ok button will save the\n"
"changes and exit the edit window. The cancel button will not undo any changes, but just\n"
"exits without saving changes.\n"
"\n"
"Rename:\n"
"This allows you to rename an existing group, by clicking this button, a new window will\n"
"appear and let you enter in the new name for the selected group.\n"
"\n"
"Delete:\n"
"Obviously, by clicking on this button, the group highlighted in the list will be\n"
"permanently deleted from the group list, once done, there is no way to undelete it.\n"
"\n"
"Cancel:\n"
"This just exits from the work with groups window, it does not reverse any changes\n"
"that may have be made prior to clicking this button.\n"
"\n"
"Work With Charts:\n"
"----------------\n"
"This window gives the ability to perform functions that apply to individual charts. There is\n"
"a button on the button bar for this function. By highlighting a chart from the list you can:\n"
"\n"
"Open:\n"
"Opens a single chart for viewing. The chart symbol and (chart name) will be displayed in the\n"
"titlebar window that gstalker is running in. eg redhat (Red Hat Software).\n"
"\n"
"Edit:\n"
"This gives you the ability to edit the data of an existing chart. By clicking this button\n"
"an edit chart window will appear. All fields can be manually edited except the curent record\n"
"and date fields. The buttons allow for navigating through the data and saving changes. The\n"
"first button brings you to the first record in the chart. The next button advances forward\n"
"one record. The back button retreats one record. The end button skips to the last record.\n"
"\n"
"The save button saves the changes made to the current record. The delete button will delete\n"
"permanently the current record. The close button will exit without saving changes. If you\n"
"make changes to a record and move to another one without saving, the changes will be lost.\n"
"The Goto button allows you to jump to particular record number. A dialog will pop up asking\n"
"you for the record number to goto. Entering an invalid record number will do nothing, the\n"
"dialog will stay displayed until you press the cancel button or enter a valid record number.\n"
"\n"
"Delete:\n"
"Obviously, by clicking on this button, the chart highlighted in the list will be\n"
"permanently deleted from the chart list, once done, there is no way to undelete it\n"
"\n"
"Cancel:\n"
"This just exits from the work with charts window, it does not reverse any changes\n"
"that may have be made prior to clicking this button.\n"
"\n"
"Import Data:\n"
"------------\n"
"You are presented with several choices. Clicking on the 'import from' button will bring up\n"
"a file selector, which you use to choose the file you want to import into gstalker.\n"
"The 'import field format' gives some choice on the format of the ascii data to be imported.\n"
"Second, the format of the date field.\n"
"\n"
"*Note (It does not matter if there are / slashes in the date field as gstalker will\n"
"ignore them, but the date field must be at least 6 characters in length not including\n"
"any slashes.)\n"
"\n"
"This function reads ASCII data from a file and converts it to binary, then either creates\n"
"or updates a chart in the gstalker database. This is the only way to display data in gstalker.\n"
"\n"
"ASCII is the only file format gstalker understands in this release.\n"
"\n"
"If any errors during import are encountered, they will be written to the error log which\n"
"you can view for details with any text editor. The error log is located in the gstalker\n"
"directory as error.log.\n"
"\n"
"Export Data:\n"
"------------\n"
"This feature allows you to export data in gstalker from binary format to ASCII format, so\n"
"it can be used in spreadsheets, printed out etc.\n"
"\n"
"An export options window will be displayed. Here you choose from a list of all charts in\n"
"the gstalker database to export. Similar to the import options, you can specify how you\n"
"want the data to be exported. The default file to create is /tmp/export.txt, click\n"
"the Export-> button if you want to browse files, or you can enter a new file name\n"
"in the entry space provided.\n"
"\n"
"Quit:\n"
"-----\n"
"This cleanly exits gstalker and saves any configuration changes that may have been made.\n"
"Use this way of terminating the program, if you kill it via the window manager, changes\n"
"may not be saved.\n\n";

char *text3 =
"Edit Menu:\n"
"==========\n"
"\n"
"Edit Chart Indicators:\n"
"----------------------\n"
"This window allows you to modify any technical indicators for the current chart displayed\n"
"in the main window. You are shown a list of all the indicators possible and their current\n"
"status. There are two display modes to the indicators, global and single mode. You change\n"
"modes by clicking the 'Globals' button. You are then prompted if you want to switch modes\n"
"You can tell what mode you are in by looking at the titlebar of the Edit Indicator window.\n"
"If you see the word 'Global', then you're in global mode. If you don't see it, then you're\n"
"in single mode.\n"
"\n"
"Global mode applies the same set of indicator settings to every chart displayed, while\n"
"single mode lets you apply custom settings to each chart. The first column displays the\n"
"on or off status of each indicator. The second column shows the indicator type. The third\n"
"column shows the color of the indicator displayed on the chart. The fourth indicator shows any\n"
"parameters used for the indicator. You may leave this window open all the time so that you\n"
"have quick and easy access to the indicators for each active chart.\n"
"\n"
"There is a button on the button bar for this function.\n"
"\n"
"gstalker has currently these technical indicators;\n"
"\n"
"Volume\n"
"3 Moving Average types (Exponential, Simple, Weighted).\n"
"\n"
"Any changes are displayed on the chart immediately. The indicators are enabled or\n"
"disabled by clicking the toggle status button. You can also change the Moving Average\n"
"parameters by high lighting the indicator and pressing the edit button. Here you can change\n"
"the period lengths. eg entering 10 will create a 10 day moving average.\n"
"\n"
"Edit Alerts Window:\n"
"-------------------\n"
"gstalker has 6 alert settings. They operate the same way as the technical indicators.\n"
"You have 2 modes two work in, global and single mode just like the indicators. The alerts\n"
"do not go into effect until an alert scan is performed.\n"
"\n"
"There are up to 3 seperate moving average alerts, which are based on the 3 moving average\n"
"indicators. You can't edit the parameters from this window, only enable/disable them.\n"
"To use them, you must enable the related indicator and the alert by using the\n"
"toggle button. It's important to remember that if you turn on the alert, the indicator\n"
"must also be enabled, otherwise nothing will happen during the alert scan.\n"
"\n"
"The 3 moving average alerts will trigger if the close plot line penetrates any of the moving\n"
"average plot lines either above or below it. What you do with this info is up to you :-)\n"
"\n"
"The last three alerts are edited only here. These are kind of an alert/indicator hybrid.\n"
"They can be edited by using the edit button.\n"
"\n"
"The percent net change works by entering a value eg. 60.75 will trigger an alert if the\n"
"close has gone up 60.75% from the previous close, or entering -60.75 will trigger the alert\n"
"if the close has gone down 60.75% from the previous close.\n"
"\n"
"The percent volume change works by entering a value eg. 60.75 will trigger an alert if the\n"
"volume has gone up 60.75% from the previous close, or entering -60.75 will trigger the alert\n"
"if the volume has gone down 60.75% from the previous close.\n"
"\n"
"The threshold alert works by entering a value eg. 60.75 will trigger an alert if the close\n"
"has penetrated the 60.75 level from the previous close. This is a one-way alert, the alert\n"
"will be triggered if it crosses the threshold value either going up or down. This is used\n"
"to monitor prices when they break out of sideways price trends.\n"
"\n"
"Edit Options:\n"
"-------------\n"
"This is where you can customize some of the general features in gstalker.\n"
"Pressing the Save button saves the changes and updates gstalker immediately.\n"
"\n"
"Status Bars Page:\n"
"Enable status bars just enables or disables the chart stats and data areas, if disabled,\n"
"more space is created to display charts.\n"
"\n"
"Stats bar field enables or disables each individual stat you want displayed.\n"
"\n"
"Data bar field enables or disables each individual data field you want displayed.\n"
"\n"
"Charts Page:\n"
"This specifies the maximum amount of data to load for every chart. eg. 500 would load a\n"
"maximum of 500 plot points of data. If 0 is entered then the whole chart will be loaded.\n"
"\n"
"Colors Page:\n"
"This is where you can specify colors for the indicators. The combo box contains a list of\n"
"the objects you can specify a color for. The list below it shows all the available colors\n"
"you can choose from. Changing colors is as easy as selecting an object from the combo box,\n"
"the color associated with the object will scroll down the list and highlight for you. To\n"
"change the color, just click on any other color in the list and that's it. Whatever color\n"
"you select is changed, no fuss, no muss.\n"
"\n"
"Pixmaps Page:\n"
"The default location for pixmaps used by gstalker is /usr/local/share/gstalker. You can\n"
"change the path if you want to place the pixmaps in another location.\n\n";

char *text4 =
"View Menu:\n"
"==========\n"
"\n"
"Expand Chart:\n"
"-------------\n"
"This will increase the spacing between the plot points on the chart by one pixel, changing\n"
"the scale at which the data appears on the chart. The maximum you can expand is 20 pixels.\n"
"There is a button on the button bar for this function.\n"
"\n"
"Compress Chart:\n"
"-------------\n"
"This will decrease the spacing between the plot points on the chart by one pixel, changing\n"
"the scale at which the data appears on the chart.\n"
"If OHLC style is active, there is a minimum spacing limitation imposed so the chart is still\n"
"legible. There is a button on the button bar for this function.\n"
"\n"
"Line Style:\n"
"-----------\n"
"This draws the price plot on the chart as an uninterrupted line. There is a button on the\n"
"button bar for this function.\n"
"\n"
"OHLC Style:\n"
"----------\n"
"This draws the price plot on the chart as an open/high/low/close series of ticks and lines.\n"
"Where the tick to the left of the high/low range is the open level, the vertical line is the\n"
"range of the high/low levels, and the close is the tick to the right of the high/low range.\n"
"There is a button on the button bar for this function.\n"
"\n"
"Toggle Chart Grid:\n"
"------------------\n"
"This will display the background grid in the chart area.\n"
"\n"
"Toggle Volume Indicator:\n"
"------------------------\n"
"This will toggle the volume indicator as the default for all charts displayed.\n"
"\n"
"View Data Window:\n"
"------------------\n"
"This will display in a separate window, all the data in the chart in detail form. The window\n"
"can be left active at all times, and will be updated whenever a chart is displayed. There\n"
"is also the function of left clicking anywhere on the active chart, will immediately highlight\n"
"the associated data in the data window if it is active. There is a button on the button bar\n"
"for this function.\n"
"\n"
"Goto Chart:\n"
"-----------\n"
"This allows you to display any chart that is in the currently loaded group. Just highlight\n"
"the chart you wish to view and press the OK button. Useful if you have a lot of charts in\n"
"a group and do not want to advance to it one at a time using the left and right buttons on\n"
"the button bar. There is a button on the button bar for this function.\n\n";

char *text5 =
"Tools:\n"
"======\n"
"\n"
"Alert Scan:\n"
"-----------\n"
"This function allows you to scan each chart in the database, and trigger any alerts that have\n"
"been set for it. There is a button on the button bar for this function.\n"
"\n"
"The Select Groups To Scan window will display which allows you to choose either a particular\n"
"group to be scanned, or you can scan the entire database by enabling the scan all charts\n"
"check button. The scan date is the date you want to scan backwards from. eg 19980715 will\n"
"scan from July 15, 1998 to the previous date, presumably July 14, 1998 and trigger any alerts\n"
"accordingly.\n"
"\n"
"Once the scan is started, the Alert View report window will display a list of any alerts\n"
"that have been triggered with a short detail of the alert. Highlighting an alert and pressing\n"
"the Goto button will immediately display that chart that triggered the alert. Pressing the\n"
"Close button will exit the Alert View window.\n"
"\n"
"Update Quotes:\n"
"--------------\n"
"This function allows you to download quotes from Yahoo's free quote server and import them\n"
"directly into gstalker. The top left box allows you to choose which quote server you would\n"
"like to download from. The top right box allows you to enter a new symbol which does not\n"
"appear in the symbol list to download. The large middle area is the list of all symbols that\n"
"appear in the gstalker database. The bottom area displays the download in progress.\n\n"
"To download all symbols in the database, you just press the select all button which will\n"
"select all the symbols, or you can select individual symbols just by selecting each one\n"
"with the mouse one at a time. When you have finished selecting, just press the download\n"
"button and watch the status area. As each quote you selected is downloaded, it will be\n"
"un-highlighted and updated in the symbol list until done. If there are any problems during\n"
"the download, you will be notified with a message. Make sure when you are ready to download\n"
"that you have an active network connection to the internet or the download will not work.\n\n"
"Also, if you are on a network with a proxy server, you must update the quotes page in the\n"
"edit options dialog with the proxy server name and port number info.\n";


/*** flags,  0=off, 1=on ***/
int chartflag = 0; /* chart currently displayed */
int open_file_flag = 0; /* if a group is not currently loaded */
int edit_chart_save_flag = 0; /* on = change has been made to the data */
int edit_options_save_flag = 0; /* on = change has been made to the data */
int edit_options_flag = 0; /* on = the edit options window is visible */
int edit_indicators_window_flag = 0;
int edit_alerts_window_flag = 0;
int data_window_flag = 0;



/*** int ***/
int edit_group_size; /* size of the group being edited */
int group_pointer; /* position of the currently displayed chart within the active group */
int group_size; /* size of the currently displayed group */
unsigned int records;
int global_int, global_int2, global_int3, global_int4; /* global scratch variables */


/*** char ***/
char global_string[GS_LENGTH]; /* global scratch string */
char *config_file; /* path to the config file */
char *lastdir; /* last directory used */
char *grouppath; /* path to the groups directory */
char *datapath; /* path to the data directory */
char *errorlog; /* path to the errorlog */
char *groupfilename; /* filename of the active group */
char *error_message; /* pointer to error message */
char *edit_groupfilename; /* filename of the group being edited */
char *date_alert; /* storage for date string when alert scans being done */
char *edit_chart_path; /* filename of the chart being edited */
char yahoo_server[] = "quote.yahoo.com";
char data_file[] = "/tmp/quotes.csv";


/*** long ***/
unsigned long volume_high = 0; /* highest volume in chart */


/*** float ***/
float maxhigh; /* highest trading price for chart */
float maxlow; /* lowest trading price for chart */
float range; /* the difference between maxhigh and maxlow */

/*** lists ***/
GList *object_list = NULL; /* options object list */
GList *moving_type_list = NULL; /* moving type list */ 
GList *source_list = NULL; /* quote source list */ 

struct record1 *data;
int data_size = sizeof(struct record1);

struct record2 header;
int header_size = sizeof(struct record2);

struct record3 config;
int config_size = sizeof(struct record3);

/*** widgets that need to be global for all functions ***/
GtkWidget *main_window;
GtkWidget *message_window;
GtkWidget *data_window;
GtkWidget *data_window_clist;
GtkWidget *data_button;
GtkWidget *alert_window;
GtkWidget *alert_window_clist;
GtkWidget *ticker_combo_box;
GdkPixmap *pixmap = NULL, *pixmap2 = NULL, *volume_pixmap = NULL, *date_pixmap = NULL;
GtkWidget *chart, *scale, *volume, *date;
GtkWidget *indicator_button;
GtkWidget *alert_button;
GtkWidget *style_button;
GtkWidget *data_button;
GtkWidget *grid_button;
GtkWidget *volume_button;
GtkWidget *style_button;
GtkWidget *data_frame;
GtkWidget *scrolled_win;
GtkWidget *info_frame;
GtkWidget *info_bar;
GtkWidget *data_bar;
GtkWidget *openfile;


/*** progress window ***/
GtkWidget *progwindow, *progress_bar;

/*** new group ***/
GtkWidget *new_group_window, *new_group_value_entry;

/*** workwith groups window ***/
GtkWidget *workwith_groups_window, *workwith_groups_clist;

/*** rename group window ***/
GtkWidget *rename_group_window, *rename_group_value_entry, *rename_group_old_entry;

/*** edit group window ***/
GtkWidget *edit_group_window, *edit_group_clist, *edit_group_clist2;

/*** edit indicator window ***/
GtkWidget *edit_indicator_window, *edit_indicator_clist, *indicator_clist;

/*** show indicator2 window ***/
GtkWidget *edit_indicator2_window, *edit_indicator2_entry, *indicator_type_combo;

/*** new indicator window ***/
GtkWidget *new_indicator_window, *new_indicator_clist;

/*** edit alerts window ***/
GtkWidget *edit_alerts_window, *edit_alerts_clist, *edit_alerts2_window, *edit_alerts2_entry;

/*** edit options window ***/
GtkWidget *edit_options_window, *enable_top_check, *enable_bottom_check;
GtkWidget *enable_ch_check, *enable_cl_check, *enable_ld_check;
GtkWidget *enable_lc_check, *enable_nc_check, *enable_date_check;
GtkWidget *enable_open_check, *enable_high_check, *enable_low_check;
GtkWidget *enable_close_check, *enable_volume_check, *enable_openi_check;
GtkWidget *bars_value_entry, *object_combo, *pixmaps_entry, *color_clist;
GtkWidget *proxy_entry, *port_entry;

/*** goto chart window ***/
GtkWidget *goto_chart_window, *goto_chart_clist;

/*** workwith charts window ***/
GtkWidget *workwith_charts_window, *workwith_charts_clist;

/*** edit chart window ***/
GtkWidget *edit_chart_open_value_entry, *edit_chart_high_value_entry, *edit_chart_low_value_entry;
GtkWidget *edit_chart_close_value_entry, *edit_chart_volume_value_entry, *edit_chart_clist;
GtkWidget *edit_chart_openi_value_entry, *edit_chart_date, *edit_chart_record;
GtkWidget *edit_chart_window, *edit_chart_name_value_entry, *edit_chart_symbol;

/*** edit goto window ***/
GtkWidget *edit_goto_window, *edit_goto_entry;

/*** alert scan window ***/
GtkWidget *alert_scan_window, *alert_scan_clist, *alert_scan_entry, *alert_scan_check;

/*** import options window ***/
GtkWidget *import_options_window, *import_options_radio, *import_options_radio2;
GtkWidget *import_options_radio3, *import_options_radio4, *import_options_radio5;
GtkWidget *import_options_radio6, *import_options_radio7, *import_options_radio8;
GtkWidget *import_options_entry;
GtkWidget *import_options_radio11, *import_options_radio9, *import_options_radio10;

/*** export options window ***/
GtkWidget *export_options_window, *export_options_radio, *export_options_radio2;
GtkWidget *export_options_radio3, *export_options_radio4, *export_options_radio5;
GtkWidget *export_options_radio6, *export_options_radio7, *export_options_clist;
GtkWidget *export_options_radio8, *export_options_radio9, *export_options_radio10;
GtkWidget *export_options_entry, *export_options_radio11, *export_options_radio12;
GtkWidget **export_options_radio13, *date_check;

/*** help window ***/
GtkWidget *help_window, *help_text;

/*** yesno window ***/
GtkWidget *yesno_window, *yesno_yes_button, *yesno_no_button;;

/*** Initialize Directories ***/
GtkWidget *init_window;

/*** update window ***/
GtkWidget *update_window, *update_window_message;

/*** update quotes window ***/
GtkWidget *quotes_clist, *update_quotes_window, *quotes_clist, *quote_entry;
GtkWidget *source_combo, *quotes_label, *quotes_bar;


/**********************************************************************************/
int main (int argc, char *argv[])
{
	GtkWidget *temp, *temp2, *temp3, *vbox, *vbox2, *hbox, *menubar, *toolbar, *pixmapwid;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	int tint;
	char tstring[250], *gs_dir, *gs_home;
	GdkColor *yellow, *black;		
      	GdkColormap *colormap;
	
	
	gtk_init(&argc, &argv);
	
	object_list = g_list_append(object_list, "Background");
	object_list = g_list_append(object_list, "Borders");
	object_list = g_list_append(object_list, "Grid");
	object_list = g_list_append(object_list, "MA 1");
	object_list = g_list_append(object_list, "MA 2");
	object_list = g_list_append(object_list, "MA 3");
	object_list = g_list_append(object_list, "Price");
	object_list = g_list_append(object_list, "Volume");
	
	moving_type_list = g_list_append(moving_type_list, "Exponential");
	moving_type_list = g_list_append(moving_type_list, "Simple");
	moving_type_list = g_list_append(moving_type_list, "Weighted");
	
	source_list = g_list_append(source_list, "Yahoo");

	
	gs_home = getenv ("HOME");
        if (gs_home != NULL)
           strcpy (tstring, gs_home);
        else
           strcpy (tstring, "/tmp");

        gs_dir = getenv ("GSTALKER_DIR");
        if (gs_dir != NULL)
           strcat (tstring, gs_dir);
        else
           strcat(tstring, "/gstalker");

	tint = chdir(tstring);
	if (tint)
		new_init();
	else
		init();
	
	tint = chdir(config.pixmap_path);
	if (tint)
	{
		tint = chdir("/usr/share/gstalker");
		if (tint)
		{
			fprintf(stderr, "Can't find my pixmaps in:\n");
			fprintf(stderr, config.pixmap_path);
			fprintf(stderr, "\n/usr/share/gstalker\n");
			fprintf(stderr, "Aborting gstalker...");
			exit(1);
		}
		else
			strcpy(config.pixmap_path, "/usr/share/gstalker");
	}
		
	main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (main_window), "delete_event",
			    GTK_SIGNAL_FUNC (exit_program), NULL);
	gtk_signal_connect (GTK_OBJECT (main_window), "destroy",
			    GTK_SIGNAL_FUNC (exit_program), NULL);
	gtk_window_set_title (GTK_WINDOW (main_window), "gstalker");
	gtk_window_position(GTK_WINDOW(main_window), GTK_WIN_POS_NONE);
	
	vbox = gtk_vbox_new (FALSE, 0);
      	gtk_container_add (GTK_CONTAINER (main_window), vbox);
      	gtk_widget_show (vbox);
      	
      	/*** create the menubar ***/
      	
      	menubar = gtk_menu_bar_new ();
        gtk_box_pack_start (GTK_BOX (vbox), menubar, FALSE, TRUE, 0);
        gtk_widget_show (menubar);
        
        temp = gtk_menu_new ();
        temp2 = gtk_menu_item_new_with_label ("File");
        gtk_widget_show (temp2);
        
        temp3 = gtk_menu_item_new_with_label("New Group...");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (new_group), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Work With Groups...");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (workwith_groups), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Work With Charts...");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (workwith_charts), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new();
        gtk_menu_append (GTK_MENU (temp), temp3);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Import Data...");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (import_options), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Export Data...");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (export_options), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new();
        gtk_menu_append (GTK_MENU (temp), temp3);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Quit");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (exit_program), NULL);
	gtk_widget_show (temp3);
	
        gtk_menu_item_set_submenu (GTK_MENU_ITEM (temp2), temp);
      	gtk_menu_bar_append (GTK_MENU_BAR (menubar), temp2);
      	
      	temp = gtk_menu_new ();
        temp2 = gtk_menu_item_new_with_label ("Edit");
        gtk_widget_show (temp2);
        
        temp3 = gtk_menu_item_new_with_label("Edit Chart Indicators...");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (menu_edit_indicators), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Edit Alerts...");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (menu_edit_alerts), NULL);
	gtk_widget_show (temp3);
        
	temp3 = gtk_menu_item_new_with_label("Edit Options...");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (edit_options), NULL);
	gtk_widget_show (temp3);
	
        gtk_menu_item_set_submenu (GTK_MENU_ITEM (temp2), temp);
      	gtk_menu_bar_append (GTK_MENU_BAR (menubar), temp2);
      	
      	temp = gtk_menu_new ();
        temp2 = gtk_menu_item_new_with_label ("View");
        gtk_widget_show (temp2);
        
        temp3 = gtk_menu_item_new_with_label("Expand Chart");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (expand_chart), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Compress Chart");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (shrink_chart), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new();
        gtk_menu_append (GTK_MENU (temp), temp3);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Previous Chart");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (previous_chart), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Next Chart");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (next_chart), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new();
        gtk_menu_append (GTK_MENU (temp), temp3);
	gtk_widget_show (temp3);
		
        temp3 = gtk_menu_item_new_with_label("Line Style");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (style_button_pressed), NULL);
	gtk_widget_show (temp3);
	
        temp3 = gtk_menu_item_new_with_label("OHLC Style");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (style_button_pressed), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Toggle Chart Grid");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (menu_toggle_grid), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new();
        gtk_menu_append (GTK_MENU (temp), temp3);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Toggle Volume Indicator");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (menu_toggle_volume), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new();
        gtk_menu_append (GTK_MENU (temp), temp3);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("View Data Window");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (menu_show_data_window), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new();
        gtk_menu_append (GTK_MENU (temp), temp3);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Goto Chart...");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (goto_chart), NULL);
	gtk_widget_show (temp3);
	
        gtk_menu_item_set_submenu (GTK_MENU_ITEM (temp2), temp);
      	gtk_menu_bar_append (GTK_MENU_BAR (menubar), temp2);
      	
	temp = gtk_menu_new ();
        temp2 = gtk_menu_item_new_with_label ("Tools");
        gtk_widget_show (temp2);
        
        temp3 = gtk_menu_item_new_with_label("Alert Scan");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (alert_scan), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Update Quotes");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (show_update_quotes), NULL);
	gtk_widget_show (temp3);
	
        gtk_menu_item_set_submenu (GTK_MENU_ITEM (temp2), temp);
      	gtk_menu_bar_append (GTK_MENU_BAR (menubar), temp2);
      	
      	temp = gtk_menu_new ();
        temp2 = gtk_menu_item_new_with_label ("Help");
        gtk_widget_show (temp2);
        
        temp3 = gtk_menu_item_new_with_label("About...");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (about), NULL);
	gtk_widget_show (temp3);
	
	temp3 = gtk_menu_item_new_with_label("Help...");
        gtk_menu_append (GTK_MENU (temp), temp3);
        gtk_signal_connect (GTK_OBJECT (temp3), "activate",
			    GTK_SIGNAL_FUNC (help_index), NULL);
	gtk_widget_show (temp3);
	
        gtk_menu_item_set_submenu (GTK_MENU_ITEM (temp2), temp);
      	gtk_menu_bar_append (GTK_MENU_BAR (menubar), temp2);
      	
      	gtk_widget_realize( main_window );

	/*** create the toolbar ***/
	
	style = gtk_widget_get_style(main_window);
	toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_set_space_size (GTK_TOOLBAR (toolbar), 10);
	gtk_box_pack_start (GTK_BOX (vbox), toolbar, FALSE, TRUE, 2);
	

	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_new.xpm");
    	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
    	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), NULL, "Work With Charts",
    				 NULL, pixmapwid, (GtkSignalFunc) workwith_charts, NULL);

    	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_open.xpm");
    	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
    	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), NULL, "Work With Groups",
    				 NULL, pixmapwid, (GtkSignalFunc) workwith_groups, NULL);
    				 
	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_left_arrow.xpm");
	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
    	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), NULL, "Previous Chart",
    				 NULL, pixmapwid, (GtkSignalFunc) previous_chart, NULL);
    				 
    	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_refresh.xpm");
    	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
    	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), NULL, "Goto Chart",
    				 NULL, pixmapwid, (GtkSignalFunc) goto_chart, NULL);
    	
    	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_right_arrow.xpm");
    	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), NULL, "Next Chart",
    				 NULL, pixmapwid, (GtkSignalFunc) next_chart, NULL);
    				 
	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_minus.xpm");
	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), NULL, "Compress Chart",
    				 NULL, pixmapwid, (GtkSignalFunc) shrink_chart, NULL);
    	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_plus.xpm");			 
    	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
    	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), NULL, "Expand Chart",
   				 NULL, pixmapwid, (GtkSignalFunc) expand_chart, NULL);
    				 
	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_preferences.xpm");
	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
	indicator_button = gtk_toggle_button_new();
	gtk_signal_connect (GTK_OBJECT (indicator_button), "toggled",
			    GTK_SIGNAL_FUNC (edit_indicators), NULL);
    	gtk_widget_show(indicator_button);
    	gtk_container_add (GTK_CONTAINER (indicator_button), pixmapwid);
	gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar), indicator_button, "Edit Chart Indicators", NULL);
    				 
    	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_stop.xpm");
    	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
	alert_button = gtk_toggle_button_new();
	gtk_signal_connect (GTK_OBJECT (alert_button), "toggled",
			    GTK_SIGNAL_FUNC (edit_alerts), NULL);
    	gtk_widget_show(alert_button);
    	gtk_container_add (GTK_CONTAINER (alert_button), pixmapwid);
	gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar), alert_button, "Edit Chart Alerts", NULL);
    	
    	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_search.xpm");
	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), NULL, "Alert Scan",
    				 NULL, pixmapwid, (GtkSignalFunc) alert_scan, NULL);
    	
    	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_down_arrow.xpm");
	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), NULL, "Update Quotes",
    				 NULL, pixmapwid, (GtkSignalFunc) show_update_quotes, NULL);
    				 
    	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
    	
    	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_info.xpm");			 
	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
	data_button = gtk_toggle_button_new();
	gtk_signal_connect (GTK_OBJECT (data_button), "toggled",
			    GTK_SIGNAL_FUNC (show_data_window), NULL);
    	gtk_widget_show(data_button);
    	gtk_container_add (GTK_CONTAINER (data_button), pixmapwid);
	gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar), data_button, "View Data Window", NULL);
    				 
    	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_grid.xpm");
    	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
	grid_button = gtk_toggle_button_new();
	if (config.grid)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(grid_button), 1);
	gtk_signal_connect (GTK_OBJECT (grid_button), "toggled",
			    GTK_SIGNAL_FUNC (toggle_grid), NULL);
    	gtk_widget_show(grid_button);
    	gtk_container_add (GTK_CONTAINER (grid_button), pixmapwid);
	gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar), grid_button, "Toggle Grid", NULL);
    	
    	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_line.xpm");
    	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
	style_button = gtk_toggle_button_new();
	if (config.style)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(style_button), 1);
	gtk_signal_connect (GTK_OBJECT (style_button), "toggled",
			    GTK_SIGNAL_FUNC (style_button_pressed), NULL);
    	gtk_widget_show(style_button);
    	gtk_container_add (GTK_CONTAINER (style_button), pixmapwid);
	gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar), style_button,
				  "Toggle Chart Style", NULL);
    	
    	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_dial.xpm");
	pixmap = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					    &style->bg[GTK_STATE_NORMAL], tstring);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
	volume_button = gtk_toggle_button_new();
	if (config.volume)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(volume_button), 1);
	gtk_signal_connect (GTK_OBJECT (volume_button), "toggled",
			    GTK_SIGNAL_FUNC (toggle_volume), NULL);
    	gtk_widget_show(volume_button);
    	gtk_container_add (GTK_CONTAINER (volume_button), pixmapwid);
	gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar), volume_button, "Toggle Volume Indicator", NULL);
    				 
    	gtk_widget_show (toolbar);
    	
    	/**** info bar ****/
	
	info_bar = gtk_hbox_new (FALSE, 0);
    	gtk_box_pack_start (GTK_BOX (vbox), info_bar, FALSE, TRUE, 0);
      	gtk_widget_show (info_bar);    	
    	if (config.top_enable_flag)
    	{
      		info_frame = gtk_statusbar_new ();
      		gtk_box_pack_start (GTK_BOX (info_bar), info_frame, TRUE, TRUE, 2);
      		gtk_widget_show (info_frame);
      		gtk_widget_realize(info_frame);
      	}
    	
    	/*** chart area ***/
    	
    	hbox = gtk_hbox_new (FALSE, 0);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
      	gtk_widget_show (hbox);
    	
      	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
      	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
				      	GTK_POLICY_AUTOMATIC, 
				      	GTK_POLICY_AUTOMATIC);
      	gtk_box_pack_start (GTK_BOX (hbox), scrolled_win, TRUE, TRUE, 0);
      	gtk_container_border_width (GTK_CONTAINER (scrolled_win), 0);
      	gtk_widget_show (scrolled_win);
      	
      	vbox2 = gtk_vbox_new (FALSE, 0);
     	gtk_container_add (GTK_CONTAINER (scrolled_win), vbox2);
     	gtk_container_enable_resize(GTK_CONTAINER(vbox2));
      	gtk_widget_show (vbox2);
      	
      	chart = gtk_drawing_area_new();
      	gtk_signal_connect (GTK_OBJECT(chart), "expose_event",
      			    (GtkSignalFunc) expose_event, NULL);
      	gtk_signal_connect (GTK_OBJECT(chart), "configure_event",
      			    (GtkSignalFunc) configure_event, NULL);		    
      	gtk_signal_connect (GTK_OBJECT(chart), "motion_notify_event",
      			    (GtkSignalFunc) motion_notify_event, NULL);
      	gtk_signal_connect (GTK_OBJECT(chart), "button_press_event",
      			    (GtkSignalFunc) button_press_event, NULL);
      	gtk_widget_set_events (chart, GDK_EXPOSURE_MASK
      			       | GDK_LEAVE_NOTIFY_MASK
      			       | GDK_BUTTON_PRESS_MASK
      			       | GDK_POINTER_MOTION_MASK
      			       | GDK_POINTER_MOTION_HINT_MASK);
      	gtk_box_pack_start (GTK_BOX (vbox2), chart, TRUE, TRUE, 0);
      	gtk_widget_show(chart);
      	
      	scale = gtk_drawing_area_new();
      	gtk_signal_connect (GTK_OBJECT(scale), "expose_event",
      			    (GtkSignalFunc) scale_expose_event, NULL);
      	gtk_signal_connect (GTK_OBJECT(scale), "configure_event",
      			    (GtkSignalFunc) scale_configure_event, NULL);		    
      	gtk_widget_set_events (scale, GDK_EXPOSURE_MASK);
      	gtk_widget_set_usize(GTK_WIDGET (scale), WIDTH_OFFSET, 0);
      	gtk_box_pack_end (GTK_BOX (hbox), scale, FALSE, FALSE, 0);
      	gtk_widget_show(scale);
      	
      	volume = gtk_drawing_area_new();
      	gtk_signal_connect (GTK_OBJECT(volume), "expose_event",
      			    (GtkSignalFunc) volume_expose_event, NULL);
      	gtk_signal_connect (GTK_OBJECT(volume), "configure_event",
      			    (GtkSignalFunc) volume_configure_event, NULL);		    
      	gtk_signal_connect (GTK_OBJECT(volume), "motion_notify_event",
      			    (GtkSignalFunc) volume_motion_notify_event, NULL);
      	gtk_signal_connect (GTK_OBJECT(volume), "button_press_event",
      			    (GtkSignalFunc) volume_button_press_event, NULL);
      	gtk_widget_set_events (volume, GDK_EXPOSURE_MASK
      			       | GDK_LEAVE_NOTIFY_MASK
      			       | GDK_BUTTON_PRESS_MASK
      			       | GDK_POINTER_MOTION_MASK
      			       | GDK_POINTER_MOTION_HINT_MASK);
      	gtk_box_pack_start (GTK_BOX (vbox2), volume, FALSE, TRUE, 0);
      	
      	
      	date = gtk_drawing_area_new();
      	gtk_signal_connect (GTK_OBJECT(date), "expose_event",
      			    (GtkSignalFunc) date_expose_event, NULL);
      	gtk_signal_connect (GTK_OBJECT(date), "configure_event",
      			    (GtkSignalFunc) date_configure_event, NULL);		    
      	gtk_widget_set_events (date, GDK_EXPOSURE_MASK);
      	gtk_box_pack_start (GTK_BOX (vbox2), date, FALSE, TRUE, 0);
      	gtk_widget_set_usize(GTK_WIDGET (date), 0, DATE_SIZE);
      	gtk_widget_show(date);
      	
      	/*** data_bar setup ***/
      	
      	data_bar = gtk_hbox_new (FALSE, 0);
    	gtk_box_pack_start (GTK_BOX (vbox), data_bar, FALSE, TRUE, 0);
      	gtk_widget_show (data_bar);
      	if (config.bottom_enable_flag)
      	{
      		data_frame = gtk_statusbar_new ();
      		gtk_box_pack_start (GTK_BOX (data_bar), data_frame, TRUE, TRUE, 2);
      		gtk_widget_show (data_frame);
      	}
 	
	/*** set tooltips colors ***/
	 
      	yellow   = calloc (1, sizeof (GdkColor));
      	black    = calloc (1, sizeof (GdkColor));
	colormap = gdk_window_get_colormap (main_window->window);
     	yellow->red    = 255 << 8;
      	yellow->green  = 255 << 8;
      	yellow->blue   =   0 << 8;
      	if (!gdk_color_alloc (colormap, yellow))
	 	gdk_color_white (colormap, yellow);
      	black->red   = 0 << 8;
      	black->green = 0 << 8;
      	black->blue  = 0 << 8;
      	if (!gdk_color_alloc (colormap, black))
	 	gdk_color_black (colormap, black);
      	gtk_tooltips_set_colors (GTK_TOOLBAR (toolbar)->tooltips, yellow, black);
      	
	gtk_widget_show(main_window);
	if (strlen(config.last_group) != 0)
 		load_first_group();
 				
	gtk_main();
	return 0;							
}
