#include "myheader.h"
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/stat.h>


char datapath[250];
int data_size, header_size, config_size;

struct record1 *data;
struct record2 header;
struct record3 config;

/**************************************************************************************
inserts a new record into a chart 
***************************************************************************************/
void insert_chart_record (char *filename, unsigned long date, float open, float high, float low, float close, unsigned long volume, unsigned long openint)
{
	char tstring[250];
	FILE *infile, *outfile;
	unsigned int tuint;
	struct record1 data, data2;
	struct record2 header;
	
	
	
	strcpy(tstring, datapath);
	strcat(tstring, "temp.dat");
	outfile = fopen(tstring, "wb");

	infile = fopen(filename, "rb");
	fread(&header, header_size, 1, infile);
	header.records++;
	if (header.first_date > date)
		header.first_date = date;
	fwrite(&header, header_size, 1, outfile);
	for (tuint = 0; tuint < header.records - 1; tuint++)
	{
		fread(&data, data_size, 1, infile);
		if (data.date > date)
			break;
		fwrite(&data, data_size, 1, outfile);
	}
	data2.date = date;
	data2.open = open;
	data2.high = high;
	data2.low = low;
	data2.close = close;
	data2.volume = volume;
	data2.openint = openint;
	fwrite(&data2, data_size, 1, outfile);
	fwrite(&data, data_size, 1, outfile);
	for (tuint = tuint; tuint < header.records - 1; tuint++)
	{
		fread(&data, data_size, 1, infile);
		fwrite(&data, data_size, 1, outfile);
	}
	fclose(infile);
	fclose(outfile);
	unlink(filename);
	rename(tstring, filename);
}
/***************************************************************************************
overwrites existing chart record
****************************************************************************************/
void overwrite_chart_record (char *filename, unsigned int record, unsigned long date, float open, float high, float low, float close, unsigned long volume, unsigned long openint)
{
	FILE *outfile;
	struct record1 data;
	struct record2 header;
	
	
	outfile = fopen(filename, "r+b");
	fread(&header, header_size, 1, outfile);
	fseek(outfile, (long)(record * data_size) + header_size, SEEK_SET);
	data.date = date;
	data.open = open;
	data.high = high;
	data.low = low;
	data.close = close;
	data.volume = volume;
	data.openint = openint;
	fwrite(&data, data_size,1,outfile);
	fclose(outfile);
}
/***************************************************************************************
searches chart for particular record, returns record # or zero for not found
***************************************************************************************/
int find_chart_record(char *filename, unsigned long date)
{
	int tint;
	FILE *infile;
	long lowlist, highlist, middlelist;
	struct record1 data;
	struct record2 header;
	
	
	tint = -1;
	infile = fopen(filename, "rb");
	fread(&header, header_size, 1, infile);
	if (header.records < 2)
	{
		fread(&data, data_size, 1, infile);
		if (date == data.date)
			tint = 0;
		return tint;
	}
	lowlist = 0;
	highlist = header.records;
	while (tint == -1)
	{
		middlelist = (lowlist + highlist) / 2;
		if (highlist < lowlist)
			break;
		fseek(infile,(long)(middlelist * data_size) + header_size, SEEK_SET);
		fread(&data, data_size, 1, infile);
		if (date > data.date)
			lowlist = middlelist + 1;
		else
		{
			if (date < data.date)
				highlist = middlelist - 1;
			else
			{
				tint = middlelist;
				break;
			}
		}
	}
	fclose(infile);
	return tint;
}
/****************************************************************************************
creates a new chart - header format is (name, symbol, records, style, density, volume, 
		      moving, moving2, moving3, volumeroc, closeroc, threshold)
*****************************************************************************************/
int create_new_chart(char *symbol)
{
	int tint;
	char tstring[250];
	FILE *outfile;
	struct record2 header;
	
	
	strcpy(tstring, datapath);
	strcat(tstring, symbol);
	outfile = fopen(tstring, "wb");
	if (outfile)
	{
		header.version = FILE_VERSION;
		strcpy(header.name, symbol);
		strcpy(header.symbol, symbol);
		header.first_date = 0;
		header.last_date = 0;
		header.records = 0;
		header.styleflag = 0;
		header.pixelspace = 1;
		header.volume = 0;
		header.moving[0] = 0;
		header.moving[1] = 1;
		header.moving[2] = 10;
		header.moving2[0] = 0;
		header.moving2[1] = 1;
		header.moving2[2] = 10;
		header.moving3[0] = 0;
		header.moving3[1] = 1;
		header.moving3[2] = 10;
		header.volumeroc_status = 0;
		header.closeroc_status = 0;
		header.threshold_status = 0;
		header.volumeroc = 0.0;
		header.closeroc = 0.0;
		header.threshold = 0.0;
		header.ma_alert = 0;
		header.ma2_alert = 0;
		header.ma3_alert = 0;
		fwrite(&header, header_size, 1, outfile);
		fclose(outfile);
		tint = 0;
	}
	else
		tint = 1;
	return tint;
}
/****************************************************************************************
appends a new record to a chart
*****************************************************************************************/
void append_chart_record(char *filename, unsigned long date, float open, float high, float low, float close, unsigned long volume, unsigned long openint)
{
	FILE *outfile;
	struct record1 data;
	struct record2 header;
	
	
	outfile = fopen(filename, "r+b");
	if (outfile)
	{
		fread(&header, header_size, 1, outfile);
		header.records++;
		header.last_date = date;
		if (header.first_date == 0)
			header.first_date = date;
		rewind(outfile);
		fwrite(&header, header_size, 1, outfile);
		fseek(outfile, 0L, SEEK_END);
		data.date = date;
		data.open = open;
		data.high = high;
		data.low = low;
		data.close = close;
		data.volume = volume;
		data.openint = openint;
		fwrite(&data, data_size, 1, outfile);
		fclose(outfile);
	}
}
/*******************************************************************************************/
int main (int argc, char *argv[])
{

	int tint, tint2, error_flag = 0, format = 0, dateformat = 0, tint3, importline;
	int skip_flag = 0, found = 0;
   	FILE *infile, *infile2;
   	char *tstringpointer, tstring[250], tstring2[250], error_msg[50], tstring3[25];
   	char *gs_home;
   	unsigned long date = 0, volume = 0, openint = 0;
   	float open=0.0, high=0.0, low=0.0, close=0.0;
	struct record2 header2;
	
	
	data_size = sizeof(struct record1);
	header_size = sizeof(struct record2);
	config_size = sizeof(struct record3);
	
	if ((argc < 4) || (argc > 4))
	{
		printf("\nUsage: [import file] [field format] [date format]\n");
		printf("eg.  gstalker ~/temp/importfile.txt 1 1\n\n");
		printf("Field format is:\n\n");
		printf("1 = Symbol Date Open High Low Close Volume Openint\n");
		printf("2 = Symbol Date High Low Close Volume\n");
		printf("3 = Symbol Date Close\n");
		printf("4 = Symbol Date Open High Low Close\n");
		printf("5 = Symbol Date Open High Low Close Volume\n");
		printf("6 = Symbol Date Open High Low Close Volume Openint\n\n");
		printf("Date format is:\n\n");
		printf("1 = YYYYMMDD\n");
		printf("2 = YYMMDD\n");
		printf("3 = MMDDYYYY\n");
		printf("4 = MMDDYY\n");
		printf("5 = DDMMYYYY\n");
		printf("6 = DDMMYY\n\n");
		return 1;
	}
	
	format = atoi(argv[2]);
	if ((format < 1) || (format > 6))
	{
		printf("Invalid field format option.\n");
		return 1;
	}
	
	dateformat = atoi(argv[3]);
	if ((dateformat < 1) || (dateformat > 6))
	{
		printf("Invalid date format option.\n");
		return 1;
	}
	
   	sscanf(argv[1], "%s", tstring);
   	if (strlen(tstring) == 0)
   	{
   		printf("\nError, No filename given.\n");
   		return 1;
   	}
   	
   	gs_home = getenv ("HOME");
        if (gs_home != NULL)
        {
           	strcpy (datapath, gs_home);
           	strcat(datapath, "/gstalker/data/");
        }
        else
        {
        	printf("Cant get HOME environment.\n");
        	return 1;
        }

      	infile = fopen(tstring, "r");
      	if (! infile)
      	{
      		printf("\nError, invalid filename.\n");
      		return 1;
      	}
	
	importline = 1;
	while (fgets(tstring, 250, infile) != NULL)
	{
		error_msg[0] = 0;
		error_flag = 0;
		skip_flag = 1;
		tstring2[0] = 0;
		tstring3[0] = 0;
		open = 0.0;
		date = 0;
		high = 0.0;
		low = 0.0;
		close = 0.0;
		volume = 0;
		openint = 0;
		tint = strlen(tstring);
		for (tint2 = 0; tint2 < tint; tint2++)
		{
			if (isalnum(tstring[tint2]))
			{
				skip_flag = 0;
				break;
			}
		}
		if (! skip_flag)
		{
			for (tint2 = 0; tint2 < tint; tint2++)
			{
				if (tstring[tint2] == ',')
					tstring[tint2] = ' ';
			}
			switch(format)
			{
				case 1 : sscanf(tstring,"%s %s %g %g %g %g %ld %ld", tstring3, tstring2, &open, &high, &low, &close, &volume, &openint);
				 	break;
				case 2 : sscanf(tstring,"%s %s %g %g %g %ld", tstring3, tstring2, &high, &low, &close, &volume);
				 	break;
				case 3 : sscanf(tstring,"%s %s %g", tstring3, tstring2, &close);
				 	break;
				case 4 : sscanf(tstring,"%s %s %g %g %g %g", tstring3, tstring2, &open, &high, &low, &close);
				 	break;
				case 5 : sscanf(tstring,"%s %s %g %g %g %g %ld", tstring3, tstring2, &open, &high, &low, &close, &volume);
				 	break;
				default : break;
			}
			tstringpointer = strchr(tstring2, '/');
			if (tstringpointer != NULL)
			{
				tint3 = 0;
				tstring[0] = 0;
				tint = strlen(tstring2);
				for (tint2 = 0; tint2 < tint; tint2++)
				{
					if (tstring2[tint2] != '/')
					{
						tstring[tint3] = tstring2[tint2];
						tint3++;
					}
				}
				tstring[tint3] = 0;
				strcpy(tstring2, tstring);
			}
			tint = strlen(tstring2);
			for (tint2 = 0; tint2 < tint; tint2++)
			{
				if (! isdigit(tstring2[tint2]))
				{
					error_flag++;
					strcpy(error_msg,"Invalid date character, must be all digits.");
					break;
				}
			}
			switch(dateformat)
			{
				case 1 : if (tint != 8)
				 	{
				 		strcpy(error_msg,"Invalid date format, must be 8 numbers.");
				 		error_flag++;
				 	}
				 	else
				 		date = atol(tstring2);
				 	break;
				case 2 : if (tint != 6)
				 	{
				 		strcpy(error_msg, "Invalid date format, must be 6 numbers.");
				 		error_flag++;
				 	}
				 	else
				 	{
				 		strcpy(tstring, "19");
				 		strcat(tstring, tstring2);
				 		date = atol(tstring);
				 	}
				 	break;
				case 3 : if (tint != 8)
				 	{
				 		strcpy(error_msg, "Invalid date format, must be 8 numbers.");
				 		error_flag++;
				 	}
				 	else
				 	{
				 		tstring[0] = tstring2[4];
				 		tstring[1] = tstring2[5];
				 		tstring[2] = tstring2[6];
				 		tstring[3] = tstring2[7];
				 		tstring[4] = tstring2[0];
				 		tstring[5] = tstring2[1];
				 		tstring[6] = tstring2[2];
				 		tstring[7] = tstring2[3];
				 		tstring[8] = 0;
				 		date = atol(tstring);
				 	}
				 	break;
				case 4 : if (tint != 6)
				 	{
				 		strcpy(error_msg, "Invalid date format, must be 6 numbers.");
				 		error_flag++;
				 	}
				 	else
				 	{
				 		tstring[0] = '1';
				 		tstring[1] = '9';
				 		tstring[2] = tstring2[4];
				 		tstring[3] = tstring2[5];
				 		tstring[4] = tstring2[0];
				 		tstring[5] = tstring2[1];
				 		tstring[6] = tstring2[2];
				 		tstring[7] = tstring2[3];
				 		tstring[8] = 0;
				 		date = atol(tstring);
				 	}
				 	break;
				case 5 : if (tint != 8)
				 	{
				 		strcpy(error_msg, "Invalid date format, must be 8 numbers.");
				 		error_flag++;
				 	}
				 	else
				 	{
				 		tstring[0] = tstring2[4];
				 		tstring[1] = tstring2[5];
				 		tstring[2] = tstring2[6];
				 		tstring[3] = tstring2[7];
				 		tstring[4] = tstring2[2];
				 		tstring[5] = tstring2[3];
				 		tstring[6] = tstring2[0];
				 		tstring[7] = tstring2[1];
				 		tstring[8] = 0;
				 		date = atol(tstring);
				 	}
				 	break;
				case 6 : if (tint != 6)
				 	{
				 		strcpy(error_msg, "Invalid date format, must be 6 numbers.");
				 		error_flag++;
				 	}
				 	else
				 	{
				 		tstring[0] = '1';
				 		tstring[1] = '9';
				 		tstring[2] = tstring2[4];
				 		tstring[3] = tstring2[5];
				 		tstring[4] = tstring2[2];
				 		tstring[5] = tstring2[3];
				 		tstring[6] = tstring2[0];
				 		tstring[7] = tstring2[1];
				 		tstring[8] = 0;
				 		date = atol(tstring);
					}
					break;
				default : break;
			}
			if (strlen(tstring3) == 0)
			{
				strcpy(error_msg, "Invalid symbol.");
				error_flag++;
			}
			if (error_flag != 1)
			{
      				strcpy(tstring, datapath);
				strcat(tstring, tstring3);
				infile2 = fopen(tstring, "rb");
				if (infile2)
				{
					fread(&header2, header_size, 1, infile2);
					fclose(infile2);
					if (date > header2.last_date)
						append_chart_record(tstring, date, open, high, low, close, volume, openint);
					else
					{
						found = find_chart_record(tstring, date);
						if (found > -1)
							overwrite_chart_record (tstring, found, date, open, high, low, close, volume, openint);
						else
							insert_chart_record (tstring, date, open, high, low, close, volume, openint);
					}
				}
				else
				{
					tint = create_new_chart(tstring3);
					if (! tint) 
						append_chart_record(tstring, date, open, high, low, close, volume, openint);
				}
			}
			else
			{
				strcpy(tstring, "Bad data, line# ");
				sprintf(tstring2, "%d", importline);
				strcat(tstring, tstring2);
				strcat(tstring, " ");
				strcat(tstring, error_msg);
				strcat(tstring, ", data not imported");
				strcat(tstring, "\n");
				printf(tstring);
			}
		}
		importline++;
	}
	fclose(infile);
	return 0;
}