/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "myheader.h"
#include "myerrors.h"
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>	
#include <fcntl.h>


/***********************************************************************************/
int check_chart_version(unsigned int version)
{
	if (version != FILE_VERSION)
	{
		fprintf(stderr,"\n\nWhoops! I have detected a chart in a file format from a previous version\n");
		fprintf(stderr,"I can't read. You have to run the gstalker-convert utility\n");
		fprintf(stderr,"for me to read this chart. I'm aborting gstalker...\n\n");
		return (1);
	}
	else
		return(0);
}
/**************************************************************************************
inserts a new record into a chart 
***************************************************************************************/
void insert_chart_record (char *filename, unsigned long date, float open, float high, float low, float close, unsigned long volume, unsigned long openint)
{
	char tstring[250];
	FILE *infile, *outfile;
	unsigned int tuint;
	extern char *datapath, *error_message;
	extern int data_size, header_size;
	struct record1 data, data2;
	struct record2 header;
	
	
	
	strcpy(tstring, datapath);
	strcat(tstring, "temp.dat");
	outfile = fopen(tstring, "wb");
	if (! outfile)
	  RETURN_ERR(gs_cant_create_tempfile);

	infile = fopen(filename, "rb");
	fread(&header, header_size, 1, infile);
	header.records++;
	if (header.first_date > date)
		header.first_date = date;
	fwrite(&header, header_size, 1, outfile);
	for (tuint = 0; tuint < header.records - 1; tuint++)
	{
		fread(&data, data_size, 1, infile);
		if (data.date > date)
			break;
		fwrite(&data, data_size, 1, outfile);
	}
	data2.date = date;
	data2.open = open;
	data2.high = high;
	data2.low = low;
	data2.close = close;
	data2.volume = volume;
	data2.openint = openint;
	fwrite(&data2, data_size, 1, outfile);
	fwrite(&data, data_size, 1, outfile);
	for (tuint = tuint; tuint < header.records - 1; tuint++)
	{
		fread(&data, data_size, 1, infile);
		fwrite(&data, data_size, 1, outfile);
	}
	fclose(infile);
	fclose(outfile);
	unlink(filename);
	rename(tstring, filename);
}
/***************************************************************************************
overwrites existing chart record
****************************************************************************************/
void overwrite_chart_record (char *filename, unsigned int record, unsigned long date, float open, float high, float low, float close, unsigned long volume, unsigned long openint)
{
	FILE *outfile;
	extern int data_size, header_size;
	struct record1 data;
	struct record2 header;
	
	
	outfile = fopen(filename, "r+b");
	fread(&header, header_size, 1, outfile);
	fseek(outfile, (long)(record * data_size) + header_size, SEEK_SET);
	data.date = date;
	data.open = open;
	data.high = high;
	data.low = low;
	data.close = close;
	data.volume = volume;
	data.openint = openint;
	fwrite(&data, data_size,1,outfile);
	fclose(outfile);
}
/***************************************************************************************
searches chart for particular record, returns record # or zero for not found
***************************************************************************************/
int find_chart_record(char *filename, unsigned long date)
{
	int tint;
	FILE *infile;
	long lowlist, highlist, middlelist;
	extern int data_size, header_size;
	struct record1 data;
	struct record2 header;
	
	
	tint = -1;
	infile = fopen(filename, "rb");
	fread(&header, header_size, 1, infile);
	if (header.records < 2)
	{
		fread(&data, data_size, 1, infile);
		if (date == data.date)
			tint = 0;
		return tint;
	}
	lowlist = 0;
	highlist = header.records;
	while (tint == -1)
	{
		middlelist = (lowlist + highlist) / 2;
		if (highlist < lowlist)
			break;
		fseek(infile,(long)(middlelist * data_size) + header_size, SEEK_SET);
		fread(&data, data_size, 1, infile);
		if (date > data.date)
			lowlist = middlelist + 1;
		else
		{
			if (date < data.date)
				highlist = middlelist - 1;
			else
			{
				tint = middlelist;
				break;
			}
		}
	}
	fclose(infile);
	return tint;
}
/****************************************************************************************
creates a new chart - header format is (name, symbol, records, style, density, volume, 
		      moving, moving2, moving3, volumeroc, closeroc, threshold)
*****************************************************************************************/
int create_new_chart(char *symbol)
{
	int tint;
	char tstring[250];
	FILE *outfile;
	extern char *datapath;
	extern int header_size;
	struct record2 header;
	
	
	strcpy(tstring, datapath);
	strcat(tstring, symbol);
	outfile = fopen(tstring, "wb");
	if (outfile)
	{
		header.version = FILE_VERSION;
		strcpy(header.name, symbol);
		strcpy(header.symbol, symbol);
		header.first_date = 0;
		header.last_date = 0;
		header.records = 0;
		header.styleflag = 0;
		header.pixelspace = 1;
		header.volume = 0;
		header.moving[0] = 0;
		header.moving[1] = 1;
		header.moving[2] = 10;
		header.moving2[0] = 0;
		header.moving2[1] = 1;
		header.moving2[2] = 10;
		header.moving3[0] = 0;
		header.moving3[1] = 1;
		header.moving3[2] = 10;
		header.volumeroc_status = 0;
		header.closeroc_status = 0;
		header.threshold_status = 0;
		header.volumeroc = 0.0;
		header.closeroc = 0.0;
		header.threshold = 0.0;
		header.ma_alert = 0;
		header.ma2_alert = 0;
		header.ma3_alert = 0;
		fwrite(&header, header_size, 1, outfile);
		fclose(outfile);
		tint = 0;
	}
	else
		tint = 1;
	return tint;
}
/****************************************************************************************
appends a new record to a chart
*****************************************************************************************/
void append_chart_record(char *filename, unsigned long date, float open, float high, float low, float close, unsigned long volume, unsigned long openint)
{
	FILE *outfile;
	extern int global_int, data_size, header_size;
	struct record1 data;
	struct record2 header;
	
	
	outfile = fopen(filename, "r+b");
	if (outfile)
	{
		fread(&header, header_size, 1, outfile);
		header.records++;
		header.last_date = date;
		if (header.first_date == 0)
			header.first_date = date;
		rewind(outfile);
		fwrite(&header, header_size, 1, outfile);
		fseek(outfile, 0L, SEEK_END);
		data.date = date;
		data.open = open;
		data.high = high;
		data.low = low;
		data.close = close;
		data.volume = volume;
		data.openint = openint;
		fwrite(&data, data_size, 1, outfile);
		fclose(outfile);
	}
	else
		global_int = 1;
}
/*************************************************************************************/
void save_chart_header()
{
	char tstring[250];
	FILE *outfile;
	extern char *datapath, *error_message;
	extern int header_size;
	extern struct record2 header;
	
	
	strcpy(tstring, datapath);
	strcat(tstring, header.symbol);
	outfile = fopen(tstring, "r+b");
    	if (! outfile)
	  RETURN_ERR(gs_cant_open_chart);

	fwrite(&header, header_size, 1, outfile);
	fclose(outfile);
}
/***************************************************************************************/
void ok_goto_chart()
{
	char tstring[5];
    	gint tint;
    	GList *list;
    	extern GtkWidget *goto_chart_clist, *goto_chart_window;
    	extern int group_pointer;
    	extern char *error_message;
    	

	list = GTK_CLIST (goto_chart_clist)->selection;
	if (list)
	{
      		tint = (int) list->data;
      		group_pointer = tint;
		load_file(tstring);
		if (goto_chart_window)
			gtk_widget_destroy(goto_chart_window);
    	}
    	else
	  RETURN_ERR(gs_nothing_selected);
}
/***************************************************************************************/
void goto_chart()
{
	GtkVisibility visible;
   	char tstring[250], tstring2[50], *line[4], *text[] = {"Symbol", "Name", "Start", "End"};
   	char tstring3[15];
   	int tint, tint2;
   	FILE *infile, *infile2;
   	GtkWidget *vbox, *hbox, *button, *button2, *button3, *hsep;
	extern GtkWidget *goto_chart_window, *goto_chart_clist;
	extern int group_size, chartflag, open_file_flag, group_pointer, header_size;
	extern char *groupfilename, *datapath, *error_message;
	struct record2 header;
	
   	
   	if (chartflag == 0)
   		return;
   	if (open_file_flag)
   		return;
	if (goto_chart_window)
	{
		gtk_clist_select_row(GTK_CLIST(goto_chart_clist), group_pointer, 0);
		visible = gtk_clist_row_is_visible(GTK_CLIST(goto_chart_clist), group_pointer);
		if ((visible==GTK_VISIBILITY_PARTIAL) || (visible==GTK_VISIBILITY_NONE))
			gtk_clist_moveto(GTK_CLIST(goto_chart_clist), group_pointer, 0, 0.5, 0);
   		return;
   	}
   		
	goto_chart_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (goto_chart_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &goto_chart_window);
	gtk_window_position(GTK_WINDOW (goto_chart_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (goto_chart_window), "Goto Chart");
	gtk_widget_set_usize(GTK_WIDGET (goto_chart_window), 0, 0);
	
	vbox = gtk_vbox_new (FALSE, 0);
      	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_container_add (GTK_CONTAINER (goto_chart_window), vbox);
      	gtk_widget_show (vbox);
      	
      	goto_chart_clist = gtk_clist_new_with_titles (4, text);
      	gtk_clist_set_column_width(GTK_CLIST(goto_chart_clist), 0, 70);
      	gtk_clist_set_column_width(GTK_CLIST(goto_chart_clist), 1, 200);
      	gtk_clist_set_column_width(GTK_CLIST(goto_chart_clist), 2, 70);
      	gtk_clist_set_column_width(GTK_CLIST(goto_chart_clist), 3, 70);
      	gtk_clist_set_selection_mode (GTK_CLIST (goto_chart_clist), GTK_SELECTION_SINGLE);
       	gtk_clist_set_policy (GTK_CLIST (goto_chart_clist), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
      	gtk_box_pack_start (GTK_BOX (vbox), goto_chart_clist, TRUE, TRUE, 0);
      	gtk_container_border_width (GTK_CONTAINER (goto_chart_clist), 10);
      	gtk_widget_set_usize(GTK_WIDGET (goto_chart_clist), 500, 200);
      	gtk_widget_show (goto_chart_clist);
			    
       	hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
       	gtk_widget_show(hsep);
        
       	hbox = gtk_hbutton_box_new();
       	gtk_container_border_width (GTK_CONTAINER (hbox), 10);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
	gtk_hbutton_box_set_spacing_default(10);
       	gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
	gtk_widget_show(hbox);
      	
	button = gtk_button_new_with_label("OK");
	gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 0);
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (ok_goto_chart), NULL);
	gtk_widget_show (button);
      	
	button2 = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (hbox), button2, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(goto_chart_window));
      	gtk_widget_show (button2);
      	
      	button3 = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (hbox), button3, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			    GTK_SIGNAL_FUNC (help_goto_chart_window), NULL);
      	gtk_widget_show (button3);
      	
      	gtk_clist_freeze (GTK_CLIST (goto_chart_clist));
      	infile = fopen(groupfilename, "rb");
      	if (! infile)
	  RETURN_ERR(gs_cant_open_group);

	for (tint = 0; tint <= group_size; tint++)
	{
		fread(&tstring2, GROUP_RECORDSIZE, 1, infile);
		strcpy(tstring, datapath);
		strcat(tstring, tstring2);
   		infile2 = fopen(tstring, "rb");
   		if (infile2)
   		{
   			fread(&header, header_size, 1, infile2);
   			tint2 = check_chart_version(header.version);
			if (tint2)
			{
				exit_program();
				exit(1);
			}
			line[1] = header.name;
			line[0] = header.symbol;
			sprintf(tstring3, "%ld", header.first_date);
			tstring[0] = tstring3[4];
			tstring[1] = tstring3[5];
			tstring[2] = '/';
			tstring[3] = tstring3[6];
			tstring[4] = tstring3[7];
			tstring[5] = '/';
			tstring[6] = tstring3[0];
			tstring[7] = tstring3[1];
			tstring[8] = tstring3[2];
			tstring[9] = tstring3[3];
			tstring[10] = 0;
			line[2] = tstring;
			sprintf(tstring3, "%ld", header.last_date);
			tstring2[0] = tstring3[4];
			tstring2[1] = tstring3[5];
			tstring2[2] = '/';
			tstring2[3] = tstring3[6];
			tstring2[4] = tstring3[7];
			tstring2[5] = '/';
			tstring2[6] = tstring3[0];
			tstring2[7] = tstring3[1];
			tstring2[8] = tstring3[2];
			tstring2[9] = tstring3[3];
			tstring2[10] = 0;
			line[3] = tstring2;
			gtk_clist_append (GTK_CLIST (goto_chart_clist), line);
			fclose(infile2);
		}
	}
       	fclose(infile);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default(button);
	gtk_widget_show(goto_chart_window);
	gtk_clist_select_row(GTK_CLIST(goto_chart_clist), group_pointer, 0);
	visible = gtk_clist_row_is_visible(GTK_CLIST(goto_chart_clist), group_pointer);
	if ((visible==GTK_VISIBILITY_PARTIAL) || (visible==GTK_VISIBILITY_NONE))
		gtk_clist_moveto(GTK_CLIST(goto_chart_clist), group_pointer, 0, 0.5, 0);
       	gtk_clist_thaw (GTK_CLIST (goto_chart_clist));
}
/****************************************************************************************/
void yes_delete_chart()
{
	FILE *infile, *outfile;
	long tlong;
	struct dirent **dirlist;
	char tstring[250], tstring2[250], tstring3[50], chart[50], *tstringpointer;
	GList *list;
	int tint, tint2, tint3, group_records;
	extern GtkWidget *workwith_charts_clist, *yesno_window;
	extern char *datapath, *grouppath;
	
	
	list = GTK_CLIST (workwith_charts_clist)->selection;
	tint = (int) list->data;
	gtk_clist_get_text(GTK_CLIST(workwith_charts_clist), tint, 0, &tstringpointer);  
	strcpy(tstring, datapath);
	strcat(tstring, tstringpointer);
	strcpy(chart, tstringpointer);
	unlink(tstring);
	gtk_clist_freeze (GTK_CLIST (workwith_charts_clist));
	gtk_clist_remove(GTK_CLIST(workwith_charts_clist), tint);
	gtk_clist_thaw (GTK_CLIST (workwith_charts_clist));
	
	tint = scandir(grouppath, &dirlist, NULL, alphasort);
	if (tint < 0)
		return;
	tint2 = tint;
	for (tint = 2; tint < tint2; tint++)
   	{
   		strcpy(tstring, grouppath);
   		strcat(tstring, dirlist[tint]->d_name);
   		infile = fopen(tstring, "rb");
   		fseek(infile, 0L, SEEK_END);
   		tlong = ftell(infile);
   		group_records = tlong / GROUP_RECORDSIZE;
   		fseek(infile, 0L, SEEK_SET);
   		strcpy(tstring2, grouppath);
   		strcat(tstring2, "temp.dat");
   		outfile = fopen(tstring2, "wb");
		for (tint3 = 0; tint3 <= group_records; tint3++)
		{   		
			fread(&tstring3, GROUP_RECORDSIZE, 1, infile);
			if (strcmp(chart, tstring3))
				fwrite(&tstring3, GROUP_RECORDSIZE, 1, outfile);
		}
		fclose(infile);
		fclose(outfile);
		unlink(tstring);
		rename(tstring2, tstring);
	}
	if (yesno_window)
		gtk_widget_destroy(yesno_window);
}
/*****************************************************************************************/
void delete_chart()
{
	GList *list;
	int tint;
	gchar *tstringpointer, tstring[250];
    	extern GtkWidget *workwith_charts_clist, *yesno_window, *yesno_yes_button;
    	extern GtkWidget *yesno_no_button;
    	extern char *error_message;
    	
	
	if (yesno_window)
		return;
    	list = GTK_CLIST (workwith_charts_clist)->selection;
    	if (! list)
	  RETURN_ERR(gs_nothing_selected);

	tint = (int) list->data;
	gtk_clist_get_text(GTK_CLIST(workwith_charts_clist), tint, 0, &tstringpointer);  
      	strcpy(tstring, "Are you sure you want to delete ");
      	strcat(tstring, tstringpointer);
      	strcat(tstring, " ?");
      	show_yesno_window(tstring);
      	gtk_signal_connect (GTK_OBJECT (yesno_yes_button), "clicked",
			    GTK_SIGNAL_FUNC (yes_delete_chart), NULL);
      	gtk_signal_connect_object (GTK_OBJECT (yesno_no_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(yesno_window));
}
/***********************************************************************************/
void ok_open_chart()
{
	GList *list;
	int tint;
	gchar *tstringpointer;
    	extern int open_file_flag;
    	extern GtkWidget *workwith_charts_clist, *workwith_charts_window;
    	extern char *error_message;
    	

    	list = GTK_CLIST (workwith_charts_clist)->selection;
    	if (! list)
	  RETURN_ERR(gs_nothing_selected);

	tint = (int) list->data;
	gtk_clist_get_text (GTK_CLIST (workwith_charts_clist), tint, 0, &tstringpointer);
	open_file_flag = 1;
    	load_file(tstringpointer);
    	if (workwith_charts_window)
    		gtk_widget_destroy(workwith_charts_window);
}
/****************************************************************************************/
void workwith_charts()
{
	char *text[] = {"Symbol", "Name", "Start", "End"};
	GtkWidget *vbox, *hbox, *open_button, *edit_button, *delete_button, *cancel_button;
	GtkWidget *help_button;
	extern GtkWidget *workwith_charts_window, *workwith_charts_clist, *workwith_groups_window;

    	
	if (workwith_charts_window)
		return;
	if (workwith_groups_window)
		return;
		
	workwith_charts_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (workwith_charts_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &workwith_charts_window);
	gtk_window_position(GTK_WINDOW (workwith_charts_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (workwith_charts_window), "Work With Charts");
	gtk_container_border_width (GTK_CONTAINER (workwith_charts_window), 0);
	
	hbox = gtk_hbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      	gtk_container_add (GTK_CONTAINER (workwith_charts_window), hbox);
      	gtk_widget_show (hbox);
      	
      	workwith_charts_clist = gtk_clist_new_with_titles (4, text);
      	gtk_clist_set_column_width(GTK_CLIST(workwith_charts_clist), 0, 70);
      	gtk_clist_set_column_width(GTK_CLIST(workwith_charts_clist), 1, 200);
      	gtk_clist_set_column_width(GTK_CLIST(workwith_charts_clist), 2, 70);
      	gtk_clist_set_column_width(GTK_CLIST(workwith_charts_clist), 3, 70);
      	gtk_clist_set_selection_mode (GTK_CLIST (workwith_charts_clist), GTK_SELECTION_SINGLE);
       	gtk_clist_set_policy(GTK_CLIST(workwith_charts_clist),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
      	gtk_container_add (GTK_CONTAINER (hbox), workwith_charts_clist);
      	gtk_container_border_width (GTK_CONTAINER (workwith_charts_clist), 0);
      	gtk_widget_set_usize(GTK_WIDGET (workwith_charts_clist), 465, 0);
      	gtk_widget_show (workwith_charts_clist);
      	
      	vbox = gtk_vbutton_box_new();
      	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);
      	gtk_vbutton_box_set_spacing_default(5);
        gtk_vbutton_box_set_layout_default(GTK_BUTTONBOX_START);
      	gtk_widget_show (vbox);
      	
      	open_button = gtk_button_new_with_label("Open");
      	gtk_box_pack_start (GTK_BOX (vbox), open_button, FALSE, TRUE, 0);
	gtk_signal_connect (GTK_OBJECT (open_button), "clicked",
		    	    GTK_SIGNAL_FUNC (ok_open_chart), NULL);
	gtk_widget_show (open_button);
	
      	edit_button = gtk_button_new_with_label("Edit");
      	gtk_box_pack_start (GTK_BOX (vbox), edit_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
			    GTK_SIGNAL_FUNC (edit_chart_data), NULL);
	gtk_widget_show (edit_button);
	
      	delete_button = gtk_button_new_with_label("Delete");
      	gtk_box_pack_start (GTK_BOX (vbox), delete_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
			    GTK_SIGNAL_FUNC (delete_chart), NULL);
	gtk_widget_show (delete_button);
	
      	cancel_button = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (vbox), cancel_button, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(workwith_charts_window));
      	gtk_widget_show (cancel_button);
      	
      	help_button = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (vbox), help_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (help_button), "clicked",
			    GTK_SIGNAL_FUNC (help_workwith_charts_window), NULL);
      	gtk_widget_show (help_button);
      	
      	show_chart_list(workwith_charts_clist);
      	gtk_widget_show(workwith_charts_window);
}
/******************************************************************************************/
void load_file(char *filename)
{
	int tint;
	char *tstringpointer, tstring[250], tstring2[50];
	unsigned int tuint;
	float tfloat;
   	FILE *infile;
   	extern char *groupfilename, *datapath, *error_message;
	extern float maxhigh, maxlow, range;
	extern unsigned long volume_high;
	extern unsigned int records;
	extern GtkWidget *main_window, *data_button, *alert_button;
	extern GtkWidget *goto_chart_window, *indicator_button;
	extern int chartflag, open_file_flag, group_pointer, header_size, data_size;
	extern int edit_chart_save_flag;
	extern struct record1 *data;
	extern struct record2 header;
	extern struct record3 config;
	
	
	
	if (! open_file_flag)
	{
		infile = fopen(groupfilename, "rb");
		if (! infile)
		  RETURN_ERR(gs_cant_open_group);

		fseek(infile, group_pointer * GROUP_RECORDSIZE, SEEK_SET);
		fread(&tstring2, GROUP_RECORDSIZE, 1, infile);
		fclose(infile);
        	if (strlen(tstring2) == 0)
		  RETURN_ERR(gs_group_empty);

        }
	if (open_file_flag)
	{
		strcpy(tstring, datapath);
		strcat(tstring, filename);
	}
	else
	{
		strcpy(tstring, datapath);
		strcat(tstring, tstring2);
	}
	infile = fopen(tstring, "rb");
	if (! infile)
		RETURN_ERR(gs_cant_open_chart);
	
	maxhigh = 0;
	maxlow = 9999999;
	volume_high = 0;
	
	if (chartflag)
	{
		if (! edit_chart_save_flag)
			save_chart_header();
	}
	if (data)
		free(data);
	fread(&header, header_size, 1, infile);
	tint = check_chart_version(header.version);
	if (tint)
	{
		exit_program();
		exit(1);
	}
  	if (config.bars == 0)
  	{
		records = header.records;
		data = (struct record1 *) malloc(records * data_size);
		for (tuint = 0; tuint < records; tuint++)
		{
			fread(&data[tuint], data_size, 1, infile);
			if (data[tuint].high != 0)
			{
         			if (data[tuint].high > maxhigh)
         				maxhigh = data[tuint].high;
         		}
         		else
         		{
         			if (data[tuint].close > maxhigh)
         				maxhigh = data[tuint].close;
         		}
         		if (data[tuint].low != 0)
         		{
         			if (data[tuint].low < maxlow)
         				maxlow = data[tuint].low;
         		}
         		else
         		{
         			if (data[tuint].close < maxlow)
         				maxlow = data[tuint].close;
         		}
         		if (data[tuint].volume > volume_high)
         			volume_high = data[tuint].volume;
         	}
	}
	else
	{
		if (config.bars >= header.records)
			records = header.records;
		else
		{
			records = config.bars;
			fseek(infile, (long)((header.records - records) * data_size) + header_size, SEEK_SET);
		}
		data = (struct record1 *) malloc(records * data_size);
		for (tuint = 0; tuint < records; tuint++)
		{
			fread(&data[tuint], data_size, 1, infile);
			if (data[tuint].high != 0)
			{
         			if (data[tuint].high > maxhigh)
         				maxhigh = data[tuint].high;
         		}
         		else
         		{
         			if (data[tuint].close > maxhigh)
         				maxhigh = data[tuint].close;
         		}
         		if (data[tuint].low != 0)
         		{
         			if (data[tuint].low < maxlow)
         				maxlow = data[tuint].low;
         		}
         		else
         		{
         			if (data[tuint].close < maxlow)
         				maxlow = data[tuint].close;
         		}
         		if (data[tuint].volume > volume_high)
         			volume_high = data[tuint].volume;
         	}
	}
	fclose(infile);
	tfloat = (maxhigh - maxlow) / 100;
	maxhigh = maxhigh + tfloat;
	maxlow = maxlow - tfloat;
	range = maxhigh - maxlow;
	if (open_file_flag == 1)
	{
		strcpy(tstring, "gstalker: ");
		strcat(tstring, header.name);
		strcat(tstring, " (");
		strcat(tstring, header.symbol);
		strcat(tstring, ")");
		if (GTK_TOGGLE_BUTTON(data_button)->active)
			show_data_window();
		if (GTK_TOGGLE_BUTTON(indicator_button)->active)
			edit_indicators();
		if (GTK_TOGGLE_BUTTON(alert_button)->active)
			edit_alerts();
	}
	else
	{
		strcpy(tstring, "gstalker: [");
		tstringpointer = strrchr(groupfilename, '/');
		strcat(tstring, tstringpointer + 1);
		strcat(tstring, "] - ");
		strcat(tstring, header.name);
		strcat(tstring, " (");
		strcat(tstring, header.symbol);
		strcat(tstring, ")");
		if (GTK_TOGGLE_BUTTON(data_button)->active)
	      		show_data_window();
		if (GTK_TOGGLE_BUTTON(indicator_button)->active)
			edit_indicators();
		if (GTK_TOGGLE_BUTTON(alert_button)->active)
			edit_alerts();
		if (goto_chart_window)
			goto_chart();
	}
	gtk_window_set_title (GTK_WINDOW (main_window), tstring);
	
	chartflag = 1;
	if (config.top_enable_flag)
		update_stats_bar();
	show_indicators();
	draw();
}