/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */
 
 
#include "myheader.h"
#include "myerrors.h"	/* for gs_err_enum and gs_err_msgs */
#include <string.h>
#include <ctype.h>
#include <dirent.h>
#include <unistd.h>


/*************************************************************************************/
void toggle_global_alerts()
{
	extern GtkWidget *yesno_window;
    	extern struct record3 config;
    	
    	
    	if (config.global_alerts)
    		config.global_alerts = 0;
    	else
    		config.global_alerts = 1;
	update_alerts_clist();
	if (yesno_window)
		gtk_widget_destroy(yesno_window);
}
/************************************************************************************/
void yesno_global_alerts()
{
	char tstring[250];
    	extern GtkWidget *yesno_window, *yesno_yes_button, *yesno_no_button;
    	extern struct record3 config;
    	
	
	if (config.global_alerts)
		strcpy(tstring, "Turn off global alerts?");
	else
		strcpy(tstring, "Turn on global alerts?");
	show_yesno_window(tstring);
   	gtk_signal_connect (GTK_OBJECT (yesno_yes_button), "clicked",
			    GTK_SIGNAL_FUNC (toggle_global_alerts), NULL);
      	gtk_signal_connect_object (GTK_OBJECT (yesno_no_button), "clicked",
			    	   GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    	   GTK_OBJECT(yesno_window));
}
/*****************************************************************************/
void scan_ma(char *filename, unsigned int record, int manum)
{
	int tint = 0, tint2 = 0, type = 0, length = 0;
	float tfloat = 0.0, ma = 0.0, ma2 = 0.0, close, close2, expo, expo2;
	unsigned long date, date2;
	char tstring[25], tstring2[25], tstring3[25], tstring4[25], tstring5[25], *line[5];
	FILE *infile;
	struct record2 header;
	struct record1 data;
	extern struct record3 config;
	extern int header_size, data_size;
	extern GtkWidget *alert_window_clist;
	
	
	
	infile = fopen(filename, "rb");
	fread(&header, header_size, 1, infile);
	if ((header.records - 1) == record)
	{
		fseek(infile, (long)((record - 1) * data_size) + header_size, SEEK_SET);
		fread(&data, data_size, 1, infile);
	}
	else
		fseek(infile, (long)((record) * data_size) + header_size, SEEK_SET);
	fread(&data, data_size, 1, infile);
	date = data.date;
	close = data.close;
	fseek(infile, (long)((record - 1) * data_size) + header_size, SEEK_SET);
	fread(&data, data_size, 1, infile);
	date2 = data.date;
	close2 = data.close;
	
	if (config.global_alerts)
	{
		switch(manum)
		{
			case 1: type = config.global_moving_type;
				length = config.global_moving_length;
				break;
			case 2: type = config.global_moving2_type;
				length = config.global_moving2_length;
				break;
			case 3: type = config.global_moving3_type;
				length = config.global_moving3_length;
				break;
			default: break;
		}
	}
	else
	{
		switch(manum)
		{
			case 1: type = header.moving[1];
				length = header.moving[2];
				break;
			case 2: type = header.moving2[1];
				length = header.moving2[2];
				break;
			case 3: type = header.moving3[1];
				length = header.moving3[2];
				break;
			default: break;
		}
	}
	
	switch(type)
	{
		case 1:	fseek(infile, (long)((record - (length + 1)) * data_size) + header_size, SEEK_SET);
			for(tint = 0; tint < length; tint++)
			{
				fread(&data, data_size, 1, infile);
				tfloat = tfloat + data.close;
			}
			ma2 = tfloat / length;
			fseek(infile, (long)((record - length) * data_size) + header_size, SEEK_SET);
			tfloat = 0.0;
			for(tint = 0; tint < length; tint++)
			{
				fread(&data, data_size, 1, infile);
				tfloat = tfloat + data.close;
			}
			ma = tfloat / length;
			break;
		case 2: fseek(infile, (long)((record - (length + 1)) * data_size) + header_size, SEEK_SET);
			for(tint = 1, tint2 = 0; tint <= length; tint++)
			{
				fread(&data, data_size, 1, infile);
				tfloat = tfloat + (data.close * tint);
				tint2 = tint2 + tint;
			}
			ma2 = tfloat / tint2;
			fseek(infile, (long)((record - length) * data_size) + header_size, SEEK_SET);
			tfloat = 0.0;
			for(tint = 1, tint2 = 0; tint <= length; tint++)
			{
				fread(&data, data_size, 1, infile);
				tfloat = tfloat + (data.close * tint);
				tint2 = tint2 + tint;
			}
			ma = tfloat / tint2;
			break;
		case 3: fseek(infile, (long)((record - (length + 1)) * data_size) + header_size, SEEK_SET);
			tfloat = 0.0;
			for(tint = 0; tint < length; tint++)
			{
				fread(&data, data_size, 1, infile);
				tfloat = tfloat + data.close;
			}
			tfloat = tfloat / length;
			fread(&data, data_size, 1, infile);
			expo = 2.0 / (length + 1);
			expo2 = 1.0 - expo;
			ma2 = (data.close * expo) + (tfloat * expo2);
			fseek(infile, (long)((record - length) * data_size) + header_size, SEEK_SET);
			tfloat = 0.0;
			for(tint = 0; tint < length; tint++)
			{
				fread(&data, data_size, 1, infile);
				tfloat = tfloat + data.close;
			}
			tfloat = tfloat / length;
			fread(&data, data_size, 1, infile);
			expo = 2.0 / (length + 1);
			expo2 = 1.0 - expo;
			ma = (data.close * expo) + (tfloat * expo2);
			break;
		default: break;
	}
	
	if (close2 > ma2)
	{
		if (close <= ma)
		{
			sprintf(tstring, "%ld", date);
			tstring2[0] = tstring[4];
			tstring2[1] = tstring[5];
			tstring2[2] = '/';
			tstring2[3] = tstring[6];
			tstring2[4] = tstring[7];
			tstring2[5] = '/';
			tstring2[6] = tstring[0];
			tstring2[7] = tstring[1];
			tstring2[8] = tstring[2];
			tstring2[9] = tstring[3];
			tstring2[10] = 0;
			line[0] = tstring2;
			line[1] = header.symbol;
			switch(manum)
			{
				case 1: switch(type)
					{
						case 1: strcpy(tstring3, "Close <= MA 1 Simple");
						break;
						case 2: strcpy(tstring3, "Close <= MA 1 Weighted");
						break;
						case 3: strcpy(tstring3, "Close <= MA 1 Exponential");
						break;
						default: break;
					}
					break;
				case 2: switch(type)
					{
						case 1: strcpy(tstring3, "Close <= MA 2 Simple");
						break;
						case 2: strcpy(tstring3, "Close <= MA 2 Weighted");
						break;
						case 3: strcpy(tstring3, "Close <= MA 2 Exponential");
						break;
						default: break;
					}
					break;
				case 3: switch(type)
					{
						case 1: strcpy(tstring3, "Close <= MA 3 Simple");
						break;
						case 2: strcpy(tstring3, "Close <= MA 3 Weighted");
						break;
						case 3: strcpy(tstring3, "Close <= MA 3 Exponential");
						break;
						default: break;
					}
					break;
				default: break;
			}
			line[2] = tstring3;
			sprintf(tstring4, "%g", close);
			line[3] = tstring4;
			sprintf(tstring5, "%g", ma);
			line[4] = tstring5;
			gtk_clist_append (GTK_CLIST (alert_window_clist), line);
		}
	}
	if (close2 < ma2)
	{
		if (close >= ma)
		{
			sprintf(tstring, "%ld", date);
			tstring2[0] = tstring[4];
			tstring2[1] = tstring[5];
			tstring2[2] = '/';
			tstring2[3] = tstring[6];
			tstring2[4] = tstring[7];
			tstring2[5] = '/';
			tstring2[6] = tstring[0];
			tstring2[7] = tstring[1];
			tstring2[8] = tstring[2];
			tstring2[9] = tstring[3];
			tstring2[10] = 0;
			line[0] = tstring2;
			line[1] = header.symbol;
			switch(manum)
			{
				case 1: switch(type)
					{
						case 1: strcpy(tstring3, "Close >= MA 1 Simple");
						break;
						case 2: strcpy(tstring3, "Close >= MA 1 Weighted");
						break;
						case 3: strcpy(tstring3, "Close >= MA 1 Exponential");
						break;
						default: break;
					}
					break;
				case 2: switch(type)
					{
						case 1: strcpy(tstring3, "Close >= MA 2 Simple");
						break;
						case 2: strcpy(tstring3, "Close >= MA 2 Weighted");
						break;
						case 3: strcpy(tstring3, "Close >= MA 2 Exponential");
						break;
						default: break;
					}
					break;
				case 3: switch(type)
					{
						case 1: strcpy(tstring3, "Close >= MA 3 Simple");
						break;
						case 2: strcpy(tstring3, "Close >= MA 3 Weighted");
						break;
						case 3: strcpy(tstring3, "Close >= MA 3 Exponential");
						break;
						default: break;
					}
					break;
				default: break;
			}
			line[2] = tstring3;
			sprintf(tstring4, "%g", close);
			line[3] = tstring4;
			sprintf(tstring5, "%g", ma);
			line[4] = tstring5;
			gtk_clist_append (GTK_CLIST (alert_window_clist), line);
		}
	}
	fclose(infile);
}
/*****************************************************************************/
void scan_threshold(char *filename, unsigned int record)
{
	float target;
	char tstring[25], tstring2[50], tstring3[25], tstring4[25], *line[5];
	FILE *infile;
	struct record2 header;
	struct record1 data, data2;
	extern int header_size, data_size;
	extern GtkWidget *alert_window_clist;
	extern struct record3 config;
	
	
	
	infile = fopen(filename, "rb");
	fread(&header, header_size, 1, infile);
	fseek(infile, (long)((record - 1) * data_size) + header_size, SEEK_SET);
	fread(&data2, data_size, 1, infile);
	fread(&data, data_size, 1, infile);
	if (config.global_alerts)
		target = config.global_threshold;
	else
		target = header.threshold;
	if (data2.close > target)
	{
		if (data.close <= target)
		{
			sprintf(tstring2, "%ld", data.date);
			tstring[0] = tstring2[4];
			tstring[1] = tstring2[5];
			tstring[2] = '/';
			tstring[3] = tstring2[6];
			tstring[4] = tstring2[7];
			tstring[5] = '/';
			tstring[6] = tstring2[0];
			tstring[7] = tstring2[1];
			tstring[8] = tstring2[2];
			tstring[9] = tstring2[3];
			tstring[10] = 0;
			line[0] = tstring;
			line[1] = header.symbol;
			strcpy(tstring2, "Close <= ");
			sprintf(tstring3, "%g", target);
			strcat(tstring2, tstring3);
			strcat(tstring2, " Threshold");
			line[2] = tstring2;
			sprintf(tstring3, "%g", data.close);
			line[3] = tstring3;
			sprintf(tstring4, "%g", target);
			line[4] = tstring4;
			gtk_clist_append (GTK_CLIST (alert_window_clist), line);
		}
	}
	if (data2.close < target)
	{
		if (data.close >= target)
		{
			sprintf(tstring2, "%ld", data.date);
			tstring[0] = tstring2[4];
			tstring[1] = tstring2[5];
			tstring[2] = '/';
			tstring[3] = tstring2[6];
			tstring[4] = tstring2[7];
			tstring[5] = '/';
			tstring[6] = tstring2[0];
			tstring[7] = tstring2[1];
			tstring[8] = tstring2[2];
			tstring[9] = tstring2[3];
			tstring[10] = 0;
			line[0] = tstring;
			line[1] = header.symbol;
			strcpy(tstring2, "Close >= ");
			sprintf(tstring3, "%g", target);
			strcat(tstring2, tstring3);
			strcat(tstring2, " Threshold");
			line[2] = tstring2;
			sprintf(tstring3, "%g", data.close);
			line[3] = tstring3;
			sprintf(tstring4, "%g", target);
			line[4] = tstring4;
			gtk_clist_append (GTK_CLIST (alert_window_clist), line);
		}
	}
	fclose(infile);
}
/******************************************************************************/
void scan_closeroc(char *filename, unsigned int record)
{
	char tstring[25], tstring2[50], tstring3[25], tstring4[25], *line[5];
	float tfloat = 0.0, tfloat2 = 0.0, target;
	FILE *infile;
	struct record2 header;
	struct record1 data, data2;
	extern int header_size, data_size;
	extern GtkWidget *alert_window_clist;
	extern struct record3 config;
	
	
	infile = fopen(filename, "rb");
	fread(&header, header_size, 1, infile);
	fseek(infile, (long)((record - 1) * data_size) + header_size, SEEK_SET);
	fread(&data2, data_size, 1, infile);
	fread(&data, data_size, 1, infile);
	tfloat2 = data.close - data2.close;
	if (data2.close != 0)
		tfloat = (tfloat2 / data2.close) * 100;
	else
		return;
	if (config.global_alerts)
		target = config.global_closeroc;
	else
		target = header.closeroc;
	if (target < 0)
	{
		if (tfloat <= target)
		{
			sprintf(tstring2, "%ld", data.date);
			tstring[0] = tstring2[4];
			tstring[1] = tstring2[5];
			tstring[2] = '/';
			tstring[3] = tstring2[6];
			tstring[4] = tstring2[7];
			tstring[5] = '/';
			tstring[6] = tstring2[0];
			tstring[7] = tstring2[1];
			tstring[8] = tstring2[2];
			tstring[9] = tstring2[3];
			tstring[10] = 0;
			line[0] = tstring;
			line[1] = header.symbol;
			strcpy(tstring2, "Close >= ");
			sprintf(tstring3, "%g", target);
			strcat(tstring2, tstring3);
			strcat(tstring2, " % Price ROC");
			line[2] = tstring2;
			sprintf(tstring3, "%g", data.close);
			line[3] = tstring3;
			sprintf(tstring4, "%5.2f", tfloat);
			strcat(tstring4, " %");
			line[4] = tstring4;
			gtk_clist_append (GTK_CLIST (alert_window_clist), line);
		}
	}
	else
	{
		if (tfloat >= target)
		{
			sprintf(tstring2, "%ld", data.date);
			tstring[0] = tstring2[4];
			tstring[1] = tstring2[5];
			tstring[2] = '/';
			tstring[3] = tstring2[6];
			tstring[4] = tstring2[7];
			tstring[5] = '/';
			tstring[6] = tstring2[0];
			tstring[7] = tstring2[1];
			tstring[8] = tstring2[2];
			tstring[9] = tstring2[3];
			tstring[10] = 0;
			line[0] = tstring;
			line[1] = header.symbol;
			strcpy(tstring2, "Close >= ");
			sprintf(tstring3, "%g", target);
			strcat(tstring2, tstring3);
			strcat(tstring2, " % Price ROC");
			line[2] = tstring2;
			sprintf(tstring3, "%g", data.close);
			line[3] = tstring3;
			sprintf(tstring4, "%5.2f", tfloat);
			strcat(tstring4, " %");
			line[4] = tstring4;
			gtk_clist_append (GTK_CLIST (alert_window_clist), line);
		}
	}
	fclose(infile);
}
/********************************************************************************/
void scan_volumeroc(char *filename, unsigned int record)
{
	char tstring[25], tstring2[50], tstring3[25], tstring4[25], *line[5];
	float tfloat = 0.0, target;
	long tlong;
	FILE *infile;
	struct record2 header;
	struct record1 data, data2;
	extern int header_size, data_size;
	extern GtkWidget *alert_window_clist;
	extern struct record3 config;	
	
	
	infile = fopen(filename, "rb");
	fread(&header, header_size, 1, infile);
	fseek(infile, (long)((record - 1) * data_size) + header_size, SEEK_SET);
	fread(&data2, data_size, 1, infile);
	fread(&data, data_size, 1, infile);
	if (data.volume != 0)
	{
		tlong = data.volume - data2.volume;
		tfloat = ((float)tlong / (float)data2.volume) * 100;
	}
	else
			return;
	if (config.global_alerts)
		target = config.global_volumeroc;
	else
		target = header.volumeroc;
	if (target < 0)
	{
		if (tfloat <= target)
		{
			sprintf(tstring2, "%ld", data.date);
			tstring[0] = tstring2[4];
			tstring[1] = tstring2[5];
			tstring[2] = '/';
			tstring[3] = tstring2[6];
			tstring[4] = tstring2[7];
			tstring[5] = '/';
			tstring[6] = tstring2[0];
			tstring[7] = tstring2[1];
			tstring[8] = tstring2[2];
			tstring[9] = tstring2[3];
			tstring[10] = 0;
			line[0] = tstring;
			line[1] = header.symbol;
			strcpy(tstring2, "Close >= ");
			sprintf(tstring3, "%g", target);
			strcat(tstring2, tstring3);
			strcat(tstring2, " % Volume ROC");
			line[2] = tstring2;
			sprintf(tstring3, "%ld", data.volume);
			line[3] = tstring3;
			sprintf(tstring4, "%5.2f", tfloat);
			strcat(tstring4, " %");
			line[4] = tstring4;
			gtk_clist_append (GTK_CLIST (alert_window_clist), line);
		}
	}
	else
	{
		if (tfloat >= target)
		{
			sprintf(tstring2, "%ld", data.date);
			tstring[0] = tstring2[4];
			tstring[1] = tstring2[5];
			tstring[2] = '/';
			tstring[3] = tstring2[6];
			tstring[4] = tstring2[7];
			tstring[5] = '/';
			tstring[6] = tstring2[0];
			tstring[7] = tstring2[1];
			tstring[8] = tstring2[2];
			tstring[9] = tstring2[3];
			tstring[10] = 0;
			line[0] = tstring;
			line[1] = header.symbol;
			strcpy(tstring2, "Close >= ");
			sprintf(tstring3, "%g", target);
			strcat(tstring2, tstring3);
			strcat(tstring2, " % Volume ROC");
			line[2] = tstring2;
			sprintf(tstring3, "%ld", data.volume);
			line[3] = tstring3;
			sprintf(tstring4, "%5.2f", tfloat);
			strcat(tstring4, " %");
			line[4] = tstring4;
			gtk_clist_append (GTK_CLIST (alert_window_clist), line);
		}
	}
	fclose(infile);
}
/********************************************************************************/
void update_alerts2()
{
	char tstring[15];
	int tint, tint2;
    	GList *list;
	char *text;
	extern GtkWidget *edit_alerts2_window, *edit_alerts2_entry, *edit_alerts_clist;
	extern struct record2 header;
	extern struct record3 config;
	extern char *error_message;
		
	
	text = gtk_entry_get_text(GTK_ENTRY(edit_alerts2_entry));
	strcpy(tstring, text);
	tint = strlen(tstring);
	for (tint2 = 0; tint2 < tint; tint2++)
	{
		if (! isdigit(tstring[tint2]))
		{
			if ((tstring[tint2] != '.') && (tstring[tint2] != '-'))
				RETURN_ERR(gs_invalid_entry);
		}
	}
	list = GTK_CLIST (edit_alerts_clist)->selection;
	tint = (int) list->data;
	if (tint == 3)
	{
		if (config.global_alerts)
			config.global_closeroc = (float) atof(text);
		else
			header.closeroc = (float) atof(text);
	}
	if (tint == 4)
	{
		if (config.global_alerts)
			config.global_threshold = (float) atof(text);
		else
			header.threshold = (float) atof(text);
	}
	if (tint == 5)
	{
		if (config.global_alerts)
			config.global_volumeroc = (float) atof(text);
		else
			header.volumeroc = (float) atof(text);
	}
	update_alerts_clist();
	gtk_widget_destroy(edit_alerts2_window);
}
/*********************************************************************************/
void update_alerts_clist()
{
	int tint = 0, flag = 0, type=0, type2=0, type3=0, status=0, status2=0, status3=0;
	int status4=0, status5=0, status6=0, length=0, length2=0, length3=0;
	float value=0.0, value2=0.0, value3=0.0;
    	GList *list;
	GdkPixmap *on = NULL, *off = NULL;
	GdkBitmap *mask;
	GtkStyle *style;
	char tstring[250], tstring2[15], tstring3[15], *line[3];
	extern struct record2 header;
	extern struct record3 config;
	extern GtkWidget *edit_alerts_clist, *main_window, *edit_alerts_window;
	
	
	style = gtk_widget_get_style(edit_alerts_clist);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_on.xpm");
    	on = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					&style->bg[GTK_STATE_NORMAL], tstring);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_off.xpm");
    	off = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	
	list = GTK_CLIST (edit_alerts_clist)->selection;
	if (list)
	{
		tint = (int) list->data;
		flag++;
	}
      	gtk_clist_clear(GTK_CLIST(edit_alerts_clist));
      	
      	if (config.global_alerts)
      	{
      		type = config.global_moving_type;
      		type2 = config.global_moving2_type;
      		type3 = config.global_moving3_type;
      		length = config.global_moving_length;
      		length2 = config.global_moving2_length;
      		length3 = config.global_moving3_length;
      		status = config.global_alerts_moving_status;
      		status2 = config.global_alerts_moving2_status;
      		status3 = config.global_alerts_moving3_status;
      		status4 = config.global_alerts_closeroc_status;
      		status5 = config.global_alerts_threshold_status;
      		status6 = config.global_alerts_volumeroc_status;
      		value = config.global_closeroc;
      		value2 = config.global_threshold;
      		value3 = config.global_volumeroc;
      	}
      	else
      	{
      		type = header.moving[1];
      		type2 = header.moving2[1];
      		type3 = header.moving3[1];
      		length = header.moving[2];
      		length2 = header.moving2[2];
      		length3 = header.moving3[2];
      		status = header.ma_alert;
      		status2 = header.ma2_alert;
      		status3 = header.ma3_alert;
      		status4 = header.closeroc_status;
      		status5 = header.threshold_status;
      		status6 = header.volumeroc_status;
      		value = header.closeroc;
      		value2 = header.threshold;
      		value3 = header.volumeroc;
      	}
      	
      	line[0] = 0;
	switch(type)
      	{
      		case 1: strcpy(tstring2, "MA 1 Simple");
      			break;
      		case 2: strcpy(tstring2, "MA 1 Weighted");
      			break;
      		case 3: strcpy(tstring2, "MA 1 Exponential");
      			break;
      		default: break;
      	}
      	line[1] = tstring2;
      	sprintf(tstring3, "%d", length);
      	line[2] = tstring3;
      	gtk_clist_append (GTK_CLIST (edit_alerts_clist), line);
      	if (status)
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 0, 0, on, mask);
      	else
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 0, 0, off, mask);
      	
      	line[0] = 0;
      	switch(type2)
      	{
      		case 1: strcpy(tstring2, "MA 2 Simple");
      			break;
      		case 2: strcpy(tstring2, "MA 2 Weighted");
      			break;
      		case 3: strcpy(tstring2, "MA 2 Exponential");
      			break;
      		default: break;
      	}
      	line[1] = tstring2;
     	sprintf(tstring3, "%d", length2);
      	line[2] = tstring3;
      	gtk_clist_append (GTK_CLIST (edit_alerts_clist), line);
     	if (status2)
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 1, 0, on, mask);
      	else
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 1, 0, off, mask);
      	
      		
      	line[0] = 0;
      	switch(type3)
      	{
      		case 1: strcpy(tstring2, "MA 3 Simple");
      			break;
      		case 2: strcpy(tstring2, "MA 3 Weighted");
      			break;
      		case 3: strcpy(tstring2, "MA 3 Exponential");
      			break;
      		default: break;
      	}
      	line[1] = tstring2;
      	sprintf(tstring3, "%d", length3);
      	line[2] = tstring3;
      	gtk_clist_append (GTK_CLIST (edit_alerts_clist), line);
      	if (status3)
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 2, 0, on, mask);
      	else
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 2, 0, off, mask);
      	
      	
      	line[0] = 0;
     	strcpy(tstring2, "Close ROC");
      	line[1] = tstring2;
     	sprintf(tstring3, "%g", value);
      	line[2] = tstring3;
      	gtk_clist_append (GTK_CLIST (edit_alerts_clist), line);
      	if (status4)
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 3, 0, on, mask);
      	else
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 3, 0, off, mask);
      	
     	strcpy(tstring2, "Threshold");
      	line[1] = tstring2;
      	sprintf(tstring3, "%g", value2);
      	line[2] = tstring3;
      	gtk_clist_append (GTK_CLIST (edit_alerts_clist), line);
      	if (status5)
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 4, 0, on, mask);
      	else
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 4, 0, off, mask);
      	
      	strcpy(tstring2, "Volume ROC");
      	line[1] = tstring2;
      	sprintf(tstring3, "%g", value3);
      	line[2] = tstring3;
      	gtk_clist_append (GTK_CLIST (edit_alerts_clist), line);
      	if (status6)
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 5, 0, on, mask);
      	else
      		gtk_clist_set_pixmap(GTK_CLIST(edit_alerts_clist), 5, 0, off, mask);
      	
      	if (flag)
      		gtk_clist_select_row(GTK_CLIST(edit_alerts_clist), tint, 0);
      		
      	if (config.global_alerts)
		strcpy(tstring, "Edit Global Alerts - ");
	else
        	strcpy(tstring, "Edit Alerts - ");
	strcat(tstring, header.name);
	strcat(tstring, " (");
	strcat(tstring, header.symbol);
	strcat(tstring, ")");
	gtk_window_set_title (GTK_WINDOW (edit_alerts_window), tstring);
}
/*********************************************************************************/
void ok_edit_alerts()
{
	int tint;
    	GList *list;
	char tstring[50], *value;
	GtkWidget *vbox, *hbox, *hbox2, *label, *button, *button2, *button3, *hsep;
	extern GtkWidget *edit_alerts2_window, *edit_alerts2_entry, *edit_alerts_clist;
	extern struct record3 config;
    	
	
	
	list = GTK_CLIST (edit_alerts_clist)->selection;
	tint = (int) list->data;
	if (tint < 3)
		return;
	
	edit_alerts2_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (edit_alerts2_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &edit_alerts2_window);
	gtk_window_position(GTK_WINDOW (edit_alerts2_window), GTK_WIN_POS_CENTER);
	gtk_widget_set_usize(GTK_WIDGET (edit_alerts2_window), 0, 0);
	
	vbox = gtk_vbox_new (FALSE, 0);
      	gtk_container_add (GTK_CONTAINER (edit_alerts2_window), vbox);
      	gtk_widget_show (vbox);
      	
     	hbox = gtk_hbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_widget_show (hbox);
      	
	label = gtk_label_new("Value:");
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 0);
        gtk_widget_show(label);
        
	gtk_clist_get_text (GTK_CLIST (edit_alerts_clist), tint, 2, &value);
	edit_alerts2_entry = gtk_entry_new ();
      	gtk_entry_set_text(GTK_ENTRY(edit_alerts2_entry), value);
      	gtk_box_pack_start (GTK_BOX (hbox), edit_alerts2_entry, FALSE, TRUE, 0);
      	gtk_widget_show (edit_alerts2_entry);
      	
      	if (config.global_alerts)
      		strcpy(tstring, "Editing Global ");
      	else
      		strcpy(tstring, "Editing ");
      	gtk_clist_get_text (GTK_CLIST (edit_alerts_clist), tint, 1, &value);
      	strcat(tstring, value);
      	gtk_window_set_title (GTK_WINDOW (edit_alerts2_window), tstring);
      	
        hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        gtk_widget_show(hsep);
        
        hbox2 = gtk_hbutton_box_new();
        gtk_hbutton_box_set_spacing_default(10);
        gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
        gtk_container_border_width (GTK_CONTAINER (hbox2), 10);
        gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, TRUE, 0);
      	gtk_widget_show(hbox2);
      	
      	button = gtk_button_new_with_label("OK");
      	gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
     	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (update_alerts2), NULL);
	gtk_widget_show (button);
	
	button2 = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (hbox2), button2, TRUE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(edit_alerts2_window));
      	gtk_widget_show (button2);
      	
      	button3 = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (hbox2), button3, TRUE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			    GTK_SIGNAL_FUNC (help_edit_indicator_window), NULL);
      	gtk_widget_show (button3);
      	
      	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default(button);
      	gtk_widget_show(edit_alerts2_window);
}
/*********************************************************************************/
void toggle_alerts()
{
	int tint;
    	GList *list;
	char *text;
	extern GtkWidget *edit_alerts_clist;
    	extern char *error_message;
    	extern struct record2 header;
    	extern struct record3 config;
    	
    	
	list = GTK_CLIST (edit_alerts_clist)->selection;
	if (list)
	{
		tint = (int) list->data;
		gtk_clist_get_text (GTK_CLIST (edit_alerts_clist), tint, 0, &text);
		switch(tint)
		{
			case 0: if (config.global_alerts)
				{
					if (config.global_alerts_moving_status)
						config.global_alerts_moving_status = 0;
					else
						config.global_alerts_moving_status = 1;
				}
				else
				{
					if (header.ma_alert)
						header.ma_alert = 0;
					else
						header.ma_alert = 1;
				}
				break;
			case 1: if (config.global_alerts)
				{
					if (config.global_alerts_moving2_status)
						config.global_alerts_moving2_status = 0;
					else
						config.global_alerts_moving2_status = 1;
				}
				else
				{
					if (header.ma2_alert)
						header.ma2_alert = 0;
					else
						header.ma2_alert = 1;
				}
				break;
			case 2: if (config.global_alerts)
				{
					if (config.global_alerts_moving3_status)
						config.global_alerts_moving3_status = 0;
					else
						config.global_alerts_moving3_status = 1;
				}
				else
				{
					if (header.ma3_alert)
						header.ma3_alert = 0;
					else
						header.ma3_alert = 1;
				}
				break;
			case 3: if (config.global_alerts)
				{
					if (config.global_alerts_closeroc_status)
						config.global_alerts_closeroc_status = 0;
					else
						config.global_alerts_closeroc_status = 1;
				}
				else
				{
					if (header.closeroc_status)
						header.closeroc_status = 0;
					else
						header.closeroc_status = 1;
				}
				break;
			case 4: if (config.global_alerts)
				{
					if (config.global_alerts_threshold_status)
						config.global_alerts_threshold_status = 0;
					else
						config.global_alerts_threshold_status = 1;
				}
				else
				{
					if (header.threshold_status)
						header.threshold_status = 0;
					else
						header.threshold_status = 1;
				}
				break;
			case 5: if (config.global_alerts)
				{
					if (config.global_alerts_volumeroc_status)
						config.global_alerts_volumeroc_status = 0;
					else
						config.global_alerts_volumeroc_status = 1;
				}
				else
				{
					if (header.volumeroc_status)
						header.volumeroc_status = 0;
					else
						header.volumeroc_status = 1;
				}
				break;
			default: break;
		}
		update_alerts_clist();
    	}
    	else
	  RETURN_ERR(gs_nothing_selected_edit);
}
/*********************************************************************************/
void exit_alerts_window()
{
	extern GtkWidget *edit_alerts_window, *alert_button;
	extern int edit_alerts_window_flag;
	
	
	gtk_widget_destroy(edit_alerts_window);
	edit_alerts_window_flag = 0;
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(alert_button), 0);
}
/************************************************************************************/
void alert_goto_chart()
{
	GList *list;
	int tint;
	char *text;
	extern GtkWidget *alert_window_clist;
	extern int open_file_flag;
	extern char *error_message;

	
	list = GTK_CLIST (alert_window_clist)->selection;
	if (! list)
	  RETURN_ERR(gs_nothing_selected);

	tint = (int) list->data;
	list = GTK_CLIST (alert_window_clist)->selection;
	gtk_clist_get_text (GTK_CLIST (alert_window_clist), tint, 1, &text);
	open_file_flag = 1;
	load_file(text);
}
/*****************************************************************************/
void create_alert_report()
{
	gchar *header[] = {"Date", "Symbol", "Alert", "Data", "Indicator"};
	int tint;
	GtkWidget *vbox, *hbox, *hsep, *button, *button2, *button3;
    	extern GtkWidget *alert_window, *alert_window_clist;
    	

	if (! alert_window)
   	{	
		alert_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_signal_connect (GTK_OBJECT (alert_window), "destroy",
		    	    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &alert_window);
       		gtk_window_set_title (GTK_WINDOW (alert_window), "Alert View");
        	gtk_container_border_width (GTK_CONTAINER (alert_window), 0);
        	gtk_window_position(GTK_WINDOW (alert_window), GTK_WIN_POS_CENTER);
		gtk_widget_set_usize(GTK_WIDGET (alert_window), 560, 200);
	
		vbox = gtk_vbox_new (FALSE, 0);
        	gtk_container_add (GTK_CONTAINER (alert_window), vbox);
        	gtk_widget_show (vbox);
	
		alert_window_clist = gtk_clist_new_with_titles (5, header);
		gtk_clist_set_column_width(GTK_CLIST(alert_window_clist), 0, 70);
		gtk_clist_set_column_width(GTK_CLIST(alert_window_clist), 1, 70);
		gtk_clist_set_column_width(GTK_CLIST(alert_window_clist), 2, 200);
		gtk_clist_set_column_width(GTK_CLIST(alert_window_clist), 3, 70);
		gtk_clist_set_column_width(GTK_CLIST(alert_window_clist), 4, 70);
		for (tint = 0; tint < 5; tint++)
			gtk_clist_set_column_justification(GTK_CLIST(alert_window_clist), tint, GTK_JUSTIFY_LEFT);
        	gtk_clist_set_selection_mode (GTK_CLIST (alert_window_clist), GTK_SELECTION_SINGLE);
        	gtk_clist_set_policy (GTK_CLIST (alert_window_clist), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
        	gtk_box_pack_start (GTK_BOX (vbox), alert_window_clist, TRUE, TRUE, 0);
        	gtk_container_border_width (GTK_CONTAINER (alert_window_clist), 10);
        	gtk_widget_show(alert_window_clist);
        
        	hsep = gtk_hseparator_new();
		gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        	gtk_widget_show(hsep);
        
        	hbox = gtk_hbutton_box_new();
        	gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      		gtk_hbutton_box_set_spacing_default(5);
        	gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
      		gtk_widget_show(hbox);
      	
      		button = gtk_button_new_with_label("Goto Chart");
      		gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 0);
      		gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (alert_goto_chart), NULL);
      		gtk_widget_show (button);
      	
      		button2 = gtk_button_new_with_label("Close");
      		gtk_box_pack_start (GTK_BOX (hbox), button2, FALSE, TRUE, 0);
      		gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT (alert_window));
      		gtk_widget_show (button2);
      	
      		button3 = gtk_button_new_with_label("Help");
      		gtk_box_pack_start (GTK_BOX (hbox), button3, FALSE, TRUE, 0);
      		gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			    GTK_SIGNAL_FUNC (help_alert_view_window), NULL);
      		gtk_widget_show (button3);
      	
      		gtk_widget_show(alert_window);
    }
    else
    {
    	gtk_clist_freeze(GTK_CLIST(alert_window_clist));
        gtk_clist_clear(GTK_CLIST(alert_window_clist));
        gtk_clist_thaw(GTK_CLIST(alert_window_clist));
    }
}
/****************************************************************************/
void ok_alert_scan()
{
	struct dirent **dirlist;
	char *tstringpointer, tstring[250], tstring2[250], *text, group[50], symbol[25];
	int tint, tint2, group_records, importline;
	unsigned long scandate, tlong;
	unsigned int found;
	float tfloat = 0.0;
	FILE *infile, *infile2;
    	GList *list;
	extern GtkWidget *alert_scan_entry, *alert_scan_check;
	extern GtkWidget *alert_scan_clist, *progwindow, *alert_scan_window, *progress_bar;
	extern char *datapath, *grouppath, *error_message;
	extern int header_size;
	struct record2 header;
	extern struct record3 config;
	
	
	
	tstringpointer = gtk_entry_get_text(GTK_ENTRY(alert_scan_entry));
	if (strlen(tstringpointer) != 0)
	{
		strcpy(tstring, tstringpointer);
		tint = strlen(tstring);
		if (tint != 8)
			RETURN_ERR(gs_invalid_date2);
		for (tint2 = 0; tint2 < tint; tint2++)
		{
			if (! isdigit(tstring[tint2]))
			{
				if (tstring[tint2] != '.')
				  RETURN_ERR(gs_invalid_date);
			}
		}
		scandate = atol(tstringpointer);
	}
	else
		RETURN_ERR(gs_invalid_date3);
	if (GTK_TOGGLE_BUTTON (alert_scan_check)->active)
    	{
    		gtk_widget_destroy(alert_scan_window);
    		create_alert_report();
    		
		show_progress_window("Scanning...");
		    		
    		tint = scandir(datapath, &dirlist, NULL, alphasort);
		if (tint < 0)
			RETURN_ERR(gs_data_missing);
		tint2 = tint;
		importline = 0;
		for (tint = 2; tint < tint2; tint++)
   		{
   			strcpy(tstring, datapath);
   			strcat(tstring, dirlist[tint]->d_name);
     			found = find_chart_record(tstring, scandate);
			if (found > 0)
			{
				infile = fopen(tstring, "rb");
				fread(&header, header_size, 1, infile);
				fclose(infile);
				if (config.global_alerts)
				{
					if (config.global_alerts_volumeroc_status)
						scan_volumeroc(tstring, found);
					if (config.global_alerts_closeroc_status)
						scan_closeroc(tstring, found);
					if (config.global_alerts_threshold_status)
						scan_threshold(tstring, found);
					if (config.global_alerts_moving_status)
						scan_ma(tstring, found, 1);
					if (config.global_alerts_moving2_status)
						scan_ma(tstring, found, 2);
					if (config.global_alerts_moving3_status)
						scan_ma(tstring, found, 3);
				}
				else
				{
					if (header.volumeroc)
						scan_volumeroc(tstring, found);
					if (header.closeroc)
						scan_closeroc(tstring, found);
					if (header.threshold)
						scan_threshold(tstring, found);
					if ((header.ma_alert) && (header.moving[0]))
						scan_ma(tstring, found, 1);
					if ((header.ma2_alert) && (header.moving2[0]))
						scan_ma(tstring, found, 2);
					if ((header.ma3_alert) && (header.moving3[0]))
						scan_ma(tstring, found, 3);
				}
			}
			importline++;
			tfloat = ((float)importline / tint2);
			if (tfloat > 1.0)
				tfloat = 1.0;
			if (tfloat < 0.0)
				tfloat = 0.0;
			gtk_progress_bar_update (GTK_PROGRESS_BAR (progress_bar), tfloat);
			while (gtk_events_pending())
				gtk_main_iteration();
   		}
   		if (progwindow)
   			gtk_widget_destroy(progwindow);
    	}
    	else
    	{
    		list = GTK_CLIST (alert_scan_clist)->selection;
		if (! list)
			RETURN_ERR(gs_nothing_selected);
		while (list)
		{
			tint =  (int) list->data;
			gtk_clist_get_text (GTK_CLIST (alert_scan_clist), tint, 0, &text);
			strcpy(tstring, grouppath);
			strcat(tstring, text);
			strcpy(group, text);
			gtk_widget_destroy(alert_scan_window);
			create_alert_report();
   			infile = fopen(tstring, "rb");
   			if (! infile)
		  		RETURN_ERR(gs_cant_open_group);

			show_progress_window("Scanning...");
		      		
    			fseek(infile, 0L, SEEK_END);
   			tlong = ftell(infile);
   			group_records = tlong / GROUP_RECORDSIZE;
   			fseek(infile, 0L, SEEK_SET);
   			importline = 0;
   			for (tint = 0; tint < group_records; tint++)
   			{
   				fread(&tstring, GROUP_RECORDSIZE, 1, infile);
   				sscanf(tstring, "%s", tstring2);
     				strcpy(symbol, tstring2);
     				strcpy(tstring, datapath);
     				strcat(tstring, symbol);
     				found = find_chart_record(tstring, scandate);
				if (found > 0)
				{
					infile2 = fopen(tstring, "rb");
					fread(&header, header_size, 1, infile2);
					fclose(infile2);
					if (config.global_alerts)
					{
						if (config.global_alerts_volumeroc_status)
							scan_volumeroc(tstring, found);
						if (config.global_alerts_closeroc_status)
							scan_closeroc(tstring, found);
						if (config.global_alerts_threshold_status)
							scan_threshold(tstring, found);
						if (config.global_alerts_moving_status)
							scan_ma(tstring, found, 1);
						if (config.global_alerts_moving2_status)
							scan_ma(tstring, found, 2);
						if (config.global_alerts_moving3_status)
							scan_ma(tstring, found, 3);
					}
					else
					{
						if (header.volumeroc)
							scan_volumeroc(tstring, found);
						if (header.closeroc)
							scan_closeroc(tstring, found);
						if (header.threshold)
							scan_threshold(tstring, found);
						if ((header.ma_alert) && (header.moving[0]))
							scan_ma(tstring, found, 1);
						if ((header.ma2_alert) && (header.moving2[0]))
							scan_ma(tstring, found, 2);
						if ((header.ma3_alert) && (header.moving3[0]))
							scan_ma(tstring, found, 3);
					}
				}
				importline++;
				if (tfloat > 1.0)
					tfloat = 1.0;
				if (tfloat < 0.0)
					tfloat = 0.0;
				tfloat = ((float)importline / group_records);
				gtk_progress_bar_update (GTK_PROGRESS_BAR (progress_bar), tfloat);
				while (gtk_events_pending())
					gtk_main_iteration();
   			}
   			list = list->next;
   		}
   		fclose(infile);
   		if (progwindow)
   			gtk_widget_destroy(progwindow);
    	}
}
/****************************************************************************/
void alert_scan()
{
	struct dirent **dirlist;
	int tint, tint2;
	gchar tstring[250], *text[] = {"Group Name"}, *line[1];
   	GtkWidget *vbox, *vbox2, *hbox, *hbox2, *frame, *button, *button2, *button3, *hsep;
	extern GtkWidget *alert_scan_clist, *alert_scan_entry, *alert_scan_window;
	extern GtkWidget *alert_scan_check;
    	extern char *grouppath, *error_message;
   	
   	
   	if (alert_scan_window)
   		return;
   		
   	alert_scan_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (alert_scan_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &alert_scan_window);
	gtk_window_position(GTK_WINDOW (alert_scan_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (alert_scan_window), "Select Groups To Scan");
	gtk_widget_set_usize(GTK_WIDGET (alert_scan_window), 0, 0);
	gtk_container_border_width (GTK_CONTAINER (alert_scan_window), 0);
	
	vbox = gtk_vbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_container_add (GTK_CONTAINER (alert_scan_window), vbox);
      	gtk_widget_show (vbox);
      	
      	vbox2 = gtk_vbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 0);
      	gtk_widget_show (vbox2);
      	
      	alert_scan_clist = gtk_clist_new_with_titles (1, text);
      	gtk_clist_set_selection_mode (GTK_CLIST (alert_scan_clist), GTK_SELECTION_MULTIPLE);
	gtk_clist_set_column_width (GTK_CLIST (alert_scan_clist), 0,200);
	gtk_clist_set_column_justification (GTK_CLIST (alert_scan_clist), 0,GTK_JUSTIFY_LEFT);
       	gtk_clist_set_policy (GTK_CLIST (alert_scan_clist), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
      	gtk_container_add (GTK_CONTAINER (vbox2), alert_scan_clist);
      	gtk_container_border_width (GTK_CONTAINER (alert_scan_clist), 0);
      	gtk_widget_set_usize(GTK_WIDGET (alert_scan_clist), 350, 100);
      	gtk_widget_show (alert_scan_clist);
      	
      	frame = gtk_frame_new("Scan Date (YYYYMMDD):");
      	gtk_container_border_width (GTK_CONTAINER (frame), 0);
      	gtk_box_pack_start (GTK_BOX (vbox2), frame, FALSE, TRUE, 0);
      	gtk_widget_show(frame);
      	
      	hbox2 = gtk_hbox_new(FALSE, 0);
        gtk_container_border_width (GTK_CONTAINER (hbox2), 5);
        gtk_container_add (GTK_CONTAINER (frame), hbox2);
      	gtk_widget_show(hbox2);
      	
        alert_scan_entry = gtk_entry_new ();
      	gtk_box_pack_start (GTK_BOX (hbox2), alert_scan_entry, FALSE, TRUE, 0);
        gtk_widget_show(alert_scan_entry);
        
      	alert_scan_check = gtk_check_button_new_with_label("Scan All Charts");
        gtk_box_pack_end (GTK_BOX (hbox2), alert_scan_check, FALSE, TRUE, 0);
      	gtk_widget_show(alert_scan_check);
			    
        hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        gtk_widget_show(hsep);
        
        hbox = gtk_hbutton_box_new();
        gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_hbutton_box_set_spacing_default(5);
        gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
      	gtk_widget_show(hbox);
        
      	button = gtk_button_new_with_label("OK");
      	gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (ok_alert_scan), NULL);
      	gtk_widget_show (button);
      	
      	button2 = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (hbox), button2, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(alert_scan_window));
      	gtk_widget_show (button2);
      	
      	button3 = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (hbox), button3, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			    GTK_SIGNAL_FUNC (help_alert_scan_window), NULL);
      	gtk_widget_show (button3);
      	
    	gtk_clist_freeze (GTK_CLIST (alert_scan_clist));
    	tint = scandir(grouppath, &dirlist, NULL, alphasort);
    	if (tint < 0)
	  RETURN_ERR(gs_group_missing);
	tint2 = tint;
	for (tint = 2; tint < tint2; tint++)
	{
		strcpy(tstring, dirlist[tint]->d_name); 
   		line[0] = tstring;
		gtk_clist_append (GTK_CLIST (alert_scan_clist), line);
	}
   	gtk_clist_thaw (GTK_CLIST (alert_scan_clist));
	
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default(button);
	gtk_widget_show(alert_scan_window);
}
/****************************************************************************************/
void edit_alerts()
{
	char tstring[250], *text[] = {"Status", "Alert", "Value"};
    	GtkWidget *edit_button, *status_button, *help_button, *global_button;
    	GtkWidget *vbox, *hbox;
    	extern int chartflag, edit_alerts_window_flag;
    	extern GtkWidget *edit_alerts_window, *edit_alerts_clist, *alert_button;
    	extern struct record2 header;
    	extern struct record3 config;
	
	
	if (chartflag != 1)
	{
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(alert_button), 0);
		return;
	}
	if (! GTK_TOGGLE_BUTTON(alert_button)->active)
    	{
    		if (edit_alerts_window_flag)
    		{
    			exit_alerts_window();
    			return;
    		}
    		else
    			return;
    	}
    	else
	{
		if (edit_alerts_window_flag)
    		{
			if (config.global_alerts)
				strcpy(tstring, "Edit Global Alerts - ");
			else
        			strcpy(tstring, "Edit Alerts - ");
			strcat(tstring, header.name);
			strcat(tstring, " (");
			strcat(tstring, header.symbol);
			strcat(tstring, ")");
			gtk_window_set_title (GTK_WINDOW (edit_alerts_window), tstring);
			update_alerts_clist();
        		return;
        	}
        	else
        	{
			edit_alerts_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
			gtk_signal_connect (GTK_OBJECT (edit_alerts_window), "destroy",
			    GTK_SIGNAL_FUNC (exit_alerts_window), NULL);
        		gtk_window_set_title (GTK_WINDOW (edit_alerts_window), "Edit Alerts");
        		gtk_container_border_width (GTK_CONTAINER (edit_alerts_window), 0);
        		gtk_window_position(GTK_WINDOW (edit_alerts_window), GTK_WIN_POS_CENTER);
			gtk_widget_set_usize(GTK_WIDGET (edit_alerts_window), 350, 0);
	
			if (config.global_alerts)
				strcpy(tstring, "Edit Global Alerts - ");
			else
 				strcpy(tstring, "Edit Alerts - ");
			strcat(tstring, header.name);
			strcat(tstring, " (");
			strcat(tstring, header.symbol);
			strcat(tstring, ")");
			gtk_window_set_title (GTK_WINDOW (edit_alerts_window), tstring);
			gtk_widget_realize(edit_alerts_window);
	
			hbox = gtk_hbox_new(FALSE, 10);
        		gtk_container_add (GTK_CONTAINER (edit_alerts_window), hbox);
        		gtk_container_border_width (GTK_CONTAINER (hbox), 10);
        		gtk_widget_show (hbox);
        
      			vbox = gtk_vbutton_box_new ();
      			gtk_vbutton_box_set_spacing_default(5);
      			gtk_vbutton_box_set_layout_default(GTK_BUTTONBOX_START);
      			gtk_box_pack_end (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);
      			gtk_widget_show (vbox);
      	
			edit_button = gtk_button_new_with_label("Edit");
      			gtk_box_pack_start (GTK_BOX (vbox), edit_button, FALSE, TRUE, 0);
      			gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
			    GTK_SIGNAL_FUNC (ok_edit_alerts), NULL);
			gtk_widget_show (edit_button);
	
			status_button = gtk_button_new_with_label("Toggle Status");
      			gtk_box_pack_start (GTK_BOX (vbox), status_button, FALSE, TRUE, 0);
      			gtk_signal_connect (GTK_OBJECT (status_button), "clicked",
			    GTK_SIGNAL_FUNC (toggle_alerts), NULL);
			gtk_widget_show (status_button);
	
			global_button = gtk_button_new_with_label("Globals");
      			gtk_box_pack_start (GTK_BOX (vbox), global_button, FALSE, TRUE, 0);
      			gtk_signal_connect (GTK_OBJECT (global_button), "clicked",
			    GTK_SIGNAL_FUNC (yesno_global_alerts), NULL);
			gtk_widget_show (global_button);
      	
      			help_button = gtk_button_new_with_label("Help");
      			gtk_box_pack_start (GTK_BOX (vbox), help_button, FALSE, TRUE, 0);
      			gtk_signal_connect (GTK_OBJECT (help_button), "clicked",
			    GTK_SIGNAL_FUNC (help_alert_view_window), NULL);
      			gtk_widget_show (help_button);
      	
        		edit_alerts_clist = gtk_clist_new_with_titles (3, text);
      			gtk_clist_set_column_width(GTK_CLIST(edit_alerts_clist), 0, 40);
      			gtk_clist_set_column_width(GTK_CLIST(edit_alerts_clist), 1, 100);
      			gtk_clist_set_column_width(GTK_CLIST(edit_alerts_clist), 2, 40);
      			gtk_clist_set_selection_mode (GTK_CLIST (edit_alerts_clist), GTK_SELECTION_SINGLE);
       			gtk_clist_set_policy(GTK_CLIST(edit_alerts_clist), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
       			gtk_box_pack_start (GTK_BOX (hbox), edit_alerts_clist, TRUE, TRUE, 0);
      			gtk_widget_show (edit_alerts_clist);
      	
      			update_alerts_clist();
        
      			edit_alerts_window_flag = 1;
      			gtk_widget_show(edit_alerts_window);
      		}
      	}
}