
/* Vis5D version 4.3 */

/*
Vis5D system for visualizing five dimensional gridded data sets
Copyright (C) 1990 - 1997 Bill Hibbard, Johan Kellum, Brian Paul,
Dave Santek, and Andre Battaiola.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* anim.c */


/*
 * Stored frame animation.
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "globals.h"
#include "graphics.h"
#ifdef OPENGL
#  include <GL/gl.h>
#endif
#ifdef SGI_GL
#include <gl/gl.h>
#endif
#ifdef DENALI
#include <gl/gl.h>
#endif
#ifdef MESA
  extern XImage *mesa_read_image( void );
  extern void mesa_draw_image( XImage *img );
#endif



/*
 * Call this once during initialization.
 */
void init_anim( Context ctx )
{
   int i;

   for (i=0;i<MAXTIMES;i++) {
      ctx->cache[i] = NULL;
   }
   ctx->all_invalid = 1;
}




/*
 * Invalidate all the frames in the cache.  This should be called when
 * the viewpoint changes, the selected graphics changes, or the window
 * size changes.
 */
void invalidate_frames( Context ctx )
{
   int i;

   if (!ctx->all_invalid) {
      printf("invalidating frames\n");

      for (i=0;i<MAXTIMES;i++) {
         if (ctx->cache[i]) {
            XDestroyImage( ctx->cache[i] );
            ctx->cache[i] = NULL;
         }
      }
      ctx->all_invalid = 1;
   }
}



/*
 * This function is called after a frame has been rendered.  If the
 * cached frame is invalid we'll copy the newly rendered frame into the
 * cache.
 * Input:  timestep - a timestep in [0,NumTimes-1]
 * Return:  1 = the cache was loaded with a new image
 *          0 = the cache was unchanged
 */
int save_frame( Context ctx, int timestep )
{
   if (!ctx->cache[timestep]) {
      printf("saving frame %d\n", timestep );
#ifdef MESA
      ctx->cache[timestep] = mesa_read_image();
#endif
      ctx->all_invalid = 0;
      return 1;
   }
   else {
      return 0;
   }
}


/*
 * This function returns a frame from the cache and displays it.
 * Input:  timestep - a timestep in [0,NumTimes-1]
 * Return:  1 = there was a cached frame and it's now displayed
 *          0 = there was no cached frame to display, we must render it
 */
int get_frame( Context ctx, int timestep )
{
   if (ctx->cache[timestep]) {
      printf("drawing cached frame %d...\n", timestep );
#ifdef MESA
      mesa_draw_image( ctx->cache[timestep] );
#endif
      return 1;
   }
   else {
      return 0;
   }
}

