/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include "../common/common.h"

String label_get(Widget w)
{
	String p;
	XtVaGetValues(w, XtNlabel, &p, (char *)0);
	return p;
}

void label_set(Widget w, String p)
{
	char *q = translate((char *)p);
	if (w != None && strcmp(q, label_get(w)))
		XtVaSetValues(w, XtNlabel, q, (char *)0);
}

Boolean state_get(Widget w)
{
	Boolean i = False;
	if (w != None)
		XtVaGetValues(w, XtNstate, &i, (char *)0);
	return i;
}

void state_set(Widget w, Boolean i)
{
	if (w != None && i != state_get(w))
		XtVaSetValues(w, XtNstate, i, (char *)0);
}

Dimension width_get(Widget w)
{
	Dimension x = 80;
	if (w != None)
		XtVaGetValues(w, XtNwidth, &x, (char *)0);
	return x;
}

Dimension height_get(Widget w)
{
	Dimension x = 20;
	if (w != None)
		XtVaGetValues(w, XtNheight, &x, (char *)0);
	return x;
}

