
/*
 * tooltip.c
 */

#include <stdlib.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include "../common/common.h"
#include "xcommon.h"
#define TOOLTIP_INTERVAL 500
#define HIGHLIGHT_WIDTH 2
#define UNHIGHLIGHT_WIDTH 1

static Widget label1, tooltip_shell, tooltip_label;
static int tooltip_mode = TOOLTIP_POPUP;
static int tooltip_timeout = None;
static char tooltip_text[256];
static unsigned long highlight_color, unhighlight_color;

static void highlight_action(Widget w, XEvent *event,
        String *params, Cardinal *num_params)
{
	int sw;

	if (*num_params) sw = atoi(*params);
	else sw = HIGHLIGHT_WIDTH;

        if (w) XtVaSetValues(w,
#if 0
                XtNbackground, highlight_color,
#else
		"shadowWidth", sw,
#endif
                (char *)0);
}

static void unhighlight_action(Widget w, XEvent *event,
        String *params, Cardinal *num_params)
{
	int sw;

	if (*num_params) sw = atoi(*params);
        else sw = UNHIGHLIGHT_WIDTH;

        if (w) XtVaSetValues(w,
#if 0
                XtNbackground, unhighlight_color,
#else
		"shadowWidth", sw,
#endif
                (char *)0);
}

static void tooltip_popup(XtPointer client_data, XtIntervalId *id)
{
        tooltip_timeout = None;
        XtPopup(tooltip_shell, XtGrabNone);
}

static void tooltip_popdown(void)
{
        if (tooltip_timeout != None)
                XtRemoveTimeOut(tooltip_timeout);
        tooltip_timeout = None;
        XtPopdown(tooltip_shell);
}

static void draw_input_action(Widget w, XEvent *event,
        String *params, Cardinal *num_params)
{
        if (tooltip_mode & TOOLTIP_LABEL) {
                char *p = "";
                label_set(label1, p);
        }
        if (tooltip_mode & TOOLTIP_POPUP) {
                tooltip_popdown();
        }
}

static void tooltip_action(Widget w, XEvent *event,
        String *params, Cardinal *num_params)
{
        int i;
	char b[256];

        strncpy(b, params[0], 255);
        for (i = 1; i < *num_params; i++) {
                strncat(b, " ", 255);
                strncat(b, params[i], 255);
        }
	strcpy(tooltip_text, translate(b));
        if (tooltip_mode & TOOLTIP_LABEL) {
                XtVaSetValues(label1, XtNlabel, tooltip_text, (char *)0);
        }
        if (tooltip_mode & TOOLTIP_POPUP) {
                Position x, y;
                Dimension height, width;
                XFontStruct *font;

                XtVaGetValues(w,
                        XtNheight, &height, (char *)0);
                XtTranslateCoords(w,
                        0, height+10, &x, &y);
                XtVaGetValues(tooltip_label,
                        XtNfont, &font, (char *)0);
                width = XTextWidth(font, tooltip_text, strlen(tooltip_text));
                XtVaSetValues(tooltip_shell,
                        XtNx, x,
                        XtNy, y,
                        XtNwidth, width+8, (char *)0);
                XtVaSetValues(tooltip_label, XtNlabel, tooltip_text, (char *)0);
                tooltip_timeout = XtAppAddTimeOut(
			XtWidgetToApplicationContext(w),
                        TOOLTIP_INTERVAL,
                        tooltip_popup, (XtPointer)w);
        }
}

static XtActionsRec actions[] =
{
        {"siag-highlight", highlight_action},
        {"siag-unhighlight", unhighlight_action},
        {"tooltip", tooltip_action},
        {"draw-input", draw_input_action}
};

void tooltip_mode_set(int mode, Widget label)
{
	draw_input_action(NULL, NULL, NULL, NULL);
	tooltip_mode = mode;
	label1 = label;
	if (label1 == None) mode &= ~TOOLTIP_LABEL;
}

void tooltip_init(Widget pw, unsigned long hl, unsigned long uhl)
{
	XtAppAddActions(XtWidgetToApplicationContext(pw),
		actions, XtNumber(actions));
	tooltip_shell = XtVaCreatePopupShell("tooltip_shell",
		overrideShellWidgetClass, pw, (char *)0);
	tooltip_label = XtVaCreateManagedWidget("tooltip_label",
		labelWidgetClass, tooltip_shell, (char *)0);
	label1 = None;
	highlight_color = hl;
	unhighlight_color = uhl;
}

