/*
   Copyright (C) 1997, 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Dialog.h>

#include "../common/common.h"
#include "xcommon.h"
#include "Textentry.h"

#define ABORT	0
#define	DONE	1
#define	WAITING	2

static Widget pshell, dialog, dialogLabel, dialogText,
	dialogCancel, dialogDone;

static Widget alert, listshell;
static int status;

int input_warp_pointer = 1;

static Widget add_button(Widget pw, char *name, char *label,
        void (*cb)(Widget, XtPointer, XtPointer), XtPointer data)
{
        Widget w = XtVaCreateManagedWidget(name,
                commandWidgetClass, pw,
                (char *)0);
        label_set(w, label);
        XtVaSetValues(w, XtNwidth, 80, (char *)0);
        if (cb) XtAddCallback(w, XtNcallback, cb, data);
        return w;
}

static void
alert_clicked(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtPopdown(alert);
	status = (int)client_data;
}

int alertbox(Widget pw, char *text, char *buttons[], int nbuttons)
{
	Widget topbox, buttonbox, label, command;
	int i;
	Position x, y;
	Dimension width, height, w1, h1;
	XtAppContext app_context = XtWidgetToApplicationContext(pw);

	alert = XtVaCreatePopupShell("alert",
		transientShellWidgetClass, pw,
		XtNtitle, translate("Alert"),
		(char *)0);
	topbox = XtVaCreateManagedWidget("topbox",
		boxWidgetClass, alert, (char *)0);
	label = XtVaCreateManagedWidget("label",
		labelWidgetClass, topbox,
		(char *)0);
	label_set(label, text);
	buttonbox = XtVaCreateManagedWidget("buttonbox",
		boxWidgetClass, topbox, (char *)0);
	for (i = 0; i < nbuttons; i++) {
		command = add_button(buttonbox, "command", buttons[i],
			alert_clicked, (XtPointer)i);
	}
	status = -1;
	XtRealizeWidget(alert);
	XtUnrealizeWidget(alert);
	XtVaGetValues(pw,
		XtNwidth, &width,
		XtNheight, &height, (char *)0);
	XtVaGetValues(alert,
		XtNwidth, &w1,
		XtNheight, &h1, (char *)0);
	XtTranslateCoords(pw,
		(Position) (width-w1)/2, (Position) (height-h1)/2,
		&x, &y);
	XtVaSetValues(alert,
		XtNx, x,
		XtNy, y, (char *)0);
	XtPopup(alert, XtGrabNonexclusive);
	while (status < 0) {
		XEvent event_return;
		XtAppNextEvent(app_context, &event_return);
		XtDispatchEvent(&event_return);
	}
	XtDestroyWidget(alert);
	return status;
}

void errorbox(Widget pw, char *message)
{
	char *buttons[] = {"OK"};

	alertbox(pw, message, buttons, 1);
}

static void
listsel_clicked(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtPopdown(listshell);
	status = (int)client_data;
}

void center(Widget parent, Widget child)
{
	Position x, y;
	Dimension width, height, w1, h1;

	XtRealizeWidget(child);
	XtUnrealizeWidget(child);
	XtVaGetValues(parent,
		XtNwidth, &width,
		XtNheight, &height, (char *)0);
	XtVaGetValues(child,
		XtNwidth, &w1,
		XtNheight, &h1, (char *)0);
	XtTranslateCoords(parent,
		(Position)(width-w1)/2, (Position)(height-h1)/2, &x, &y);
	XtVaSetValues(child,
		XtNx, x,
		XtNy, y, (char *)0);
}

int listsel(Widget pw, char *text, char *choices[], int nchoices)
{
	Widget topbox, listbox, buttonbox, label, viewport, list,
		okbutton, cancelbutton;
	int n;
	XtAppContext app_context = XtWidgetToApplicationContext(pw);

	listshell = XtVaCreatePopupShell("listshell",
		transientShellWidgetClass, pw,
		XtNtitle, translate("List"),
		(char *)0);
	topbox = XtVaCreateManagedWidget("topbox",
		boxWidgetClass, listshell, (char *)0);
	listbox = XtVaCreateManagedWidget("listbox",
		boxWidgetClass, topbox, (char *)0);
	label = XtVaCreateManagedWidget("label",
		labelWidgetClass, listbox,
		(char *)0);
	label_set(label, text);
	viewport = XtVaCreateManagedWidget("viewport",
		viewportWidgetClass, listbox, (char *)0);
	list = XtVaCreateManagedWidget("list",
		listWidgetClass, viewport, (char *)0);
	XawListChange(list,
		choices, nchoices, 0, True);
	XtVaSetValues(list, XtNwidth, width_get(list)+20, (char *)0);
	buttonbox = XtVaCreateManagedWidget("buttonbox",
		boxWidgetClass, topbox, (char *)0);
	okbutton = add_button(buttonbox, "okbutton", "OK", listsel_clicked,
		(XtPointer)1);
	cancelbutton = add_button(buttonbox, "cancelbutton",
		"Cancel", listsel_clicked, (XtPointer)0);
	status = -1;
	center(pw, listshell);
	XtPopup(listshell, XtGrabNonexclusive);

	while (status < 0) {
		XEvent event_return;
		XtAppNextEvent(app_context, &event_return);
		XtDispatchEvent(&event_return);
	}
	n = XawListShowCurrent(list)->list_index;
	XtDestroyWidget(listshell);
	if (status)	/* clicked OK */
		return n;
	else		/* clicked Cancel */
		return -1;
}

static void DialogDone(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtPopdown(pshell);
	status = DONE;
}

static void DialogAbort(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtPopdown(pshell);
	status = ABORT;
}

static void DialogCancelAction(Widget w, XEvent * event,
		String * params, Cardinal * n)
{
	XtPopdown(pshell);
	status = ABORT;
}

static void DialogDoneAction(Widget w, XEvent * event,
		String * params, Cardinal * n)
{
	XtPopdown(pshell);
	status = DONE;
}

static XtActionsRec actions[] = {
	{"dialog-done", DialogDoneAction},
	{"dialog-cancel", DialogCancelAction},
};

static void init_input(Widget topLevel)
{
	static int init_done = 0;

	XtAppContext app_context = XtWidgetToApplicationContext(topLevel);

	if (init_done) return;

	XtAppAddActions(app_context, actions, XtNumber(actions));

	pshell = XtVaCreatePopupShell("pshell",
		transientShellWidgetClass, topLevel,
		XtNtitle, translate("Dialog"),
		(char *)0);
	dialog = XtVaCreateManagedWidget("dialog",
		formWidgetClass, pshell, (char *)0);
	dialogLabel = XtVaCreateManagedWidget("dialogLabel",
		labelWidgetClass, dialog, (char *)0);
	dialogText = XtVaCreateManagedWidget("dialogText",
		textentryWidgetClass, dialog,
		(char *)0);
	XtOverrideTranslations(dialogText,
		XtParseTranslationTable(
			"<Key>Return:	dialog-done()\n"
			"<Key>Escape:	dialog-cancel()"));
	dialogDone = add_button(dialog, "dialogDone", "OK",
		DialogDone, NULL);
	dialogCancel = add_button(dialog, "dialogCancel", "Cancel",
		DialogAbort, NULL);
	init_done = 1;
}

int dialog_input(Widget pw, char *prompt, char *buffr, int (*comp)(char *))
{
	XtAppContext app_context = XtWidgetToApplicationContext(pw);
	Position x, y;
	Dimension width, height, w1, h1;
	String string;

	init_input(pw);
	status = WAITING;

	XtVaGetValues(pw,
		XtNwidth, &width,
		XtNheight, &height, (char *)0);
	XtVaGetValues(pshell,
		XtNwidth, &w1,
		XtNheight, &h1, (char *)0);
	XtTranslateCoords(pw,
	       (Position) (width - w1) / 2, (Position) (height - h1) / 2,
		&x, &y);
	XtVaSetValues(pshell,
		XtNx, x,
		XtNy, y, (char *)0);
	label_set(dialogLabel, prompt);
	XtVaSetValues(dialogLabel,
		XtNwidth, w1-10, (char *)0);
	XtVaSetValues(dialogText,
		XtNstring, buffr,
		XtNinsertPosition, strlen(buffr), (char *)0);
	XtPopup(pshell, XtGrabNonexclusive);
	if (input_warp_pointer)
		XWarpPointer(XtDisplay(pshell), None, XtWindow(pshell),
				0, 0, 0, 0, 0, 0);
	XtSetKeyboardFocus(pshell, dialogText);

	while (status == WAITING) {
		XEvent event_return;

		XtAppNextEvent(app_context, &event_return);
		XtDispatchEvent(&event_return);
	}

	XtVaGetValues(dialogText,
		XtNstring, &string, (char *)0);
	strcpy(buffr, string);
	return status;
}

