/*
   Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "HsepP.h"

#define offset(field) XtOffsetOf(HsepRec, hsep.field)
static XtResource resources[] = {
	{
		XtNhighlight,
		XtCHighlight,
		XtRPixel,
		sizeof(Pixel),
		offset(highlight),
		XtRString,
		XtDefaultBackground
	}, {
		XtNshadow,
		XtCShadow,
		XtRPixel,
		sizeof(Pixel),
		offset(shadow),
		XtRString,
		XtDefaultForeground
	}
};
#undef offset

/* methods */
static void Redisplay();
static Boolean SetValues();
static void Destroy();
static void Realize();

/* actions */
static void HsepAction(Widget, XEvent *, String *, Cardinal *);

static XtActionsRec actions[] =
{
	{"hsep", HsepAction},
};

/* translations */
static char translations[] =
"<Key>:		hsep()\n";

HsepClassRec hsepClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &widgetClassRec,
    /* class_name		*/	"Hsep",
    /* widget_size		*/	sizeof(HsepRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	NULL,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	NULL,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	translations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* hsep fields */
    /* empty			*/	0
  }
};

WidgetClass hsepWidgetClass = (WidgetClass)&hsepClassRec;


/* supporting code copied directly from hsep.c */

static void HsepAction(Widget w, XEvent *event, String *params, Cardinal *n)
{
	;
}

static void Redisplay(Widget w, XExposeEvent *event)
{
	HsepWidget aw = (HsepWidget) w;

	XDrawLine(XtDisplay(w), XtWindow(w), aw->hsep.shadow_gc,
		0, 0, aw->core.width-1, 0);
	XDrawLine(XtDisplay(w), XtWindow(w), aw->hsep.highlight_gc,
		0, 1, aw->core.width-1, 1);	
}

static GC get_gc(Widget w, unsigned long fg, unsigned long bg)
{
        unsigned long valuemask = 0;
        XGCValues values;
        GC gc = XCreateGC(XtDisplay(w), XtWindow(w),
                                valuemask, &values);
        XSetForeground(XtDisplay(w), gc, fg);
        XSetBackground(XtDisplay(w), gc, bg);
        return gc;
}

#define superclass (&coreClassRec)
static void Realize(Widget w, XtValueMask *valueMask,
                XSetWindowAttributes *attributes)
{
        HsepWidget tw = (HsepWidget) w;

        (*superclass->core_class.realize) (w, valueMask, attributes);
	tw->hsep.highlight_gc = get_gc(w, tw->hsep.highlight, tw->hsep.shadow);
	tw->hsep.shadow_gc = get_gc(w, tw->hsep.shadow, tw->hsep.highlight);
}

static void Destroy(Widget w)
{
        HsepWidget tw = (HsepWidget) w;

        XFreeGC(XtDisplay(w), tw->hsep.highlight_gc);
        XFreeGC(XtDisplay(w), tw->hsep.shadow_gc);
}


static Boolean SetValues(Widget current, Widget request, Widget new)
{
	Boolean do_redisplay = True;

	return do_redisplay;
}

