/*
   Siag, Scheme In A Grid
   Copyright (C) 1996-1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

/*
 * calc.h
 */

#ifdef DEBUG
#define TRACEME(s) do {\
	FILE *f=fopen("TRACEME","a");\
	fprintf(f,"[%s,%d]: " ,__FILE__,__LINE__);\
	fprintf s;\
	fprintf(f,"\n");\
	fclose(f);\
	} while(0);
#else
#define TRACEME(s)
#endif

#define VERSION "Siag (Scheme In A Grid) " VERSION_NO ". No Warranty."

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define BUFFER_COLS 100000
#define BUFFER_ROWS 100000

#define MAKE_POSITION(p)\
	(cons(flocons((p).row),cons(flocons((p).col),NIL)))

#define POSITION_ROW(p) (get_c_long(car(p)))
#define POSITION_COL(p) (get_c_long(cadr(p)))

typedef struct {
	int row, col;
} position;

typedef union {
	char *text;
	double number;
} cval;

typedef struct s_spread {
	char *text;
	int interpreter;
	cval value;
	short type;
	long format;
} spread;

typedef struct s_property_list {
	char *key;
	char *value;
	struct s_property_list *next;
} property_list;

typedef struct plugin_t {
	long row, col;		/* geometry */
	int ph;			/* handle */
	char *name;		/* file name or whatever */
	int displayed;		/* has it been put up on the screen? */
} plugin_t;

typedef struct s_buffer {
	char name[1024];	/* identifies the buffer */
	char path[1024];	/* file name */

	long alloc_lines;	/* number of allocated lines */
	long *alloc_cols;	/* array of column sizes */
	long used_lines;	/* this is for the height array */
	long used_cols;		/* this is for the width array */
	int sh;			/* standard height */
	int *height;		/* array of ints, (longest_line+1) in size */
	int sw;			/* standard width */
	int *width;		/* array of ints, (alloc_lines+1) in size */
	long sf;		/* standard format */

	position mark_pos;	/* mark */
	spread **matrix;	/* the cell array */
	int recalc;		/* if buffers need recalculating */
	int change;		/* if there are pending changes */
	property_list *p_list;	/* arbitrary data */
	plugin_t *plugin;	/* array of plugins */
	int nplugin;		/* number of plugins */
	struct s_buffer *next;	/* next buffer in buffer ring */
} buffer;

typedef struct s_window {
	position point_pos;	/* point */
	buffer *buf;		/* buffer */
	position top;		/* left top of visible part of buffer */
	position prot;		/* protected lines/cols */
	position blku, blkl;	/* upper left & lower right block corners */
	int begin_y;		/* position on the screen */
	int max_y;		/* height in lines */
	struct siag_ui *ui;	/* user interface specifics (Widgets) */
	struct s_window *next;	/* next window in window ring */
} window;

typedef struct s_eval_struct {
	int errorflag;
	int siag_type;
	int siag_row;
	int siag_col;
	buffer *siag_buffer;
	struct s_eval_struct *next;
} eval_struct;

typedef struct {
  int size;             /* the number of keys pressed */
  int maxsize;          /* size of the buffer */
  char *text;           /* the textual contents */
} textbuf;

#include "user_interface.h"

#define set_window_buffer(w,b) ((w)->buf=(b))
#define next_window(w) ((w)->next)
#define buffer_of_window(w) ((w)->buf)
#define block_upper(w) ((w)->blku)
#define block_lower(w) ((w)->blkl)
#define set_blku_row(w,r) ((w)->blku.row=(r))
#define set_blkl_row(w,r) ((w)->blkl.row=(r))
#define set_blku_col(w,c) ((w)->blku.col=(c))
#define set_blkl_col(w,c) ((w)->blkl.col=(c))
#define set_point_row(w,r) ((w)->point_pos.row=(r))
#define set_point_col(w,c) ((w)->point_pos.col=(c))
#define set_mark_row(w,r) ((w)->buf->mark_pos.row=(r))
#define set_mark_col(w,c) ((w)->buf->mark_pos.col=(c))
#define set_prot(w,p) ((w)->prot=(p))
#define get_prot(w) ((w)->prot)

/* from window.c */

extern window * w_list;
extern int pr_scr_flag;		/* if the display needs updating */

extern void activate_window(window * );
extern void llpr(char *);
extern void free_window(window * );
extern window * new_window(buffer *, window * );
extern int remove_window(window * );
extern int split_window(window * );
extern void init_windows(buffer *, int, char **);
extern void exit_windows(void);
extern void show_cur(window * );
extern void hide_cur(window * );
extern void get_cell_coords(window * , int, int, int, int, int *, int *);
extern void get_coords_cell(window * , int, int, int *, int *, int, int);

extern void do_cmd(int);
extern void init_calc_cmds(void);

/* from selection.c */
extern int pack_selection(buffer *, char *, int, int, int, int);
extern void transfer_done_proc(void);
extern int unpack_selection(buffer *, char *, int, int);

/* from matrix.c */
extern char *fmt_put(char *, int);
extern char *fmt_get(char *, int);
extern void free_matrix(spread **);
extern void swap_cells(buffer *, long, long, long, long);
extern int ins_data(buffer *, int, char *, cval, short, int, int);
extern int ins_format(buffer *, int, int, int);
extern char *ret_text(buffer *, int, int);
extern int ret_interpreter(buffer *, int, int);
extern char *ret_string(buffer *, int, int);
extern cval ret_val(buffer *, int, int);
extern short ret_type(buffer *, int, int);
extern int ret_format(buffer *, int, int);
extern int ret_font(buffer *, int, int);
extern int ret_color(buffer *, int, int);
extern void set_color(buffer *, int, int, int);
extern char *ret_pvalue(char *, buffer *, int, int, int);
extern int line_last_used(buffer *);
extern int col_last_used(buffer *, int);
extern void downshift_matrix(buffer *, int);
extern void upshift_matrix(buffer *, int);
extern void rightshift_matrix(buffer *, int);
extern void leftshift_matrix(buffer *, int);
extern char *pack_area(buffer *, long, long, long, long, long *);
extern void unpack_area(buffer *, char *, long, long);
extern int undo_save(buffer *, long, long, long, long);
extern int undo_restore(buffer *);

/* from cmds.c */
extern void init_cmds(void);

/* from buffer.c */
extern buffer *b_list;
extern char *buffer_name(char *);
extern char *put_property(buffer *, char *, char *);
extern char *get_property(buffer *, char *);
extern buffer *new_buffer(char *, char *);
extern buffer *free_buffer(buffer *);
extern char *plugin_basedir(buffer *, char *);
extern void plugin_unique_name(char *, char *);
extern buffer *find_buffer_by_name(char *);
extern int cell_width(buffer *, long);
extern int cell_height(buffer *, long);
extern void set_width(buffer *, long, int);
extern void set_height(buffer *, long, int);
extern void buffer_global_coords(buffer *, long, long, long *, long *);
extern int buffer_plugin2index(buffer *, int);

/* from main.c */
extern int ok2print;
extern int C_interpreter, siod_interpreter;
extern char *siaghome, *siaghelp, *siagdocs, *siag_basedir;

/* from print.c */
extern void plot(int);
extern void preview(void);
extern void printer(void);

/* from railway.c */
extern int errorflag;
extern int siag_type;
extern int a1_refs;
extern char *interpreter2name(int);
extern int name2interpreter(char *);
extern int register_interpreter(char *,
	cval (*)(buffer *, char *, int, int),
	void (*)(char *),
	char *(*)(char *, int, int, int, int, int, int));
extern cval parse_expr(buffer *, int, char *, int, int);
extern int calc_matrix(buffer *);
extern int ref_counter(char *);
extern void ref_expander(char *, char *, char *, char *, char *);
extern int ref_updater(char *, char *, char *, int, int, int, int, int, int);
extern char *update_references(int, char *, int, int, int, int, int, int);
extern void update_all_references(buffer *, int, int, int, int, int, int);
/* execute is no longer siod only */
#define execute(p) exec_expr(siod_interpreter,(p))
extern void exec_expr(int, char *);

/* from fileio.c */
extern char *patterns[];
extern void register_format(int (*)(char *, buffer *),
		int (*)(char *, buffer*),
		int (*)(char *), char *);
extern void fileio_init(void);
extern int savematrix(char *, buffer *, char *);
extern int loadmatrix(char *, buffer *, char *);
extern char *guess_file_format(char *);

/* from position.c */
extern position set_point(window * , position);
extern position get_point(window * );
extern position set_mark(window * , position);
extern position get_mark(window * );
extern position set_top(window * , position);
extern position get_top(window *);
extern void init_position(void);
extern int inblock(window * , int, int);

/* from mathwrap.c */
extern void init_mathwrap(void);

/* from fontsel.c */
extern int font_input(int *, int *);

