/*
   Egon Animator
   Copyright (C) 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * fileio.c
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/xpm.h>

#include "../xcommon/Animator.h"
#include "egon.h"
#include "types.h"
#include "../common/fonts.h"
#include "../common/cmalloc.h"
#include "../xcommon/dialogs.h"

#define MAX_FORMATS (20)

static int format_count = 0;

struct {
	int (*load)(char *, buffer *);
	int (*save)(char *, buffer *);
	int (*myformat)(char *);
	char *pattern;
} fileformats[MAX_FORMATS];

static int save_all(char *fn, buffer *buf)
{
	int n = listsel(topLevel, "Which format?", patterns, format_count);
	if (n < 0) return -1;
	return savematrix(fn, buf, fileformats[n].pattern);
}

static int load_all(char *fn, buffer *buf)
{
	int n = listsel(topLevel, "Which format?", patterns, format_count);
	if (n < 0) return -1;
	return loadmatrix(fn, buf, fileformats[n].pattern);
}

static int myformat(char *fn)
{
	return 0;	/* this doesn't handle any format at all */
}

/* Need this in a separate structure for fsel_input */
char *patterns[MAX_FORMATS];

void register_format(int (*load)(char *, buffer *),
		int (*save)(char *, buffer *),
		int (*myformat)(char *), char *p)
{
	fileformats[format_count].load = load;
	fileformats[format_count].save = save;
	fileformats[format_count].myformat = myformat;
	fileformats[format_count].pattern = cstrdup(p);
	patterns[format_count] = fileformats[format_count].pattern;
	format_count++;
	patterns[format_count] = NULL;
}

/* These are not declared in calc.h because they will only be called here */
extern void fileio_egon_init(void);
extern void fileio_c_init(void);
extern void fileio_gif_init(void);
extern void fileio_ps_init(void);
extern void fileio_scm_init(void);

static int siag_fmt;

void fileio_init(void)
{
	/* Register Egon format first */
	siag_fmt = format_count;
	fileio_egon_init();
	fileio_c_init();
	fileio_gif_init();
	fileio_ps_init();
	fileio_scm_init();

	/* Put this catch-all last */
	register_format(load_all, save_all, myformat, "All files (*)");
}

static int fmt_index(char *fmt)
{
	int i;

	if (fmt == NULL) return siag_fmt;

	for (i = 0; i < format_count; i++)
		if (!strcmp(fileformats[i].pattern, fmt)) return i;
	return -1;
}

int savematrix(char *fn, buffer *buf, char *format)
{
	int (*fun)(char *, buffer *);
	int i;

	if (format) {
		i = fmt_index(format);
		if (i < 0) return 1;
	} else i = format_count-1;	/* Ask for format */

	fun = fileformats[i].save;
	if (fun) return fun(fn, buf);
	else return 1;
}

int loadmatrix(char *fn, buffer *buf, char *format)
{
	int (*fun)(char *, buffer *);
	int i;

	if (format) {
		i = fmt_index(format);
		if (i < 0) return 1;
	} else i = format_count-1;	/* Ask for format */

	fun = fileformats[i].load;
	if (fun) return fun(fn, buf);
	else return 1;
}

char *guess_file_format(char *fn)
{
        int i;
        int (*my_format)(char *);

        for (i = 0; i < format_count; i++) {
                my_format = fileformats[i].myformat;
                if (my_format && my_format(fn))
                        return fileformats[i].pattern;
        }
        return NULL;
}

