"multi.menu" <-
function (choices, title, header, allow.zero = T) 
{
        # Select more than one value from a menu 
        # 
        if (!missing(title)) 
                cat(title, "\n\n")
        mat <- matrix(c(1:length(choices), choices), ncol = 2)
        if (!missing(header)) {
                if (length(header) == 2) 
                        mat <- rbind(header, mat)
                else stop("header is wrong length")
        }
        cat(paste(format(mat[, 1]), format(mat[, 2])), sep = "\n")
        repeat {
                cat("\nEnter relevant number(s), separated by commas", 
                        "Ranges such as 3:7 may be specified)", 
                        sep = "\n")
                if (allow.zero) 
                        cat("(Enter 0 for none)\n")
                ans <- scan(what = character(), sep = ",", strip.white = T, 
                        nlines = 1, quiet = T)
                if (length(ans) > 0) {
                        out <- numeric(0)
                        for (i in 1:length(ans)) {
                                nc <- nchar(ans[i])
                                wrd <- substring(ans[i], 1:nc, 
                                 1:nc)
                                colons <- wrd == ":"
                                err <- any(is.na(as.numeric(wrd[!colons]))) | 
                                 sum(colons) > 1 | colons[1] | 
                                 colons[nc]
                                if (err) {
                                 cat("Error: you have specified a non-numeric value!\n")
                                 break
                                }
                                else {
                                 out <- c(out, eval(parse(text = ans[i])))
                                 if (min(out) < ifelse(allow.zero, 
                                  0, 1) | max(out) > length(choices) | 
                                  (any(out == 0) & length(out) > 
                                   1)) {
                                  err <- T
                                  cat("Error: you have specified variable number(s) out of range!\n")
                                  break
                                 }
                                }
                        }
                        if (!err) 
                                break
                }
        }
        return(out)
}
