/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "quadP.h"

/*
 * Note: Calling QuadNormal will undo this!
 */
Quad *
QuadEvert( q )
    Quad *q;
{
    int i;
    register Point3 *np;

    if(q != NULL && (np = &q->n[0][0]) != NULL) {
        for(i = 4 * q->maxquad; --i >= 0; np++) {
	    np->x = -np->x;
	    np->y = -np->y;
	    np->z = -np->z;
	}
    }
    return q;
}
