/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef QUADDEFS
#define QUADDEFS

#include "bbox.h"

#define QUADMAGIC GeomMagic ('q', 1)

typedef struct Quad Quad;

extern GeomClass *QuadMethods( void );
extern char *QuadName( void );
extern Quad *QuadLoad( char * );
extern Quad *QuadFLoad( FILE *, char *fname );
extern Quad *QuadSave( Quad *, char * );
extern Quad *QuadFSave( Quad *, FILE *, char *fname );
extern BBox *QuadBound( Quad *, Transform );
extern Geom *QuadSphere( Quad *, Transform, int );
extern Quad *QuadEvert( Quad * );
extern Quad *QuadDraw( Quad * );
extern Quad *QuadTransform( Quad *, Transform );
extern Quad *QuadTransformTo( Quad *, Transform );

#endif

