/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "ndmeshP.h"

NDMesh *
NDMeshFSave(NDMesh *m, FILE *outf)
{
	int  i, j, k, wdim;
	register HPointN **p = m->p;
	register ColorA *c = m->c;
	register Point3 *u = m->u;

	if (!outf || !m)
		return NULL;
	if (m->c == NULL)
		m->flag &= ~MESH_C;
	if (m->u == NULL)
		m->flag &= ~MESH_U;
	wdim = m->pdim;

	if (m->flag & MESH_C) fputc('C', outf);
	if (m->geomflags & VERT_4D) fputc('4', outf);
	if (m->flag & MESH_U) fputc('U', outf);
	if (m->flag & MESH_UWRAP) fputc('u', outf);
	if (m->flag & MESH_VWRAP) fputc('v', outf);
	fprintf(outf, "nMESH %d", m->pdim);
	if (m->flag & MESH_BINARY)    /* Hack -- should be sent by context */
	{
	    fprintf(outf, "BINARY\n");
	    fwrite(&m->mdim, sizeof(int), m->meshd, outf);
	    for (i = 0; i < m->mdim[1]; i++) {
		for (j = 0; j < m->mdim[0]; j++) {
		    fwrite((*p)->v, sizeof(float), wdim, outf);
		    p++;
		    if (m->flag & MESH_C) { fwrite(c, 4, 4, outf); c++; }
		    if (m->flag & MESH_U) { fwrite(u, 4, 3, outf); u++; }
		}
	    }
	}
	else
	{
	    fprintf(outf, "\n%d %d\n", m->mdim[0], m->mdim[1]);
	    for (i = 0; i < m->mdim[1]; i++) {
		for (j = 0; j < m->mdim[0]; j++) {
		    for(k = 0; k < wdim; k++)
			fprintf(outf, "%g ", (*p)->v[k]);
		    p++;
		    if (m->flag & MESH_C) {
			    fprintf(outf, " %.3g %.3g %.3g %.3g ",
				c->r, c->g, c->b, c->a);
			    c++;
		    }
		    if (m->flag & MESH_U) {
			    fprintf(outf, " %g %g %g", u->x, u->y, u->z);
			    u++;
		    }
		    fputc('\n', outf);
		}
		fputc('\n', outf);
	    }
	}

	return m;
}
