/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "meshP.h"

Mesh *
MeshCopy(obj)
    Mesh *obj;
{
	register Mesh  *m;
	register Mesh  *om = obj;
	register int    n;

	if (om == NULL) return (NULL);

	if ( (m = GeomNew(Mesh)) == NULL ) {
           GeomError(0,"Can't allocate space for mesh");
           return (NULL);
        }

	*m = *om; /* copy scalar fields */
	n = m->nu * m->nv;
	if ((m->p = GeomNewN(HPoint3, n)) == NULL) {
           GeomError(0,"Can't allocate space for mesh vertices");
           return (NULL);
        }
	memcpy(m->p, om->p, n * sizeof(HPoint3));

	if (m->flag & MESH_N) {
           if ((m->n = GeomNewN(Point3, n)) == NULL) {
                GeomError(0,"Can't allocate space for mesh normals");
                return(NULL);
           }
           memcpy(m->n, om->n, n * sizeof(Point3));
	} else
		m->n = NULL;

	if (m->flag & MESH_C) {
           if ((m->c = GeomNewN(ColorA, n)) == NULL) {
                GeomError(0,"Can't allocate space for mesh colors");
                return(NULL);
           }
	   memcpy(m->c, om->c, n * sizeof(ColorA));
	} else
		m->c = NULL;

	if (m->flag & MESH_U) {
           if ((m->u = GeomNewN(Point3, n)) == NULL) {
                GeomError(0,"Can't allocate space for mesh texture");
                return(NULL);
           }
	   memcpy(m->u, om->u, n * sizeof(Point3));
	} else
                m->u = NULL;

	if (m->flag & MESH_D) {
	   if ((m->d = GeomNewN(float, n)) == NULL
		    || (m->nd = GeomNewN(Point3, n)) == NULL) {
              GeomError(0,"Can't allocate space for mesh d/nd");
              return(NULL);
           }
	   memcpy(m->nd, om->nd, n * sizeof(Point3));
	   memcpy(m->d, om->d, n * sizeof(float));
	} else {
		m->d = NULL;
		m->nd = NULL;
	}
	return m;
}
