/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef GEOMDEF
#define GEOMDEF


#include "handle.h"
#include "3d.h"
#include "create.h"


#ifndef __cplusplus
typedef struct Geom		Geom;		/* Complete OOGL object */
typedef struct GeomClass	GeomClass;	/* Virtual func tbl for Geom */
typedef struct GeomIter		GeomIter;	/* opaque iteration handle */
#else
struct Geom; struct GeomClass; struct GeomIter;
#endif

extern char    *GeomName( Geom *obj );
extern GeomClass *GeomMethods( Geom * );
extern Geom    *GeomMessage( Geom *obj, int ac, char *av[] );
extern Geom    *GeomCopy( Geom *obj );
extern Geom    *GeomCreate( char *classname, ... );
extern Geom    *GeomCCreate( Geom *existing_value, GeomClass *Class, ... );
extern void	GeomDelete( Geom *obj );
extern Geom    *GeomLoad( char *name );
extern Geom    *GeomFLoad( FILE *inf, char *fname ); /* name for errs & type-guessing, may be NULL */
extern int	GeomFLoadEmbedded( Geom **obj, Handle **handlep, FILE *inf, char *fname );
extern int	GeomStreamIn( Pool *, Handle **handlep, Geom **geomp );
extern int	GeomStreamOut( Pool *, Handle *h, Geom *g );
extern Geom    *GeomSave( Geom *obj, char *name );
extern Geom    *GeomFSave( Geom *obj, FILE *outf, char *fname );
extern Geom    *GeomFSaveEmbedded( Geom *obj, Handle *handle, FILE *inf, char *fname );
extern void	GeomReplace( Geom *parent, Geom *newchild );
extern Geom    *GeomEvert( Geom *obj );
extern Geom    *GeomBound( Geom *obj, Transform T );
extern Geom    *GeomBoundSphere( Geom *obj, Transform T, int space );
extern Geom    *GeomEval( Geom *obj );
extern Geom    *GeomDice( Geom *obj, int nu, int nv );
extern Geom    *GeomSubdivide( Geom *obj );
extern Geom    *GeomPosition( Geom *obj, Transform T );
extern Geom    *GeomTransform( Geom *obj, Transform T );
extern Geom    *GeomTransformTo( Geom *obj, Transform T );

extern int	GeomSet( Geom *g, /* int attr, */ ... /* , CR_END */ );
extern int	GeomGet( Geom *g, int attr, void *attrp );

extern void	GeomHandleScan( Geom *g, int (*func)(), void *arg );

extern Geom    *GeomDraw( Geom *obj );	/* Using current mg context */

	/* Extensions.  These are roughly objective-C style.
 	 * Extension-functions are named with ASCII strings; for efficiency,
	 * the library interface uses integer "selectors".  Typical usage:
	 * int sel = GeomNewMethod( "new_method_name", my_default_func );
	 *   to define a new method, and/or
	 * GeomDefineMethod( sel, PolyListMethods(), my_func_for_polylists );
	 * GeomDefineMethod( sel, InstMethods(), my_func_for_insts );
	 * ...
	 *   to define a new method & its behavior on various object types. Or:
	 * int sel = GeomMethodSel( "method_name" );
	 *   returns the selector of an already-defined extension.
	 *   (GeomMethodSel() returns 0 for undefined extensions).
	 * To use the new method:
	 *   result = GeomCall( sel, geom, ... );
	 */

typedef  void *GeomExtFunc( int sel, Geom *geom, va_list args );

extern int   GeomMethodSel( char *name );	/* name -> selector, or 0 */
extern char *GeomMethodName( int sel );		/* selector -> name or NULL */
extern int   GeomNewMethod( char *name, GeomExtFunc *defaultfunc );/* -> selector */
GeomExtFunc *GeomSpecifyMethod( int sel, GeomClass *Class, GeomExtFunc *func );

extern void *GeomCall( int sel, Geom *geom, ... );
extern void *GeomCallV( int sel, Geom *geom, va_list args );

    /* Notes:
     * GeomMethodSel() returns the selector for a given extension; 0 = unknown.
     * GeomMethodName() returns the string naming an extension; NULL = unknown.
     * GeomNewMethod() returns the newly assigned selector.
     * GeomSpecifyMethod() returns the old method function, or NULL if none.
     * GeomCall() invokes a method function; if none was specified for that
     *		object class, the method's default function is called.
     * GeomCallV() takes a va_list rather than GeomCall's explicit param list.
     */

	/* Iteration */
			/* Iterate() flag bits: */
#define SHALLOW	1	/* Shallow traversal */
#define	DEEP	0	/* vs. Fully recursive */
#define	TRANSFORMED 2	/* Fully flatten all Geom's */
#define	INSTANCED 0	/* vs. Return Inst -> Geom's (saves copying data) */
#define	RETAIN	4	/* Retain returned Geom's indefinitely */
#define	DESTROY	0	/* vs. Destroy returned Geom's at next iteration step */

extern GeomIter *GeomIterate( Geom *root, int flags );
extern Geom	*NextGeom( GeomIter * );
extern int	 NextTransform( GeomIter *, Transform T );
extern void	 DestroyIter( GeomIter * );

	/* Import/export */
extern int	 GeomUpdate( Geom *obj, int doImport );	/* Recursive bind */

/* to support compatibility with the old way of doing it */
#define GeomScale(ggg, sx, sy, sz)	{	\
	Transform t;				\
	Tm3Scale(t, sz, sy, sz);		\
	GeomTransform(ggg, t); 	}

#define GeomTranslate(ggg, tx, ty, tz)	{	\
	Transform t;				\
	Tm3Translate(t, tz, ty, tz);		\
	GeomTransform(ggg, t); 	}

#define GeomRotate(ggg, aa, axis)	{	\
	Transform t;				\
	Tm3Rotate(t, aa, axis);			\
	GeomTransform(ggg, t); 	}


#endif /*GEOMDEF*/
