/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "discgrpP.h"

extern keytokenpair attr_list[], dspyattr_list[]; 

DiscGrp           *
DiscGrpFSave(DiscGrp *dg, FILE *fp, char *fname)
{

	int i, j;

	fprintf(fp,"DISCGRP\n");
	if (dg->name) fprintf(fp,"(group \" %s \" )\n",dg->name);
	if (dg->comment) fprintf(fp,"(comment \" %s \" )\n",dg->comment);
	for (i=0; i<DG_NUM_ATTR; ++i)	{
	    if (dg->attributes & attr_list[i].token)
		fprintf(fp,"(attribute %s )\n",attr_list[i].key);
	    }
	for (i=0; i<DG_NUM_DSPYATTR; ++i)	{
	    if (dg->flag & dspyattr_list[i].token)
		fprintf(fp,"(display %s )\n",dspyattr_list[i].key);
	    }
	fprintf(fp,"(dimn %d )\n",dg->dimn);
	fprintf(fp,"(ngens %d )\n",dg->gens->num_el);

	fprintf(fp,"(gens\n");
	for (i=0; i<dg->gens->num_el; ++i)	{
	    fprintf(fp,"%s\n",dg->gens->el_list[i].word);
	    fputtransform(fp, 1, (float *)dg->gens->el_list[i].tform, 0);
	    }
	fprintf(fp,")\n");

    if (dg->flag & DG_SAVEBIGLIST && dg->big_list)	{
	fprintf(fp,"(nels %d )\n",dg->big_list->num_el);
	fprintf(fp,"(els\n");
	for (i=0; i<dg->big_list->num_el; ++i)	{
	    fprintf(fp,"# %s\n",dg->big_list->el_list[i].word);
	    fputtransform(fp, 1, (float *)dg->big_list->el_list[i].tform, 0);
	    }
	fprintf(fp,")\n");
	}

    fprintf(fp,"(cpoint %f %f %f %f )\n",
	dg->cpoint.x, dg->cpoint.y, dg->cpoint.z, dg->cpoint.w);

    if (dg->c2m)	{
	fprintf(fp,"(c2m ");
	fputtransform(fp, 1, (float *) dg->c2m, 0);
	fprintf(fp,")\n");
	}

    fprintf(fp,"(enumdepth %d )\n",dg->enumdepth);
    fprintf(fp,"(enumdist %g )\n",dg->enumdist);
    fprintf(fp,"(drawdist %g )\n",dg->drawdist);
    fprintf(fp,"(scale %g )\n",dg->scale);

    if (dg->geom && dg->geom != dg->ddgeom)	{
	fprintf(fp,"(geom\n");
	GeomFSave(dg->geom, fp, fname);
	fprintf(fp,")\n");
	}

    else if (dg->ddgeom  && dg->flag & DG_SAVEDIRDOM )	{
	fprintf(fp,"(geom\n");
	GeomFSave(dg->ddgeom, fp, fname);
	fprintf(fp,")\n");
	}

    if (dg->camgeom)	{
	fprintf(fp,"(camgeom\n");
	GeomFSave(dg->camgeom, fp, fname);
	fprintf(fp,")\n");
	}

	return(dg);
}


DiscGrp           *
DiscGrpSave(dg, name)
DiscGrp           *dg;
char           *name;
{
	DiscGrp           *tdg;
	FILE           *outf;

	outf = fopen(name, "w");
	if (!outf)
	{
		OOGLError(1,"Unable to open file %s\n",name);
		return NULL;
	}
	tdg = DiscGrpFSave(dg, outf, name);
	fclose(outf);

	return (dg);
}
