/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

#define det( a1, a2, a3, b1, b2, b3, c1, c2, c3 ) \
    (a1*(b2*c3-c2*b3) - a2*(b1*c3-c1*b3) + a3*(b1*c2-c1*b2))

static
float 
cofactor( T, x, y )
    Tm3Coord T[4][4];
    int x, y;
{
    static Tm3Coord mat3x3[3][3];
    register Tm3Coord *dst = mat3x3[0];
    register Tm3Coord *src = T[0];
    int i;

    for( i=0; i<4; i++, src += 4 ) {
	if(i == x)
	    continue;
	if(y != 0) *dst++ = src[0];
	if(y != 1) *dst++ = src[1];
	if(y != 2) *dst++ = src[2];
	if(y != 3) *dst++ = src[3];
    }
    return det( mat3x3[0][0], mat3x3[0][1], mat3x3[0][2],
                mat3x3[1][0], mat3x3[1][1], mat3x3[1][2],
                mat3x3[2][0], mat3x3[2][1], mat3x3[2][2] );
}


static
void
adjoint( T, Tadj )
    Transform3 T, Tadj;
{
    register int x, y;
    float cof;

    for( x=0; x<4; x++ )
	for( y=0; y<4; y++ ) {
	    cof = cofactor( T, y, x );
	    Tadj[x][y] = ((x+y)&1) ? -cof : cof;
	}
}

/*-----------------------------------------------------------------------
 * Function:	Tm3Adjoint
 * Description:	compute the adjoint of a transform
 * Args:	T: the transform (INPUT)
 *		Tadj: the adjoint of T (OUTPUT)
 * Returns:	nothing
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 15:38:56 1991
 * Notes:	
 */
void
Tm3Adjoint( T, Tadj )
    Transform3 T, Tadj;
{
    if( T == Tadj ) {
	Transform3 Ttmp;

	adjoint( T, Ttmp );
	Tm3Copy( Ttmp, Tadj );
    }
    else
	adjoint( T, Tadj );
}

/*-----------------------------------------------------------------------
 * Function:	determinant
 * Description:	compute the determinant of a transform, using an already
 *		  computed adjoint transform
 * Args:	T: the transform (INPUT)
 *		Tadj: T's adjoint transform (INPUT)
 * Returns:	det(T)
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 15:23:53 1991
 * Notes:	
 */
static
float
determinant( T, Tadj )
    Transform3 T, Tadj;
{
    return T[0][0]*Tadj[0][0] 
        + T[0][1]*Tadj[1][0] 
        + T[0][2]*Tadj[2][0] 
        + T[0][3]*Tadj[3][0];
}

/*-----------------------------------------------------------------------
 * Function:	Tm3Determinant
 * Description:	compute the determinant of a transform
 * Args:	T: the transform (INPUT)
 * Returns:	det(T)
 * Author:	mbp
 * Date:	Thu Aug  8 15:27:52 1991
 * Notes:	
 */
float
Tm3Determinant( T )
    Transform3 T;
{
    Transform3 Tadj;

    Tm3Adjoint( T, Tadj );

    return determinant( T, Tadj );
}
