/* help.c
 * geg, a GTK+ Equation Grapher
 * David Bryant 1998
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include "help.h"

/* locally global data */
static gchar *help_text =
"Mouse Buttons:\n" \
"    Left      Zoom Selection\n" \
"    Middle    Solve Function Intercepts\n" \
"    Right     Solve Axis Intercepts\n" \
"\n" \
"The following functions are recognised:\n" \
"    sin       (Sine)\n" \
"    cos       (Cosine)\n" \
"    tan       (Tangent)\n" \
"    asin      (Arc-Sine)\n" \
"    acos      (Arc-Cosine)\n" \
"    atan      (Arc-Tan)\n" \
"    sinc      (Sinc)\n" \
"    sinh      (Hyperbolic Sine)\n" \
"    cosh      (Hyperbolic Cosine)\n" \
"    tanh      (Hyperbolic Tangent)\n" \
"    log       (log base 10)\n" \
"    ln        (Natural Log, Log base e)\n" \
"    sqrt      (Square Root)\n" \
"    cbrt      (Cube Root)\n" \
"    u         (Unit Step)\n" \
"    abs       (Absolute Value)\n" \
"\n" \
"The following constants are recognised:\n" \
"    pi        (3.141592654....)\n" \
"    e         (2.718281828....)\n" \
"\n" \
"The following operators are recognised:\n" \
"    +         (Add)\n" \
"    -         (Subtract)\n" \
"    *         (Multiply)\n" \
"    /         (Divide)\n" \
"    ^         (Raise to the Power)\n" \
"\n" \
"The following miscellaneous symbols are recognised:\n" \
"    (         (Left Bracket)\n" \
"    )         (Right Bracket)\n" \
"    [         (Left Square Bracket)\n" \
"    ]         (Right Square Bracket)\n" \
"    {         (Left Curly Bracket)\n" \
"    }         (Right Curly Bracket)\n" \
"    x         (Variable Parameter)\n" \
"\n" \
"The Extended Backus Naur Notation (EBNF used in geg is:\n" \
"    <expression> ::= <term>   { + | - <term> }\n" \
"    <term>       ::= <factor> { * | / | ^ <factor> }\n" \
"    <factor>     ::= <number> | <function> |\n" \
"                     (<expression>) | -<factor>\n" \
"    <number>     ::= <float> | x\n" \
"    <function>   ::= <function_name>(<expression>)";


static GtkWidget *wi = NULL;
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);
static void ok_event(GtkWidget *widget, gpointer data);

static void
ok_event(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(wi);
  wi = NULL;
}

static gint
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_widget_destroy(wi);
  wi = NULL;
  return(TRUE);
}

void
help_event(GtkWidget *widget, gpointer data)
{
  static GdkFont *font = NULL;
  GtkWidget *bu, *fr, *hb, *te, *sb;

  if(wi && wi->window) {
    gtk_widget_map(wi);
    gdk_window_raise(wi->window);
    return;
  }

  if(!font)
    font = gdk_font_load("fixed");
  
  g_assert(font != NULL);

  wi = gtk_dialog_new();

  gtk_signal_connect(GTK_OBJECT(wi), "delete_event",
                     GTK_SIGNAL_FUNC(delete_event), NULL);

  gtk_window_set_wmclass(GTK_WINDOW(wi), "help", "Geg");
  gtk_window_set_title(GTK_WINDOW(wi), "Help");
  gtk_window_set_policy(GTK_WINDOW(wi), TRUE, TRUE, TRUE);
  gtk_window_position(GTK_WINDOW(wi), GTK_WIN_POS_NONE);

  gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(wi)->vbox), 5);

  fr = gtk_frame_new("Syntax information:");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(wi)->vbox), fr, TRUE, TRUE, 0);
  gtk_widget_show(fr);

  hb = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(fr), hb);
  gtk_widget_show(hb);

  te = gtk_text_new(NULL, NULL);
  gtk_widget_set_usize(te, 70 * gdk_char_width(font, ' '), 400);
  gtk_text_set_word_wrap(GTK_TEXT(te), FALSE);
  gtk_box_pack_start(GTK_BOX(hb), te, TRUE, TRUE, 0);
  gtk_widget_show(te);

  sb = gtk_vscrollbar_new(GTK_TEXT(te)->vadj);
  gtk_box_pack_start(GTK_BOX(hb), sb, FALSE, FALSE, 0);
  gtk_widget_show(sb);

  bu = gtk_button_new_with_label("Ok");
  GTK_WIDGET_SET_FLAGS(bu, GTK_CAN_DEFAULT); 
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(wi)->action_area), bu, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(bu), "clicked",
                     GTK_SIGNAL_FUNC(ok_event), NULL);
  gtk_widget_grab_default(bu);
  gtk_widget_show(bu);
  
  gtk_widget_show(wi);
  gtk_text_insert(GTK_TEXT(te), font, NULL, NULL, help_text, strlen(help_text));
}
