/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:20:06 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 32 */

/*
 * This function contains 898 FP additions, 405 FP multiplications,
 * (or, 726 additions, 233 multiplications, 172 fused multiply/add),
 * 93 stack variables, and 256 memory accesses
 */
static const fftw_real K382683432 = FFTW_KONST(+0.382683432365089771728459984030398866761344562);
static const fftw_real K923879532 = FFTW_KONST(+0.923879532511286756128183189396788286822416626);
static const fftw_real K707106781 = FFTW_KONST(+0.707106781186547524400844362104849039284835938);
static const fftw_real K765366864 = FFTW_KONST(+0.765366864730179543456919968060797733522689125);
static const fftw_real K1_847759065 = FFTW_KONST(+1.847759065022573512256366378793576573644833252);
static const fftw_real K555570233 = FFTW_KONST(+0.555570233019602224742830813948532874374937191);
static const fftw_real K831469612 = FFTW_KONST(+0.831469612302545237078788377617905756738560812);
static const fftw_real K195090322 = FFTW_KONST(+0.195090322016128267848284868477022240927691618);
static const fftw_real K980785280 = FFTW_KONST(+0.980785280403230449126182236134239036973933731);
static const fftw_real K1_414213562 = FFTW_KONST(+1.414213562373095048801688724209698078569671875);
static const fftw_real K2_000000000 = FFTW_KONST(+2.000000000000000000000000000000000000000000000);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_backward_32(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (32 * iostride);
     {
	  fftw_real tmp818;
	  fftw_real tmp943;
	  fftw_real tmp905;
	  fftw_real tmp846;
	  fftw_real tmp841;
	  fftw_real tmp867;
	  fftw_real tmp865;
	  fftw_real tmp889;
	  fftw_real tmp954;
	  fftw_real tmp958;
	  fftw_real tmp928;
	  fftw_real tmp932;
	  fftw_real tmp815;
	  fftw_real tmp843;
	  fftw_real tmp902;
	  fftw_real tmp942;
	  fftw_real tmp826;
	  fftw_real tmp848;
	  fftw_real tmp855;
	  fftw_real tmp892;
	  fftw_real tmp909;
	  fftw_real tmp945;
	  fftw_real tmp912;
	  fftw_real tmp946;
	  fftw_real tmp834;
	  fftw_real tmp858;
	  fftw_real tmp874;
	  fftw_real tmp888;
	  fftw_real tmp951;
	  fftw_real tmp957;
	  fftw_real tmp921;
	  fftw_real tmp931;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp816;
	       fftw_real tmp817;
	       fftw_real tmp903;
	       fftw_real tmp844;
	       fftw_real tmp845;
	       fftw_real tmp904;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp816 = X[4 * iostride];
	       tmp817 = X[12 * iostride];
	       tmp903 = tmp816 - tmp817;
	       tmp844 = Y[-4 * iostride];
	       tmp845 = Y[-12 * iostride];
	       tmp904 = tmp845 + tmp844;
	       tmp818 = K2_000000000 * (tmp816 + tmp817);
	       tmp943 = K1_414213562 * (tmp903 + tmp904);
	       tmp905 = K1_414213562 * (tmp903 - tmp904);
	       tmp846 = K2_000000000 * (tmp844 - tmp845);
	  }
	  {
	       fftw_real tmp837;
	       fftw_real tmp922;
	       fftw_real tmp864;
	       fftw_real tmp926;
	       fftw_real tmp840;
	       fftw_real tmp925;
	       fftw_real tmp861;
	       fftw_real tmp923;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp835;
		    fftw_real tmp836;
		    fftw_real tmp862;
		    fftw_real tmp863;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp835 = X[3 * iostride];
		    tmp836 = X[13 * iostride];
		    tmp837 = tmp835 + tmp836;
		    tmp922 = tmp835 - tmp836;
		    tmp862 = Y[-3 * iostride];
		    tmp863 = Y[-13 * iostride];
		    tmp864 = tmp862 - tmp863;
		    tmp926 = tmp862 + tmp863;
	       }
	       {
		    fftw_real tmp838;
		    fftw_real tmp839;
		    fftw_real tmp859;
		    fftw_real tmp860;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp838 = X[5 * iostride];
		    tmp839 = X[11 * iostride];
		    tmp840 = tmp838 + tmp839;
		    tmp925 = tmp839 - tmp838;
		    tmp859 = Y[-5 * iostride];
		    tmp860 = Y[-11 * iostride];
		    tmp861 = tmp859 - tmp860;
		    tmp923 = tmp860 + tmp859;
	       }
	       tmp841 = tmp837 + tmp840;
	       tmp867 = tmp840 - tmp837;
	       tmp865 = tmp861 + tmp864;
	       tmp889 = tmp864 - tmp861;
	       {
		    fftw_real tmp952;
		    fftw_real tmp953;
		    fftw_real tmp924;
		    fftw_real tmp927;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp952 = tmp922 + tmp923;
		    tmp953 = tmp926 - tmp925;
		    tmp954 = (K980785280 * tmp952) - (K195090322 * tmp953);
		    tmp958 = (K195090322 * tmp952) + (K980785280 * tmp953);
		    tmp924 = tmp922 - tmp923;
		    tmp927 = tmp925 + tmp926;
		    tmp928 = (K831469612 * tmp924) - (K555570233 * tmp927);
		    tmp932 = (K555570233 * tmp924) + (K831469612 * tmp927);
	       }
	  }
	  {
	       fftw_real tmp814;
	       fftw_real tmp901;
	       fftw_real tmp812;
	       fftw_real tmp899;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp813;
		    fftw_real tmp900;
		    fftw_real tmp810;
		    fftw_real tmp811;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp813 = X[8 * iostride];
		    tmp814 = K2_000000000 * tmp813;
		    tmp900 = Y[-8 * iostride];
		    tmp901 = K2_000000000 * tmp900;
		    tmp810 = X[0];
		    tmp811 = X[16 * iostride];
		    tmp812 = tmp810 + tmp811;
		    tmp899 = tmp810 - tmp811;
	       }
	       tmp815 = tmp812 + tmp814;
	       tmp843 = tmp812 - tmp814;
	       tmp902 = tmp899 - tmp901;
	       tmp942 = tmp899 + tmp901;
	  }
	  {
	       fftw_real tmp822;
	       fftw_real tmp907;
	       fftw_real tmp854;
	       fftw_real tmp911;
	       fftw_real tmp825;
	       fftw_real tmp910;
	       fftw_real tmp851;
	       fftw_real tmp908;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp820;
		    fftw_real tmp821;
		    fftw_real tmp852;
		    fftw_real tmp853;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp820 = X[2 * iostride];
		    tmp821 = X[14 * iostride];
		    tmp822 = tmp820 + tmp821;
		    tmp907 = tmp820 - tmp821;
		    tmp852 = Y[-2 * iostride];
		    tmp853 = Y[-14 * iostride];
		    tmp854 = tmp852 - tmp853;
		    tmp911 = tmp852 + tmp853;
	       }
	       {
		    fftw_real tmp823;
		    fftw_real tmp824;
		    fftw_real tmp849;
		    fftw_real tmp850;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp823 = X[6 * iostride];
		    tmp824 = X[10 * iostride];
		    tmp825 = tmp823 + tmp824;
		    tmp910 = tmp824 - tmp823;
		    tmp849 = Y[-6 * iostride];
		    tmp850 = Y[-10 * iostride];
		    tmp851 = tmp849 - tmp850;
		    tmp908 = tmp850 + tmp849;
	       }
	       tmp826 = K2_000000000 * (tmp822 + tmp825);
	       tmp848 = tmp822 - tmp825;
	       tmp855 = tmp851 + tmp854;
	       tmp892 = K2_000000000 * (tmp854 - tmp851);
	       tmp909 = tmp907 - tmp908;
	       tmp945 = tmp907 + tmp908;
	       tmp912 = tmp910 + tmp911;
	       tmp946 = tmp911 - tmp910;
	  }
	  {
	       fftw_real tmp830;
	       fftw_real tmp915;
	       fftw_real tmp873;
	       fftw_real tmp919;
	       fftw_real tmp833;
	       fftw_real tmp918;
	       fftw_real tmp870;
	       fftw_real tmp916;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp828;
		    fftw_real tmp829;
		    fftw_real tmp871;
		    fftw_real tmp872;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp828 = X[iostride];
		    tmp829 = X[15 * iostride];
		    tmp830 = tmp828 + tmp829;
		    tmp915 = tmp828 - tmp829;
		    tmp871 = Y[-iostride];
		    tmp872 = Y[-15 * iostride];
		    tmp873 = tmp871 - tmp872;
		    tmp919 = tmp871 + tmp872;
	       }
	       {
		    fftw_real tmp831;
		    fftw_real tmp832;
		    fftw_real tmp868;
		    fftw_real tmp869;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp831 = X[7 * iostride];
		    tmp832 = X[9 * iostride];
		    tmp833 = tmp831 + tmp832;
		    tmp918 = tmp832 - tmp831;
		    tmp868 = Y[-7 * iostride];
		    tmp869 = Y[-9 * iostride];
		    tmp870 = tmp868 - tmp869;
		    tmp916 = tmp869 + tmp868;
	       }
	       tmp834 = tmp830 + tmp833;
	       tmp858 = tmp830 - tmp833;
	       tmp874 = tmp870 + tmp873;
	       tmp888 = tmp873 - tmp870;
	       {
		    fftw_real tmp949;
		    fftw_real tmp950;
		    fftw_real tmp917;
		    fftw_real tmp920;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp949 = tmp915 + tmp916;
		    tmp950 = tmp919 - tmp918;
		    tmp951 = (K555570233 * tmp949) + (K831469612 * tmp950);
		    tmp957 = (K831469612 * tmp949) - (K555570233 * tmp950);
		    tmp917 = tmp915 - tmp916;
		    tmp920 = tmp918 + tmp919;
		    tmp921 = (K980785280 * tmp917) - (K195090322 * tmp920);
		    tmp931 = (K195090322 * tmp917) + (K980785280 * tmp920);
	       }
	  }
	  {
	       fftw_real tmp842;
	       fftw_real tmp890;
	       fftw_real tmp827;
	       fftw_real tmp887;
	       fftw_real tmp819;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp842 = K2_000000000 * (tmp834 + tmp841);
	       tmp890 = K2_000000000 * (tmp888 - tmp889);
	       tmp819 = tmp815 + tmp818;
	       tmp827 = tmp819 + tmp826;
	       tmp887 = tmp819 - tmp826;
	       X[16 * iostride] = tmp827 - tmp842;
	       X[0] = tmp827 + tmp842;
	       X[8 * iostride] = tmp887 - tmp890;
	       X[24 * iostride] = tmp887 + tmp890;
	  }
	  {
	       fftw_real tmp893;
	       fftw_real tmp897;
	       fftw_real tmp896;
	       fftw_real tmp898;
	       fftw_real tmp891;
	       fftw_real tmp894;
	       fftw_real tmp895;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp891 = tmp815 - tmp818;
	       tmp893 = tmp891 - tmp892;
	       tmp897 = tmp891 + tmp892;
	       tmp894 = tmp834 - tmp841;
	       tmp895 = tmp888 + tmp889;
	       tmp896 = K1_414213562 * (tmp894 - tmp895);
	       tmp898 = K1_414213562 * (tmp894 + tmp895);
	       X[20 * iostride] = tmp893 - tmp896;
	       X[4 * iostride] = tmp893 + tmp896;
	       X[12 * iostride] = tmp897 - tmp898;
	       X[28 * iostride] = tmp897 + tmp898;
	  }
	  {
	       fftw_real tmp857;
	       fftw_real tmp877;
	       fftw_real tmp876;
	       fftw_real tmp878;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp847;
		    fftw_real tmp856;
		    fftw_real tmp866;
		    fftw_real tmp875;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp847 = tmp843 - tmp846;
		    tmp856 = K1_414213562 * (tmp848 - tmp855);
		    tmp857 = tmp847 + tmp856;
		    tmp877 = tmp847 - tmp856;
		    tmp866 = tmp858 - tmp865;
		    tmp875 = tmp867 + tmp874;
		    tmp876 = (K1_847759065 * tmp866) - (K765366864 * tmp875);
		    tmp878 = (K1_847759065 * tmp875) + (K765366864 * tmp866);
	       }
	       X[18 * iostride] = tmp857 - tmp876;
	       X[2 * iostride] = tmp857 + tmp876;
	       X[10 * iostride] = tmp877 - tmp878;
	       X[26 * iostride] = tmp877 + tmp878;
	  }
	  {
	       fftw_real tmp881;
	       fftw_real tmp885;
	       fftw_real tmp884;
	       fftw_real tmp886;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp879;
		    fftw_real tmp880;
		    fftw_real tmp882;
		    fftw_real tmp883;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp879 = tmp843 + tmp846;
		    tmp880 = K1_414213562 * (tmp848 + tmp855);
		    tmp881 = tmp879 - tmp880;
		    tmp885 = tmp879 + tmp880;
		    tmp882 = tmp858 + tmp865;
		    tmp883 = tmp874 - tmp867;
		    tmp884 = (K765366864 * tmp882) - (K1_847759065 * tmp883);
		    tmp886 = (K765366864 * tmp883) + (K1_847759065 * tmp882);
	       }
	       X[22 * iostride] = tmp881 - tmp884;
	       X[6 * iostride] = tmp881 + tmp884;
	       X[14 * iostride] = tmp885 - tmp886;
	       X[30 * iostride] = tmp885 + tmp886;
	  }
	  {
	       fftw_real tmp929;
	       fftw_real tmp933;
	       fftw_real tmp914;
	       fftw_real tmp930;
	       fftw_real tmp906;
	       fftw_real tmp913;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp929 = K2_000000000 * (tmp921 + tmp928);
	       tmp933 = K2_000000000 * (tmp931 - tmp932);
	       tmp906 = tmp902 + tmp905;
	       tmp913 = (K1_847759065 * tmp909) - (K765366864 * tmp912);
	       tmp914 = tmp906 + tmp913;
	       tmp930 = tmp906 - tmp913;
	       X[17 * iostride] = tmp914 - tmp929;
	       X[iostride] = tmp914 + tmp929;
	       X[9 * iostride] = tmp930 - tmp933;
	       X[25 * iostride] = tmp930 + tmp933;
	  }
	  {
	       fftw_real tmp936;
	       fftw_real tmp940;
	       fftw_real tmp939;
	       fftw_real tmp941;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp934;
		    fftw_real tmp935;
		    fftw_real tmp937;
		    fftw_real tmp938;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp934 = tmp902 - tmp905;
		    tmp935 = (K765366864 * tmp909) + (K1_847759065 * tmp912);
		    tmp936 = tmp934 - tmp935;
		    tmp940 = tmp934 + tmp935;
		    tmp937 = tmp921 - tmp928;
		    tmp938 = tmp931 + tmp932;
		    tmp939 = K1_414213562 * (tmp937 - tmp938);
		    tmp941 = K1_414213562 * (tmp937 + tmp938);
	       }
	       X[21 * iostride] = tmp936 - tmp939;
	       X[5 * iostride] = tmp936 + tmp939;
	       X[13 * iostride] = tmp940 - tmp941;
	       X[29 * iostride] = tmp940 + tmp941;
	  }
	  {
	       fftw_real tmp955;
	       fftw_real tmp959;
	       fftw_real tmp948;
	       fftw_real tmp956;
	       fftw_real tmp944;
	       fftw_real tmp947;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp955 = K2_000000000 * (tmp951 - tmp954);
	       tmp959 = K2_000000000 * (tmp957 - tmp958);
	       tmp944 = tmp942 - tmp943;
	       tmp947 = (K765366864 * tmp945) - (K1_847759065 * tmp946);
	       tmp948 = tmp944 - tmp947;
	       tmp956 = tmp944 + tmp947;
	       X[11 * iostride] = tmp948 - tmp955;
	       X[27 * iostride] = tmp948 + tmp955;
	       X[19 * iostride] = tmp956 - tmp959;
	       X[3 * iostride] = tmp956 + tmp959;
	  }
	  {
	       fftw_real tmp962;
	       fftw_real tmp966;
	       fftw_real tmp965;
	       fftw_real tmp967;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp960;
		    fftw_real tmp961;
		    fftw_real tmp963;
		    fftw_real tmp964;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp960 = tmp942 + tmp943;
		    tmp961 = (K1_847759065 * tmp945) + (K765366864 * tmp946);
		    tmp962 = tmp960 - tmp961;
		    tmp966 = tmp960 + tmp961;
		    tmp963 = tmp957 + tmp958;
		    tmp964 = tmp951 + tmp954;
		    tmp965 = K1_414213562 * (tmp963 - tmp964);
		    tmp967 = K1_414213562 * (tmp964 + tmp963);
	       }
	       X[23 * iostride] = tmp962 - tmp965;
	       X[7 * iostride] = tmp962 + tmp965;
	       X[15 * iostride] = tmp966 - tmp967;
	       X[31 * iostride] = tmp966 + tmp967;
	  }
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 31) {
	  fftw_real tmp585;
	  fftw_real tmp719;
	  fftw_real tmp328;
	  fftw_real tmp377;
	  fftw_real tmp521;
	  fftw_real tmp559;
	  fftw_real tmp446;
	  fftw_real tmp471;
	  fftw_real tmp653;
	  fftw_real tmp747;
	  fftw_real tmp493;
	  fftw_real tmp547;
	  fftw_real tmp592;
	  fftw_real tmp748;
	  fftw_real tmp656;
	  fftw_real tmp720;
	  fftw_real tmp374;
	  fftw_real tmp411;
	  fftw_real tmp504;
	  fftw_real tmp550;
	  fftw_real tmp426;
	  fftw_real tmp475;
	  fftw_real tmp507;
	  fftw_real tmp551;
	  fftw_real tmp639;
	  fftw_real tmp689;
	  fftw_real tmp732;
	  fftw_real tmp782;
	  fftw_real tmp646;
	  fftw_real tmp690;
	  fftw_real tmp735;
	  fftw_real tmp781;
	  fftw_real tmp343;
	  fftw_real tmp431;
	  fftw_real tmp496;
	  fftw_real tmp523;
	  fftw_real tmp392;
	  fftw_real tmp472;
	  fftw_real tmp499;
	  fftw_real tmp522;
	  fftw_real tmp600;
	  fftw_real tmp659;
	  fftw_real tmp727;
	  fftw_real tmp751;
	  fftw_real tmp607;
	  fftw_real tmp658;
	  fftw_real tmp724;
	  fftw_real tmp750;
	  fftw_real tmp359;
	  fftw_real tmp394;
	  fftw_real tmp511;
	  fftw_real tmp553;
	  fftw_real tmp409;
	  fftw_real tmp474;
	  fftw_real tmp514;
	  fftw_real tmp554;
	  fftw_real tmp620;
	  fftw_real tmp686;
	  fftw_real tmp739;
	  fftw_real tmp779;
	  fftw_real tmp627;
	  fftw_real tmp687;
	  fftw_real tmp742;
	  fftw_real tmp778;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp316;
	       fftw_real tmp583;
	       fftw_real tmp434;
	       fftw_real tmp652;
	       fftw_real tmp319;
	       fftw_real tmp651;
	       fftw_real tmp437;
	       fftw_real tmp584;
	       fftw_real tmp323;
	       fftw_real tmp586;
	       fftw_real tmp441;
	       fftw_real tmp587;
	       fftw_real tmp326;
	       fftw_real tmp589;
	       fftw_real tmp444;
	       fftw_real tmp590;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp314;
		    fftw_real tmp315;
		    fftw_real tmp432;
		    fftw_real tmp433;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp314 = X[0];
		    tmp315 = Y[-16 * iostride];
		    tmp316 = tmp314 + tmp315;
		    tmp583 = tmp314 - tmp315;
		    tmp432 = Y[0];
		    tmp433 = X[16 * iostride];
		    tmp434 = tmp432 - tmp433;
		    tmp652 = tmp432 + tmp433;
	       }
	       {
		    fftw_real tmp317;
		    fftw_real tmp318;
		    fftw_real tmp435;
		    fftw_real tmp436;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp317 = X[8 * iostride];
		    tmp318 = Y[-24 * iostride];
		    tmp319 = tmp317 + tmp318;
		    tmp651 = tmp317 - tmp318;
		    tmp435 = Y[-8 * iostride];
		    tmp436 = X[24 * iostride];
		    tmp437 = tmp435 - tmp436;
		    tmp584 = tmp435 + tmp436;
	       }
	       {
		    fftw_real tmp321;
		    fftw_real tmp322;
		    fftw_real tmp439;
		    fftw_real tmp440;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp321 = X[4 * iostride];
		    tmp322 = Y[-20 * iostride];
		    tmp323 = tmp321 + tmp322;
		    tmp586 = tmp321 - tmp322;
		    tmp439 = Y[-4 * iostride];
		    tmp440 = X[20 * iostride];
		    tmp441 = tmp439 - tmp440;
		    tmp587 = tmp439 + tmp440;
	       }
	       {
		    fftw_real tmp324;
		    fftw_real tmp325;
		    fftw_real tmp442;
		    fftw_real tmp443;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp324 = Y[-28 * iostride];
		    tmp325 = X[12 * iostride];
		    tmp326 = tmp324 + tmp325;
		    tmp589 = tmp324 - tmp325;
		    tmp442 = Y[-12 * iostride];
		    tmp443 = X[28 * iostride];
		    tmp444 = tmp442 - tmp443;
		    tmp590 = tmp442 + tmp443;
	       }
	       {
		    fftw_real tmp320;
		    fftw_real tmp327;
		    fftw_real tmp491;
		    fftw_real tmp492;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp585 = tmp583 - tmp584;
		    tmp719 = tmp583 + tmp584;
		    tmp320 = tmp316 + tmp319;
		    tmp327 = tmp323 + tmp326;
		    tmp328 = tmp320 + tmp327;
		    tmp377 = tmp320 - tmp327;
		    {
			 fftw_real tmp519;
			 fftw_real tmp520;
			 fftw_real tmp438;
			 fftw_real tmp445;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp519 = tmp434 - tmp437;
			 tmp520 = tmp323 - tmp326;
			 tmp521 = tmp519 - tmp520;
			 tmp559 = tmp520 + tmp519;
			 tmp438 = tmp434 + tmp437;
			 tmp445 = tmp441 + tmp444;
			 tmp446 = tmp438 - tmp445;
			 tmp471 = tmp438 + tmp445;
		    }
		    tmp653 = tmp651 + tmp652;
		    tmp747 = tmp652 - tmp651;
		    tmp491 = tmp316 - tmp319;
		    tmp492 = tmp444 - tmp441;
		    tmp493 = tmp491 - tmp492;
		    tmp547 = tmp491 + tmp492;
		    {
			 fftw_real tmp588;
			 fftw_real tmp591;
			 fftw_real tmp654;
			 fftw_real tmp655;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp588 = tmp586 - tmp587;
			 tmp591 = tmp589 - tmp590;
			 tmp592 = K707106781 * (tmp588 + tmp591);
			 tmp748 = K707106781 * (tmp588 - tmp591);
			 tmp654 = tmp586 + tmp587;
			 tmp655 = tmp589 + tmp590;
			 tmp656 = K707106781 * (tmp654 - tmp655);
			 tmp720 = K707106781 * (tmp654 + tmp655);
		    }
	       }
	  }
	  {
	       fftw_real tmp362;
	       fftw_real tmp629;
	       fftw_real tmp414;
	       fftw_real tmp641;
	       fftw_real tmp365;
	       fftw_real tmp640;
	       fftw_real tmp417;
	       fftw_real tmp630;
	       fftw_real tmp372;
	       fftw_real tmp644;
	       fftw_real tmp637;
	       fftw_real tmp424;
	       fftw_real tmp369;
	       fftw_real tmp643;
	       fftw_real tmp634;
	       fftw_real tmp421;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp360;
		    fftw_real tmp361;
		    fftw_real tmp415;
		    fftw_real tmp416;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp360 = Y[-31 * iostride];
		    tmp361 = X[15 * iostride];
		    tmp362 = tmp360 + tmp361;
		    tmp629 = tmp360 - tmp361;
		    {
			 fftw_real tmp412;
			 fftw_real tmp413;
			 fftw_real tmp363;
			 fftw_real tmp364;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp412 = Y[-15 * iostride];
			 tmp413 = X[31 * iostride];
			 tmp414 = tmp412 - tmp413;
			 tmp641 = tmp412 + tmp413;
			 tmp363 = X[7 * iostride];
			 tmp364 = Y[-23 * iostride];
			 tmp365 = tmp363 + tmp364;
			 tmp640 = tmp363 - tmp364;
		    }
		    tmp415 = Y[-7 * iostride];
		    tmp416 = X[23 * iostride];
		    tmp417 = tmp415 - tmp416;
		    tmp630 = tmp415 + tmp416;
		    {
			 fftw_real tmp370;
			 fftw_real tmp371;
			 fftw_real tmp635;
			 fftw_real tmp422;
			 fftw_real tmp423;
			 fftw_real tmp636;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp370 = Y[-27 * iostride];
			 tmp371 = X[11 * iostride];
			 tmp635 = tmp370 - tmp371;
			 tmp422 = Y[-11 * iostride];
			 tmp423 = X[27 * iostride];
			 tmp636 = tmp422 + tmp423;
			 tmp372 = tmp370 + tmp371;
			 tmp644 = tmp635 + tmp636;
			 tmp637 = tmp635 - tmp636;
			 tmp424 = tmp422 - tmp423;
		    }
		    {
			 fftw_real tmp367;
			 fftw_real tmp368;
			 fftw_real tmp632;
			 fftw_real tmp419;
			 fftw_real tmp420;
			 fftw_real tmp633;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp367 = X[3 * iostride];
			 tmp368 = Y[-19 * iostride];
			 tmp632 = tmp367 - tmp368;
			 tmp419 = Y[-3 * iostride];
			 tmp420 = X[19 * iostride];
			 tmp633 = tmp419 + tmp420;
			 tmp369 = tmp367 + tmp368;
			 tmp643 = tmp632 + tmp633;
			 tmp634 = tmp632 - tmp633;
			 tmp421 = tmp419 - tmp420;
		    }
	       }
	       {
		    fftw_real tmp366;
		    fftw_real tmp373;
		    fftw_real tmp502;
		    fftw_real tmp503;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp366 = tmp362 + tmp365;
		    tmp373 = tmp369 + tmp372;
		    tmp374 = tmp366 + tmp373;
		    tmp411 = tmp366 - tmp373;
		    tmp502 = tmp414 - tmp417;
		    tmp503 = tmp369 - tmp372;
		    tmp504 = tmp502 - tmp503;
		    tmp550 = tmp503 + tmp502;
	       }
	       {
		    fftw_real tmp418;
		    fftw_real tmp425;
		    fftw_real tmp505;
		    fftw_real tmp506;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp418 = tmp414 + tmp417;
		    tmp425 = tmp421 + tmp424;
		    tmp426 = tmp418 - tmp425;
		    tmp475 = tmp418 + tmp425;
		    tmp505 = tmp362 - tmp365;
		    tmp506 = tmp424 - tmp421;
		    tmp507 = tmp505 - tmp506;
		    tmp551 = tmp505 + tmp506;
	       }
	       {
		    fftw_real tmp631;
		    fftw_real tmp638;
		    fftw_real tmp730;
		    fftw_real tmp731;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp631 = tmp629 - tmp630;
		    tmp638 = K707106781 * (tmp634 + tmp637);
		    tmp639 = tmp631 - tmp638;
		    tmp689 = tmp631 + tmp638;
		    tmp730 = K707106781 * (tmp634 - tmp637);
		    tmp731 = tmp640 + tmp641;
		    tmp732 = tmp730 - tmp731;
		    tmp782 = tmp731 + tmp730;
	       }
	       {
		    fftw_real tmp642;
		    fftw_real tmp645;
		    fftw_real tmp733;
		    fftw_real tmp734;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp642 = tmp640 - tmp641;
		    tmp645 = K707106781 * (tmp643 - tmp644);
		    tmp646 = tmp642 - tmp645;
		    tmp690 = tmp642 + tmp645;
		    tmp733 = tmp629 + tmp630;
		    tmp734 = K707106781 * (tmp643 + tmp644);
		    tmp735 = tmp733 - tmp734;
		    tmp781 = tmp733 + tmp734;
	       }
	  }
	  {
	       fftw_real tmp331;
	       fftw_real tmp604;
	       fftw_real tmp387;
	       fftw_real tmp602;
	       fftw_real tmp334;
	       fftw_real tmp601;
	       fftw_real tmp390;
	       fftw_real tmp605;
	       fftw_real tmp338;
	       fftw_real tmp597;
	       fftw_real tmp380;
	       fftw_real tmp595;
	       fftw_real tmp341;
	       fftw_real tmp594;
	       fftw_real tmp383;
	       fftw_real tmp598;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp329;
		    fftw_real tmp330;
		    fftw_real tmp385;
		    fftw_real tmp386;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp329 = X[2 * iostride];
		    tmp330 = Y[-18 * iostride];
		    tmp331 = tmp329 + tmp330;
		    tmp604 = tmp329 - tmp330;
		    tmp385 = Y[-2 * iostride];
		    tmp386 = X[18 * iostride];
		    tmp387 = tmp385 - tmp386;
		    tmp602 = tmp385 + tmp386;
	       }
	       {
		    fftw_real tmp332;
		    fftw_real tmp333;
		    fftw_real tmp388;
		    fftw_real tmp389;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp332 = X[10 * iostride];
		    tmp333 = Y[-26 * iostride];
		    tmp334 = tmp332 + tmp333;
		    tmp601 = tmp332 - tmp333;
		    tmp388 = Y[-10 * iostride];
		    tmp389 = X[26 * iostride];
		    tmp390 = tmp388 - tmp389;
		    tmp605 = tmp388 + tmp389;
	       }
	       {
		    fftw_real tmp336;
		    fftw_real tmp337;
		    fftw_real tmp378;
		    fftw_real tmp379;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp336 = Y[-30 * iostride];
		    tmp337 = X[14 * iostride];
		    tmp338 = tmp336 + tmp337;
		    tmp597 = tmp336 - tmp337;
		    tmp378 = Y[-14 * iostride];
		    tmp379 = X[30 * iostride];
		    tmp380 = tmp378 - tmp379;
		    tmp595 = tmp378 + tmp379;
	       }
	       {
		    fftw_real tmp339;
		    fftw_real tmp340;
		    fftw_real tmp381;
		    fftw_real tmp382;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp339 = X[6 * iostride];
		    tmp340 = Y[-22 * iostride];
		    tmp341 = tmp339 + tmp340;
		    tmp594 = tmp339 - tmp340;
		    tmp381 = Y[-6 * iostride];
		    tmp382 = X[22 * iostride];
		    tmp383 = tmp381 - tmp382;
		    tmp598 = tmp381 + tmp382;
	       }
	       {
		    fftw_real tmp335;
		    fftw_real tmp342;
		    fftw_real tmp494;
		    fftw_real tmp495;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp335 = tmp331 + tmp334;
		    tmp342 = tmp338 + tmp341;
		    tmp343 = tmp335 + tmp342;
		    tmp431 = tmp335 - tmp342;
		    tmp494 = tmp380 - tmp383;
		    tmp495 = tmp338 - tmp341;
		    tmp496 = tmp494 - tmp495;
		    tmp523 = tmp495 + tmp494;
	       }
	       {
		    fftw_real tmp384;
		    fftw_real tmp391;
		    fftw_real tmp497;
		    fftw_real tmp498;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp384 = tmp380 + tmp383;
		    tmp391 = tmp387 + tmp390;
		    tmp392 = tmp384 - tmp391;
		    tmp472 = tmp391 + tmp384;
		    tmp497 = tmp331 - tmp334;
		    tmp498 = tmp387 - tmp390;
		    tmp499 = tmp497 + tmp498;
		    tmp522 = tmp497 - tmp498;
	       }
	       {
		    fftw_real tmp596;
		    fftw_real tmp599;
		    fftw_real tmp725;
		    fftw_real tmp726;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp596 = tmp594 - tmp595;
		    tmp599 = tmp597 - tmp598;
		    tmp600 = (K923879532 * tmp596) - (K382683432 * tmp599);
		    tmp659 = (K382683432 * tmp596) + (K923879532 * tmp599);
		    tmp725 = tmp597 + tmp598;
		    tmp726 = tmp594 + tmp595;
		    tmp727 = (K382683432 * tmp725) - (K923879532 * tmp726);
		    tmp751 = (K382683432 * tmp726) + (K923879532 * tmp725);
	       }
	       {
		    fftw_real tmp603;
		    fftw_real tmp606;
		    fftw_real tmp722;
		    fftw_real tmp723;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp603 = tmp601 + tmp602;
		    tmp606 = tmp604 - tmp605;
		    tmp607 = (K923879532 * tmp603) + (K382683432 * tmp606);
		    tmp658 = (K923879532 * tmp606) - (K382683432 * tmp603);
		    tmp722 = tmp604 + tmp605;
		    tmp723 = tmp602 - tmp601;
		    tmp724 = (K382683432 * tmp722) - (K923879532 * tmp723);
		    tmp750 = (K382683432 * tmp723) + (K923879532 * tmp722);
	       }
	  }
	  {
	       fftw_real tmp347;
	       fftw_real tmp610;
	       fftw_real tmp397;
	       fftw_real tmp622;
	       fftw_real tmp350;
	       fftw_real tmp621;
	       fftw_real tmp400;
	       fftw_real tmp611;
	       fftw_real tmp357;
	       fftw_real tmp625;
	       fftw_real tmp618;
	       fftw_real tmp407;
	       fftw_real tmp354;
	       fftw_real tmp624;
	       fftw_real tmp615;
	       fftw_real tmp404;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp345;
		    fftw_real tmp346;
		    fftw_real tmp398;
		    fftw_real tmp399;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp345 = X[iostride];
		    tmp346 = Y[-17 * iostride];
		    tmp347 = tmp345 + tmp346;
		    tmp610 = tmp345 - tmp346;
		    {
			 fftw_real tmp395;
			 fftw_real tmp396;
			 fftw_real tmp348;
			 fftw_real tmp349;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp395 = Y[-iostride];
			 tmp396 = X[17 * iostride];
			 tmp397 = tmp395 - tmp396;
			 tmp622 = tmp395 + tmp396;
			 tmp348 = X[9 * iostride];
			 tmp349 = Y[-25 * iostride];
			 tmp350 = tmp348 + tmp349;
			 tmp621 = tmp348 - tmp349;
		    }
		    tmp398 = Y[-9 * iostride];
		    tmp399 = X[25 * iostride];
		    tmp400 = tmp398 - tmp399;
		    tmp611 = tmp398 + tmp399;
		    {
			 fftw_real tmp355;
			 fftw_real tmp356;
			 fftw_real tmp616;
			 fftw_real tmp405;
			 fftw_real tmp406;
			 fftw_real tmp617;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp355 = Y[-29 * iostride];
			 tmp356 = X[13 * iostride];
			 tmp616 = tmp355 - tmp356;
			 tmp405 = Y[-13 * iostride];
			 tmp406 = X[29 * iostride];
			 tmp617 = tmp405 + tmp406;
			 tmp357 = tmp355 + tmp356;
			 tmp625 = tmp616 + tmp617;
			 tmp618 = tmp616 - tmp617;
			 tmp407 = tmp405 - tmp406;
		    }
		    {
			 fftw_real tmp352;
			 fftw_real tmp353;
			 fftw_real tmp613;
			 fftw_real tmp402;
			 fftw_real tmp403;
			 fftw_real tmp614;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp352 = X[5 * iostride];
			 tmp353 = Y[-21 * iostride];
			 tmp613 = tmp352 - tmp353;
			 tmp402 = Y[-5 * iostride];
			 tmp403 = X[21 * iostride];
			 tmp614 = tmp402 + tmp403;
			 tmp354 = tmp352 + tmp353;
			 tmp624 = tmp613 + tmp614;
			 tmp615 = tmp613 - tmp614;
			 tmp404 = tmp402 - tmp403;
		    }
	       }
	       {
		    fftw_real tmp351;
		    fftw_real tmp358;
		    fftw_real tmp509;
		    fftw_real tmp510;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp351 = tmp347 + tmp350;
		    tmp358 = tmp354 + tmp357;
		    tmp359 = tmp351 + tmp358;
		    tmp394 = tmp351 - tmp358;
		    tmp509 = tmp397 - tmp400;
		    tmp510 = tmp354 - tmp357;
		    tmp511 = tmp509 - tmp510;
		    tmp553 = tmp510 + tmp509;
	       }
	       {
		    fftw_real tmp401;
		    fftw_real tmp408;
		    fftw_real tmp512;
		    fftw_real tmp513;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp401 = tmp397 + tmp400;
		    tmp408 = tmp404 + tmp407;
		    tmp409 = tmp401 - tmp408;
		    tmp474 = tmp401 + tmp408;
		    tmp512 = tmp347 - tmp350;
		    tmp513 = tmp407 - tmp404;
		    tmp514 = tmp512 - tmp513;
		    tmp554 = tmp512 + tmp513;
	       }
	       {
		    fftw_real tmp612;
		    fftw_real tmp619;
		    fftw_real tmp737;
		    fftw_real tmp738;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp612 = tmp610 - tmp611;
		    tmp619 = K707106781 * (tmp615 + tmp618);
		    tmp620 = tmp612 - tmp619;
		    tmp686 = tmp612 + tmp619;
		    tmp737 = tmp622 - tmp621;
		    tmp738 = K707106781 * (tmp615 - tmp618);
		    tmp739 = tmp737 + tmp738;
		    tmp779 = tmp737 - tmp738;
	       }
	       {
		    fftw_real tmp623;
		    fftw_real tmp626;
		    fftw_real tmp740;
		    fftw_real tmp741;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp623 = tmp621 + tmp622;
		    tmp626 = K707106781 * (tmp624 - tmp625);
		    tmp627 = tmp623 - tmp626;
		    tmp687 = tmp623 + tmp626;
		    tmp740 = tmp610 + tmp611;
		    tmp741 = K707106781 * (tmp624 + tmp625);
		    tmp742 = tmp740 - tmp741;
		    tmp778 = tmp740 + tmp741;
	       }
	  }
	  {
	       fftw_real tmp344;
	       fftw_real tmp375;
	       fftw_real tmp469;
	       fftw_real tmp473;
	       fftw_real tmp476;
	       fftw_real tmp477;
	       fftw_real tmp468;
	       fftw_real tmp470;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp344 = tmp328 + tmp343;
	       tmp375 = tmp359 + tmp374;
	       tmp469 = tmp344 - tmp375;
	       tmp473 = tmp471 + tmp472;
	       tmp476 = tmp474 + tmp475;
	       tmp477 = tmp473 - tmp476;
	       X[0] = tmp344 + tmp375;
	       Y[-31 * iostride] = tmp473 + tmp476;
	       tmp468 = c_re(W[15]);
	       tmp470 = c_im(W[15]);
	       X[16 * iostride] = (tmp468 * tmp469) + (tmp470 * tmp477);
	       Y[-15 * iostride] = (tmp468 * tmp477) - (tmp470 * tmp469);
	  }
	  {
	       fftw_real tmp481;
	       fftw_real tmp487;
	       fftw_real tmp485;
	       fftw_real tmp489;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp479;
		    fftw_real tmp480;
		    fftw_real tmp483;
		    fftw_real tmp484;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp479 = tmp471 - tmp472;
		    tmp480 = tmp359 - tmp374;
		    tmp481 = tmp479 - tmp480;
		    tmp487 = tmp480 + tmp479;
		    tmp483 = tmp328 - tmp343;
		    tmp484 = tmp475 - tmp474;
		    tmp485 = tmp483 - tmp484;
		    tmp489 = tmp483 + tmp484;
	       }
	       {
		    fftw_real tmp478;
		    fftw_real tmp482;
		    fftw_real tmp486;
		    fftw_real tmp488;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp478 = c_re(W[23]);
		    tmp482 = c_im(W[23]);
		    Y[-7 * iostride] = (tmp478 * tmp481) - (tmp482 * tmp485);
		    X[24 * iostride] = (tmp482 * tmp481) + (tmp478 * tmp485);
		    tmp486 = c_re(W[7]);
		    tmp488 = c_im(W[7]);
		    Y[-23 * iostride] = (tmp486 * tmp487) - (tmp488 * tmp489);
		    X[8 * iostride] = (tmp488 * tmp487) + (tmp486 * tmp489);
	       }
	  }
	  {
	       fftw_real tmp393;
	       fftw_real tmp461;
	       fftw_real tmp428;
	       fftw_real tmp458;
	       fftw_real tmp447;
	       fftw_real tmp457;
	       fftw_real tmp450;
	       fftw_real tmp462;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp410;
		    fftw_real tmp427;
		    fftw_real tmp448;
		    fftw_real tmp449;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp393 = tmp377 + tmp392;
		    tmp461 = tmp377 - tmp392;
		    tmp410 = tmp394 - tmp409;
		    tmp427 = tmp411 + tmp426;
		    tmp428 = K707106781 * (tmp410 + tmp427);
		    tmp458 = K707106781 * (tmp410 - tmp427);
		    tmp447 = tmp431 + tmp446;
		    tmp457 = tmp446 - tmp431;
		    tmp448 = tmp394 + tmp409;
		    tmp449 = tmp426 - tmp411;
		    tmp450 = K707106781 * (tmp448 + tmp449);
		    tmp462 = K707106781 * (tmp449 - tmp448);
	       }
	       {
		    fftw_real tmp429;
		    fftw_real tmp451;
		    fftw_real tmp376;
		    fftw_real tmp430;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp429 = tmp393 - tmp428;
		    tmp451 = tmp447 - tmp450;
		    tmp376 = c_re(W[19]);
		    tmp430 = c_im(W[19]);
		    X[20 * iostride] = (tmp376 * tmp429) + (tmp430 * tmp451);
		    Y[-11 * iostride] = (tmp376 * tmp451) - (tmp430 * tmp429);
	       }
	       {
		    fftw_real tmp453;
		    fftw_real tmp455;
		    fftw_real tmp452;
		    fftw_real tmp454;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp453 = tmp393 + tmp428;
		    tmp455 = tmp447 + tmp450;
		    tmp452 = c_re(W[3]);
		    tmp454 = c_im(W[3]);
		    X[4 * iostride] = (tmp452 * tmp453) + (tmp454 * tmp455);
		    Y[-27 * iostride] = (tmp452 * tmp455) - (tmp454 * tmp453);
	       }
	       {
		    fftw_real tmp459;
		    fftw_real tmp463;
		    fftw_real tmp456;
		    fftw_real tmp460;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp459 = tmp457 - tmp458;
		    tmp463 = tmp461 - tmp462;
		    tmp456 = c_re(W[27]);
		    tmp460 = c_im(W[27]);
		    Y[-3 * iostride] = (tmp456 * tmp459) - (tmp460 * tmp463);
		    X[28 * iostride] = (tmp460 * tmp459) + (tmp456 * tmp463);
	       }
	       {
		    fftw_real tmp465;
		    fftw_real tmp467;
		    fftw_real tmp464;
		    fftw_real tmp466;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp465 = tmp457 + tmp458;
		    tmp467 = tmp461 + tmp462;
		    tmp464 = c_re(W[11]);
		    tmp466 = c_im(W[11]);
		    Y[-19 * iostride] = (tmp464 * tmp465) - (tmp466 * tmp467);
		    X[12 * iostride] = (tmp466 * tmp465) + (tmp464 * tmp467);
	       }
	  }
	  {
	       fftw_real tmp777;
	       fftw_real tmp803;
	       fftw_real tmp792;
	       fftw_real tmp804;
	       fftw_real tmp784;
	       fftw_real tmp800;
	       fftw_real tmp789;
	       fftw_real tmp799;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp775;
		    fftw_real tmp776;
		    fftw_real tmp790;
		    fftw_real tmp791;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp775 = tmp719 + tmp720;
		    tmp776 = tmp750 + tmp751;
		    tmp777 = tmp775 - tmp776;
		    tmp803 = tmp775 + tmp776;
		    tmp790 = (K195090322 * tmp779) + (K980785280 * tmp778);
		    tmp791 = (K195090322 * tmp782) + (K980785280 * tmp781);
		    tmp792 = tmp790 - tmp791;
		    tmp804 = tmp790 + tmp791;
	       }
	       {
		    fftw_real tmp780;
		    fftw_real tmp783;
		    fftw_real tmp787;
		    fftw_real tmp788;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp780 = (K195090322 * tmp778) - (K980785280 * tmp779);
		    tmp783 = (K195090322 * tmp781) - (K980785280 * tmp782);
		    tmp784 = tmp780 + tmp783;
		    tmp800 = tmp780 - tmp783;
		    tmp787 = tmp747 - tmp748;
		    tmp788 = tmp724 - tmp727;
		    tmp789 = tmp787 + tmp788;
		    tmp799 = tmp787 - tmp788;
	       }
	       {
		    fftw_real tmp785;
		    fftw_real tmp793;
		    fftw_real tmp774;
		    fftw_real tmp786;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp785 = tmp777 - tmp784;
		    tmp793 = tmp789 - tmp792;
		    tmp774 = c_re(W[22]);
		    tmp786 = c_im(W[22]);
		    X[23 * iostride] = (tmp774 * tmp785) + (tmp786 * tmp793);
		    Y[-8 * iostride] = (tmp774 * tmp793) - (tmp786 * tmp785);
	       }
	       {
		    fftw_real tmp795;
		    fftw_real tmp797;
		    fftw_real tmp794;
		    fftw_real tmp796;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp795 = tmp777 + tmp784;
		    tmp797 = tmp789 + tmp792;
		    tmp794 = c_re(W[6]);
		    tmp796 = c_im(W[6]);
		    X[7 * iostride] = (tmp794 * tmp795) + (tmp796 * tmp797);
		    Y[-24 * iostride] = (tmp794 * tmp797) - (tmp796 * tmp795);
	       }
	       {
		    fftw_real tmp801;
		    fftw_real tmp805;
		    fftw_real tmp798;
		    fftw_real tmp802;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp801 = tmp799 + tmp800;
		    tmp805 = tmp803 - tmp804;
		    tmp798 = c_re(W[14]);
		    tmp802 = c_im(W[14]);
		    Y[-16 * iostride] = (tmp798 * tmp801) - (tmp802 * tmp805);
		    X[15 * iostride] = (tmp802 * tmp801) + (tmp798 * tmp805);
	       }
	       {
		    fftw_real tmp807;
		    fftw_real tmp809;
		    fftw_real tmp806;
		    fftw_real tmp808;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp807 = tmp799 - tmp800;
		    tmp809 = tmp803 + tmp804;
		    tmp806 = c_re(W[30]);
		    tmp808 = c_im(W[30]);
		    Y[0] = (tmp806 * tmp807) - (tmp808 * tmp809);
		    X[31 * iostride] = (tmp808 * tmp807) + (tmp806 * tmp809);
	       }
	  }
	  {
	       fftw_real tmp549;
	       fftw_real tmp575;
	       fftw_real tmp564;
	       fftw_real tmp576;
	       fftw_real tmp561;
	       fftw_real tmp571;
	       fftw_real tmp556;
	       fftw_real tmp572;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp548;
		    fftw_real tmp562;
		    fftw_real tmp563;
		    fftw_real tmp560;
		    fftw_real tmp552;
		    fftw_real tmp555;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp548 = K707106781 * (tmp522 + tmp523);
		    tmp549 = tmp547 - tmp548;
		    tmp575 = tmp547 + tmp548;
		    tmp562 = (K923879532 * tmp554) - (K382683432 * tmp553);
		    tmp563 = (K382683432 * tmp550) + (K923879532 * tmp551);
		    tmp564 = tmp562 - tmp563;
		    tmp576 = tmp562 + tmp563;
		    tmp560 = K707106781 * (tmp499 + tmp496);
		    tmp561 = tmp559 - tmp560;
		    tmp571 = tmp559 + tmp560;
		    tmp552 = (K923879532 * tmp550) - (K382683432 * tmp551);
		    tmp555 = (K923879532 * tmp553) + (K382683432 * tmp554);
		    tmp556 = tmp552 - tmp555;
		    tmp572 = tmp555 + tmp552;
	       }
	       {
		    fftw_real tmp557;
		    fftw_real tmp565;
		    fftw_real tmp546;
		    fftw_real tmp558;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp557 = tmp549 - tmp556;
		    tmp565 = tmp561 - tmp564;
		    tmp546 = c_re(W[25]);
		    tmp558 = c_im(W[25]);
		    X[26 * iostride] = (tmp546 * tmp557) + (tmp558 * tmp565);
		    Y[-5 * iostride] = (tmp546 * tmp565) - (tmp558 * tmp557);
	       }
	       {
		    fftw_real tmp567;
		    fftw_real tmp569;
		    fftw_real tmp566;
		    fftw_real tmp568;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp567 = tmp549 + tmp556;
		    tmp569 = tmp561 + tmp564;
		    tmp566 = c_re(W[9]);
		    tmp568 = c_im(W[9]);
		    X[10 * iostride] = (tmp566 * tmp567) + (tmp568 * tmp569);
		    Y[-21 * iostride] = (tmp566 * tmp569) - (tmp568 * tmp567);
	       }
	       {
		    fftw_real tmp573;
		    fftw_real tmp577;
		    fftw_real tmp570;
		    fftw_real tmp574;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp573 = tmp571 - tmp572;
		    tmp577 = tmp575 - tmp576;
		    tmp570 = c_re(W[17]);
		    tmp574 = c_im(W[17]);
		    Y[-13 * iostride] = (tmp570 * tmp573) - (tmp574 * tmp577);
		    X[18 * iostride] = (tmp574 * tmp573) + (tmp570 * tmp577);
	       }
	       {
		    fftw_real tmp579;
		    fftw_real tmp581;
		    fftw_real tmp578;
		    fftw_real tmp580;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp579 = tmp571 + tmp572;
		    tmp581 = tmp575 + tmp576;
		    tmp578 = c_re(W[1]);
		    tmp580 = c_im(W[1]);
		    Y[-29 * iostride] = (tmp578 * tmp579) - (tmp580 * tmp581);
		    X[2 * iostride] = (tmp580 * tmp579) + (tmp578 * tmp581);
	       }
	  }
	  {
	       fftw_real tmp501;
	       fftw_real tmp539;
	       fftw_real tmp528;
	       fftw_real tmp540;
	       fftw_real tmp525;
	       fftw_real tmp535;
	       fftw_real tmp516;
	       fftw_real tmp536;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp500;
		    fftw_real tmp526;
		    fftw_real tmp527;
		    fftw_real tmp524;
		    fftw_real tmp508;
		    fftw_real tmp515;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp500 = K707106781 * (tmp496 - tmp499);
		    tmp501 = tmp493 - tmp500;
		    tmp539 = tmp493 + tmp500;
		    tmp526 = (K382683432 * tmp514) - (K923879532 * tmp511);
		    tmp527 = (K923879532 * tmp504) + (K382683432 * tmp507);
		    tmp528 = tmp526 - tmp527;
		    tmp540 = tmp526 + tmp527;
		    tmp524 = K707106781 * (tmp522 - tmp523);
		    tmp525 = tmp521 - tmp524;
		    tmp535 = tmp521 + tmp524;
		    tmp508 = (K382683432 * tmp504) - (K923879532 * tmp507);
		    tmp515 = (K382683432 * tmp511) + (K923879532 * tmp514);
		    tmp516 = tmp508 - tmp515;
		    tmp536 = tmp515 + tmp508;
	       }
	       {
		    fftw_real tmp517;
		    fftw_real tmp529;
		    fftw_real tmp490;
		    fftw_real tmp518;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp517 = tmp501 - tmp516;
		    tmp529 = tmp525 - tmp528;
		    tmp490 = c_re(W[29]);
		    tmp518 = c_im(W[29]);
		    X[30 * iostride] = (tmp490 * tmp517) + (tmp518 * tmp529);
		    Y[-iostride] = (tmp490 * tmp529) - (tmp518 * tmp517);
	       }
	       {
		    fftw_real tmp531;
		    fftw_real tmp533;
		    fftw_real tmp530;
		    fftw_real tmp532;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp531 = tmp501 + tmp516;
		    tmp533 = tmp525 + tmp528;
		    tmp530 = c_re(W[13]);
		    tmp532 = c_im(W[13]);
		    X[14 * iostride] = (tmp530 * tmp531) + (tmp532 * tmp533);
		    Y[-17 * iostride] = (tmp530 * tmp533) - (tmp532 * tmp531);
	       }
	       {
		    fftw_real tmp537;
		    fftw_real tmp541;
		    fftw_real tmp534;
		    fftw_real tmp538;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp537 = tmp535 - tmp536;
		    tmp541 = tmp539 - tmp540;
		    tmp534 = c_re(W[21]);
		    tmp538 = c_im(W[21]);
		    Y[-9 * iostride] = (tmp534 * tmp537) - (tmp538 * tmp541);
		    X[22 * iostride] = (tmp538 * tmp537) + (tmp534 * tmp541);
	       }
	       {
		    fftw_real tmp543;
		    fftw_real tmp545;
		    fftw_real tmp542;
		    fftw_real tmp544;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp543 = tmp535 + tmp536;
		    tmp545 = tmp539 + tmp540;
		    tmp542 = c_re(W[5]);
		    tmp544 = c_im(W[5]);
		    Y[-25 * iostride] = (tmp542 * tmp543) - (tmp544 * tmp545);
		    X[6 * iostride] = (tmp544 * tmp543) + (tmp542 * tmp545);
	       }
	  }
	  {
	       fftw_real tmp729;
	       fftw_real tmp767;
	       fftw_real tmp756;
	       fftw_real tmp768;
	       fftw_real tmp744;
	       fftw_real tmp764;
	       fftw_real tmp753;
	       fftw_real tmp763;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp721;
		    fftw_real tmp728;
		    fftw_real tmp754;
		    fftw_real tmp755;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp721 = tmp719 - tmp720;
		    tmp728 = tmp724 + tmp727;
		    tmp729 = tmp721 - tmp728;
		    tmp767 = tmp721 + tmp728;
		    tmp754 = (K831469612 * tmp742) - (K555570233 * tmp739);
		    tmp755 = (K555570233 * tmp732) + (K831469612 * tmp735);
		    tmp756 = tmp754 - tmp755;
		    tmp768 = tmp754 + tmp755;
	       }
	       {
		    fftw_real tmp736;
		    fftw_real tmp743;
		    fftw_real tmp749;
		    fftw_real tmp752;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp736 = (K831469612 * tmp732) - (K555570233 * tmp735);
		    tmp743 = (K831469612 * tmp739) + (K555570233 * tmp742);
		    tmp744 = tmp736 - tmp743;
		    tmp764 = tmp743 + tmp736;
		    tmp749 = tmp747 + tmp748;
		    tmp752 = tmp750 - tmp751;
		    tmp753 = tmp749 - tmp752;
		    tmp763 = tmp749 + tmp752;
	       }
	       {
		    fftw_real tmp745;
		    fftw_real tmp757;
		    fftw_real tmp718;
		    fftw_real tmp746;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp745 = tmp729 - tmp744;
		    tmp757 = tmp753 - tmp756;
		    tmp718 = c_re(W[26]);
		    tmp746 = c_im(W[26]);
		    X[27 * iostride] = (tmp718 * tmp745) + (tmp746 * tmp757);
		    Y[-4 * iostride] = (tmp718 * tmp757) - (tmp746 * tmp745);
	       }
	       {
		    fftw_real tmp759;
		    fftw_real tmp761;
		    fftw_real tmp758;
		    fftw_real tmp760;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp759 = tmp729 + tmp744;
		    tmp761 = tmp753 + tmp756;
		    tmp758 = c_re(W[10]);
		    tmp760 = c_im(W[10]);
		    X[11 * iostride] = (tmp758 * tmp759) + (tmp760 * tmp761);
		    Y[-20 * iostride] = (tmp758 * tmp761) - (tmp760 * tmp759);
	       }
	       {
		    fftw_real tmp765;
		    fftw_real tmp769;
		    fftw_real tmp762;
		    fftw_real tmp766;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp765 = tmp763 - tmp764;
		    tmp769 = tmp767 - tmp768;
		    tmp762 = c_re(W[18]);
		    tmp766 = c_im(W[18]);
		    Y[-12 * iostride] = (tmp762 * tmp765) - (tmp766 * tmp769);
		    X[19 * iostride] = (tmp766 * tmp765) + (tmp762 * tmp769);
	       }
	       {
		    fftw_real tmp771;
		    fftw_real tmp773;
		    fftw_real tmp770;
		    fftw_real tmp772;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp771 = tmp763 + tmp764;
		    tmp773 = tmp767 + tmp768;
		    tmp770 = c_re(W[2]);
		    tmp772 = c_im(W[2]);
		    Y[-28 * iostride] = (tmp770 * tmp771) - (tmp772 * tmp773);
		    X[3 * iostride] = (tmp772 * tmp771) + (tmp770 * tmp773);
	       }
	  }
	  {
	       fftw_real tmp685;
	       fftw_real tmp711;
	       fftw_real tmp700;
	       fftw_real tmp712;
	       fftw_real tmp692;
	       fftw_real tmp708;
	       fftw_real tmp697;
	       fftw_real tmp707;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp683;
		    fftw_real tmp684;
		    fftw_real tmp698;
		    fftw_real tmp699;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp683 = tmp585 + tmp592;
		    tmp684 = tmp658 + tmp659;
		    tmp685 = tmp683 + tmp684;
		    tmp711 = tmp683 - tmp684;
		    tmp698 = (K195090322 * tmp686) + (K980785280 * tmp687);
		    tmp699 = (K980785280 * tmp690) - (K195090322 * tmp689);
		    tmp700 = tmp698 + tmp699;
		    tmp712 = tmp699 - tmp698;
	       }
	       {
		    fftw_real tmp688;
		    fftw_real tmp691;
		    fftw_real tmp695;
		    fftw_real tmp696;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp688 = (K980785280 * tmp686) - (K195090322 * tmp687);
		    tmp691 = (K980785280 * tmp689) + (K195090322 * tmp690);
		    tmp692 = tmp688 + tmp691;
		    tmp708 = tmp688 - tmp691;
		    tmp695 = tmp653 + tmp656;
		    tmp696 = tmp607 + tmp600;
		    tmp697 = tmp695 + tmp696;
		    tmp707 = tmp695 - tmp696;
	       }
	       {
		    fftw_real tmp693;
		    fftw_real tmp701;
		    fftw_real tmp682;
		    fftw_real tmp694;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp693 = tmp685 - tmp692;
		    tmp701 = tmp697 - tmp700;
		    tmp682 = c_re(W[16]);
		    tmp694 = c_im(W[16]);
		    X[17 * iostride] = (tmp682 * tmp693) + (tmp694 * tmp701);
		    Y[-14 * iostride] = (tmp682 * tmp701) - (tmp694 * tmp693);
	       }
	       {
		    fftw_real tmp703;
		    fftw_real tmp705;
		    fftw_real tmp702;
		    fftw_real tmp704;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp703 = tmp685 + tmp692;
		    tmp705 = tmp697 + tmp700;
		    tmp702 = c_re(W[0]);
		    tmp704 = c_im(W[0]);
		    X[iostride] = (tmp702 * tmp703) + (tmp704 * tmp705);
		    Y[-30 * iostride] = (tmp702 * tmp705) - (tmp704 * tmp703);
	       }
	       {
		    fftw_real tmp709;
		    fftw_real tmp713;
		    fftw_real tmp706;
		    fftw_real tmp710;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp709 = tmp707 - tmp708;
		    tmp713 = tmp711 - tmp712;
		    tmp706 = c_re(W[24]);
		    tmp710 = c_im(W[24]);
		    Y[-6 * iostride] = (tmp706 * tmp709) - (tmp710 * tmp713);
		    X[25 * iostride] = (tmp710 * tmp709) + (tmp706 * tmp713);
	       }
	       {
		    fftw_real tmp715;
		    fftw_real tmp717;
		    fftw_real tmp714;
		    fftw_real tmp716;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp715 = tmp707 + tmp708;
		    tmp717 = tmp711 + tmp712;
		    tmp714 = c_re(W[8]);
		    tmp716 = c_im(W[8]);
		    Y[-22 * iostride] = (tmp714 * tmp715) - (tmp716 * tmp717);
		    X[9 * iostride] = (tmp716 * tmp715) + (tmp714 * tmp717);
	       }
	  }
	  {
	       fftw_real tmp609;
	       fftw_real tmp675;
	       fftw_real tmp664;
	       fftw_real tmp676;
	       fftw_real tmp648;
	       fftw_real tmp672;
	       fftw_real tmp661;
	       fftw_real tmp671;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp593;
		    fftw_real tmp608;
		    fftw_real tmp662;
		    fftw_real tmp663;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp593 = tmp585 - tmp592;
		    tmp608 = tmp600 - tmp607;
		    tmp609 = tmp593 + tmp608;
		    tmp675 = tmp593 - tmp608;
		    tmp662 = (K831469612 * tmp620) + (K555570233 * tmp627);
		    tmp663 = (K555570233 * tmp646) - (K831469612 * tmp639);
		    tmp664 = tmp662 + tmp663;
		    tmp676 = tmp663 - tmp662;
	       }
	       {
		    fftw_real tmp628;
		    fftw_real tmp647;
		    fftw_real tmp657;
		    fftw_real tmp660;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp628 = (K555570233 * tmp620) - (K831469612 * tmp627);
		    tmp647 = (K555570233 * tmp639) + (K831469612 * tmp646);
		    tmp648 = tmp628 + tmp647;
		    tmp672 = tmp628 - tmp647;
		    tmp657 = tmp653 - tmp656;
		    tmp660 = tmp658 - tmp659;
		    tmp661 = tmp657 + tmp660;
		    tmp671 = tmp657 - tmp660;
	       }
	       {
		    fftw_real tmp649;
		    fftw_real tmp665;
		    fftw_real tmp582;
		    fftw_real tmp650;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp649 = tmp609 - tmp648;
		    tmp665 = tmp661 - tmp664;
		    tmp582 = c_re(W[20]);
		    tmp650 = c_im(W[20]);
		    X[21 * iostride] = (tmp582 * tmp649) + (tmp650 * tmp665);
		    Y[-10 * iostride] = (tmp582 * tmp665) - (tmp650 * tmp649);
	       }
	       {
		    fftw_real tmp667;
		    fftw_real tmp669;
		    fftw_real tmp666;
		    fftw_real tmp668;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp667 = tmp609 + tmp648;
		    tmp669 = tmp661 + tmp664;
		    tmp666 = c_re(W[4]);
		    tmp668 = c_im(W[4]);
		    X[5 * iostride] = (tmp666 * tmp667) + (tmp668 * tmp669);
		    Y[-26 * iostride] = (tmp666 * tmp669) - (tmp668 * tmp667);
	       }
	       {
		    fftw_real tmp673;
		    fftw_real tmp677;
		    fftw_real tmp670;
		    fftw_real tmp674;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp673 = tmp671 - tmp672;
		    tmp677 = tmp675 - tmp676;
		    tmp670 = c_re(W[28]);
		    tmp674 = c_im(W[28]);
		    Y[-2 * iostride] = (tmp670 * tmp673) - (tmp674 * tmp677);
		    X[29 * iostride] = (tmp674 * tmp673) + (tmp670 * tmp677);
	       }
	       {
		    fftw_real tmp679;
		    fftw_real tmp681;
		    fftw_real tmp678;
		    fftw_real tmp680;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp679 = tmp671 + tmp672;
		    tmp681 = tmp675 + tmp676;
		    tmp678 = c_re(W[12]);
		    tmp680 = c_im(W[12]);
		    Y[-18 * iostride] = (tmp678 * tmp679) - (tmp680 * tmp681);
		    X[13 * iostride] = (tmp680 * tmp679) + (tmp678 * tmp681);
	       }
	  }
     }
     if (i == m) {
	  fftw_real tmp36;
	  fftw_real tmp138;
	  fftw_real tmp15;
	  fftw_real tmp276;
	  fftw_real tmp228;
	  fftw_real tmp256;
	  fftw_real tmp285;
	  fftw_real tmp305;
	  fftw_real tmp89;
	  fftw_real tmp155;
	  fftw_real tmp208;
	  fftw_real tmp250;
	  fftw_real tmp47;
	  fftw_real tmp154;
	  fftw_real tmp84;
	  fftw_real tmp139;
	  fftw_real tmp30;
	  fftw_real tmp281;
	  fftw_real tmp213;
	  fftw_real tmp232;
	  fftw_real tmp221;
	  fftw_real tmp253;
	  fftw_real tmp218;
	  fftw_real tmp233;
	  fftw_real tmp222;
	  fftw_real tmp254;
	  fftw_real tmp279;
	  fftw_real tmp304;
	  fftw_real tmp144;
	  fftw_real tmp145;
	  fftw_real tmp146;
	  fftw_real tmp161;
	  fftw_real tmp64;
	  fftw_real tmp69;
	  fftw_real tmp70;
	  fftw_real tmp95;
	  fftw_real tmp75;
	  fftw_real tmp151;
	  fftw_real tmp143;
	  fftw_real tmp160;
	  fftw_real tmp59;
	  fftw_real tmp94;
	  fftw_real tmp79;
	  fftw_real tmp149;
	  fftw_real tmp303;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp3;
	       fftw_real tmp32;
	       fftw_real tmp88;
	       fftw_real tmp225;
	       fftw_real tmp6;
	       fftw_real tmp85;
	       fftw_real tmp35;
	       fftw_real tmp226;
	       fftw_real tmp10;
	       fftw_real tmp37;
	       fftw_real tmp40;
	       fftw_real tmp206;
	       fftw_real tmp13;
	       fftw_real tmp42;
	       fftw_real tmp45;
	       fftw_real tmp205;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp1;
		    fftw_real tmp2;
		    fftw_real tmp86;
		    fftw_real tmp87;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp1 = X[0];
		    tmp2 = X[15 * iostride];
		    tmp3 = tmp1 + tmp2;
		    tmp32 = tmp1 - tmp2;
		    tmp86 = Y[0];
		    tmp87 = Y[-15 * iostride];
		    tmp88 = tmp86 + tmp87;
		    tmp225 = tmp87 - tmp86;
	       }
	       {
		    fftw_real tmp4;
		    fftw_real tmp5;
		    fftw_real tmp33;
		    fftw_real tmp34;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp4 = X[8 * iostride];
		    tmp5 = X[7 * iostride];
		    tmp6 = tmp4 + tmp5;
		    tmp85 = tmp5 - tmp4;
		    tmp33 = Y[-8 * iostride];
		    tmp34 = Y[-7 * iostride];
		    tmp35 = tmp33 + tmp34;
		    tmp226 = tmp34 - tmp33;
	       }
	       {
		    fftw_real tmp8;
		    fftw_real tmp9;
		    fftw_real tmp38;
		    fftw_real tmp39;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp8 = X[4 * iostride];
		    tmp9 = X[11 * iostride];
		    tmp10 = tmp8 + tmp9;
		    tmp37 = tmp8 - tmp9;
		    tmp38 = Y[-4 * iostride];
		    tmp39 = Y[-11 * iostride];
		    tmp40 = tmp38 + tmp39;
		    tmp206 = tmp38 - tmp39;
	       }
	       {
		    fftw_real tmp11;
		    fftw_real tmp12;
		    fftw_real tmp43;
		    fftw_real tmp44;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp11 = X[3 * iostride];
		    tmp12 = X[12 * iostride];
		    tmp13 = tmp11 + tmp12;
		    tmp42 = tmp11 - tmp12;
		    tmp43 = Y[-3 * iostride];
		    tmp44 = Y[-12 * iostride];
		    tmp45 = tmp43 + tmp44;
		    tmp205 = tmp44 - tmp43;
	       }
	       {
		    fftw_real tmp7;
		    fftw_real tmp14;
		    fftw_real tmp204;
		    fftw_real tmp207;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp36 = tmp32 - tmp35;
		    tmp138 = tmp32 + tmp35;
		    tmp7 = tmp3 + tmp6;
		    tmp14 = tmp10 + tmp13;
		    tmp15 = tmp7 + tmp14;
		    tmp276 = tmp7 - tmp14;
		    {
			 fftw_real tmp224;
			 fftw_real tmp227;
			 fftw_real tmp283;
			 fftw_real tmp284;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp224 = tmp13 - tmp10;
			 tmp227 = tmp225 - tmp226;
			 tmp228 = tmp224 + tmp227;
			 tmp256 = tmp227 - tmp224;
			 tmp283 = tmp206 + tmp205;
			 tmp284 = tmp226 + tmp225;
			 tmp285 = tmp283 + tmp284;
			 tmp305 = tmp284 - tmp283;
		    }
		    tmp89 = tmp85 - tmp88;
		    tmp155 = tmp85 + tmp88;
		    tmp204 = tmp3 - tmp6;
		    tmp207 = tmp205 - tmp206;
		    tmp208 = tmp204 + tmp207;
		    tmp250 = tmp204 - tmp207;
		    {
			 fftw_real tmp41;
			 fftw_real tmp46;
			 fftw_real tmp82;
			 fftw_real tmp83;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp41 = tmp37 - tmp40;
			 tmp46 = tmp42 - tmp45;
			 tmp47 = K707106781 * (tmp41 + tmp46);
			 tmp154 = K707106781 * (tmp46 - tmp41);
			 tmp82 = tmp42 + tmp45;
			 tmp83 = tmp37 + tmp40;
			 tmp84 = K707106781 * (tmp82 - tmp83);
			 tmp139 = K707106781 * (tmp83 + tmp82);
		    }
	       }
	  }
	  {
	       fftw_real tmp18;
	       fftw_real tmp49;
	       fftw_real tmp57;
	       fftw_real tmp210;
	       fftw_real tmp21;
	       fftw_real tmp54;
	       fftw_real tmp52;
	       fftw_real tmp211;
	       fftw_real tmp25;
	       fftw_real tmp60;
	       fftw_real tmp68;
	       fftw_real tmp215;
	       fftw_real tmp28;
	       fftw_real tmp65;
	       fftw_real tmp63;
	       fftw_real tmp216;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp16;
		    fftw_real tmp17;
		    fftw_real tmp55;
		    fftw_real tmp56;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp16 = X[2 * iostride];
		    tmp17 = X[13 * iostride];
		    tmp18 = tmp16 + tmp17;
		    tmp49 = tmp16 - tmp17;
		    tmp55 = Y[-2 * iostride];
		    tmp56 = Y[-13 * iostride];
		    tmp57 = tmp55 + tmp56;
		    tmp210 = tmp55 - tmp56;
	       }
	       {
		    fftw_real tmp19;
		    fftw_real tmp20;
		    fftw_real tmp50;
		    fftw_real tmp51;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp19 = X[10 * iostride];
		    tmp20 = X[5 * iostride];
		    tmp21 = tmp19 + tmp20;
		    tmp54 = tmp19 - tmp20;
		    tmp50 = Y[-10 * iostride];
		    tmp51 = Y[-5 * iostride];
		    tmp52 = tmp50 + tmp51;
		    tmp211 = tmp50 - tmp51;
	       }
	       {
		    fftw_real tmp23;
		    fftw_real tmp24;
		    fftw_real tmp66;
		    fftw_real tmp67;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp23 = X[iostride];
		    tmp24 = X[14 * iostride];
		    tmp25 = tmp23 + tmp24;
		    tmp60 = tmp23 - tmp24;
		    tmp66 = Y[-iostride];
		    tmp67 = Y[-14 * iostride];
		    tmp68 = tmp66 + tmp67;
		    tmp215 = tmp67 - tmp66;
	       }
	       {
		    fftw_real tmp26;
		    fftw_real tmp27;
		    fftw_real tmp61;
		    fftw_real tmp62;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp26 = X[6 * iostride];
		    tmp27 = X[9 * iostride];
		    tmp28 = tmp26 + tmp27;
		    tmp65 = tmp26 - tmp27;
		    tmp61 = Y[-6 * iostride];
		    tmp62 = Y[-9 * iostride];
		    tmp63 = tmp61 + tmp62;
		    tmp216 = tmp61 - tmp62;
	       }
	       {
		    fftw_real tmp22;
		    fftw_real tmp29;
		    fftw_real tmp277;
		    fftw_real tmp278;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp22 = tmp18 + tmp21;
		    tmp29 = tmp25 + tmp28;
		    tmp30 = tmp22 + tmp29;
		    tmp281 = tmp29 - tmp22;
		    {
			 fftw_real tmp209;
			 fftw_real tmp217;
			 fftw_real tmp212;
			 fftw_real tmp214;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp209 = tmp18 - tmp21;
			 tmp217 = tmp215 - tmp216;
			 tmp212 = tmp210 - tmp211;
			 tmp214 = tmp25 - tmp28;
			 tmp213 = tmp209 - tmp212;
			 tmp232 = tmp209 + tmp212;
			 tmp221 = tmp214 - tmp212;
			 tmp253 = tmp214 + tmp212;
			 tmp218 = tmp214 + tmp217;
			 tmp233 = tmp217 - tmp214;
			 tmp222 = tmp209 + tmp217;
			 tmp254 = tmp209 - tmp217;
		    }
		    tmp277 = tmp216 + tmp215;
		    tmp278 = tmp211 + tmp210;
		    tmp279 = tmp277 - tmp278;
		    tmp304 = tmp278 + tmp277;
		    tmp144 = tmp60 + tmp63;
		    tmp145 = tmp65 + tmp68;
		    tmp146 = (K382683432 * tmp144) - (K923879532 * tmp145);
		    tmp161 = (K923879532 * tmp144) + (K382683432 * tmp145);
	       }
	       {
		    fftw_real tmp73;
		    fftw_real tmp74;
		    fftw_real tmp141;
		    fftw_real tmp142;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp64 = tmp60 - tmp63;
		    tmp69 = tmp65 - tmp68;
		    tmp70 = (K923879532 * tmp64) + (K382683432 * tmp69);
		    tmp95 = (K923879532 * tmp69) - (K382683432 * tmp64);
		    tmp73 = tmp49 - tmp57;
		    tmp74 = tmp54 + tmp52;
		    tmp75 = K707106781 * (tmp73 - tmp74);
		    tmp151 = K707106781 * (tmp74 + tmp73);
		    tmp141 = tmp49 + tmp52;
		    tmp142 = tmp57 - tmp54;
		    tmp143 = (K382683432 * tmp141) - (K923879532 * tmp142);
		    tmp160 = (K923879532 * tmp141) + (K382683432 * tmp142);
		    {
			 fftw_real tmp53;
			 fftw_real tmp58;
			 fftw_real tmp77;
			 fftw_real tmp78;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp53 = tmp49 - tmp52;
			 tmp58 = tmp54 + tmp57;
			 tmp59 = (K923879532 * tmp53) - (K382683432 * tmp58);
			 tmp94 = (K382683432 * tmp53) + (K923879532 * tmp58);
			 tmp77 = tmp52 - tmp54;
			 tmp78 = tmp49 + tmp57;
			 tmp79 = K707106781 * (tmp77 - tmp78);
			 tmp149 = K707106781 * (tmp77 + tmp78);
		    }
	       }
	  }
	  X[0] = K2_000000000 * (tmp15 + tmp30);
	  {
	       fftw_real tmp309;
	       fftw_real tmp312;
	       fftw_real tmp307;
	       fftw_real tmp308;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp307 = tmp15 - tmp30;
	       tmp308 = tmp304 + tmp305;
	       tmp309 = tmp307 - tmp308;
	       tmp312 = tmp307 + tmp308;
	       {
		    fftw_real tmp306;
		    fftw_real tmp310;
		    fftw_real tmp311;
		    fftw_real tmp313;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp306 = c_re(W[23]);
		    tmp310 = c_im(W[23]);
		    X[24 * iostride] = (tmp306 * tmp309) + (tmp310 * tmp309);
		    tmp311 = c_re(W[7]);
		    tmp313 = c_im(W[7]);
		    X[8 * iostride] = (tmp311 * tmp312) - (tmp313 * tmp312);
	       }
	  }
	  tmp303 = c_im(W[15]);
	  X[16 * iostride] = tmp303 * (K2_000000000 * (tmp304 - tmp305));
	  {
	       fftw_real tmp280;
	       fftw_real tmp299;
	       fftw_real tmp287;
	       fftw_real tmp297;
	       fftw_real tmp289;
	       fftw_real tmp296;
	       fftw_real tmp292;
	       fftw_real tmp300;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp282;
		    fftw_real tmp286;
		    fftw_real tmp290;
		    fftw_real tmp291;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp280 = tmp276 + tmp279;
		    tmp299 = tmp276 - tmp279;
		    tmp282 = tmp281 + tmp279;
		    tmp286 = tmp276 + tmp285;
		    tmp287 = K707106781 * (tmp282 + tmp286);
		    tmp297 = K707106781 * (tmp282 - tmp286);
		    tmp289 = tmp281 + tmp285;
		    tmp296 = tmp281 - tmp285;
		    tmp290 = tmp281 - tmp279;
		    tmp291 = tmp285 - tmp276;
		    tmp292 = K707106781 * (tmp290 + tmp291);
		    tmp300 = K707106781 * (tmp291 - tmp290);
	       }
	       {
		    fftw_real tmp275;
		    fftw_real tmp288;
		    fftw_real tmp293;
		    fftw_real tmp294;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp275 = c_re(W[19]);
		    tmp288 = c_im(W[19]);
		    X[20 * iostride] = (tmp275 * (tmp280 - tmp287)) - (tmp288 * (tmp289 + tmp292));
		    tmp293 = c_re(W[3]);
		    tmp294 = c_im(W[3]);
		    X[4 * iostride] = (tmp293 * (tmp280 + tmp287)) + (tmp294 * (tmp292 - tmp289));
	       }
	       {
		    fftw_real tmp295;
		    fftw_real tmp298;
		    fftw_real tmp301;
		    fftw_real tmp302;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp295 = c_im(W[27]);
		    tmp298 = c_re(W[27]);
		    X[28 * iostride] = (tmp295 * (tmp296 - tmp297)) + (tmp298 * (tmp299 - tmp300));
		    tmp301 = c_im(W[11]);
		    tmp302 = c_re(W[11]);
		    X[12 * iostride] = (tmp301 * (tmp296 + tmp297)) + (tmp302 * (tmp299 + tmp300));
	       }
	  }
	  {
	       fftw_real tmp81;
	       fftw_real tmp98;
	       fftw_real tmp72;
	       fftw_real tmp104;
	       fftw_real tmp91;
	       fftw_real tmp99;
	       fftw_real tmp107;
	       fftw_real tmp97;
	       fftw_real tmp76;
	       fftw_real tmp80;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp76 = tmp75 + tmp64;
	       tmp80 = tmp79 - tmp69;
	       tmp81 = (K980785280 * tmp76) - (K195090322 * tmp80);
	       tmp98 = (K195090322 * tmp76) + (K980785280 * tmp80);
	       {
		    fftw_real tmp48;
		    fftw_real tmp96;
		    fftw_real tmp71;
		    fftw_real tmp90;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp48 = tmp36 + tmp47;
		    tmp96 = tmp94 + tmp95;
		    tmp71 = tmp59 + tmp70;
		    tmp90 = tmp84 + tmp89;
		    tmp72 = tmp48 + tmp71;
		    tmp104 = tmp48 - tmp71;
		    tmp91 = (K980785280 * tmp48) + (K195090322 * tmp90);
		    tmp99 = (K980785280 * tmp90) - (K195090322 * tmp48);
		    tmp107 = tmp96 + tmp90;
		    tmp97 = tmp96 - tmp90;
	       }
	       {
		    fftw_real tmp92;
		    fftw_real tmp100;
		    fftw_real tmp105;
		    fftw_real tmp108;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp92 = tmp81 + tmp91;
		    tmp100 = tmp98 + tmp99;
		    {
			 fftw_real tmp31;
			 fftw_real tmp93;
			 fftw_real tmp101;
			 fftw_real tmp102;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp31 = c_re(W[16]);
			 tmp93 = c_im(W[16]);
			 X[17 * iostride] = (tmp31 * (tmp72 - tmp92)) + (tmp93 * (tmp97 - tmp100));
			 tmp101 = c_re(W[0]);
			 tmp102 = c_im(W[0]);
			 X[iostride] = (tmp101 * (tmp72 + tmp92)) + (tmp102 * (tmp97 + tmp100));
		    }
		    tmp105 = tmp99 - tmp98;
		    tmp108 = tmp81 - tmp91;
		    {
			 fftw_real tmp103;
			 fftw_real tmp106;
			 fftw_real tmp109;
			 fftw_real tmp110;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp103 = c_re(W[24]);
			 tmp106 = c_im(W[24]);
			 X[25 * iostride] = (tmp103 * (tmp104 - tmp105)) - (tmp106 * (tmp107 + tmp108));
			 tmp109 = c_im(W[8]);
			 tmp110 = c_re(W[8]);
			 X[9 * iostride] = (tmp109 * (tmp108 - tmp107)) + (tmp110 * (tmp104 + tmp105));
		    }
	       }
	  }
	  {
	       fftw_real tmp220;
	       fftw_real tmp242;
	       fftw_real tmp238;
	       fftw_real tmp243;
	       fftw_real tmp235;
	       fftw_real tmp245;
	       fftw_real tmp230;
	       fftw_real tmp246;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp219;
		    fftw_real tmp236;
		    fftw_real tmp237;
		    fftw_real tmp234;
		    fftw_real tmp223;
		    fftw_real tmp229;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp219 = K707106781 * (tmp213 + tmp218);
		    tmp220 = tmp208 + tmp219;
		    tmp242 = tmp208 - tmp219;
		    tmp236 = (K382683432 * tmp221) - (K923879532 * tmp222);
		    tmp237 = (K923879532 * tmp228) - (K382683432 * tmp208);
		    tmp238 = tmp236 + tmp237;
		    tmp243 = tmp237 - tmp236;
		    tmp234 = K707106781 * (tmp232 + tmp233);
		    tmp235 = tmp234 - tmp228;
		    tmp245 = tmp234 + tmp228;
		    tmp223 = (K923879532 * tmp221) + (K382683432 * tmp222);
		    tmp229 = (K923879532 * tmp208) + (K382683432 * tmp228);
		    tmp230 = tmp223 + tmp229;
		    tmp246 = tmp223 - tmp229;
	       }
	       {
		    fftw_real tmp203;
		    fftw_real tmp231;
		    fftw_real tmp239;
		    fftw_real tmp240;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp203 = c_re(W[17]);
		    tmp231 = c_im(W[17]);
		    X[18 * iostride] = (tmp203 * (tmp220 - tmp230)) + (tmp231 * (tmp235 - tmp238));
		    tmp239 = c_re(W[1]);
		    tmp240 = c_im(W[1]);
		    X[2 * iostride] = (tmp239 * (tmp220 + tmp230)) + (tmp240 * (tmp235 + tmp238));
	       }
	       {
		    fftw_real tmp241;
		    fftw_real tmp244;
		    fftw_real tmp247;
		    fftw_real tmp248;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp241 = c_re(W[25]);
		    tmp244 = c_im(W[25]);
		    X[26 * iostride] = (tmp241 * (tmp242 - tmp243)) - (tmp244 * (tmp245 + tmp246));
		    tmp247 = c_im(W[9]);
		    tmp248 = c_re(W[9]);
		    X[10 * iostride] = (tmp247 * (tmp246 - tmp245)) + (tmp248 * (tmp242 + tmp243));
	       }
	  }
	  {
	       fftw_real tmp252;
	       fftw_real tmp268;
	       fftw_real tmp264;
	       fftw_real tmp269;
	       fftw_real tmp261;
	       fftw_real tmp271;
	       fftw_real tmp258;
	       fftw_real tmp272;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp251;
		    fftw_real tmp262;
		    fftw_real tmp263;
		    fftw_real tmp260;
		    fftw_real tmp255;
		    fftw_real tmp257;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp251 = K707106781 * (tmp233 - tmp232);
		    tmp252 = tmp250 + tmp251;
		    tmp268 = tmp250 - tmp251;
		    tmp262 = (K923879532 * tmp253) + (K382683432 * tmp254);
		    tmp263 = (K382683432 * tmp256) - (K923879532 * tmp250);
		    tmp264 = tmp262 + tmp263;
		    tmp269 = tmp263 - tmp262;
		    tmp260 = K707106781 * (tmp213 - tmp218);
		    tmp261 = tmp260 - tmp256;
		    tmp271 = tmp260 + tmp256;
		    tmp255 = (K382683432 * tmp253) - (K923879532 * tmp254);
		    tmp257 = (K382683432 * tmp250) + (K923879532 * tmp256);
		    tmp258 = tmp255 + tmp257;
		    tmp272 = tmp255 - tmp257;
	       }
	       {
		    fftw_real tmp249;
		    fftw_real tmp259;
		    fftw_real tmp265;
		    fftw_real tmp266;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp249 = c_re(W[21]);
		    tmp259 = c_im(W[21]);
		    X[22 * iostride] = (tmp249 * (tmp252 - tmp258)) + (tmp259 * (tmp261 - tmp264));
		    tmp265 = c_re(W[5]);
		    tmp266 = c_im(W[5]);
		    X[6 * iostride] = (tmp265 * (tmp252 + tmp258)) + (tmp266 * (tmp261 + tmp264));
	       }
	       {
		    fftw_real tmp267;
		    fftw_real tmp270;
		    fftw_real tmp273;
		    fftw_real tmp274;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp267 = c_re(W[29]);
		    tmp270 = c_im(W[29]);
		    X[30 * iostride] = (tmp267 * (tmp268 - tmp269)) - (tmp270 * (tmp271 + tmp272));
		    tmp273 = c_im(W[13]);
		    tmp274 = c_re(W[13]);
		    X[14 * iostride] = (tmp273 * (tmp272 - tmp271)) + (tmp274 * (tmp268 + tmp269));
	       }
	  }
	  {
	       fftw_real tmp117;
	       fftw_real tmp124;
	       fftw_real tmp114;
	       fftw_real tmp130;
	       fftw_real tmp119;
	       fftw_real tmp125;
	       fftw_real tmp133;
	       fftw_real tmp123;
	       fftw_real tmp115;
	       fftw_real tmp116;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp115 = tmp64 - tmp75;
	       tmp116 = tmp79 + tmp69;
	       tmp117 = (K555570233 * tmp115) + (K831469612 * tmp116);
	       tmp124 = (K831469612 * tmp115) - (K555570233 * tmp116);
	       {
		    fftw_real tmp112;
		    fftw_real tmp122;
		    fftw_real tmp113;
		    fftw_real tmp118;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp112 = tmp36 - tmp47;
		    tmp122 = tmp59 - tmp70;
		    tmp113 = tmp95 - tmp94;
		    tmp118 = tmp89 - tmp84;
		    tmp114 = tmp112 + tmp113;
		    tmp130 = tmp112 - tmp113;
		    tmp119 = (K555570233 * tmp112) + (K831469612 * tmp118);
		    tmp125 = (K555570233 * tmp118) - (K831469612 * tmp112);
		    tmp133 = tmp122 + tmp118;
		    tmp123 = tmp122 - tmp118;
	       }
	       {
		    fftw_real tmp120;
		    fftw_real tmp126;
		    fftw_real tmp131;
		    fftw_real tmp134;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp120 = tmp117 + tmp119;
		    tmp126 = tmp124 + tmp125;
		    {
			 fftw_real tmp111;
			 fftw_real tmp121;
			 fftw_real tmp127;
			 fftw_real tmp128;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp111 = c_re(W[20]);
			 tmp121 = c_im(W[20]);
			 X[21 * iostride] = (tmp111 * (tmp114 - tmp120)) + (tmp121 * (tmp123 - tmp126));
			 tmp127 = c_re(W[4]);
			 tmp128 = c_im(W[4]);
			 X[5 * iostride] = (tmp127 * (tmp114 + tmp120)) + (tmp128 * (tmp123 + tmp126));
		    }
		    tmp131 = tmp125 - tmp124;
		    tmp134 = tmp117 - tmp119;
		    {
			 fftw_real tmp129;
			 fftw_real tmp132;
			 fftw_real tmp135;
			 fftw_real tmp136;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp129 = c_re(W[28]);
			 tmp132 = c_im(W[28]);
			 X[29 * iostride] = (tmp129 * (tmp130 - tmp131)) - (tmp132 * (tmp133 + tmp134));
			 tmp135 = c_im(W[12]);
			 tmp136 = c_re(W[12]);
			 X[13 * iostride] = (tmp135 * (tmp134 - tmp133)) + (tmp136 * (tmp130 + tmp131));
		    }
	       }
	  }
	  {
	       fftw_real tmp153;
	       fftw_real tmp164;
	       fftw_real tmp148;
	       fftw_real tmp170;
	       fftw_real tmp157;
	       fftw_real tmp165;
	       fftw_real tmp173;
	       fftw_real tmp163;
	       fftw_real tmp150;
	       fftw_real tmp152;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp150 = tmp144 - tmp149;
	       tmp152 = tmp145 - tmp151;
	       tmp153 = (K831469612 * tmp150) - (K555570233 * tmp152);
	       tmp164 = (K555570233 * tmp150) + (K831469612 * tmp152);
	       {
		    fftw_real tmp140;
		    fftw_real tmp162;
		    fftw_real tmp147;
		    fftw_real tmp156;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp140 = tmp138 - tmp139;
		    tmp162 = tmp160 - tmp161;
		    tmp147 = tmp143 + tmp146;
		    tmp156 = tmp154 - tmp155;
		    tmp148 = tmp140 + tmp147;
		    tmp170 = tmp140 - tmp147;
		    tmp157 = (K831469612 * tmp140) + (K555570233 * tmp156);
		    tmp165 = (K831469612 * tmp156) - (K555570233 * tmp140);
		    tmp173 = tmp162 + tmp156;
		    tmp163 = tmp162 - tmp156;
	       }
	       {
		    fftw_real tmp158;
		    fftw_real tmp166;
		    fftw_real tmp171;
		    fftw_real tmp174;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp158 = tmp153 + tmp157;
		    tmp166 = tmp164 + tmp165;
		    {
			 fftw_real tmp137;
			 fftw_real tmp159;
			 fftw_real tmp167;
			 fftw_real tmp168;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp137 = c_re(W[18]);
			 tmp159 = c_im(W[18]);
			 X[19 * iostride] = (tmp137 * (tmp148 - tmp158)) + (tmp159 * (tmp163 - tmp166));
			 tmp167 = c_re(W[2]);
			 tmp168 = c_im(W[2]);
			 X[3 * iostride] = (tmp167 * (tmp148 + tmp158)) + (tmp168 * (tmp163 + tmp166));
		    }
		    tmp171 = tmp165 - tmp164;
		    tmp174 = tmp153 - tmp157;
		    {
			 fftw_real tmp169;
			 fftw_real tmp172;
			 fftw_real tmp175;
			 fftw_real tmp176;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp169 = c_re(W[26]);
			 tmp172 = c_im(W[26]);
			 X[27 * iostride] = (tmp169 * (tmp170 - tmp171)) - (tmp172 * (tmp173 + tmp174));
			 tmp175 = c_im(W[10]);
			 tmp176 = c_re(W[10]);
			 X[11 * iostride] = (tmp175 * (tmp174 - tmp173)) + (tmp176 * (tmp170 + tmp171));
		    }
	       }
	  }
	  {
	       fftw_real tmp183;
	       fftw_real tmp190;
	       fftw_real tmp180;
	       fftw_real tmp196;
	       fftw_real tmp185;
	       fftw_real tmp191;
	       fftw_real tmp200;
	       fftw_real tmp189;
	       fftw_real tmp181;
	       fftw_real tmp182;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp181 = tmp149 + tmp144;
	       tmp182 = tmp151 + tmp145;
	       tmp183 = (K195090322 * tmp181) - (K980785280 * tmp182);
	       tmp190 = (K980785280 * tmp181) + (K195090322 * tmp182);
	       {
		    fftw_real tmp178;
		    fftw_real tmp188;
		    fftw_real tmp179;
		    fftw_real tmp184;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp178 = tmp138 + tmp139;
		    tmp188 = tmp143 - tmp146;
		    tmp179 = tmp160 + tmp161;
		    tmp184 = tmp154 + tmp155;
		    tmp180 = tmp178 - tmp179;
		    tmp196 = tmp178 + tmp179;
		    tmp185 = (K195090322 * tmp178) - (K980785280 * tmp184);
		    tmp191 = (K980785280 * tmp178) + (K195090322 * tmp184);
		    tmp200 = tmp184 - tmp188;
		    tmp189 = tmp188 + tmp184;
	       }
	       {
		    fftw_real tmp186;
		    fftw_real tmp192;
		    fftw_real tmp197;
		    fftw_real tmp199;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp186 = tmp183 + tmp185;
		    tmp192 = tmp190 - tmp191;
		    {
			 fftw_real tmp177;
			 fftw_real tmp187;
			 fftw_real tmp193;
			 fftw_real tmp194;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp177 = c_re(W[22]);
			 tmp187 = c_im(W[22]);
			 X[23 * iostride] = (tmp177 * (tmp180 - tmp186)) + (tmp187 * (tmp189 - tmp192));
			 tmp193 = c_re(W[6]);
			 tmp194 = c_im(W[6]);
			 X[7 * iostride] = (tmp193 * (tmp180 + tmp186)) + (tmp194 * (tmp189 + tmp192));
		    }
		    tmp197 = tmp190 + tmp191;
		    tmp199 = tmp183 - tmp185;
		    {
			 fftw_real tmp195;
			 fftw_real tmp198;
			 fftw_real tmp201;
			 fftw_real tmp202;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp195 = c_re(W[14]);
			 tmp198 = c_im(W[14]);
			 X[15 * iostride] = (tmp195 * (tmp196 - tmp197)) + (tmp198 * (tmp199 + tmp200));
			 tmp201 = c_re(W[30]);
			 tmp202 = c_im(W[30]);
			 X[31 * iostride] = (tmp201 * (tmp196 + tmp197)) + (tmp202 * (tmp200 - tmp199));
		    }
	       }
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
fftw_codelet_desc fftw_hc2hc_backward_32_desc =
{
     "fftw_hc2hc_backward_32",
     (void (*)()) fftw_hc2hc_backward_32,
     32,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     523,
     31,
     twiddle_order,
};
