/* cp_head.h  include file of declarations for the program CirclePack */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <pwd.h>
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/cms.h>
#include <xview/xv_xrect.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/cursor.h>
#include <xview/tty.h>
#include "complex_math.h"
#include "hyp_math.h"
#include "eucl_math.h"
#include "sph_math.h"
#include "cp_util.h"
#include <sys/dirent.h>

#define float double
#define NUM_PACKS 3		/* number of packs and canvases allowed */
#define NUM_PROC 6		/* max number of remote processes */
#define MAX_PETALS 1000		/* max number of petals in a flower */
#define MAX_COMPONENTS 20	/* number of allowed boundary components */
#define CANV_SIZE 450		/* initial size of canvase 0 */
#define MAX_PIXEL 800 		/* max canvas size */
#define MSG_LENGTH 4000		/* length of message window backup */
#define BG_COLOR 0		/* background color code */
#define FG_COLOR 41		/* foreground color code */
#define NAME_MAX 255		/* max length of filenames */
#define SHOW 1
#define NOSHOW 0		/* display flags */
#define BUFSIZE 1024		/* need some big buffers */

/*======================= type definitions =========================*/

typedef struct
 {
	int vert[3];		/* ordered triple of vertices */
	int index_flag;		/* which to draw first, 0,1, or 2 */
	int next_face;		/* next face in drawing order. */
	int rwb_flag;		/* red/white/blue faces:0=white,1=red,2=blue
				   see info file for description */
	int next_red;		/* next red face */
	int plot_flag;		/* useful flag */
	int color;		/* color index */
	int mark;		/* mark */
  } f_data;

struct Vertlist
 {
	int v;			/* vertex number */
	struct Vertlist *next;
 };

struct Edgelist
 {
	int v,w;		/* vertex numbers of edge ends */
	struct Edgelist *next;
 };

struct Pathlist
 {
	float x,y;		/* coords of point */
	struct Pathlist *next;
 };

struct remote_control
{
	int 	op_code;	/* situation op_code */
		/* Options:
		 (bitwise)	0 = communications not yet set.
				1 = remote process up and waiting.
		 */
	int	locks;		/* locks on packs; bitwise, 1=locked */
	int 	pid;		/* process id; 0 if not running */
	int 	pipeto[2];	/* pipe to child; [1] open. */
	int	pipefr[2];	/* pipe from child: [0] open */
	FILE	*fp_to_remote;		/* file pointer */
	FILE	*fp_from_remote;	/* file pointer */
	Notify_client	notify_client;	/* handle to remote routine */
	char	program[32];	/* name of remote program */ 
	char 	moniker[32];	/* name for user to use in communications */
} remote[NUM_PROC];

/*==================== structure for circle data ====================*/

struct K_data
 {
	int num;                /* number of faces this node is in.*/
				/* 'flower' has entries from 0 to num */
	int bdry_flag; 		/* true for boundary nodes */
	int plot_flag;		/* true if node has been plotted - used
				   when circles are being plotted */
	int *flower;		/* ptr to list of nodes in flower;
				   in positive orientation, last = first if
				   flower is closed */
	float *overlaps;	/* cosine of overlap angle or inv dist */
	int color;		/* gives color value, 0=background */
	int mark;		/* mark */
 };

struct R_data
 {
	complex center;		/* center as complex number */
	float rad;		/* radius of circle for this node. 
				   hyperbolic case: called 's_radius' for 
				   special. exp(-r) is stored for
				   finite radii; for infinite hyp radius,
				   we store the negative of the eucl radius
				   (can then use eucl data for plotting). */
	float curv;		/* angle sum at this vertex. */
	float aim;		/* desired curvature at this vertex */
 };


/* ==================== structure for screen data ====================*/

struct s_data
 {
	Pix_box pix_box;	/* describes pixel box for screen */
	Box box;		/* real world box for screen */
	float factor;		/* display factor from param window */
	float disp_trans[3][3],disp_inv_trans[3][3];
				/* 3x3 transforms real x,y,z to those
				   for display (and inverse) */
	int display_opt;	/* display option of pack on this screen:
				   0=filled circles,  1=open circles,  
				   2=tile by drawingorder, 3=clear, 
				   4=open complex, 5= label nodes, 
				   6=label triangles, 7=filled complex*/
	int unitcircle;		/* 0=don't diplay */
	int ms_flag;		/* flags for sensitized mice in canvas.
				   0=unsensitized, 1=rubberband circ,
				   2=add circ, 3=del circ, 4=enfold,
				   5=crosshairs,6=incr rad,7=decr rad */
	int coord_flag;		/* 1=show coord axes */
	Pixmap xpm;		/* pointer to Pixmap */
	XID xid;		/* canvas xid */
 } screendata[NUM_PACKS];

/* ==================== structure for pack data ====================*/

struct p_data
 {
	int status;		/* 0 if pack empty, 1 otherwise */
	char fhead[64];		/* pack header <= 40 char*/
	char file_name[NAME_MAX]; /* filename when file was written */
	int hes;		/* curvature of geometry,-1=hyp,0=eucl,1=sph */
	struct K_data *packK_ptr;	/* pointer to corres complex data */
	struct R_data *packR_ptr;	/* pointer to corres rad data */
	int sizelimit;		/* max number of node space allocated */
	int nodecount;		/* number of nodes */
	int facecount;		/* number of faces = 1+edges-nodes */
	int intnode;		/* number of interior nodes */
	int num_bdry_comp;	/* number of bdry components */
	int num_int_comp;	/* number of components of interior verts */
	int bdry_starts[MAX_COMPONENTS+1];	
				/* indices for nodes marking bdry components */
	int int_starts[MAX_COMPONENTS+1];	
				/* indices of nodes marking int components */
	int first_face;		/* index of first face to plot */
	int first_red_face;	/* index of "red" chain of faces */
	int beta;		/* index of beta node (on boundary) */
	int alpha;		/* index of alpha node (origin) */
	int gamma;		/* index of node to be plotted on y>0 axis */
	int euler;		/* Euler characteristic */
	int genus;		/* genus of complex. Euler+#bdry=2-2g */
	int active_node;	/* currently active_node */
	int locks;		/* locks placed by remote processes;
					bitwise flags */
	int overlap_status;	/* true if some non-trivial overlaps set */
	f_data *faces;		/* pointer to face data */
	struct s_data *screen;	/* pointer to screen for display */
 } *packdata;

/* ======================= XLib graphics variables ============ */

	GC gc,gc_fill;  /* graphics contexts */
	unsigned long *colors,*color; /* color table and ptr to my colors. */
	unsigned long fgcolor,bgcolor; /* indices of fore/backgound colors */
	Xv_singlecolor cms_colors[50];
	Display *display;
	XFontStruct *font;
	Cms cms;
	XGCValues gc_val;
	Xv_cmsdata cms_data;
	char stipple_bits[4];
	Pixmap sph_pic;			/* Pixmap for sphere bkground */

/* ================== graphics and XView variables ========== */

	Frame base_frame, parameter_frame, cmd_frame, script_frame,
		help_frame,history_frame,setup_frame,text_frame,msg_frame;
	Frame canvas_frame[NUM_PACKS],screen_frame[NUM_PACKS],
		manip_frame[NUM_PACKS];
	Panel panel;		/* main control panel */
	Canvas canvas[NUM_PACKS];  /* window ptr for the graphics window */
	Textsw scratch_sw,log_sw,help_sw,msg_sw,script_sw;
	Textsw_mark script_file_data_mark,script_file_cmd_mark,
		script_file_path_mark;
	Panel_item cmd_item,active_pack_item,radius_inc,Eucl_factor,
		fill_pattern,close_setup_item,print_com_item,
		remote_name_item,dir_name_item,	ps_file_item,print_file_item,
		script_name_item,cmd_button_item,
		tog[NUM_PACKS],sopt[NUM_PACKS],clsup[NUM_PACKS],
		sfac[NUM_PACKS],rset[NUM_PACKS],ssize[NUM_PACKS],
		scent[NUM_PACKS],sdp[NUM_PACKS],clcd[NUM_PACKS],
		pmsg_item[NUM_PACKS],manip_item[NUM_PACKS];
	Cursor act_can_cursor, inact_can_cursor, delete_cursor, 
		axes_cursor, add_cursor, size_cursor,enfold_cursor,
		incr_cursor,decr_cursor,path_cursor,proj_cursor,lock_cursor;
					/* Various cursors for canvases */
	unsigned char red[43],green[43],blue[43];

/* ================== global variables ======================== */
	
	int line_cmds_only;	/* 1 means no graphics; 0 is default. */
	float inc_factor,eucl_factor,degPI;
	int current_p;		/* index to current screen and pack */
	int live_node[NUM_PACKS];
	int live_face[NUM_PACKS];
				/* index of last circle/face plotted
				   in canvas 'project' mode */
	int iterates;		/* number of iterations in Newton's
				   method computations */
	int line_thick;		/* thickness setting for lines */
	int totalpasses;	/* number of passes in riffle */
	float toler;	/* numerical tolerance for computing */
	float okerr;	/* quantity small enough to set to zero 
				   in calculating */
	char emsgbuf[BUFSIZE];	/* error message buffer */
	char *msgbuf;		/* message buffer */
	char buf[BUFSIZE];	/* general purpose utility buffer */
	char packlabels[NUM_PACKS][64]; /* pack panel button labels */
	char cmd_history[BUFSIZE]; /* stores last command for reuse */
	char path[NAME_MAX];	/* path name for packing directory */
	int current_canvas;	/* holds index of canvas being worked on
				   so it can be passed to procedures */
	int sc_print_size;	/* size (inches) for postscript output */
	int fill_mode;		/* mode for filled circles: 0=grey,1=white,
				   2=black */
	int draw_speed;		/* 0 = disp screen after all objects drawn */
	Box std_real_box;	/* default real world window */
	FILE *post_fp;		/* file for canvas postscript output */
	FILE *custom_fp;	/* file for "custom" postscript output */
	FILE *script_fp;	/* file for command scripts */
	int custom_status;	/* true if custom_fp is open and initialized */
	int pathlength;		/* number of pts in stored pathlist */
	struct Pathlist *pathlist,*newpath; 	
				/* specify "cookie cutting" paths. */
	char *next_script_cmd;	/* pts to next command from script file */
	float Aspect;		/* aspect ratio of screen */
	int ScrX,ScrY;		/* x,y of main panel */
	int editYN;		/* enable flag for editing script file */
	Mobius Mob;		/* currently specified Mobius transform */
	unsigned long int rand_next;
				/* random number generator variable */
	int cmd_search_depth;	/* prevent looping of cmd search */

	struct Edgelist *b_flip,*r_flip;
				/* ptrs to edges for Whitehead moves */
	char *home_dir;		/* store user home directory */
	char *working_dir;	/* store current working directory */
	int num_plot;		/* num plot points for arcs on sphere */
