/* $Id: wk1.hh,v 1.18 1997/02/10 15:09:59 aml Exp $*/

/* Cell format opcodes */

#include "xlf.hh"

#define PARSE_ERROR -1
#define PARSE_OK 0

#define CODE_BOF 0
#define CODE_EOF 1
#define CODE_RECALC 2

#define CODE_BLANK 12
#define CODE_INTEGER 13
#define CODE_NUMBER 14
#define CODE_LABEL  15
#define CODE_FORMULA 16
#define CODE_ERROR 17

#define CODE_NUMBER_SIZE 13

#define CODE_ORANGE         25
#define CODE_PRANGE         26
#define CODE_SRANGE         27
#define CODE_FRANGE         28
#define CODE_KRANGE1        29
#define CODE_HRANGE         32
#define CODE_KRANGE2        35


#define CODE_WINDOW1 7
#define CODE_COLW1 8

#define CODE_STRING_VAL 51




/*  Formula format opcodes */

#define FORM_FP_SIZE 8
#define FORM_REF_SIZE 4
#define FORM_RANGE_SIZE 8
#define FORM_RETURN_SIZE 0
#define FORM_PAR_SIZE 0
#define FORM_INT_SIZE 2
#define FORM_STRING_SIZE 0

#define FORM_VAR_ARG_CNT 256
#define FORM_FP 0
#define FORM_REF 1
#define FORM_RANGE 2
#define FORM_RETURN 3
#define FORM_PAR 4
#define FORM_INT 5
#define FORM_STRING 6
#define FORM_ERROR 7

#define FORM_UNMINUS 8
#define FORM_PLUS 9
#define FORM_SUB 10
#define FORM_MULT 11
#define FORM_DIV 12
#define FORM_POWER 13

#define FORM_EQUAL 14
#define FORM_NEQUAL 15
#define FORM_SMALLEREQ 16
#define FORM_GREATEREQ 17
#define FORM_SMALLER 18
#define FORM_GREATER 19
#define FORM_AND 20
#define FORM_OR 21
#define FORM_NOT 22
#define FORM_UNARY_MINUS 23

#define FORM_NA 31
#define FORM_ERR 32
#define FORM_ABS 33
#define FORM_INTF 34
#define FORM_SQRT 35
#define FORM_LOG 36
#define FORM_LN 37
#define FORM_PI 38
#define FORM_SIN 39
#define FORM_COS 40
#define FORM_TAN 41
#define FORM_ATAN2 42
#define FORM_ATAN 43
#define FORM_ASIN 44
#define FORM_ACOS 45
#define FORM_EXP 46
#define FORM_MOD 47
#define FORM_ISNA 49
#define FORM_ISERR 50
#define FORM_FALSE 51
#define FORM_TRUE 52
#define FORM_RAND 53
#define FORM_TODAY 54
#define FORM_DAY 60
#define FORM_MONTH 61
#define FORM_ROUND 63
#define FORM_HOUR 65
#define FORM_MINUTE 66
#define FORM_SECOND 67
#define FORM_ISNUMBER 68
#define FORM_ISSTRING 69
#define FORM_LENGTH 70
#define FORM_VALUE 71
#define FORM_STRINGF 72
#define FORM_CHAR 74
#define FORM_CODE 75
#define FORM_TIMEVALUE 78
#define FORM_CELLPOINTER 79

#define FORM_IF    59

#define FORM_SUM 80
#define FORM_AVG 81
#define FORM_COUNT 82
#define FORM_MIN 83
#define FORM_MAX 84
#define FORM_VLOOKUP 85
#define FORM_HLOOKUP 90

#define FORM_UPPER 102
#define FORM_LOWER 103
#define FORM_PROPER 107

/*
$Log: wk1.hh,v $
Revision 1.18  1997/02/10 15:09:59  aml
Print settings now are saved to file.
Fixed buggy error message when loading sheets.

Revision 1.17  1997/01/02 16:15:29  aml
Fixed unsufficient range of colunm width.
First cut of vlookup and hlookup functions.
Fixed bug in display routines.

Revision 1.16  1996/12/31 17:38:25  aml
On-demand calculation improved. Loops are detected.
Automatic recalculation can now be disabled.
Printing was improved.

Revision 1.15  1996/10/07 12:35:26  aml
First cut at error handling.
Date formats are in.
Fixed problem with blank cell drawing.

# Revision 1.14  1996/09/02  10:51:05  aml
# Cell fonts created, loaded and saved.
# Row height created.
#
# Revision 1.13  1996/08/28  17:17:12  aml
# Load and save now accept string_value for formula cells.
# This fixes previous thought problem of formula values not
# being stored.
# Functions upper,lower and proper created.
# Function if can now return labels.
# Fixed problem with function count.
# Reasonably stable version, very used to manipulate notas.wk1.
#
Revision 1.12  1996/08/27 17:18:46  aml
First version of regressive tests created.
Changes were made to allow for string functions.
String function upper created. Raises the problem
that formulas do NOT have a space for string values,
and therefore have to be evaluated upon loading.

Revision 1.11  1996/08/26 17:22:24  aml
Function round fixed.
Many other functions added, from power to mod.

Revision 1.10  1996/03/11 15:47:45  aml
Made redraw more efficient by removing at once all cells before redrawing.
Fixed problem with unsufficient difinition of logical expressions.
Added >=, <=, <>, @and and @or functions.

Revision 1.9  1996/03/08 19:00:19  aml
Fixed problem in string_single_arg macro
Created if function, boolean evaluations and so on.

Revision 1.8  1996/03/07 20:32:50  aml
Created print range ability.
Set in gray non-working menus.
Created RangeKill command.
Created round function and macros for single argument functions.

Revision 1.7  1996/01/11 22:48:43  aml
Range iterators created.
Functions sum, max and min now work properly.
Negative numbers now allowed by flex (oops :-)

# Revision 1.6  1996/01/07  09:07:27  aml
# Sheet::save and Sheet::load created.
# Program can now write and read wk1 files.
# Slight changes made to relative references. Bit 14 is now always 0.
#
# Revision 1.5  1996/01/05  23:05:56  aml
# Cell references evaluated.
# Spreadsheet is recalculated at every change, by an arbitrary order.
# Reformulated program structure. Evaluation and reverse parsing
# are member functions of Sheet.
#
# Revision 1.4  1996/01/04  20:27:16  aml
# Range references parsed and reverse parsed.
#
# Revision 1.3  1996/01/02  16:22:07  aml
# Formula compilation, evaluation and decompilation now work.
# Cells can be of type label, numerical formula or numbers.
#
# Revision 1.2  1995/12/30  16:40:26  aml
# First cut of formula compilation.
#
# Revision 1.1  1995/12/30  15:02:56  aml
# Initial revision
#
*/
