# $Id: find.tcl,v 1.1 1998/10/25 20:48:06 cthulhu Exp $
#
#  Search
#

proc Search {sheet} {

    #
    # Vars
    #

    global search

    set search(geometry) 300x175
    set search(casesens) 0
    set search(oldstring) [set search(string) ""]
    set search(nextstat) 0
    set search(whole) 1

    #
    # Initialize Search window
    #

    set w .search
    toplevel $w -class abacus

    wm iconname $w "Search"
    
    wm geometry $w $search(geometry)
  
    focus $w
 
    #
    # Search Frame
    #

    frame $w.search

    button $w.search.s -text "Search" -command {
	set tmp [Find $activeSheet $search(string) $search(formulas) \
		  $search(values) $search(casesens) $search(whole) 0];
        if {$tmp==""} {winstderr .search.message " $search(string) Not found!"
	} else { 
	    set activeCellCol [lfirst $tmp]; 
	    set activeCellRow [lindex $tmp 1]; 
	    winstdout .search.message \
		" Found at Cell [ColName $activeCellCol]:[expr $activeCellRow + 1]" blue ; 
	    highlightActiveCell ;
	    .search.search.next configure -state normal ;
	    .search.search.prev configure -state normal ;
	    .search.search.s configure -state disabled ;
	    set search(nextstat) 1;
	};
	
    }
    
    button $w.search.next -text "Next" -command {
	set tmp [Find $activeSheet $search(string) $search(formulas) \
		  $search(values) $search(casesens) $search(whole) 1];
        if {$tmp==""} {
	    winstderr .search.message "No more matches;try again to wrap around!"
	} else { 
	    set activeCellCol [lfirst $tmp]; 
	    set activeCellRow [lindex $tmp 1]; 

	    winstdout .search.message \
		" Found at Cell [ColName $activeCellCol]:[expr $activeCellRow + 1]" blue ; 
	    highlightActiveCell }
    }

    button $w.search.prev -text "Previous" -command {
	set tmp [Find $activeSheet $search(string) $search(formulas) \
		  $search(values) $search(casesens) $search(whole) -1];
        if {$tmp==""} {
	    winstderr .search.message "No more matches;try again to wrap around!"
	} else { 
	    set activeCellCol [lfirst $tmp]; 
	    set activeCellRow [lindex $tmp 1]; 

	    winstdout .search.message \
		" Found at Cell [ColName $activeCellCol]:[expr $activeCellRow + 1]" blue ; 
	    highlightActiveCell }
    }

    label $w.search.cnt

    entry $w.search.t -relief sunken -textvariable search(string) -bg White

    pack $w.search.s -side left
    pack $w.search.next $w.search.prev -side left -padx 4
    pack $w.search.t -side left -fill x -expand yes -ipadx 10 -anchor w
    pack $w.search.cnt -side left

    #
    # Options
    #

    frame $w.options -relief sunken
    
    label $w.options.label -text "Options:" 
    
    checkbutton $w.options.case -text "Case Sensitive" -variable search(casesens) -relief sunken -padx 10
    checkbutton $w.options.whole -text "Entire Cell" -variable search(whole) -relief sunken -padx 10

    frame $w.options.look
    label $w.options.look.listlabel -text "Look in:" 

    checkbutton $w.options.look.formulas -text "Formulas" -variable search(formulas) -relief sunken -padx 10 
    checkbutton $w.options.look.values -text "Values" -variable search(values) -relief sunken -padx 10 
    $w.options.look.formulas select
    $w.options.look.values select
    
    pack $w.options.label -side top -fill x 
    pack $w.options.look -side bottom -fill x 
    pack $w.options.case -side left -fill x -ipadx 10
    pack $w.options.whole -side right -fill x -ipadx 10

    pack $w.options.look.listlabel -side top -ipadx 10
    pack $w.options.look.formulas -side left -ipadx 10
    pack $w.options.look.values -side right -ipadx 10

    #
    # OK/ABORT Buttons Frame
    #

    frame $w.okabort

    button $w.okabort.abort -text "Abort" -command "destroy .search" -padx 10
    button $w.okabort.ok -text "Ok" -command "$w.search.s invoke" -padx 10
    
    pack $w.okabort.abort -side right -padx 5
    pack $w.okabort.ok -side right -padx 5

    #
    # Message Box
    #

    label $w.message

    #
    # Packing frames
    #

    pack $w.search -pady 6
    pack $w.okabort -side bottom
    pack $w.message -fill x -side bottom 
    pack $w.options -fill x

    bind $w <Enter> "focus $w.search.t"

    bind $w.search.t <Key> {
	    .search.search.next configure -state disabled
	    .search.search.prev configure -state disabled
	    .search.search.s configure -state normal
#	    .search.search.s invoke
	    set search(nextstat) 0
    }	
    
    bind .search <Key-Return> {
	if { $search(oldstring) == $search(string)} {
	    if { $search(nextstat) == 1 } {
		.search.search.next invoke
	    } else {.search.search.s invoke}
	} else {
	    .search.search.next configure -state disabled
	    .search.search.prev configure -state disabled
	    .search.search.s configure -state normal
	    .search.search.s invoke
	    set search(nextstat) 0
	}
	set search(oldstring) $search(string)
    }
	
    $w.search.next configure -state disabled
    $w.search.prev configure -state disabled
    
    return $w
}

#
#  Replace
#

proc Replace {sheet} {

    #
    # Vars
    #

    global replace

    set replace(geometry) 300x250
    set replace(casesens) 0
    set replace(stat) 0

    #
    # Initialize Replace window
    #

    set w .replace
    toplevel $w -class abacus

    wm iconname $w "Replace"
    
    wm geometry $w $replace(geometry)
  
    focus $w
 
    #
    # Entrys frame
    #

    frame $w.entry

    frame $w.entry.replace
    label $w.entry.replace.label -text "Replace:" -padx 0 -anchor e
    entry $w.entry.replace.text -relief sunken -textvariable replace(findstring) -bg White
    
    pack $w.entry.replace.text -side right  -expand yes -ipadx 0 -anchor e
    pack $w.entry.replace.label -side left -anchor e

    frame $w.entry.with
    label $w.entry.with.label -text "With:" -padx 0 -anchor e
    entry $w.entry.with.text -relief sunken -textvariable replace(replacestring) -bg White
    
    pack $w.entry.with.text -side right -expand yes -ipadx 0 -anchor e
    pack $w.entry.with.label -side left -anchor e

    pack $w.entry.replace -side top -fill x 
    pack $w.entry.with -side bottom -fill x

    #
    # Buttons frame
    #

    frame $w.buttons

    button $w.buttons.search -text     "Search     " -command {
    	set tmp [Find $activeSheet $replace(findstring) $replace(formulas) \
		     $replace(values) $replace(casesens) $replace(whole) 0];
        if {$tmp==""} {winstderr .replace.message " $replace(findstring) Not found!"
	} else { 
	    set activeCellCol [lfirst $tmp]; 
	    set activeCellRow [lindex $tmp 1]; 
	    winstdout .search.message \
		" Found at Cell [ColName $activeCellCol]:[expr $activeCellRow + 1]" blue ; 
	    highlightActiveCell ;
	};
    }

    button $w.buttons.replace -text    "Replace    " -command {
    	set tmp [Find $activeSheet $replace(findstring) $replace(formulas) \
		     $replace(values) $replace(casesens) $replace(whole) 0 $replace(replacestring)];
        if {$tmp==""} {winstderr .replace.message " $replace(findstring) Not found!"
	} else { 
	    set activeCellCol [lfirst $tmp]; 
	    set activeCellRow [lindex $tmp 1]; 
	    winstdout .search.message \
		" Replaced at Cell [ColName $activeCellCol]:[expr $activeCellRow + 1]" blue ; 
	    highlightActiveCell ;
	};
    
    }

    button $w.buttons.replaceall -text "Replace All" -command {
    
    }

    pack $w.buttons.search -side top
    pack $w.buttons.replace -side top
    pack $w.buttons.replaceall -side top
    
    #
    # Options
    #

    frame $w.options -relief sunken
    
    label $w.options.label -text "Options:" 
    
    checkbutton $w.options.case -text "Case Sensitive" -variable replace(casesens) -relief sunken -padx 10
    checkbutton $w.options.whole -text "Entire Cell" -variable replace(whole) -relief sunken -padx 10

    frame $w.options.look
    label $w.options.look.listlabel -text "Look in:" 

    checkbutton $w.options.look.formulas -text "Formulas" -variable replace(formulas) -relief sunken -padx 10 
    checkbutton $w.options.look.values -text "Values" -variable replace(values) -relief sunken -padx 10 
    $w.options.look.formulas select
    $w.options.look.values select
    
    pack $w.options.label -side top -fill x 
    pack $w.options.look -side bottom -fill x 
    pack $w.options.case -side left -fill x -ipadx 10
    pack $w.options.whole -side right -fill x -ipadx 10

    pack $w.options.look.listlabel -side top -ipadx 10
    pack $w.options.look.formulas -side left -ipadx 10
    pack $w.options.look.values -side right -ipadx 10

    #
    # abort Button
    #

    button $w.abort -text "Abort" -command "unset replace; destroy .replace" -padx 3

    #
    # Message Box
    #

    label $w.message

    #
    # Packing frames
    #
    pack $w.abort -side bottom 
    pack $w.message -side bottom 
    pack $w.options -side bottom 
    pack $w.entry -side left 
    pack $w.buttons -side right
    

    #
    # Some important bindings
    #

    bind .replace <Enter> " if { \$replace(stat) == 0 } {focus $w.entry.replace.text \
						    } else { focus $w.entry.with.text}"

    bind .replace <Key-Return> " if { \$replace(stat) == 0 } {focus $w.entry.with.text; \
                                   set replace(stat) 1} else { focus $w.entry.replace.text; \
                                   set replace(stat) 0}"
    return $w
}

# $Log: find.tcl,v $
# Revision 1.1  1998/10/25 20:48:06  cthulhu
# Initial revision
#