/* $Id: scan.l,v 1.21 1998/10/20 11:12:50 cthulhu Exp $
*/


%{ // -*- C++ -*-

  /* lex grammar for Abacus expressions */

  /* Arlindo Oliveira */

#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "gram.h"
#include "yydefines.h"
#include "wk1.hh"
extern int parse_return_code;

#define yywrap() 1

int yylineno = 1;

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
{ \
  xxl_input(buf,&result,max_size);\
}

%}

ANYCHAR [A-Za-z0-9 \`\~\!\@\#\$\%\^\&\*\(\)\\\=\-\{\}\[\]\:\;\'\<\,\>\.\?\/]
WHITESPACE [ \t]
ALPHA [A-Za-z]
DIGIT [0-9]

%%


$?{ALPHA}$?{DIGIT}+         {yylval.stval = yysave(yytext); return L_CELL_ID;}
$?{ALPHA}{ALPHA}$?{DIGIT}+  {yylval.stval = yysave(yytext); return L_CELL_ID;}

{DIGIT}+"."{DIGIT}*?E"-"?{DIGIT}*     {yylval.fval = atof(yytext); return L_FLOAT; }
{DIGIT}+"."{DIGIT}*E"+"{DIGIT}*     {yylval.fval = atof(yytext); return L_FLOAT; }
{DIGIT}+E"-"?{DIGIT}*     {yylval.fval = atof(yytext); return L_FLOAT; }
{DIGIT}+E"+"{DIGIT}*     {yylval.fval = atof(yytext); return L_FLOAT; }
{DIGIT}+"."{DIGIT}*     {yylval.fval = atof(yytext); return L_FLOAT; }
{DIGIT}*"."{DIGIT}+     {yylval.fval = atof(yytext); return L_FLOAT; }
{DIGIT}+                {yylval.ival = (int)atoi(yytext); return L_INTEGER; }

{DIGIT}+"/"{DIGIT}+"/"{DIGIT}+ {yylval.fval = gettime(yytext);
                                return L_DATE; }

"\""{ANYCHAR}*"\""          {yylval.stval = yysave(yytext);return L_STRING;}
"'"{ANYCHAR}*             {return L_LABEL;}

"and"                   {return L_AND;};
"or"                    {return L_OR;};
"not"                   {return L_NOT;};

"round"                 {return L_ROUND;};
"abs"                   {return L_ABS;};
"int"                   {return L_INTF;};
"sqrt"                  {return L_SQRT;};
"log"                   {return L_LOG;};
"ln"                    {return L_LN;};
"pi"                    {return L_PI;};
"sin"                   {return L_SIN;};
"cos"                   {return L_COS;};
"tan"                   {return L_TAN;};
"atan2"                 {return L_ATAN2;};
"atan"                  {return L_ATAN;};
"asin"                  {return L_ASIN;};
"acos"                  {return L_ACOS;};
"exp"                   {return L_EXP;};
"mod"                   {return L_MOD;};

"if"                    {return L_IF;};
"sum"                   {return L_SUM;};
"average"               {return L_AVG;};
"count"                 {return L_COUNT;};
"min"                   {return L_MIN;};
"max"                   {return L_MAX;};
"vlookup"               {return L_VLOOKUP;};
"hlookup"               {return L_HLOOKUP;};


"upper"                 {return L_UPPER;};
"lower"                 {return L_LOWER;};
"proper"                 {return L_PROPER;};
"day"                    {return L_DAY;};
"month"                  {return L_MONTH;};
"second"                 {return L_SECOND;};
"minute"                 {return L_MINUTE;};
"hour"                   {return L_HOUR;};

"sumif"                 {return L_SUMIF;};


"<>"                    {return L_NEQUAL;}
"<="                    {return L_SMALLEREQ;}
">="                    {return L_GREATEREQ;}
"="                     {return L_EQUAL;}
">"                     {return L_GREATER;}
"<"                     {return L_SMALLER;}
"+"                     {return L_PLUS;}
"-"                     {return L_MINUS;}
"*"                     {return L_TIMES;}
"/"                     {return L_DIVIDE;}
"^"                     {return L_POWER;}
"("                     {return L_LEFTPAR;}
")"                     {return L_RIGHTPAR;}
"@"                     {return L_ETA;}
","                     {return L_COMMA;}
":"                     {return L_COLON;}
"\""                    {return L_DOUBLEQUOTE;}

{ALPHA}+                {return L_STRING;}


%%

#define MAX_SAVE 20
#define MAX_LENG 20
char *yysave(char *s) {
   static char buf[MAX_SAVE][MAX_LENG];
   static int i = 0;
   
   i++; if (i == MAX_SAVE) i = 0;

   strcpy(buf[i],s);
   return(buf[i]);
}

yyerror(char * s)
{
#if DEBUG_PARSER
  fprintf(stderr,"Error parsing expression\n");
#endif
     parse_return_code = PARSE_ERROR;
}


/* $Log: scan.l,v $
 * Revision 1.21  1998/10/20 11:12:50  cthulhu
 * Union fields of yytext are nor properly used.
 *
 * Revision 1.20  1998/08/06 21:05:30  aml
 * Released alpha version of Abacus.
 *
 * Revision 1.19  1997/01/02 16:15:28  aml
 * Fixed unsufficient range of colunm width.
 * First cut of vlookup and hlookup functions.
 * Fixed bug in display routines.
 *
 * Revision 1.18  1996/12/11 21:39:42  aml
 * Sumif implemented.
 * Diverse time functions implemented.
 * Fixed needtoscroll2 to avoid out of control scroll.
 *
 * Revision 1.17  1996/10/07 12:35:24  aml
 * First cut at error handling.
 * Date formats are in.
 * Fixed problem with blank cell drawing.
 *
 * Revision 1.16  1996/08/28  17:17:11  aml
 * Load and save now accept string_value for formula cells.
 * This fixes previous thought problem of formula values not
 * being stored.
 * Functions upper,lower and proper created.
 * Function if can now return labels.
 * Fixed problem with function count.
 * Reasonably stable version, very used to manipulate notas.wk1.
 *
 * Revision 1.15  1996/08/27 17:18:45  aml
 * First version of regressive tests created.
 * Changes were made to allow for string functions.
 * String function upper created. Raises the problem
 * that formulas do NOT have a space for string values,
 * and therefore have to be evaluated upon loading.
 *
 * Revision 1.14  1996/08/26 17:22:23  aml
 * Function round fixed.
 * Many other functions added, from power to mod.
 *
 * Revision 1.13  1996/04/27 11:12:28  aml
 * Inserted check and delete button.
 * Font selection widget created.
 * Fixed bug canvas_information destructor.
 *
 * Revision 1.12  1996/03/11 15:47:44  aml
 * Made redraw more efficient by removing at once all cells before redrawing.
 * Fixed problem with unsufficient difinition of logical expressions.
 * Added >=, <=, <>, @and and @or functions.
 *
 * Revision 1.11  1996/03/08 19:00:18  aml
 * Fixed problem in string_single_arg macro
 * Created if function, boolean evaluations and so on.
 *
 * Revision 1.10  1996/03/07 20:32:49  aml
 * Created print range ability.
 * Set in gray non-working menus.
 * Created RangeKill command.
 * Created round function and macros for single argument functions.
 *
 * Revision 1.9  1996/02/19 15:47:31  aml
 * Fixed abnormality with mouse click.
 * Variable width columns implemented, but not yet saved.
 * Labels are now a lex element, fixing some aberrant behavior that existed.
 *
 * Revision 1.8  1996/02/13 12:03:23  aml
 * Fixed bug with range definition via mouse.
 * Fixed bug in range iterators.
 *
 * Revision 1.7  1996/01/11  22:48:41  aml
 * Range iterators created.
 * Functions sum, max and min now work properly.
 * Negative numbers now allowed by flex (oops :-)
 *
 * Revision 1.6  1996/01/10  18:53:37  aml
 * Fixed limited integer range of cells.
 * Fixed incorrect code in spreadsheet type.
 * Users interface improved. Cursors and mouse clicks
 * now work in the most basic modes.
 *
 * Revision 1.5  1996/01/04  20:27:15  aml
 * Range references parsed and reverse parsed.
 *
 * Revision 1.4  1996/01/02  16:22:06  aml
 * Formula compilation, evaluation and decompilation now work.
 * Cells can be of type label, numerical formula or numbers.
 *
 * Revision 1.3  1995/12/30  16:40:25  aml
 * First cut of formula compilation.
 *
 * Revision 1.2  1995/12/28  19:20:36  aml
 * Created skeleton to merge calculation engine
 *
 * Revision 1.1  1995/12/28  18:23:16  aml
 * Initial revision
 *
 * Revision 1.8  1995/09/18  09:25:36  aml
 * Last working release with inline expressions.
 * Move to wk1 format will start after this.
 *
 * Revision 1.7  1995/08/18 19:39:48  aml
 *  Modularized to allow for multiple spreadsheets.
 *  Introduced bindings for cursors in main canvas.
 *  Introduced range_opers. Copy redone, cut created.
 *  Automatic positioning of active cell.
 *
 * Revision 1.6  1995/08/08 22:05:21  aml
 * Fixed copy operation.
 * Fixed parsing of ranges in operations.
 *
 * Revision 1.5  1995/08/08 02:25:33  aml
 * Fixed evaluation for loop-free spreadsheets.
 * Got first version of cursor state machine working.
 *
 * Revision 1.4  1995/06/26 22:52:30  aml
 * Change to C++
 *
 * Revision 1.3  1995/06/25  00:09:49  aml
 * First version of copy
 *
 * Revision 1.2  1995/06/23  16:10:24  aml
 * *** empty log message ***
 *
 * Revision 1.1  1995/06/23  15:42:30  aml
 * Initial revision
 * */