/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998, Double Precision Inc.                                    */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#ifndef	pipefds_h
#define	pipefds_h

static const char pipefds_h_rcsid[]="$Id: pipefds.h 1.1 1998/04/17 00:08:53 mrsam Exp $";

/////////////////////////////////////////////////////////////////////////
//
//  Convenience class - automatically destroy pair of pipe handles.
//
/////////////////////////////////////////////////////////////////////////

#include	"autoconf.h"
#include	<stdlib.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

class PipeFds {
public:
	int fds[2];

	PipeFds() { fds[0]= -1; fds[1]= -1; }
	int Pipe();
	void close0()
		{
			if (fds[0] >= 0)	close(fds[0]);
			fds[0]= -1;
		}
	void close1()
		{
			if (fds[1] >= 0)	close(fds[1]);
			fds[1]= -1;
		}
	~PipeFds();
} ;
#endif
