/*
 * gbuffy.c
 */

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <pwd.h>
#include <string.h>

#include "gbuffy.h"

char *Homedir;
char *Maildir = NULL;
char *Spooldir = "/var/spool/mail";
int Vertical = FALSE;
int PollTime = 10;
int PollId = 0;
int DontExit = FALSE;

static GtkStyle *SelectedStyle = 0;

BOX_INFO *MailboxInfo;
/* This currently needs to be in the same order as enum BOXTYPE */
BOX_CLASS MailboxClass[] =
{
  { "mbox",     mbox_folder_count,     0 },
  { "mmdf",     mbox_folder_count,     0 },
  { "maildir",  dir_folder_count,      0 },
  { "mh",       dir_folder_count,      0 },
  { "imap",     imap_folder_count,     1 },
  { "nntp",     nntp_folder_count,     1 },
  { "external", external_folder_count, 0 }
};

void gbuffy_exit (GtkWidget *widget, gpointer data)
{
  if (!DontExit)
    gtk_main_quit ();
  DontExit = FALSE;
}

gint gbuffy_display_expose (GtkWidget *da, GdkEventExpose *event, BOX_INFO *box)
{

  if (box->pixmap)
  {
    gdk_draw_pixmap (da->window, da->style->fg_gc[GTK_WIDGET_STATE (da)],
	box->pixmap, event->area.x, event->area.y, event->area.x, event->area.y,
	event->area.width, event->area.height); 
  }
  return FALSE;
}

GdkPixmap * pixmap_from_ikon (GdkWindow *w, char *buf)
{
  char data[300];
  unsigned int a = 0, b = 0, c = 0;
  int num = 0;
  int x = 0;
  char *line;
  char *p;

  line = buf;
  while (line)
  {
    p = strchr (line, '\n');
    if (p)
    {
      *p = '\0';
      p++;
    }
#define LO_BYTE(y) (0x00ff & y)
#define HI_BYTE(y) ((0x0ff00 & y)>>8)

    sscanf (line, "%i,%i,%i", &a, &b, &c);
    data[x++] = LO_BYTE(c);
    data[x++] = HI_BYTE(c);
    data[x++] = LO_BYTE(b);
    data[x++] = HI_BYTE(b);
    data[x++] = LO_BYTE(a);
    data[x++] = HI_BYTE(a);
    line = p;
  }

  /*
  for (a = 0; a < 48; a++)
  {
    printf ("%0x, %0x, %0x, %0x, %0x, %0x\n", 
	    data[a * 6 + 0],
	    data[a * 6 + 1],
	    data[a * 6 + 2],
	    data[a * 6 + 3],
	    data[a * 6 + 4],
	    data[a * 6 + 5]);
  }
  */
  return gdk_bitmap_create_from_data (w, data, 48, 48);
}

#include <gdk/gdkprivate.h>
void
gdk_draw_bitmap (GdkDrawable *drawable,
                 GdkGC       *gc,
                 GdkPixmap   *src,
                 gint         xsrc,
                 gint         ysrc,
                 gint         xdest,
                 gint         ydest,
                 gint         width,
                 gint         height)
{
  GdkWindowPrivate *drawable_private;
  GdkWindowPrivate *src_private;
  GdkGCPrivate *gc_private;
  g_return_if_fail (drawable != NULL);
  g_return_if_fail (src != NULL);
  g_return_if_fail (gc != NULL);

  drawable_private = (GdkWindowPrivate*) drawable;
  src_private = (GdkWindowPrivate*) src;
  if (drawable_private->destroyed || src_private->destroyed)
    return;
  gc_private = (GdkGCPrivate*) gc;

  if (width == -1)
    width = src_private->width;
  if (height == -1)
    height = src_private->height;

  XCopyPlane (drawable_private->xdisplay,
             src_private->xwindow,
             drawable_private->xwindow,
             gc_private->xgc,
             xsrc, ysrc,
             width, height,
             xdest, ydest, 1);
}

gint configure_event (GtkWidget *da, GdkEventConfigure *event, BOX_INFO *box)
{
  GList *headers, *tmp;
  int y = box->height;
  int x;
  int face_display = FALSE;
  GdkPixmap *black;
  GdkGC *mask_gc;

  if (da->allocation.width == 1)
    return FALSE;

  if (box->pixmap)
    gdk_pixmap_unref (box->pixmap);

  box->pixmap = gdk_pixmap_new (da->window, da->allocation.width, 
      da->allocation.height, -1);

  black = gdk_pixmap_new (da->window, 48, 48, -1);
  gdk_draw_rectangle (black, da->style->black_gc, TRUE, 0, 0, 47, 47);
  mask_gc = gdk_gc_new (da->window);
  gdk_gc_copy (mask_gc, da->style->light_gc[GTK_WIDGET_STATE (da)]);

  gdk_draw_rectangle (box->pixmap, da->style->bg_gc[GTK_WIDGET_STATE (da)],
      TRUE, 0, 0, da->allocation.width, da->allocation.height);
  headers = g_list_first (box->headers);
  x = 2 + (50 * box->face);
  while (headers)
  {
    if (headers->data)
    {
      MESSAGE_INFO *m = (MESSAGE_INFO *)(headers->data);

      face_display = FALSE;
      if (m->face)
      {
	char buf[2048];
	GdkPixmap *face;

	strfcpy (buf, m->face, sizeof (buf));
	if (uncompface (buf) >= 0)
	{
	  face = pixmap_from_ikon (box->pixmap, buf); 
	  gdk_gc_set_clip_mask (mask_gc, face); 
	  gdk_gc_set_clip_origin (mask_gc, 2, y - box->height + 3);
	  gdk_draw_pixmap (box->pixmap, mask_gc, black, 0, 0, 2, y - box->height+3, -1, -1);
	  /*
	  gdk_draw_bitmap (box->pixmap, 
	      da->style->light_gc[GTK_WIDGET_STATE (da)],
	      face, 0, 0, 2, y - box->height + 3, -1, -1);
	  */
	  gdk_gc_set_clip_mask (mask_gc, NULL); 
	  gdk_pixmap_unref (face); 
	  face_display = TRUE;
	}
      }
      gdk_draw_string (box->pixmap, da->style->font, 
	  da->style->fg_gc[GTK_WIDGET_STATE (da)], x, y + (face_display * 3), 
	  m->from);
      y += box->height;
      gdk_draw_string (box->pixmap, da->style->font, 
	  da->style->fg_gc[GTK_WIDGET_STATE (da)], x, y + (face_display * 3), 
	  m->subject);
      y += box->height;
      if (face_display)
	y += box->height;
      gdk_draw_line (box->pixmap, da->style->dark_gc[GTK_WIDGET_STATE (da)],
/*	  (2 + (50 * !face_display)), y - box->height + 3,  */
	  x, y - box->height + 3,  
	  da->allocation.width - 18, 
	  y - box->height + 3);
    }
    headers = headers->next;
  }

  return TRUE;
}

gint populate_clist (GtkWidget *clist, BOX_INFO *box)
{
  GList *headers, *tmp;
  int y = box->height;
  int x;
  char buf[STRING_LEN];
  int row = 0;
  GdkPixmap *black;


  black = gdk_pixmap_new (NULL, 48, 48, gdk_visual_get_best()->depth);

  headers = g_list_first (box->headers);
  x = 2 + (50 * box->face);
  while (headers)
  {
    if (headers->data)
    {
      MESSAGE_INFO *m = (MESSAGE_INFO *)(headers->data);

      gtk_clist_append (GTK_CLIST (clist), NULL);
      if (m->face)
      {
	char buf[2048];
	GdkPixmap *face;

	strfcpy (buf, m->face, sizeof (buf));
	if (uncompface (buf) >= 0)
	{
	  face = pixmap_from_ikon (box->pixmap, buf); 

	  snprintf (buf, sizeof (buf), "%s\n%s", m->from, m->subject);
	  gtk_clist_set_pixtext (GTK_CLIST (clist), row, 0, buf, 2, black, 
	      face);
	     
	  gdk_pixmap_unref (face); 
	}
	else 
	{
	  snprintf (buf, sizeof (buf), "%s\n%s", m->from, m->subject);
	  gtk_clist_set_text (GTK_CLIST (clist), row, 0, buf);
	}
      }
      else
      {
	snprintf (buf, sizeof (buf), "%s\n%s", m->from, m->subject);
	gtk_clist_set_text (GTK_CLIST (clist), row, 0, buf);
      }
    }
    headers = headers->next;
    row++;
  }

  return TRUE;
}

void gbuffy_display_box (BOX_INFO *box, int xpos, int ypos)
{
  GtkWidget *da;
  GtkWidget *clist;
  GList *headers;
  char buf[STRING_LEN];
  int height = 16, width = 0;
  int x, num = 0;
  int change;

  if (box->w == NULL)
  {
    headers = g_list_alloc ();

    change = (*(MailboxClass[box->type].count))(box, 1, headers);
    if (change)
    {
      char buf[STRING_LEN];

      snprintf (buf, sizeof (buf), "%s: %d", box->title, box->new_messages);
      gtk_label_set (GTK_LABEL (GTK_BUTTON (box->button)->child), buf); 
      if (box->new_messages)
	gtk_widget_set_state (box->button, GTK_STATE_SELECTED);
    }
    if (box->new_messages == 0)
      return;

    box->w = gtk_window_new (GTK_WINDOW_DIALOG);
    snprintf (buf, sizeof (buf), "%s:  %d / %d", box->title, box->new_messages, 
	box->num_messages);
    gtk_window_set_title (GTK_WINDOW (box->w), buf);
    gtk_window_position (GTK_WINDOW (box->w), GTK_WIN_POS_MOUSE);
    gtk_widget_realize (box->w);
    gtk_widget_set_uposition (box->w, xpos+5, ypos+5);
/*    headers = g_list_first (headers);  */
    box->headers = headers->next;
    g_list_free_1 (headers);
    headers = box->headers;
    headers->prev = NULL;
    while (headers)
    {
      if (headers->data)
      {
	MESSAGE_INFO *m = (MESSAGE_INFO *)(headers->data);
	if (m->from)
	{
	  x = gdk_string_measure (box->w->style->font, m->from);
	  if (x > width)
	    width = x;
	  num++;
	}
	if (m->subject)
	{
	  x = gdk_string_measure (box->w->style->font, m->subject);
	  if (x > width)
	    width = x;
	  num++;
	}
	if (m->face)
	{
	  box->face = TRUE;
	  num++;
	}
	/*
	   x = gdk_string_height (box->w->style->font, (char *)headers->data);
	   if (x > height)
	   height = x;
	 */
      }
      headers = headers->next;
    }
    box->height = height;
    da = gtk_drawing_area_new (); 
    gtk_drawing_area_size (GTK_DRAWING_AREA (da), (box->face * 50) + width + 20,
	(height) * num + 4);
    gtk_signal_connect (GTK_OBJECT (da), "expose_event",
	(GtkSignalFunc) gbuffy_display_expose, box); 
    gtk_widget_set_events (da, GDK_EXPOSURE_MASK);
    gtk_container_add (GTK_CONTAINER (box->w), da); 
    gtk_widget_show (da);
    gtk_signal_connect (GTK_OBJECT(da),"configure_event",
	(GtkSignalFunc) configure_event, box);
    gtk_widget_set_usize (box->w, (box->face * 50) + width + 20,
	(height) * num + 4);
    /*
    clist = gtk_clist_new (1);
    gtk_clist_set_policy (GTK_CLIST (clist), GTK_POLICY_AUTOMATIC,
	            GTK_POLICY_AUTOMATIC);
    gtk_clist_set_column_width (GTK_CLIST (clist), 0, (box->face * 50) + width + 20);
    if (box->face)
      gtk_clist_set_row_height (GTK_CLIST (clist), 50);
    gtk_clist_freeze (GTK_CLIST (clist));
    populate_clist (clist, box);
    gtk_clist_thaw (GTK_CLIST (clist));
    gtk_container_add (GTK_CONTAINER (box->w), clist); 
    gtk_widget_show (clist);
	*/
    gtk_widget_show (box->w);
  }
}

gint gbuffy_button_callback (GtkWidget *widget, GdkEventButton *event, 
    BOX_INFO *box)
{
  switch (event->button)
  {
    case 1:
      box->leave = FALSE;
      gbuffy_display_box (box, event->x_root, event->y_root);
      break;
    case 2:
      if (box->command != NULL)
	gbuffy_system (box->command, GB_DETACH_PROCESS);
      break;
    case 3:
      gtk_timeout_remove (PollId);
      gbuffy_configure_dialog ();
      break;
    default:
      break;
  }
/*  gtk_signal_emit_stop_by_name (GTK_OBJECT (widget), "button_press_event");  */
  return TRUE;
}

gint gbuffy_leave_box (GtkWidget *widget, GdkEventButton *event, 
    BOX_INFO *box)
{
  box->leave = TRUE;
  if (box->new_messages)
    gtk_widget_set_state (box->button, GTK_STATE_SELECTED);
  return TRUE;
}

gint gbuffy_delete_box (GtkWidget *widget, GdkEventButton *event, 
    BOX_INFO *box)
{

  if (event->button == 1)
  {
    if (box->w != NULL && !box->leave)
    {
      GList *headers, *tmp;

      headers = g_list_first (box->headers);
      while (headers)
      {
	if (headers->data)
	{
	  safe_free ((void **)&((MESSAGE_INFO *)(headers->data))->from);
	  safe_free ((void **)&((MESSAGE_INFO *)(headers->data))->subject);
	  free (headers->data);
	}
	tmp = headers->next;
	g_list_free_1 (headers);
	headers = tmp;
      }
      gtk_widget_hide (box->w);
      gtk_widget_destroy (box->w);
      box->w = NULL;
    }
  }
  return TRUE;
}

gint gbuffy_poll_boxes (gpointer data)
{
  BOX_INFO *mbox;
  int change;

  mbox = MailboxInfo;
  while (mbox != NULL)
  {
    change = (*(MailboxClass[mbox->type].count))(mbox, 0, NULL);
    if (change)
    {
      char buf[STRING_LEN];

      snprintf (buf, sizeof (buf), "%s: %d", mbox->title, mbox->new_messages);
      gtk_label_set (GTK_LABEL (GTK_BUTTON (mbox->button)->child), buf); 
      if (mbox->new_messages)
	gtk_widget_set_state (mbox->button, GTK_STATE_SELECTED);
    }
    mbox = mbox->next;
  }
  return TRUE;
}

int gbuffy_display ()
{
  static GtkWidget *window = NULL;
  GtkWidget *box;
  GtkWidget *button;
  BOX_INFO *mbox;
  char buf[STRING_LEN];

  if (window != NULL)
  {
    DontExit = TRUE;
    gtk_widget_destroy (window);
  }

  gtk_rc_parse ("gtkrc");

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (window, "main window");
/*  gtk_widget_set_uposition (window, 0, 0); */
/*  gtk_container_border_width (GTK_CONTAINER (window), 0); */

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
      GTK_SIGNAL_FUNC (gbuffy_exit), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
      GTK_SIGNAL_FUNC (gbuffy_exit), NULL);

  if (Vertical)
    box = gtk_vbox_new (TRUE, 0);
  else
    box = gtk_hbox_new (TRUE, 0);

  gtk_container_add (GTK_CONTAINER (window), box);

  mbox = MailboxInfo;
  while (mbox != NULL)
  {
    /* (*(MailboxClass[mbox->type].count))(mbox, 1, NULL); */
    snprintf (buf, sizeof (buf), "%s: %d", mbox->title, mbox->new_messages);
    mbox->button = gtk_button_new_with_label (buf);

    if (mbox->new_messages)
      gtk_widget_set_state (mbox->button, GTK_STATE_SELECTED);

    gtk_box_pack_start (GTK_BOX (box), mbox->button, TRUE, TRUE, TRUE);
    gtk_widget_show (mbox->button);
    gtk_signal_connect (GTK_OBJECT (mbox->button), "button_press_event",
	GTK_SIGNAL_FUNC (gbuffy_button_callback), mbox);
    gtk_signal_connect (GTK_OBJECT (mbox->button), "button_release_event",
	GTK_SIGNAL_FUNC (gbuffy_delete_box), mbox);
    gtk_signal_connect_after (GTK_OBJECT (mbox->button), "leave_notify_event",
	GTK_SIGNAL_FUNC (gbuffy_leave_box), mbox);
    mbox = mbox->next;
  }

  gtk_widget_show (box);

  gtk_widget_show (window);

  PollId = gtk_timeout_add (PollTime * 1000, gbuffy_poll_boxes, NULL);
}

int main (int argc, char *argv[])
{
  char path[_POSIX_PATH_MAX];
  char *p;
  struct passwd *pw;

  gtk_init (&argc, &argv);

  if ((p = getenv ("HOME")))
    Homedir = safe_strdup (p);
  else
    if ((pw = getpwuid (getuid ())))
    {
      if (!Homedir)
	Homedir = safe_strdup (pw->pw_dir);
    }

  MailboxInfo = gbuffy_configure_load ();
  if (MailboxInfo == NULL)
  {
    MailboxInfo = (BOX_INFO *) calloc (1, sizeof (BOX_INFO));
    MailboxInfo->type = GB_MBOX;
    if (getenv ("MAIL"))
      MailboxInfo->path = safe_strdup (getenv ("MAIL"));
    else
    {
      snprintf (path, sizeof (path), "%s/%s", Spooldir, getenv ("USER"));
      MailboxInfo->path = safe_strdup (path);
    }
    MailboxInfo->title = safe_strdup ("Spool");
    MailboxInfo->command = safe_strdup ("mutt");
  }

  gbuffy_display ();

  gtk_main ();

  return 0;
}
