static char rcsid[] = "@(#)$Id: mailmsg2.c,v 1.12.4.2 1999/10/10 15:57:05 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.12.4.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Interface to allow mail to be sent to users.  Part of ELM  **/

#include "headers.h"
#include "s_elm.h"
#include <errno.h>
#include "me.h"

#ifdef USE_DSN
#include "menu2.h"
#endif

extern int errno;
extern char version_buff[];

char *error_description(), *strip_parens();
char *format_long(), *strip_commas(), *tail_of_string(); 
long ftell();

#ifdef SITE_HIDING 
 char *get_ctime_date();
#endif

extern mime_t *attachments;

int  gotten_key;
char *bounce_off_remote();

static int verify_transmission P_((char *,int  *, int *, int, char *,
				   int, int, int *, int,
				   struct mailing_headers *));  /* Prototype */
static void mail_sent P_((FILE *fd, char * title, struct run_state *rs,
 			  int ret, int exit_stat));

static int append_sig P_((FILE *file,struct mailing_headers *headers));

int mail_backend(real_reply,headers,dsn,func,encoding_top,title,resend)
     FILE *real_reply;
     struct mailing_headers * headers;
     int dsn;
     end_handler *func;
     int encoding_top;
     char * title;
     int resend;
{
    char *mailerflags[20], **argv;
    int mf_idx=0;
    struct run_state RS;
    char t[80];

    int options = SY_ENV_SHELL;
    int ret;


    mailerflags[mf_idx++] = mailer;
    
    if (strcmp(sendmail, mailer) == 0
#ifdef SITE_HIDING
	&& ! is_a_hidden_user(username)
#endif
	) {
	mailerflags[mf_idx++] = "-oi";
	mailerflags[mf_idx++] = "-oem";
	if (sendmail_verbose)
	    mailerflags[mf_idx++] = "-v";
	if (metoo) 
	    mailerflags[mf_idx++] = "-om";
    } else if (strcmp(submitmail, mailer) == 0)
	mailerflags[mf_idx++] = "-mlrnv";
    else if (strcmp(execmail, mailer) == 0) {
	if (sendmail_verbose)
	    mailerflags[mf_idx++] = "-d";
	if (metoo)
	    mailerflags[mf_idx++] = "-m";
    } 
        
#ifdef USE_8BITMIME
    if (encoding_top == ENCODING_8BIT)
	mailerflags[mf_idx++] = "-B8BITMIME";
#endif
#ifdef USE_BINARYMIME
    if (encoding_top == ENCODING_BINARY)
	/* With -BBINARYMIME lines must terminate with \r\n
	 * Unix's \n is _NOT_ sufficient - K E H              */
	mailerflags[mf_idx++] = "-BBINARYMIME";
#endif
    
#ifdef USE_DSN
    if (dsn & DSN_FULL) {
	mailerflags[mf_idx++] = "-R";
	mailerflags[mf_idx++] = "full";
    } else if (dsn & DSN_HDRS) {
	mailerflags[mf_idx++] = "-R";
	mailerflags[mf_idx++] = "hdrs";
    }
    
    if (dsn & DSN_NEVER) {
	mailerflags[mf_idx++] = "-N";
	mailerflags[mf_idx++] = "never";
    } else if (dsn & (DSN_SUCCESS|DSN_FAILURE|DSN_DELAY)) {	    
	t[0] = '\0';
	if (dsn & DSN_SUCCESS)
	    strfcat(t,"success", sizeof t);
	if (dsn & DSN_FAILURE) {
	    if (t[0]) strfcat(t,",", sizeof t);
	    strfcat(t,"failure", sizeof t);
	}
	if (dsn & DSN_DELAY) {
	    if (t[0]) strfcat(t,",", sizeof t);
	    strfcat(t,"delay", sizeof t);
	}
	mailerflags[mf_idx++] = "-N";
	mailerflags[mf_idx++] = t;
    }
#endif
    mailerflags[mf_idx] = NULL;
    
    if (strcmp(submitmail, mailer) == 0)
	argv = mailerflags;
    else {
	char **argvt = argv_from_headers(headers);
	argv = join_argv(mailerflags,argvt);
	free(argvt);
    }

    if (!sendmail_verbose)
	options |= SY_NOTTY;

    fseek (real_reply, 0, 0);
#ifdef _POSIX_VERSION
    fflush(real_reply);  /* Synzronize underlying file descriptor */
#else
    seek(fileno(real_reply),0,0);
#endif

    ret=start_run(&RS, options, argv, fileno(real_reply),-1);
    
    if (ret) {
	int backgrounded = 0;
	int exit_code;

	ret = run_already_done(&RS,&exit_code);
	if (0 == ret) {
	    if (resend)
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmResendingMail,
				  "Resending mail..."));
	    else
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSendingMail,
				  "Sending mail..."));
	    fflush(stdout);
	    
#ifdef BACKGROUD_PROCESSES       /* We assume POSIX in here */
	    if (background_wait_time) {
 		int tmp;
 		dprint(4, (debugfile, 
 			   "Sleeping ( %d seconds ) for completion!\n",
 			   background_wait_time));
 		tmp = sleep(background_wait_time);  
 		/* POSIX sleep returns time in left on
 		 * interrupt -- when sendmail terminates
		 * we will get interrupt (SIGCHLD signal)
		 */
		if (tmp > 0) {
		    dprint(4, (debugfile, 
			       " -- sleeping interrupted, %d seconds left!\n",
			       tmp));
		} else if (tmp < 0) {
		    dprint(4, (debugfile, 
			       " -- sleeping failed?\n"));
		}
		ret = run_already_done(&RS,&exit_code);
		if (0 == ret) 
		    ret = maybe_background(&RS,&exit_code,
					   real_reply,title,mail_sent);
		if (0 == ret) {
		    if (resend)
			lib_error(CATGETS(elm_msg_cat, ElmSet, 
					  ElmResendingMailBackground,
					  "Resending mail... in background"));
		    
		    else
			lib_error(CATGETS(elm_msg_cat, ElmSet, 
					  ElmSendingMailBackground,
					  "Sending mail... in background"));
		    fflush(stdout);
		    backgrounded = 1;
		}
	    } else
#endif
		ret = wait_end(&RS,&exit_code);
	}
	if (!backgrounded)
	    func(real_reply,title,&RS,ret,exit_code);
    } else {
	if (RS.save_errno)
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailErrno,
			      "Failed: %.30s: %.40s"),
		      argv[0],error_description(RS.save_errno));
	else
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCantStart,
			      "Can't start %.30s"),
		      argv[0]);
    }
    
    if (argv != mailerflags)
	free(argv);
    
    return ret;
}


int mail(current_header,options,form, headers)
     struct header_rec * current_header;
     int options,form;
     struct mailing_headers * headers;
{
  int copy_msg       = 0 != current_header && 0 != (options & MAIL_COPY_MSG);
  int edit_message   =                        0 != (options & MAIL_EDIT_MSG);
  int replying       = 0 != current_header && 0 != (options & MAIL_REPLYING);
  int forwarding     = 0 != current_header && 0 != (options & MAIL_FORWARDING);

	/** Given the addresses and various other miscellany (specifically, 
	    'copy-msg' indicates whether a copy of the current message should 
	    be included, 'edit_message' indicates whether the message should 
	    be edited) this routine will invoke an editor for the user and 
	    then actually mail off the message. 'form' can be YES, NO, or
	    MAYBE.  YES=add "Content-Type: mailform" header, MAYBE=add the
	    M)ake form option to last question, and NO=don't worry about it!
	    Also, if 'copy_msg' = FORM, then grab the form temp file and use
	    that...
	    Return TRUE if the main part of the screen has been changed
	    (useful for knowing whether a redraw is needed.
	**/

	FILE *reply, *real_reply; /* second is post-input buffer */
	char *whole_msg_file, *tempnam();
	char fname[SLEN], copy_file[SLEN],
             very_long_buffer[VERY_LONG_STRING];
	  
	int ch, sys_status, line_len;
	register int retransmit = FALSE; 
	int      already_has_text = FALSE;		/* we need an ADDRESS */
	int	 signature_done = FALSE;
	int	 need_redraw = 0;
	int	 err;
	int reask_verify = FALSE;
	int dsn = 0;
	mime_send_t MIME_info;

	static int cancelled_msg = 0;
	char title[80];

#ifdef USE_DSN
	if(DSN_success)
	  dsn |= DSN_SUCCESS|DSN_FAILURE|DSN_DELAY;
#endif

        if (current_header && (options & MAIL_ISFORM))
	  copy_msg = FORM;

	/* Initialize structure */
	MIME_info.encoding_top = ENCODING_7BIT;
        MIME_info.type_opts_top[0] = '\0';
	MIME_info.encoding_text = ENCODING_7BIT;
	MIME_info.Charset = charset;
	MIME_info.need_enc = 0;
	MIME_info.type_text = MIME_TYPE_TEXT;
	strfcpy (MIME_info.subtype_text, "plain", 
		 sizeof MIME_info.subtype_text);
        MIME_info.type_opts_text[0] = '\0';
	MIME_info.encoded_subject[0] = '\0';
	strfcpy (MIME_info.encoded_fullname, full_username,
		 sizeof(MIME_info.encoded_fullname));
	MIME_info.cl_offset = MIME_info.cl_start = MIME_info.cl_end = 0;

	dump_expanded_address(4,"Mailing to",headers->to);
	dprint(4, (debugfile, "   (with%s editing)\n",
		   edit_message? "" : "out"));

	/* this will get set to 1 on a successful reply */ 
	me_retcode = 0;

	gotten_key = 0;		/* ignore previously gotten encryption key */

	/** first generate the temporary filename **/

	elm_sfprintf(cur_editfile,sizeof cur_editfile,
		     FRM("%s%s%d"), 
		     temp_dir, temp_file, getpid());

	/** if possible, let's try to recall the last message? **/

	if (! batch_only && copy_msg != FORM && user_level != 0)
	  retransmit = recall_last_msg(cur_editfile, copy_msg, &cancelled_msg, 
		       &already_has_text);

	/** if we're not retransmitting, create the file.. **/

	if (! retransmit)
        {
	  if ((reply = safeopen_rdwr(cur_editfile)) == NULL) {
	    err = errno;
	    dprint(1, (debugfile, 
               "Attempt to write to temp file %s failed with error %s (mail)\n",
		 cur_editfile, error_description(err)));
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldNotCreateFile,
				"Could not create file %s (%s)."),
			cur_editfile, error_description(errno));
	    return(need_redraw);
	  }
	}
   

	(void) elm_chown(cur_editfile, userid, groupid);

	/* copy the message from standard input */
	if (batch_only) {
	  while (line_len = fread(very_long_buffer, 1, sizeof(very_long_buffer), stdin))
	    fwrite(very_long_buffer, 1, line_len, reply);
	}

	/** if there is an included file, copy it into the temp file **/
	if (*included_file) {
	  FILE *input;
	  if ((input = fopen(included_file,"r")) == NULL) {
	    dprint(1, (debugfile, 
              "Can't open included file %s.  Failed with error %s (mail)\n",
	      included_file, error_description(errno)));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldNotOpenFile,
			      "Could not open file %s."), 
		      included_file);
	    return(need_redraw);
	  }

	  while (fgets(very_long_buffer, VERY_LONG_STRING, input) != NULL) 
	    fputs(very_long_buffer, reply);

	  fclose(input);
	  already_has_text = TRUE;
	} 

	if (copy_msg == FORM) {
	  elm_sfprintf(fname, sizeof fname,
		       FRM("%s%s%d"), temp_dir, temp_form_file, getpid());
	  fclose(reply);	/* we can't retransmit a form! */
	  if (access(fname,ACCESS_EXISTS) != 0) {
	    if(batch_only) {
	      printf(catgets(elm_msg_cat, ElmSet, ElmCouldNotFindForm,
		"Couldn't find forms file!"));
	      printf("\n");
	    } else
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldNotFindForm,
				"Couldn't find forms file!"));
	    return(need_redraw);
	  }
	  dprint(4, (debugfile, "-- renaming existing file %s to file %s --\n",
		  fname, cur_editfile));
	  rename(fname, cur_editfile);	  
	}
	else if (copy_msg && ! retransmit) {  /* if retransmit we have it! */
	  char From_buffer[LONG_STRING];
	  struct addr_item *p;

	  From_buffer[0] = '\0';
	  if (current_header->from) {
	    for (p = current_header->from; p->addr && p->fullname; p++) {
	      char * str = p->fullname[0] ? p->fullname : p->addr;
	      if (From_buffer[0])
		strfcat(From_buffer,", ",sizeof From_buffer);
	      strfcat(From_buffer,str,sizeof From_buffer);
	    }
	  }

	  if (!forwarding || (forwarding && !mimeforward)) {
	    if (forwarding && !quote_forward) {
	      if (From_buffer[0]) {
		fprintf (reply, "----- Forwarded message from %s -----\n\n", 
			 From_buffer);
	      } else
		fprintf (reply, "----- Forwarded message (env-from %s) -----\n\n", 
			 current_header->env_from);
	      
	    } else if (attribution[0] && current_header) {
	      if (From_buffer[0]) {
		fprintf(reply, attribution, From_buffer);
	      } else
		fprintf(reply, attribution, current_header->env_from);
	      fputc('\n', reply);
	    }
	    if (edit_message && current_folder) {
	      int NOHDR = forwarding ? noheaderfwd : noheader;
	      int NOQUOTE = forwarding && !quote_forward; 
	      copy_message(MAILFILE(current_folder),current_header,
			   NOQUOTE ? "" : prefixchars, reply,
			   ( NOHDR ? CM_REMOVE_HEADER : 0 ) 
			   | CM_MMDF_HEAD | CM_DECODE 
			   /* I think it is good idea to use CM_FILT_HDR
			    * even when we don't have forwarding ... -KEH
			    */
			   | CM_FILT_HDR );
	      already_has_text = TRUE;	/* we just added it, right? */
	    }
	    else if (current_folder) {
	      int NOHDR = forwarding ? noheaderfwd : noheader;
	      copy_message(MAILFILE(current_folder),current_header,
			   "", reply,
			   ( NOHDR ? CM_REMOVE_HEADER : 0 ) 
			   | CM_MMDF_HEAD
			   /* I added CM_DECODE to here -KEH */
			   | CM_DECODE);
	    }
	    if (forwarding && !quote_forward) {
	      if (From_buffer[0])
		fprintf (reply, "----- End of forwarded message from %s -----\n",
			 From_buffer);
	      else
		fprintf (reply, "----- End of forwarded message (env-from %s) -----\n",
			 current_header->env_from);
	    }
	  }
	  else {
	    FILE *tmpfp;
	    int len,first_line = 1;
	    int in_headers = TRUE;

	    /* Use MESSAGE/RFC822 to forward messages. */

	    elm_sfprintf (very_long_buffer, sizeof very_long_buffer,
			  FRM("%selmfwd.%d"), 
			  temp_dir, getpid ());
	    if (! (tmpfp = safeopen_rdwr (very_long_buffer))) {
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailFileForward,
			    "Failed to create file for forwarding"));
	    } else if (current_folder) {
	      attachments = (mime_t *) mime_t_alloc ();
	      attachments->flags = MIME_RFC822;
	      attachments->pathname = (char *) strmcpy(attachments->pathname, 
						       very_long_buffer);


	      copy_message(MAILFILE(current_folder),current_header,"",tmpfp,
			   CM_REMOVE_ENVELOPE);
	   
	      attachments->length = fsize(tmpfp);
	      fclose (tmpfp);
	      attachments->unlink = 1; /* mark for later deletion */
	      attachments->type = MIME_TYPE_MESSAGE;
	      strfcpy (attachments->subtype, "rfc822", 
		       sizeof attachments->subtype);
	      elm_sfprintf (very_long_buffer, sizeof very_long_buffer,
			    CATGETS(elm_msg_cat, ElmSet, ElmForwardedMesg,
				    "Forwarded message from %s"), 
			    From_buffer[0] ? From_buffer : current_header->env_from);
	      attachments->description = (char *)strmcpy (attachments->description,
							  very_long_buffer);
	      
	      /* Pick up the encoding from the message. */
	      attachments->encoding = ENCODING_7BIT;
	      (void) update_encoding (&(attachments->encoding),
				      current_header->mime_rec.encoding);
	      
	    }
	  }
	}

	/* Initial attachment */
	if(attachments) 
	  attachments->next = attach_files;
	else
	  attachments = attach_files;
	attach_files = NULL;

        /* append signature now if we are going to use an external editor */
	/* Don't worry about the remote/local determination too much */

        if (already_has_text || 
           (strcmp(editor,"builtin") != 0 && strcmp(editor,"none") != 0)) {
	     signature_done = TRUE;
             if (!retransmit && copy_msg != FORM) 
	       already_has_text |= append_sig(reply, headers);
	}

	if (! retransmit && copy_msg != FORM)
	  if (reply != NULL)
	    (void) fclose(reply);	/* on replies, it won't be open! */

	/** Edit the message **/

	/* calculate default save_file name */
	if(auto_cc) {
	  if(save_by_name) {
	    if(force_name) {
	      strfcpy(copy_file, "=",
		      sizeof copy_file);    /* signals save by 'to' logname */
	    } else {
	      strfcpy(copy_file, "=?",
		      sizeof copy_file); /* conditional save by 'to' logname */
	    }
	  } else {
	    strfcpy(copy_file, "<", sizeof copy_file);	/* signals save to sentmail */
	  }
	} else *copy_file = '\0';	/* signals to not save a copy */

	/* tell to verify_transmission() */
	if (attachments) 
	  options |= MAIL_HAVE_ATTACHMENTS;
#ifdef USE_PGP
	if (current_header &&
	    current_header->pgp & PGP_MESSAGE)
	  options |= MAIL_HAVE_PGP_ENCODED;
#endif

	do { /* So we can return here if check_for_multipart() fails
	      * - K E H <hurtta+elm@ozone.FMI.FI>    */

	  reask_verify = 0;

	  /* ask the user to confirm transmission of the message */
	  if (!batch_only) {
	  fatal_label:
	    ch = (edit_message? 'e' : '\0');
	    if (verify_transmission(cur_editfile, &form, &need_redraw,
				    already_has_text, copy_file, ch,
				    options, &dsn, sizeof copy_file,
				    headers) != 0) {
	      cancelled_msg = (bytes(cur_editfile) > 0);
	      if (attachments) {
		mime_destroy (attachments);
		attachments = 0;
	      }
	      return need_redraw;
	    }
	    if (form == YES && format_form(cur_editfile) < 1) {
	      cancelled_msg = (bytes(cur_editfile) > 0);
	      return need_redraw;
	    }
            /* so we can mark the reply flag */
            me_retcode = 1;
	  }

	  if ((reply = fopen(cur_editfile,"r+")) == NULL) {
	    err = errno;
	    dprint(1, (debugfile,
		       "Attempt to open file %s for reading failed with error %s (mail)\n",
		       cur_editfile, error_description(err)));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldNotOpenReply,
			      "Could not open reply file (%s)."), 
		      error_description(err));
	    return need_redraw;
	  }

	/* Append signature if not done earlier, so that need_eccoding
	 * takes account of 8-bit data on signature
	 */
	
	  if (!signature_done && !retransmit && copy_msg != FORM) {
	    /* Go to the end of the file! */
	    fseek (reply, 0, 2);
	    append_sig(reply, headers);
	    rewind(reply);
	    signature_done = TRUE;
	  }

	  MIME_info.encoding_top  = ENCODING_7BIT;/* Encoding for Multipart/ */
	  MIME_info.encoding_text = ENCODING_7BIT;/* Encoding for Text/plain */
	  
	  /* Determine how this message should be MIME encoded:
	   * 7BIT, 8BIT, BINARY or QUOTED-PRINTABLE.
	   */
	  MIME_info.need_enc = needs_encoding (reply);
	  if (allow_no_hdrencoding && headers->subject)
	    MIME_info.need_enc |= check_8bit_str (headers->subject);
	  
	  if (MIME_info.need_enc & HAVE_BINARY) {
#ifdef USE_BINARYMIME
	    MIME_info.encoding_text =  ENCODING_BINARY;
#else
	    if (allow_no_encoding >= 2)
	      /* Just send BINARY anyway */
	      MIME_info.encoding_text = ENCODING_BINARY;
	    else
	      /* no -BBINARYMIME option */
	      MIME_info.encoding_text = ENCODING_QUOTED;
#endif
	  }
	  else if (MIME_info.need_enc & HAVE_8BIT) {
#ifdef USE_8BITMIME
	    MIME_info.encoding_text =  ENCODING_8BIT;
#else
	    if (allow_no_encoding >= 1)
	      /* Just send 8BIT anyway */
	      MIME_info.encoding_text = ENCODING_8BIT;
	    else
	      /* no -B8BITMIME option */
	      MIME_info.encoding_text = ENCODING_QUOTED;
#endif
	  }
	  /* Control characters can send with encoding 7BIT
	   * HAVE_BINARY takes care really severe stuff */
	  if ((MIME_info.need_enc & HAVE_CTRL) &&
	      MIME_info.encoding_text != ENCODING_QUOTED) {
	    if (batch_only) 		
	      MIME_info.encoding_text =  ENCODING_QUOTED;
	    else { 
	      int ch;
	      ch = want_to("Text have control characters. \
Encode text with quoted-printable? ",*def_ans_yes,elm_LINES-1,0);
	      if (ch == *def_ans_yes) 
		MIME_info.encoding_text =  ENCODING_QUOTED;
	      else if (ch != *def_ans_no) {
		edit_message = FALSE;
		reask_verify = TRUE;
		continue;    /* Go again to verify_transmission loop */
	      }
	    }
	  }

	  (void) update_encoding(&MIME_info.encoding_top,
				 MIME_info.encoding_text);

	  /* Update Charset */
	  MIME_info.Charset = charset;
	  if (!(MIME_info.need_enc & HAVE_8BIT) &&
	      istrcmp(charset,"US-ASCII") != 0 &&
	      charset_ok(charset))
	    MIME_info.Charset="US-ASCII";
	  else if ((MIME_info.need_enc & HAVE_8BIT) &&
		   istrcmp(charset,"US-ASCII") == 0 &&
		   istrcmp(display_charset,"US-ASCII") != 0 &&
		   charset_ok(display_charset))
	    MIME_info.Charset=display_charset;
	  else if ((MIME_info.need_enc & HAVE_8BIT) &&
		   istrcmp(charset,"US-ASCII") == 0) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmUsingUNKNOWN8BIT,
			      "Text has 8BIT data and charset=US-ASCII, using charset=UNKNOWN-8BIT instead."));
	    
	    if (sleepmsg > 0)
	      sleep(sleepmsg);
	    
	    MIME_info.Charset="UNKNOWN-8BIT";           
         }

	  cancelled_msg = FALSE;	/* it ain't cancelled, is it? */

	  MIME_info.msg_is_multipart = check_for_multipart(reply, &MIME_info);
	  if (MIME_info.msg_is_multipart < 0) { /* Error in [include ...] */
	    if (!batch_only) {
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFixInclude,
				"Please fix [include ...] lines!"));
	      if (sleepmsg > 0)
		sleep (sleepmsg);

	      edit_message = FALSE;
	      reask_verify = TRUE; /* Go to verify_transmission again. */
	    }
	  }

	  if (attachments != 0) {
	    /* Determine what the top level Content-Transfer-Encoding: field
	     * should be.  BINARY has the highest weight, followed by
	     * 8BIT.  NOTE: no checking to see if the mailer supports those
	     * encodings since that will already have been done in the
	     * attach_menu() routine.
	     */
	    mime_t *tmp;
	    
	    MIME_info.msg_is_multipart = TRUE;
	    
	    for (tmp = attachments; tmp != 0; tmp = tmp->next) {
	      (void) update_encoding(&MIME_info.encoding_top,tmp->encoding); 
	      if (tmp->pathname) {
		if (access(tmp->pathname,READ_ACCESS) < 0) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmAccessAttach,
				    "Can't access attachment: %.50s"),
			    tmp->pathname);
		  reask_verify = TRUE; /* Go to verify_transmission again. */
		  if (sleepmsg > 0)
		    sleep (sleepmsg);
		  edit_message = FALSE;
		}
	      } else {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadAttach,
				  "Bad attachment -- no filename!"));
	      }
	    }
	  }
	  
	  /* End of check_for_multipart failure loop */
	} while (!batch_only && reask_verify);
	
	if (MIME_info.msg_is_multipart) {
	  (void) mime_generate_boundary (MIME_info.mime_boundary,
					 sizeof MIME_info.mime_boundary);
          add_parameter(MIME_info.type_opts_top, "boundary",
                        MIME_info.mime_boundary, 
			sizeof(MIME_info.type_opts_top),
                        FALSE);
	}
#ifdef USE_PGP
        if (pgp_status & (PGP_MESSAGE | PGP_SIGNED_MESSAGE | PGP_PUBLIC_KEY)) {
	  MIME_info.type_text = MIME_TYPE_APPLICATION;
	  strfcpy(MIME_info.subtype_text, "pgp",
		  sizeof MIME_info.subtype_text);

	  if (! (pgp_status & PGP_MESSAGE)) {
	    switch (pgp_sign_type) {
	    case 0:
	      MIME_info.type_text = MIME_TYPE_APPLICATION;
	      strfcpy(MIME_info.subtype_text, "pgp",
		      sizeof MIME_info.subtype_text);
	      break;
	    case 1:
	      MIME_info.type_text = MIME_TYPE_TEXT;
	      strfcpy(MIME_info.subtype_text, "plain",
		      sizeof MIME_info.subtype_text);
	      break;
	    case 2:
	      MIME_info.type_text = MIME_TYPE_TEXT;
	      strfcpy(MIME_info.subtype_text, "x-pgp",
		      sizeof MIME_info.subtype_text);
	      break;
	    }
	  }
	    
	  if (pgp_status & PGP_PUBLIC_KEY)
            add_parameter(MIME_info.type_opts_text,"format","keys-only",
                          sizeof(MIME_info.type_opts_text), FALSE);
          else {
            add_parameter(MIME_info.type_opts_text, "format", "text",
                          sizeof(MIME_info.type_opts_text), FALSE);
            /* This next bit is a non-non-standard, but exmh does this and it
             * can be very useful when parsing the message.
             */
            if (pgp_status & PGP_MESSAGE) {
              add_parameter(MIME_info.type_opts_text, "x-action",
                            (pgp_status & PGP_SIGNED_MESSAGE) ? 
			    "encryptsign" : "encrypt",
                            sizeof(MIME_info.type_opts_text),FALSE);
            }
            else
              add_parameter(MIME_info.type_opts_text, "x-action", "sign",
                            sizeof(MIME_info.type_opts_text), FALSE);
          }
        }
#endif
	/* charset parameter is valid for all subtypes of Text/ */
        if (MIME_info.type_text == MIME_TYPE_TEXT)
          add_parameter(MIME_info.type_opts_text, "charset", MIME_info.Charset,
                        sizeof(MIME_info.type_opts_text), FALSE);
         
	/** grab a copy if the user so desires... **/

	if (allow_no_hdrencoding) {
	    if (headers->subject)
		strfcpy(MIME_info.encoded_subject,headers->subject,
			sizeof(MIME_info.encoded_subject));
	    else
		MIME_info.encoded_subject[0] = '\0';

	    MIME_info.encoded_fullname[0] = '"';
	    strfcpy(MIME_info.encoded_fullname+1,full_username,
		    sizeof(MIME_info.encoded_fullname)-2);
	    strfcat(MIME_info.encoded_fullname,"\"",
		    sizeof MIME_info.encoded_fullname);

	    if (headers->in_reply_to)
		strfcpy(MIME_info.encoded_in_reply_to,
			headers->in_reply_to,
			sizeof(MIME_info.encoded_in_reply_to));
	    else
		MIME_info.encoded_in_reply_to[0] = '\0';


	    dprint(2,(debugfile,"Subject not encoded: %s\n",
		      MIME_info.encoded_subject));
	    dprint(2,(debugfile,"Fullname not encoded: %s\n",
		      MIME_info.encoded_fullname));
	    dprint(2,(debugfile,"In-Reply-To not encoded: %s\n",
		      MIME_info.encoded_in_reply_to));

	} else {
	    char *ptr,*next_ptr,*rptr;
	    int qcount = 0;

	    if (headers->subject)
		rfc1522_encode_text(MIME_info.encoded_subject,
				    sizeof(MIME_info.encoded_subject),
				    headers->subject,0);
	    else
		MIME_info.encoded_subject[0] = '\0';

	    rfc1522_encode_text(MIME_info.encoded_fullname,
				sizeof(MIME_info.encoded_fullname),
				full_username,HDR_PHRASE);

	    for (ptr = headers->in_reply_to, 
		     rptr = MIME_info.encoded_in_reply_to; 
		 ptr && *ptr; ptr = next_ptr) {
		int left = ((MIME_info.encoded_in_reply_to + 
			     sizeof(MIME_info.encoded_in_reply_to)) - rptr)-1;
		char c = 0;
		if (left < 2)
		    break;
		next_ptr = qstrpbrk(ptr,"<>");
		if (next_ptr) {
		    c = *next_ptr;
		    *next_ptr = '\0';
		    if ('<' == c) 
			qcount ++;
		}
		dprint(12,(debugfile,
			   "Encoding in-reply-to - elem='%s', qcount=%d, c='%c'\n",
			   ptr,qcount,c));
		if (!next_ptr || next_ptr > ptr) {
		    int len;
		    if (qcount > 0) {
			strfcpy(rptr,ptr,left);
		    } else if (0 == qcount) {
			rfc1522_encode_text(rptr,left,ptr,HDR_PHRASE);
		    } else {
			error("Error in In-Reply-To");
			*rptr = '\0';		
		    }
		    dprint(12,(debugfile,
			       "Encoding in-reply-to - encoded='%s'\n",
			       rptr));
		    
		    len = strlen(rptr);
		    rptr += len;
		}
	    if (next_ptr) {
		if ('>' == c) 
		    qcount --;
		*next_ptr = c;
		next_ptr++;
		if (rptr < (MIME_info.encoded_in_reply_to + 
			    sizeof(MIME_info.encoded_in_reply_to)) -1) 
		    *rptr++=c;
		*rptr='\0';
	    }
	    }
	    *rptr = '\0';
	    if (qcount > 0) {
		error("Error in In-Reply-To");
	    }

	    dprint(2,(debugfile,"Encoded subject: %s\n",
		      MIME_info.encoded_subject));
	    dprint(2,(debugfile,"Encoded fullname: %s\n",
		      MIME_info.encoded_fullname));
	    dprint(2,(debugfile,"Encoded In-Reply-To: %s\n",
		      MIME_info.encoded_in_reply_to));
	}

	if (*copy_file) /* i.e. if copy_file contains a name */
	  save_copy(headers,cur_editfile, copy_file, form, &MIME_info);

	/** write all header information into whole_msg_file **/

	if((whole_msg_file=tempnam(temp_dir, "snd.")) == NULL) {
	  dprint(1, (debugfile, "couldn't make temp file nam! (mail)\n"));
	  if(batch_only) {
	    printf(catgets(elm_msg_cat, ElmSet, ElmCouldNotMakeTemp,
		"Sorry - couldn't make temp file name!"));
	    printf("\n");
	  } else if(mail_only)
	    error(catgets(elm_msg_cat, ElmSet, ElmCouldNotMakeTemp,
		"Sorry - couldn't make temp file name."));
	  else
	    set_error(catgets(elm_msg_cat, ElmSet, ElmCouldNotMakeTemp,
		"Sorry - couldn't make temp file name."));
	  return(need_redraw);
	}

	/** try to write headers to new temp file **/

	dprint(6, (debugfile, "Composition file='%s' and mail buffer='%s'\n", 
		    cur_editfile, whole_msg_file));

	dump_expanded_address(2,"To",headers->to);
	dump_expanded_address(2,"CC",headers->cc);
	dump_expanded_address(2,"Bcc",headers->bcc);

	if ((real_reply = 
	     write_header_info(whole_msg_file, headers,
			       form == YES, FALSE, &MIME_info)
	     ) == NULL) {
	  error("Failed to create temp file for mailing!");
	  sleep_message();
	  edit_message = FALSE;
	  fclose(reply);
	  free(whole_msg_file);

	  if (!batch_only)
	    goto fatal_label;

	  if (!batch_only)
	    goto fatal_label;
	  return TRUE; /* need redraw */
	}
	
	copy_message_across(reply, real_reply, FALSE, &MIME_info);
	
	/* clean up the allocated space */
	if (attachments) {
	  mime_destroy (attachments);
	  attachments = 0;
	}

	elm_sfprintf(title, sizeof title,
		     CATGETS(elm_msg_cat, ElmSet, ElmMailTo,
			     "Mail to %.50s..."),
		     headers->to.addrs ? headers->to.addrs[0].addr : 
		     "(someone)");

	mail_backend(real_reply,headers,dsn,mail_sent, 
		     MIME_info.encoding_top, title,0);

	unlink(whole_msg_file);
	free(whole_msg_file);

	fclose(reply);
	fclose(real_reply);
	
	/* Unlink temp file now.
	 * This is a precaution in case the message was encrypted.
	 * I.e. even though this file is readable by the owner only,
	 * encryption is supposed to hide things even from someone
	 * with root privelges. The best we can do is not let this
	 * file just hang after we're finished with it.
	 */
	(void)unlink(cur_editfile);
#ifdef USE_PGP
        pgp_status=0;
#endif
	return(need_redraw);
	
}

static void mail_sent (fd,title,rs,ret,exit_code)
     FILE *fd; 
     char * title;
     struct run_state *rs;
     int ret; 
     int exit_code;
{
  char very_long_buffer[90];

  lower_prompt(title);
  if (ret < 0) 
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailSignal,
		      "%.30s fail: Signal?"),
	      mailer);
  else if (ret > 0) {
    if (rs->save_errno)
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailErrno,
			"Failed: %.30s: %.40s"),
		mailer,error_description(rs->save_errno));
    else if (exit_code) {
      lib_error(
		CATGETS(elm_msg_cat, ElmSet, 
			ElmMailerReturnedError,
			"mailer returned error status %d"), 
		exit_code);
    } else
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMailSent, "Mail sent!"));
  } else {
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLostErrno,
		      "%.30s lost: %.40s"),
	      mailer,error_description(rs->save_errno));
  }
}

int mail_form(current_header, address, subj)
     struct header_rec *current_header;
     struct addr_item *address; 
     char *subj;
{
    int res;
    
    struct mailing_headers headers;
    struct expanded_address A;
    
    zero_mailing_headers(&headers);
    zero_expanded_address(&A);

    headers.subject = safe_strdup(subj);

    addr_to_expanded(&A,address);
    copy_expanded_address(&headers.to, A);
    
    res = mail(current_header,MAIL_ISFORM,NO, &headers);
    
    free_expanded_address(&A);
    free_mailing_headers(&headers);

    return res;
}

int
recall_last_msg(filename, copy_msg, cancelled_msg, already_has_text)
char *filename;
int  copy_msg, *cancelled_msg, *already_has_text;
{
	char ch;
	char msg[SLEN];

	/** If filename exists and we've recently cancelled a message,
	    the ask if the user wants to use that message instead!  This
	    routine returns TRUE if the user wants to retransmit the last
	    message, FALSE otherwise...
	**/

	register int retransmit = FALSE;

	if (access(filename, EDIT_ACCESS) == 0 && *cancelled_msg) {
	  Raw(ON);
	  CleartoEOLN();
	  if (copy_msg)
	    elm_sfprintf(msg, sizeof msg,
			 CATGETS(elm_msg_cat, ElmSet, ElmRecallLastInstead,
				 "Recall last kept message instead? (%c/%c) "),
			 *def_ans_yes, *def_ans_no);
	  else
	    elm_sfprintf(msg, sizeof msg,
			 CATGETS(elm_msg_cat, ElmSet, ElmRecallLastKept,
				 "Recall last kept message? (%c/%c) "),
			 *def_ans_yes, *def_ans_no);
	  do {
	    ch = want_to(msg, '\0', elm_LINES-1, 0);
	    if (ch == *def_ans_yes) {
              retransmit++;
	      *already_has_text = TRUE;
	    } else if (ch != *def_ans_no) {
	      Write_to_screen(FRM("%c??"), 07);	/* BEEP */
	      if (sleepmsg > 0)
		    sleep((sleepmsg + 1) / 2);
	      ch = 0;
	    }
	  } while (ch == 0);

	  fflush(stdout);

	  *cancelled_msg = 0;
	}

	return(retransmit);
}

#ifdef USE_DSN

void dsn_menu P_((int *));
void dsn_menu(dsn)
     int * dsn;
{
  static int hdr_only = 0;
  static int failure  = 1;
  static int delay    = 1;
  static int success  = 0;
  static int DSN_off  = 0;

#define BOL 1
  static struct menu_item dsn_items[] = {
    { "Return H)eaders only on FAILURE:", 'h', 3,  BOL, (char *) &hdr_only,
      sizeof hdr_only },
    { "Return DSN on F)AILURE         :", 'f', 5,  BOL, (char *) &failure,
      sizeof failure },
    { "              D)ELAY           :", 'd', 6,  BOL, (char *) &delay,
      sizeof delay },
    { "              S)UCCESS         :", 's', 7,  BOL, (char *) &success,
      sizeof success },
    { "U)se defaults (DSN off)        :", 'u', 12, BOL, (char *) &DSN_off,
      sizeof DSN_off }
  };

  if (0 == *dsn)
    DSN_off = 1;
  else {
    if (DSN_FULL    & *dsn) hdr_only = 0;
    if (DSN_HDRS    & *dsn) hdr_only = 1;
    if (DSN_SUCCESS & *dsn) success  = 1;
    if (DSN_FAILURE & *dsn) failure  = 1;
    if (DSN_DELAY   & *dsn) delay    = 1;
    if (DSN_NEVER   & *dsn) { success = 0; failure = 0; delay = 0; }
  }
  
  generic_menu(dsn_items,sizeof dsn_items / sizeof (struct menu_item),
	       "DSN (Delivery Status Notification) Configuration",
	       "DSN: ");

  if (DSN_off) *dsn = 0;
  else if (!success && !failure && !delay) *dsn = DSN_NEVER;
  else {
    int val = 0;
    if (hdr_only) val |= DSN_HDRS;
    else          val |= DSN_FULL;
    if (success)  val |= DSN_SUCCESS;
    if (failure)  val |= DSN_FAILURE;
    if (delay)    val |= DSN_DELAY;

    *dsn = val;
  }
  
}
#endif


/*
 * verify_transmission() - Ask the user to confirm transmission of the
 * message.  Returns 0 to send it, -1 to forget it.
 */
static int
verify_transmission(filename, form_p, need_redraw_p,
		    already_has_text, copy_file, force_cmd, options,
		    dsn, copy_file_size,
		    headers
)
     char *filename;	    /* pathname to mail mssg composition file        */
     int  *form_p;	    /* pointer to form message state	             */
     int *need_redraw_p;    /* pointer to flag indicating screen stepped on  */
     int already_has_text;  /* indicates there is already text in the mssg   */
     char *copy_file;	    /* pointer to buffer holding copy file name	     */
     int force_cmd;	    /* command to do, '\0' to prompt user for cmd    */
     int options;
     int *dsn;
     int copy_file_size;
     struct mailing_headers *headers;   
{
    char *prompt_mssg;		/* message to display prompting for cmd	*/
    char prompt_menu[SLEN],	/* menu of available commands		*/
         prompt_menu2[SLEN];
    int bad_cmd;		/* set TRUE to bitch about user's entry	*/
    int did_prompt;		/* TRUE if cmd prompted for and entered	*/
    int prev_form;		/* "*form_p" value last time thru loop	*/
    int cmd;			/* command to perform			*/
    char lbuf[VERY_LONG_STRING];
    int x_coord, y_coord;
    int replying          = 0 != (options & MAIL_REPLYING);
    int have_attachments  = 0 != (options & MAIL_HAVE_ATTACHMENTS);
#ifdef USE_PGP
    int was_pgp_encoded   = 0 != (options & MAIL_HAVE_PGP_ENCODED);
#endif
    int def_cmd = 's';

#ifdef USE_PGP
    if (replying && was_pgp_encoded &&
	! (pgp_status & PGP_MESSAGE)) 
	def_cmd = 'p';
#endif

    prev_form = *form_p + 1;	/* force build of prompt strings	*/
    bad_cmd = FALSE;		/* nothing to complain about yet	*/

    for (;;) {

	/* build up prompt and menu strings */
	if (prev_form == *form_p) {
	    ; /* not changed - no need to rebuild the strings */
	} else if (user_level == 0) {
	    prompt_mssg = catgets(elm_msg_cat, ElmSet, ElmVfyPromptPleaseChoose,
		"Please choose one of the following options by parenthesized letter: s");
	    strfcpy(prompt_menu, 
		    catgets(elm_msg_cat, ElmSet, ElmVfyMenuUser0,
			    "e)dit message, edit h)eaders, s)end it, or f)orget it."),
		    sizeof prompt_menu);
            prompt_menu2[0] = '\0';

	    /* In some conditions add these also to menu in user_level == 0 */
	    if (have_attachments)
	      strfcat(prompt_menu2, "a)ttachments", sizeof prompt_menu2);
#ifdef USE_DSN
	    if (dsn && *dsn != 0) {
	      if (prompt_menu2[0]) strfcat(prompt_menu2,", ", 
					   sizeof prompt_menu2);
	      strfcat(prompt_menu2, "D)SN", sizeof prompt_menu2);
	    }
#endif
#ifdef USE_PGP
	    if (replying && was_pgp_encoded) {
	      if (prompt_menu2[0]) strfcat(prompt_menu2,", ",
					   sizeof prompt_menu2);
	      strfcat(prompt_menu2, "p)gp", sizeof prompt_menu2);
	    }
#endif
	} else {
	    prompt_mssg = catgets(elm_msg_cat, ElmSet, ElmVfyPromptAndNow,
		"And now: s");
	    switch (*form_p) {
	    case PREFORMATTED:
		prompt_menu[0] = '\0';
		break;
	    case YES:
		strfcpy(prompt_menu, catgets(elm_msg_cat, ElmSet,
					     ElmVfyMenuEditForm, 
					     "e)dit form, "),
			sizeof prompt_menu);
		break;
	    case MAYBE:
		strfcpy(prompt_menu, catgets(elm_msg_cat, ElmSet,
					     ElmVfyMenuEditMake, 
					     "e)dit msg, m)ake form, "),
			sizeof prompt_menu);
		break;
	    default:
		strfcpy(prompt_menu, catgets(elm_msg_cat, ElmSet,
					     ElmVfyMenuEditMsg, 
					     "e)dit message, "),
			sizeof prompt_menu);
		break;
	    }
	    strfcat(prompt_menu, catgets(elm_msg_cat, ElmSet, ElmVfyMenuVfyCpy,
					"h)eaders, c)opy, "),
		    sizeof prompt_menu);
#ifdef ISPELL
	    strfcat(prompt_menu, catgets(elm_msg_cat, ElmSet, ElmVfyMenuIspell,
					 "i)spell, "),
		    sizeof prompt_menu);
#endif
#ifdef ALLOW_SUBSHELL
	    strfcat(prompt_menu, catgets(elm_msg_cat, ElmSet, ElmVfyMenuShell,
					 "!)shell, "),
		    sizeof prompt_menu);
#endif
            /* The previous line was getting too full... */
            prompt_menu2[0] = '\0';
	    strfcat(prompt_menu2, "a)ttachments", sizeof prompt_menu2);
#ifdef USE_DSN
	    if (dsn) strfcat(prompt_menu2, ", D)SN", sizeof prompt_menu2);
#endif
#ifdef USE_PGP
	    if (prompt_menu2[0]) strfcat(prompt_menu2,", ", 
					 sizeof prompt_menu2);
            strfcat(prompt_menu2, "p)gp", sizeof prompt_menu2);
#endif
	    strfcat(prompt_menu, catgets(elm_msg_cat, ElmSet, ElmVfyMenuSndFgt,
					 "s)end, or f)orget"),
		    sizeof prompt_menu);
	}



	prev_form = *form_p;

	/* complain if last entry was bad */
	if (bad_cmd) {
	    Write_to_screen(FRM("%c??"), 07);
	    if (sleepmsg > 0)
		sleep((sleepmsg + 1) / 2);
	    bad_cmd = FALSE;
	}

	/* if we don't have a cmd, display prompt and get response from user */
	if (force_cmd != '\0' &&
	    isascii(force_cmd)) {
	    cmd = tolower(force_cmd);
	    force_cmd = '\0';
	    did_prompt = FALSE;
	} else {
	redraw:
	    ClearLine(elm_LINES-3);
	    PutLine0(elm_LINES-3, 0, prompt_mssg);
	    GetXYLocation(&x_coord, &y_coord);
	    y_coord--; /* backspace over default answer */
	    PutLineX(elm_LINES-3, y_coord, FRM("%c"),def_cmd);
	    ClearLine(elm_LINES-2);
	    Centerline(elm_LINES-2, prompt_menu);
            ClearLine(elm_LINES-1);
            Centerline(elm_LINES-1, prompt_menu2);
	    fflush(stdout);
	    MoveCursor(x_coord, y_coord);
	    cmd = ReadCh(REDRAW_MARK);
	    if (cmd == REDRAW_MARK)
	      goto redraw;
	    if (cmd == EOF)
	      leave(0);
#ifdef ASCII_CTYPE
	    if (isascii(cmd))
#endif
	      cmd = tolower((unsigned char)cmd);
	    did_prompt = TRUE;
	}

	switch (cmd) {
	case '\n':
	case '\r':
	    cmd = def_cmd;
	}

	/* handle command */
	switch (cmd) {

	case 'a':
	    if (did_prompt)
	        Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmVfyMenuAtttach,
					"Attachments"));
	  attachments = (mime_t *) attach_menu (attachments, FALSE);
	  break;
#ifdef USE_DSN
        case 'd':
	    if (did_prompt)
	        Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmVfyMenuDsn,
					"Dsn"));
	  if (dsn) dsn_menu(dsn);
	  break;
#endif
	case 's':
	    if (did_prompt)
	        Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmVfyMenuSend,
					"Send"));
#ifdef USE_PGP
	      if (replying && was_pgp_encoded &&
		  ! (pgp_status & PGP_MESSAGE)) {
              ClearLine(elm_LINES-2);
	      PutLine0(elm_LINES-2, 0, "The recv'd message was PGP encoded, are you sure? ");
	      for (;;) {
		cmd = ReadCh(0);
		if (cmd == *def_ans_yes) {
		  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmYesWord, 
					  "Yes."));
		  return(0);
		}
		if (cmd == *def_ans_no) {
		  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmNoWord, 
					  "No."));
		  break;
		}
	      }
	      break;
	    }
#endif /* USE_PGP */
	    return 0;
	    /*NOTREACHED*/
#ifdef USE_PGP
	case ctrl('F'):
	  pgp_void_passphrase();
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPassphraseForgotten,
			  "Passphrase forgotten!"));
	  break;
#endif
       case 'f': 
	    if (did_prompt)
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmVfyMenuForget, 
					"Forget"));
	    if (bytes(filename) <= 0) {
		; /* forget about empty files */
	    } else if (mail_only) {
		FILE * fd;
		mime_send_t MIME_info;
		
		MIME_info.encoding_top  = ENCODING_7BIT;
		if ((fd = fopen(filename,"r")) != NULL) {
		    MIME_info.msg_is_multipart = 
			check_for_multipart(fd,&MIME_info);
		    MIME_info.need_enc = needs_encoding (fd);
		    if (allow_no_hdrencoding && headers->subject)
			MIME_info.need_enc |= 
			    check_8bit_str (headers->subject);
		    fclose(fd);
	      } else {
		  MIME_info.msg_is_multipart = 0;
		  MIME_info.need_enc = 0;
	      }
	      MIME_info.encoding_text =  ENCODING_7BIT;
	      MIME_info.Charset       =  charset;
	      
	      if (MIME_info.need_enc & HAVE_BINARY) 
		MIME_info.encoding_text =  ENCODING_BINARY;
	      else  if (MIME_info.need_enc & HAVE_8BIT) 
		MIME_info.encoding_text =  ENCODING_8BIT;
	      
	      update_encoding(&MIME_info.encoding_top,MIME_info.encoding_text);
	      
	      if (MIME_info.msg_is_multipart)
		(void) mime_generate_boundary (MIME_info.mime_boundary,
					       sizeof MIME_info.mime_boundary);
	      
	      elm_sfprintf(lbuf, sizeof lbuf,
			   FRM("%s/%s"), 
			   home, dead_letter);
	      (void) append_copy_to_file(headers, lbuf, filename,
					 *form_p, &MIME_info);
	    } else if (user_level > 0) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmVfyMessageKept,
				  "Message kept.  Can be restored at next f)orward, m)ail or r)eply."));
	    }
#ifdef USE_PGP
            pgp_status = 0; /* make sure to reset! */
#endif
	    return -1;
	    /*NOTREACHED*/

	case 'c':
	    if (did_prompt)
	      Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
				      ElmVfyMenuCopyFile, 
				      "Copy file"));
	    if (name_copy_file(copy_file, copy_file_size) != 0)
		*need_redraw_p = TRUE;
	    break;

	case 'e':
	    if (did_prompt)
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmVfyMenuEdit, "Edit"));
	    if (*form_p == PREFORMATTED) {
		bad_cmd = TRUE;
	    } else {
		if (*form_p == YES)
		    *form_p = MAYBE;
		*need_redraw_p = TRUE;
		if (edit_the_message(filename, already_has_text,
				     headers,editor) != 0)
		    return -1;
	    }
	    break;

	case 'h':
	    if (did_prompt)
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmVfyMenuHeaders,"Headers"));
	    edit_headers(headers);
	    *need_redraw_p = TRUE;
	    break;

	case 'm':
	    if (*form_p != MAYBE) {
		bad_cmd = TRUE;
	    } else {
		switch (check_form_file(filename)) {
		case -1:
		    /* couldn't open file??? */
		    return -1;
		case 0:
		    Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
					    ElmVfyNoFieldsInForm, 
					    "No fields in form!\007"));
		    if (sleepmsg > 0)
			sleep(sleepmsg);
		    break;
		default:
		    /* looks like a good form */
		    *form_p = YES;
		    break;
		}
	    }
	    break;

#ifdef ISPELL
	case 'i':
	    if (did_prompt)
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmVfyMenuIspell2,"Ispell"));
	    if (*form_p == PREFORMATTED) {
		bad_cmd = TRUE;
	    } else {
		if (*form_p == YES)
		    *form_p = MAYBE;
		elm_sfprintf(lbuf, sizeof lbuf,
			     FRM("%s %s %s"),
			     ISPELL_PATH, ISPELL_OPTIONS, filename);
		system_call(lbuf, SY_ENAB_SIGHUP);
		*need_redraw_p = TRUE;
#ifdef ultrix
		/* I'm told this is required to work around some sort of bug */
		force_raw();
#endif
	    }
	    break;
#endif

#ifdef ALLOW_SUBSHELL
	case '!':
	    if (subshell() != 0) {
		ClearScreen();
		*need_redraw_p = TRUE;
	    }
	    break;
#endif
#ifdef USE_PGP
        case 'p':
	    if (did_prompt)
	        Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmVfyMenuPgp,"Pgp"));
	    if (!pgp_status) {
	      pgp_status = pgp_menu (filename,headers);
	      if (pgp_status)
		  def_cmd = 's';
	      else
		  def_cmd = 'p';
	      *need_redraw_p = TRUE;
	    }
            else
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPgpAlreadyEncSig,
				"This message is already encrypted and/or signed!"));
            break;
#endif
	default:
	    bad_cmd = TRUE;
	    break;

	}

    }

}

FILE * write_header_info(filename, headers,
			 form, copy, mime_info)
     char *filename;
     struct mailing_headers * headers;  
     int   form, copy;
     mime_send_t *mime_info;
{

	/** Try to open filedesc as the specified filename.  If we can,
	    then write all the headers into the file.  The routine returns
	    'filedesc' if it succeeded, NULL otherwise.  Added the ability
	    to have backquoted stuff in the users .elmheaders file!
	    If copy is TRUE, then treat this as the saved copy of outbound
	    mail.
	**/

	char opentype[3];
	time_t time(), thetime;
	char *ctime();
	FILE *filedesc = NULL;		/* our friendly file descriptor  */
        char to_buf[VERY_LONG_STRING];
	int err;
	char fullname_buf[STRING], *qfullname = fullname_buf; 
#ifdef SITE_HIDING
	char  buffer[SLEN];
	int   is_hidden_user;		/* someone we should know about?  */
#endif
#ifdef MMDF
	int   is_submit_mailer;		/* using submit means change From: */
#endif /* MMDF */
#ifndef DONT_ADD_FROM
	char from_buf[3*40+10];
#endif
      	char  *get_arpa_date();

	elm_sfprintf(fullname_buf,sizeof fullname_buf,
		     FRM("\"%.*s\""),
		     sizeof(fullname_buf)-4,full_username);
	save_file_stats(filename);
	
	if (copy) /* Go end of (perhaps existing) file */
	  filedesc = open_end_update(filename);
	else /* Create _new_ temporary file */
	  filedesc = safeopen_rdwr(filename);

	if (filedesc == NULL) {
	  err = errno;
	  dprint(1, (debugfile,
	    "Attempt to open file %s for writing failed! (write_header_info)\n",
	     filename));
	  dprint(1, (debugfile, "** %s **\n\n", error_description(err)));
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorTryingToWrite,
			    "Error %s encountered trying to write to %s."), 
		    error_description(err), filename);
	  if (sleepmsg > 0)
		sleep(sleepmsg);
	  return(NULL);		/* couldn't open it!! */
	}

	restore_file_stats(filename);

	if(copy) {	/* Add top line that mailer would add */
#ifdef MMDF
	  fprintf(filedesc, MSG_SEPARATOR);
#endif /* MMDF */
	  thetime = time((long *) 0);
	  fprintf(filedesc,"From %s %s", username, ctime(&thetime));
#ifdef MMDF
	} else if (strcmp(submitmail,mailer) == 0) {
	  do_mmdf_addresses(filedesc, headers);
#endif /* MMDF */
	}

#ifdef SITE_HIDING
	if ( !copy && (is_hidden_user = is_a_hidden_user(username))) {
	  /** this is the interesting part of this trick... **/
	  elm_sfprintf(buffer, sizeof buffer,
		       FRM("From %s!%s %s\n"),  
		       HIDDEN_SITE_NAME,
		       username, get_ctime_date());
	  fprintf(filedesc, "%s", buffer);
	  dprint(1,(debugfile, "\nadded: %s", buffer));
	  /** so is this perverted or what? **/
	}
#endif


	/** Subject moved to top of headers for mail because the
	    pure System V.3 mailer, in its infinite wisdom, now
	    assumes that anything the user sends is part of the 
	    message body unless either:
		1. the "-s" flag is used (although it doesn't seem
		   to be supported on all implementations?? )
		2. the first line is "Subject:".  If so, then it'll
		   read until a blank line and assume all are meant
		   to be headers.
	    So the gory solution here is to move the Subject: line
	    up to the top.  I assume it won't break anyone elses program
	    or anything anyway (besides, RFC-822 specifies that the *order*
	    of headers is irrelevant).  Gahhhhh....
	**/

	if (!form) {
	  /* Our standard violations */
	  char OSV[100];
	  OSV[0] = '\0';

	  write_text_header(filedesc,"Subject",
			    mime_info ->encoded_subject,
			    mime_info->encoding_top);

	  qfullname = mime_info->encoded_fullname;

#ifndef DONT_ADD_FROM
	  /* Else From can still be Mime Par 2 encoded */
	  if (allow_no_hdrencoding && 
	      (check_8bit_str (mime_info ->encoded_subject) ||
	       is_rfc1522     (mime_info ->encoded_subject) ||
	       check_8bit_str (mime_info ->encoded_in_reply_to) ||
	       is_rfc1522     (mime_info ->encoded_in_reply_to) ||
	       check_8bit_str (qfullname) ||
	       is_rfc1522     (qfullname)))
	    add_parameter(OSV,"no-hdr-encoding","1",sizeof(OSV),TRUE);
#endif

	  if (check_8bit_str (mime_info ->encoded_subject) ||
	      check_8bit_str (qfullname) ||
	      check_8bit_str (mime_info->encoded_in_reply_to) ||
	      allow_no_hdrencoding && ( check_8bit_addr(headers->to.addrs) ||
					check_8bit_addr(headers->cc.addrs) ||
					/* BCC header is written normally
					 * only to copy, but make it consistent
					 */
					check_8bit_addr(headers->bcc.addrs) ||
					check_8bit_addr(headers->
							reply_to.addrs)))
	    add_parameter(OSV,"hdr-charset",
			  mime_info ->Charset,sizeof(OSV),FALSE);

	  if (strlen(mime_info->encoded_in_reply_to)) {
	      write_text_header(filedesc,"In-Reply-To",
				mime_info->encoded_in_reply_to,
				mime_info->encoding_top);
	  }

	  if (OSV[0]) {
	    fprintf(filedesc, "X-ELM-OSV: (Our standard violations) %s",OSV);
	    print_EOLN(filedesc,mime_info->encoding_top);
	  }

	} else 
	  {
	      if (headers->subject)
		  fprintf(filedesc, "Subject: %s\n", headers->subject);
	      qfullname = fullname_buf;	    
	    
	      if (headers->in_reply_to)
		  fprintf(filedesc, "In-Reply-To: %s\n", 
			  headers->in_reply_to);	
	      fprintf(filedesc, 
		      "X-ELM-OSV: (Our standard violations) no-mime=1; no-hdr-encoding=1\n");
	  }

	if (headers->to.addrs)
	    write_addr_header(filedesc,"To",headers->to.addrs,
			      mime_info->encoding_top);
	write_text_header(filedesc,"Date",get_arpa_date(),
			  mime_info->encoding_top);
#ifndef DONT_ADD_FROM
#ifdef MMDF
	is_submit_mailer = (strcmp(submitmail,mailer) == 0);
#endif /* MMDF */
/*
 *	quote full user name in case it contains specials
 */
# ifdef SITE_HIDING
#    ifdef MMDF
	if (is_submit_mailer)
	  elm_sfprintf(from_buf,sizeof from_buf,
		       FRM("%.40s"),username);
	else
#    endif /* MMDF */
	if (is_hidden_user)
	  elm_sfprintf(from_buf,sizeof from_buf,
		       FRM("%.40s!%.40s!%.40s"),
		       hostname, HIDDEN_SITE_NAME, username);
	else
	  elm_sfprintf(from_buf,sizeof  from_buf,
		       FRM("%.40s!%.40s"),
		       hostname, username);
# else
#   ifdef  USE_DOMAIN
#    ifdef MMDF
	if (is_submit_mailer)
	  elm_sfprintf(from_buf,sizeof from_buf,
		       FRM("%.40s"), 
		       username);
	else
#    endif /* MMDF */
	  elm_sfprintf(from_buf,sizeof from_buf,
		       FRM("%.40s@%.40s"),  
		       username, hostfullname);
#   else
#    ifdef MMDF
	if (is_submit_mailer)
	  elm_sfprintf(from_buf,sizeof from_buf,
		       FRM("%.40s"), username);
	else
#    endif /* MMDF */
	elm_sfprintf(from_buf,sizeof from_buf,
		     FRM("%.40s@%.40s"),
		     username, hostname);
#   endif
# endif
	fprintf(filedesc,"From: %s <%s>",qfullname,from_buf);
	print_EOLN(filedesc,mime_info->encoding_top);
#endif

	if (headers->cc.addrs)
	    write_addr_header(filedesc,"CC",headers->cc.addrs,
			      mime_info->encoding_top);

	if (copy && headers->bcc.addrs ||
	    /* If there is no To or CC recipients,
	     * show BCC recipients to make mail legal 
	     */
	    !headers->to.addrs && !headers->cc.addrs && headers->bcc.addrs)
	    write_addr_header(filedesc,"Bcc",headers->bcc.addrs,
			      mime_info->encoding_top);
	
	if (headers->action)
	    write_text_header(filedesc,"Action",headers->action,
			      mime_info->encoding_top);

	if (headers->priority)
	    write_text_header(filedesc,"Priority",headers->priority,
			      mime_info->encoding_top);

	if (headers->precedence)
	    write_text_header(filedesc,"Precedence",headers->precedence,
			      mime_info->encoding_top);

	if (headers->expires)
	    write_text_header(filedesc,"Expires",headers->expires,
			      mime_info->encoding_top);

	if (headers->reply_to.addrs)
	    write_addr_header(filedesc,"Reply-To",headers->reply_to.addrs,
			      mime_info->encoding_top);
	
	if (headers->user_defined_header) {
	    fprintf(filedesc, "%s", headers->user_defined_header);
	    print_EOLN(filedesc,mime_info->encoding_top);
	}

	add_mailheaders(filedesc);

#ifndef NO_XHEADER
	fprintf(filedesc, "X-Mailer: ELM [version %s]", version_buff);
	print_EOLN(filedesc,mime_info->encoding_top);
#endif /* !NO_XHEADER */

	if (form) 
	    fprintf(filedesc, "Content-Type: mailform\n");
	else {
	    mime_write_header (filedesc, mime_info, 1);
	}
	mime_info->cl_offset = 0;
	if (copy) {
	    /* Only write content-length to copy */
	    fprintf(filedesc, "Content-Length: ");
	    mime_info->cl_offset = ftell(filedesc);
	    fprintf(filedesc, "          "); /* Print Blanks as Placeholders */
	    print_EOLN(filedesc,mime_info->encoding_top);
	    fprintf(filedesc, "Status: RO");
	    print_EOLN(filedesc,mime_info->encoding_top);
	}
	print_EOLN(filedesc,mime_info->encoding_top);
	return(filedesc);
}

void copy_message_across(source, dest, copy, mime_info)
     mime_send_t *mime_info;
     FILE *source, *dest;
     int copy;
{
    /** Copy the message in the file pointed to by source to the
	file pointed to by dest.
	If copy is TRUE, treat as a saved copy of outbound mail. **/

	int  crypted = FALSE;			/* are we encrypting?  */
	int  encoded_lines = 0;			/* # lines encoded     */
	int  line_len;
	char buffer[SLEN];			/* file reading buffer */
	int	text_lines = 0;
	int	at_boundary = FALSE;

	mime_info -> cl_start = ftell(dest);

	/* Reserve one byte for conversion LF -> CR LF in
	 * case of binary mime transmission:
	 */
	while (line_len = mail_gets(buffer, SLEN-1, source)) {
	  if (buffer[0] == '[') {
	    if (strncmp(buffer, START_ENCODE, strlen(START_ENCODE))==0) {
	      if (mime_info->msg_is_multipart) {
		if (!at_boundary) {
		  print_EOLN(dest,mime_info->encoding_top);
		  fprintf(dest,"--%s",mime_info->mime_boundary);
		  print_EOLN(dest,mime_info->encoding_top);
		}
		mime_info->type_text    =  MIME_TYPE_APPLICATION;
		strfcpy(mime_info->subtype_text,"X-ELM-encode",
			sizeof mime_info->subtype_text);
		
		mime_write_header (dest, mime_info, 0);
		print_EOLN(dest,mime_info->encoding_top);
		at_boundary = FALSE;
	      }
	      crypted = TRUE;
	    }
	    else if (strncmp(buffer, END_ENCODE, strlen(END_ENCODE))==0)
	      crypted = FALSE;
	    else if ((strncmp(buffer, DONT_SAVE, strlen(DONT_SAVE)) == 0)
	          || (strncmp(buffer, DONT_SAVE2, strlen(DONT_SAVE2)) == 0)) {
	      if(copy) break;  /* saved copy doesn't want anything after this */
	      else continue;   /* next line? */
	    } else if (strncmp(buffer, MIME_INCLUDE, 
			       strlen(MIME_INCLUDE))==0) {
	      text_lines = 0;
	      if (!at_boundary) {
		print_EOLN(dest,mime_info->encoding_top);
		fprintf(dest, "--%s", mime_info->mime_boundary);
		print_EOLN(dest,mime_info->encoding_top);
	      }
	      Include_Part(dest, buffer, FALSE, mime_info, copy);
	      print_EOLN(dest,mime_info->encoding_top);
	      fprintf(dest, "--%s", mime_info->mime_boundary);
	      print_EOLN(dest,mime_info->encoding_top);
	      at_boundary = TRUE;
	      continue;
	    }

	    if (crypted) {
	      if (! gotten_key++)
	        getkey(ON);
	      else if (! encoded_lines)
	        get_key_no_prompt();		/* reinitialize.. */
	      if (0 != strncmp(buffer, START_ENCODE, strlen(START_ENCODE))) {
	        encode(buffer);
	        encoded_lines++;
	      }
	    }
	  }
	  else if (crypted) {
	    if (batch_only) {
	      printf(catgets(elm_msg_cat, ElmSet, ElmNoEncryptInBatch,
		"Sorry. Cannot send encrypted mail in \"batch mode\".\n"));
	      leave(0);
	    } else if (! gotten_key++)
	      getkey(ON);
	    else if (! encoded_lines)
	      get_key_no_prompt();		/* reinitialize.. */
	    if (0 != strncmp(buffer, START_ENCODE, strlen(START_ENCODE))) {
	      encode(buffer);
	      encoded_lines++;
	    }
	  } else {
	    if (text_lines == 0) {
	      char tmp[STRING];
	      if (mime_info->msg_is_multipart) {
		if (!at_boundary) {
		  print_EOLN(dest,mime_info->encoding_top);
	 	  fprintf(dest,"--%s",mime_info->mime_boundary);
		  print_EOLN(dest,mime_info->encoding_top);
		}

		mime_write_header (dest, mime_info, 0);
		print_EOLN(dest,mime_info->encoding_top);
		at_boundary = FALSE;
	      }
	    }	
	    text_lines++;
          }

	  if (mime_info->encoding_top == ENCODING_BINARY) {
	    /* It is better perhaps use canonical eol (CRLF) when mail have
	     * content transfer encoding BINARY somewhere (see notes about 
	     * BINARYMIME)
	     */

	    if (buffer[line_len-1] == '\n') {
	      int add = 1;
	      if (line_len >1 && buffer[line_len-2] == '\r')
		add = 0;
	      if (add) {
		buffer[line_len-1] = '\r';
		buffer[line_len] = '\n';
		line_len++;
	      }	      
	    }
	  }

	  /* Do QUOTED-PRINTABLE conversion if necessary... */
	  if (mime_info->encoding_text == ENCODING_QUOTED)
	    line_quoted_printable_encode(buffer,dest,copy,line_len,TRUE,
					 mime_info);
	  else
#ifndef DONT_ESCAPE_MESSAGES
	  if (copy && (strncmp(buffer, "From ", 5) == 0)) {
	    /* Add in the > to a From on our copy */
	    fprintf(dest, ">");
	    if (fwrite(buffer, 1, line_len, dest) != line_len) {
		MoveCursor(elm_LINES, 0);
		Raw(OFF);
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmWriteFailedCopyAcross,
				  "Write failed in copy_message_across\n"));
		emergency_exit(0);
	    }
	  }
#ifdef NEED_LONE_PERIOD_ESCAPE
	  else if (!copy && strcmp(buffer, ".\n") == 0)
	    /* Because some mail transport agents take a lone period to
	     * mean EOF, we add a blank space on outbound message.
	     */
	    fputs(". \n", dest);
#endif /* NEED_LONE_PERIOD_ESCAPE */
  	  else
#endif /* DONT_ESCAPE_MESSAGES */
  	    if (fwrite(buffer, 1, line_len, dest) != line_len) {
		MoveCursor(elm_LINES, 0);
		Raw(OFF);
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmWriteFailedCopyAcross,
				  "Write failed in copy_message_across\n"));
		emergency_exit(0);
	    }
	} 
	if (mime_info->msg_is_multipart) {
	  /* now add any attachments (NEW STYLE) */
	  if (attachments)
	    attach_generate_message (attachments, dest, copy, mime_info);

	  print_EOLN(dest,mime_info->encoding_top);
	  fprintf(dest,"--%s--", mime_info->mime_boundary);
	  print_EOLN(dest,mime_info->encoding_top);
	}


	mime_info->cl_end = ftell(dest) ;
	if (mime_info->cl_offset > 0) {
	  /* go fixup the content length header */
	  fseek(dest, mime_info->cl_offset, 0);
	  fprintf(dest, "%d", mime_info->cl_end - mime_info->cl_start);
	  
	  /* Return to the end of the file! */
	  fseek (dest, 0, 2);
	}

#ifdef MMDF
    if (copy) fputs(MSG_SEPARATOR, dest);
#else
    if (copy) fputs("\n", dest);	/* ensure a blank line at the end */
#endif /* MMDF */
}

static int append_sig(file, headers)
     FILE *file;
     struct mailing_headers *headers;
{
    /* Append the correct signature file to file.  Return TRUE if
       we append anything.  */
    
    /* Look at the to and cc list to determine which one to use */
    
    /* We could check the bcc list too, but we don't want people to
       know about bcc, even indirectly */
    
    /* Some people claim that  user@anything.same_domain should be 
       considered local.  Since it's not the same machine, better be 
       safe and use the remote sig (presumably it has more complete
       information).  You can't necessarily finger someone in the
       same domain. */

    if (!batch_only && (local_signature[0] || remote_signature[0])) {

	char filename2[SLEN];
	char *sig = "";

	/* check each @ for @thissite.domain */
	/* if any one is different than this, then use remote sig */

	struct addr_item *p;
    
	sig = local_signature;

	/* check To: list */
	for (p = headers->to.addrs ; 
	     p < headers->to.addrs + headers->to.addrs_len;
	     p++) { 
	    char *ptr = qstrpbrk(p->addr,":");
	    
	    /* skip route */
	    if (ptr)
		ptr = qstrpbrk(ptr,"@");
	    else
		ptr = qstrpbrk(p->addr,"@");

	    if (!ptr)
		continue;
	    ptr++;
	    
	    if (istrcmp(ptr, hostfullname) != 0) {
		sig = remote_signature;
		break;
	    }
	}

	if (sig == local_signature)		   /* still local? */         
	    /* check Cc: */
	    for (p = headers->cc.addrs ; 
		 p < headers->cc.addrs + headers->cc.addrs_len;
		 p++) { 
		char *ptr = qstrpbrk(p->addr,":");
		
		/* skip route */
		if (ptr)
		    ptr = qstrpbrk(ptr,"@");
		else
		    ptr = qstrpbrk(p->addr,"@");
		
		if (!ptr)
		    continue;
		ptr++;
	    
		if (istrcmp(ptr, hostfullname) != 0) {
		    sig = remote_signature;
		    break;
		}
	    }

	if (sig[0]) {  /* if there is a signature file */
	    if (sig[0] != '/')
		elm_sfprintf(filename2, sizeof filename2,
			     FRM("%s/%s"), 
			     home, sig);
	    else
		strfcpy(filename2, sig, sizeof filename2);
	    /* append the file - with a news 2.11 compatible */
	    /* seperator if "sig_dashes" is enabled */
	    (void) append(file, filename2, (sig_dashes ? "\n-- \n" : NULL));
	    
	    return TRUE;
	}    
    }
    return FALSE;
}

int check_8bit_str (str)
     char *str;
{
  char *s;

  for (s = str;	*s; s++)
    if (*s & 0x80)
      return HAVE_8BIT;
  return 0;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
