
static char rcsid[] = "@(#)$Id: leavembox.c,v 1.11.4.1 1999/08/27 04:06:11 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.11.4.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** leave current folder, updating etc. as needed...
  
**/

#include "headers.h"
#include "me.h"
#include "s_elm.h"

#include <sys/stat.h>
#ifdef USE_FLOCK_LOCKING
#define SYSCALL_LOCKING
#endif
#ifdef USE_FCNTL_LOCKING
#define SYSCALL_LOCKING
#endif
#ifdef SYSCALL_LOCKING
#  if (defined(BSD_TYPE) || !defined(apollo))
#    include <sys/file.h>
#  endif
#endif
#include <errno.h>
#ifdef I_UTIME
#  include <utime.h>
#endif
#ifdef I_SYSUTIME
#  include <sys/utime.h>
#endif

/**********
   Since a number of machines don't seem to bother to define the utimbuf
   structure for some *very* obscure reason.... 

   Suprise, though, BSD has a different utime() entirely...*sigh*
**********/

#ifndef BSD_TYPE
# ifndef UTIMBUF

struct utimbuf {
	time_t	actime;		/** access time       **/ 
	time_t	modtime;	/** modification time **/
       };

# endif /* UTIMBUF */
#endif /* BSD_TYPE */

extern int errno;

char *error_description();

static void block_signals P_((void));
static void unblock_signals P_((void));

int leave_mbox(resyncing, quitting, prompt)
     int resyncing, quitting, prompt;
{
	/** Close folder, deleting some messages, storing others in mbox,
	    and keeping others, as directed by user input and elmrc options.

	    Return	1	Folder altered
			0	Folder not altered
			-1	New mail arrived during the process and
					closing was aborted.
			-2      Leaving of folder failed
			
	    If "resyncing" we are just writing out folder to reopen it. We
		therefore only consider deletes and keeps, not stores to mbox.
		Also we don't remove NEW status so that it can be preserved
		across the resync.

	    If "quitting" and "prompt" is false, then no prompting is done.
		Otherwise prompting is dependent upon the variable
		question_me, as set by an elmrc option.  This behavior makes
		the 'q' command prompt just like 'c' and '$', while
		retaining the 'Q' command for a quick exit that never
		prompts.
	**/

	FILE *temp;
	char temp_keep_file[SLEN], buffer[SLEN];
	FILE *keep_file = NULL;
	struct stat    buf;		/* stat command  */
#ifdef SYMLINK
	struct stat    lbuf;		/* lstat command  */
#endif
#if defined(BSD_TYPE) && !defined(UTIMBUF)
	time_t utime_buffer[2];		/* utime command */
#else
	struct utimbuf utime_buffer;	/* utime command */
#endif
	register int to_delete = 0, to_store = 0, to_keep = 0, i,
		     marked_deleted, marked_read, marked_unread,
		     last_sortby, ask_questions,  asked_storage_q,
		     num_chgd_status, need_to_copy;
	int was_symlink = FALSE;
	char answer;
	int  err;
	int current_is_received = same_file(recvd_mail,
					    current_folder->cur_folder);
	long bytes();

	if (resyncing) {
	  dprint(1, (debugfile, "\n\n-- syncing folder --\n\n"));
	} else {
	  dprint(1, (debugfile, "\n\n-- leaving folder --\n\n"));
	}
	if (current_is_received) {
	  dprint(1, (debugfile, "*** Current folder is =received !\n"));
	}


	if (message_count == 0) {
	  if (current_folder->folder_type == NON_SPOOL && 
	      !keep_empty_files && !resyncing &&
	      0 == bytes(current_folder->cur_folder)) {

	    /* i.e. if no messages were and this is not a spool
	     * folder and we aren't keeping empty non-spool folders,
	     * simply remove the old original folder and that's it!
	     */
	    close_folder(current_folder);
	    if (0 == unlink(current_folder->cur_folder)) {

	      dprint(3, (debugfile, "Removing folder!\n"));
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFolderRemoved,
				"Folder removed."));

	    }
	    return(1);
	  }

	  if (!resyncing) 
	    /* do not close folder in resyncing,
	     * because it will cause lost of session lock
	     */
	    close_folder(current_folder);
	  return(0);	/* nothing changed */

	}
	ask_questions = ((quitting && !prompt) ? FALSE : question_me);

	/* YES or NO on softkeys */
	/*
	if (hp_softkeys && ask_questions) {
	  define_softkeys(YESNO);
	  softkeys_on();
	}
	*/

	/* Clear the exit dispositions of all messages, just in case
	 * they were left set by a previous call to this function
	 * that was interrupted by the receipt of new mail.
	 */
	for(i = 0; i < message_count; i++)
	  headers[i]->exit_disposition = UNSET;
	  
	/* Determine if deleted messages are really to be deleted */

	/* we need to know if there are none, or one, or more to delete */
	for (marked_deleted=0, i=0; i<message_count && marked_deleted<2; i++)
	  if (ison(headers[i]->status, DELETED))
	    marked_deleted++;

        if(marked_deleted) {
	  answer = (always_del ? *def_ans_yes : *def_ans_no);	/* default answer */
	  if(ask_questions) {
	    if (marked_deleted == 1)
	      elm_sfprintf(buffer, sizeof buffer,
			   CATGETS(elm_msg_cat, ElmSet, ElmLeaveDeleteMessage,
				   "Delete message? (%c/%c) "), 
			   *def_ans_yes, *def_ans_no);
	    else
	      elm_sfprintf(buffer, sizeof buffer,
			   CATGETS(elm_msg_cat, ElmSet, ElmLeaveDeleteMessages,
				   "Delete messages? (%c/%c) "), 
			   *def_ans_yes, *def_ans_no);
	    answer = want_to(buffer, answer, elm_LINES-3, 0);
	  }

	  if(answer == *def_ans_yes) {
	    for (i = 0; i < message_count; i++) {
	      if (ison(headers[i]->status, DELETED)) {
		headers[i]->exit_disposition = DELETE;
		to_delete++;
	      }
	    }
	  }
	}
	dprint(3, (debugfile, "Messages to delete: %d\n", to_delete));

	/* If this is a non spool file( or if received folder is treated
         * as mailbox because of protection mask of folder) , or if we are 
	 * merely resyncing, all messages with an unset disposition (i.e. 
         * not slated for deletion) are to be kept.
	 * Otherwise, we need to determine if read and unread messages
	 * are to be stored or kept.
	 */
	if(current_folder->folder_type == NON_SPOOL ||
	   current_is_received || resyncing) {
	  to_store = 0;
	  for (i = 0; i < message_count; i++) {
	    if(headers[i]->exit_disposition == UNSET) {
	      headers[i]->exit_disposition = KEEP;
	      to_keep++;
	    }
	  }
	} else {

	  /* Let's first see if user wants to store read messages 
	   * that aren't slated for deletion */

	  asked_storage_q = FALSE;

	  /* we need to know if there are none, or one, or more marked read */
	  for (marked_read=0, i=0; i < message_count && marked_read < 2; i++) {
	    if((isoff(headers[i]->status, UNREAD))
	      && (headers[i]->exit_disposition == UNSET))
		marked_read++;
	  }
	  if(marked_read) {
	    answer = (always_store ? *def_ans_yes : *def_ans_no);	/* default answer */
	    if(ask_questions) {
	      if (marked_read == 1)
		elm_sfprintf(buffer, sizeof buffer,
			     CATGETS(elm_msg_cat, ElmSet, ElmLeaveMoveMessage,
				     "Move read message to \"received\" folder? (%c/%c) "),
			     *def_ans_yes, *def_ans_no);
	      else
		elm_sfprintf(buffer, sizeof buffer,
			     CATGETS(elm_msg_cat, ElmSet, ElmLeaveMoveMessages,
				     "Move read messages to \"received\" folder? (%c/%c) "),
			     *def_ans_yes, *def_ans_no);
	      answer = want_to(buffer, answer, elm_LINES-3, 0);
	      asked_storage_q = TRUE;
	    }

	    for (i = 0; i < message_count; i++) {
	      if((isoff(headers[i]->status, UNREAD)) 
		&& (headers[i]->exit_disposition == UNSET)) {

		  if(answer == *def_ans_yes) {
		    headers[i]->exit_disposition = STORE;
		    to_store++;
		  } else {
		    headers[i]->exit_disposition = KEEP;
		    to_keep++;
		  }
	      }
	    } 
	  }

	  /* If we asked the user if read messages should be stored,
	   * and if the user wanted them kept instead, then certainly the
	   * user would want the unread messages kept as well.
	   */
	  if(asked_storage_q && answer == *def_ans_no) {

	    for (i = 0; i < message_count; i++) {
	      if((ison(headers[i]->status, UNREAD))
		&& (headers[i]->exit_disposition == UNSET)) {
		  headers[i]->exit_disposition = KEEP;
		  to_keep++;
	      }
	    }

	  } else {

	    /* Determine if unread messages are to be kept */

	    /* we need to know if there are none, or one, or more unread */
	    for (marked_unread=0, i=0; i<message_count && marked_unread<2; i++)
	      if((ison(headers[i]->status, UNREAD))
		&& (headers[i]->exit_disposition == UNSET))
		  marked_unread++;

	    if(marked_unread) {
	      answer = (always_keep ? *def_ans_yes : *def_ans_no);	/* default answer */
	      if(ask_questions) {
		if (marked_unread == 1)
		  elm_sfprintf(buffer, sizeof buffer,
			       CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepMessage,
		    "Keep unread message in incoming mailbox? (%c/%c) "),
			       *def_ans_yes, *def_ans_no);
		else
		  elm_sfprintf(buffer, sizeof buffer,
			       CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepMessages,
				       "Keep unread messages in incoming mailbox? (%c/%c) "),
			       *def_ans_yes, *def_ans_no);
		answer = want_to(buffer, answer, elm_LINES-3, 0);
	      }

	      for (i = 0; i < message_count; i++) {
		if((ison(headers[i]->status, UNREAD))
		  && (headers[i]->exit_disposition == UNSET)) {

		    if(answer == *def_ans_no) {
		      headers[i]->exit_disposition = STORE;
		      to_store++;
		    } else {
		      headers[i]->exit_disposition = KEEP;
		      to_keep++;
		    }
	      
		}
	      }
	    }
	  }
	}

	dprint(3, (debugfile, "Messages to store: %d\n", to_store));
	dprint(3, (debugfile, "Messages to keep: %d\n", to_keep));

	if(to_delete + to_store + to_keep != message_count) {
	  MoveCursor(elm_LINES, 0);
	  Raw(OFF);
	  dprint(1, (debugfile,
	  "Error: %d to delete + %d to store + %d to keep != %d message cnt\n",
	    to_delete, to_store, to_keep, message_count));
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSomethingWrongInCounts,
			    "Something wrong in message counts! Folder unchanged.\n"));
	  emergency_exit(0);
	}
	  

	/* If we are not resyncing, we are leaving the mailfile and
	 * the new messages are new no longer. Note that this changes
	 * their status.
	 */
	if(!resyncing) {
	  for (i = 0; i < message_count; i++) {
	    if (ison(headers[i]->status, NEW)) {
	      clearit(headers[i]->status, NEW);
	      headers[i]->status_chgd = TRUE;
	    }
	  }
	}

	/* If all messages are to be kept and none have changed status
	 * we don't need to do anything because the current folder won't
	 * be changed by our writing it out - unless we are resyncing, in
	 * which case we force the writing out of the mailfile.
	 */

	for (num_chgd_status = 0, i = 0; i < message_count; i++)
	  if(headers[i]->status_chgd == TRUE)
	    num_chgd_status++;
	
	if(!to_delete && !to_store && !num_chgd_status && !resyncing) {
	  dprint(3, (debugfile, "Folder keep as is!\n"));
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFolderUnchanged,
			    "Folder unchanged."));
	  return(0);
	}

	/** we have to check to see what the sorting order was...so that
	    the order in which we write messages is the same as the order
	    of the messages originally.
	    We only need to do this if there are any messages to be
	    written out (either to keep or to store). **/

	if ((to_keep || to_store ) && sortby != MAILBOX_ORDER) {
	  last_sortby = sortby;
	  sortby = MAILBOX_ORDER;
	  sort_mailbox(message_count, FALSE);
	  sortby = last_sortby;
	}



	/** next, let's lock the file up and make one last size check **/

	if(!open_folder_lock(OUTGOING,current_folder))
	  return -2;  /* failure */

	/* 
	 * lock routine will call clear_error so we print our action
	 * message after it.
	 */
	
	flush_mailfile(current_folder);

	if (current_folder->mailfile_size != bytes(current_folder->cur_folder)) {
	    unlock(0,current_folder);
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveNewMailArrived,
			      "New mail has just arrived. Resynchronizing..."));
	    return(-1);
	}
	
	/* Formulate message as to number of keeps, stores, and deletes.
	 * This is only complex so that the message is good English.
	 */
	if (to_keep > 0) {
	  if (to_store > 0) {
	    if (to_delete > 0) {
	      if (to_keep == 1)
		lib_error(
			  CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepStoreDelete,
				  "[Keeping 1 message, storing %d, and deleting %d.]"), 
			  to_store, to_delete);
	      else
		lib_error(
			  CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepStoreDeletePlural,
				  "[Keeping %d messages, storing %d, and deleting %d.]"), 
			  to_keep, to_store, to_delete);
	    } else {
	      if (to_keep == 1)
		lib_error(
			  CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepStore,
				  "[Keeping 1 message and storing %d.]"), 
			  to_store);
	      else
		lib_error(
			  CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepStorePlural,
				  "[Keeping %d messages and storing %d.]"), 
			  to_keep, to_store);
	    }
	  } else {
	    if (to_delete > 0) {
	      if (to_keep == 1)
		lib_error(
			  CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepDelete,
				  "[Keeping 1 message and deleting %d.]"), 
			  to_delete);
	      else
		lib_error(
			  CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepDeletePlural,
				  "[Keeping %d messages and deleting %d.]"), 
			  to_keep, to_delete);
	    } else {
	      if (to_keep == 1)
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeep,
					"[Keeping message.]"));
	      else
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmLeaveKeepPlural,
				  "[Keeping all messages.]"));
	    }
	  }
	} else if (to_store > 0) {
	  if (to_delete > 0) {
	    if (to_store == 1)
	      lib_error(
			CATGETS(elm_msg_cat, ElmSet, ElmLeaveStoreDelete,
				"[Storing 1 message and deleting %d.]"), 
			to_delete);
	    else
	      lib_error(
			CATGETS(elm_msg_cat, ElmSet, ElmLeaveStoreDeletePlural,
				"[Storing %d messages and deleting %d.]"), 
			to_store, to_delete);
	  } else {
	    if (to_store == 1)
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveStore,
				      "[Storing message.]"));
	    else
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveStorePlural,
				"[Storing all messages.]"));
	  }
	} else {
	  if (to_delete > 0)
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveDelete,
			      "[Deleting all messages.]"));
	}

	block_signals();
	
	dprint(2, (debugfile, "Action...\n"));

	/* Store messages slated for storage in received mail folder */
	if (to_store > 0) {
	  if ((err = can_open(recvd_mail, "a"))) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveAppendDenied,
			      "Permission to append to %s denied!  Leaving folder intact.\n"),
		      recvd_mail);
	    dprint(1, (debugfile,
	      "Error: Permission to append to folder %s denied!! (%s)\n",
	      recvd_mail, "leavembox"));
	    dprint(1, (debugfile, "** %s **\n", error_description(err)));

	    unlock(0,current_folder);

	    unblock_signals();
	    return(0);
	  }

	  /* open_end_update seeks to end of file */
	  if ((temp = open_end_update(recvd_mail)) == NULL) {
	    err = errno;

	    unlock(0,current_folder);

	    dprint(1, (debugfile, "Error: could not append to file %s\n", 
	      recvd_mail));
	    dprint(1, (debugfile, "** %s **\n", error_description(err)));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveCouldNotAppend,
			      "Could not append to folder %s!\n"), 
		      recvd_mail);
	    sleep_message();

	    unblock_signals();
	    return(0);
	  }
	  
	  dprint(10, (debugfile,
		      "!! Copying from %s to %s\n",
		      current_folder->cur_folder,recvd_mail));	    

	  dprint(2, (debugfile, "Storing message%s ", plural(to_store)));
	  for (i = 0; i < message_count; i++) {
	    if(headers[i]->exit_disposition == STORE) {
	      current = i+1;
	      dprint(2, (debugfile, "#%d, ", current));
	      copy_message(MAILFILE(current_folder),headers[i],
			   "", temp, CM_UPDATE_STATUS);
	    }
	  }
	  fclose(temp);
	  dprint(2, (debugfile, "\n\n"));
	  (void) elm_chown(recvd_mail, userid, groupid);
	  if (ferror(MAILFILE(current_folder))) {
	    unlock(0,current_folder);

	    dprint(1, (debugfile, "error when reading mailfile\n"));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorReadMailfile,
			      "Error when reading mailfile %s"),
		      current_folder->cur_folder);
	    sleep_message();
	    clearerr(MAILFILE(current_folder));

	    unblock_signals();
	    return(-2);
	  }
	}

	/* If there are any messages to keep, first copy them to a
	 * temp file, then remove original and copy whole temp file over.
	 */
	if (to_keep > 0) {
	  elm_sfprintf(temp_keep_file, sizeof temp_keep_file,
		       FRM("%s%s%d"), 
		       temp_dir, temp_file, getpid());
	  if ((err = can_open(temp_keep_file, "sw"))) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveTempFileDenied,
			      "Permission to create temp file %s for writing denied! Leaving folder intact."),
		      temp_keep_file);
	    dprint(1, (debugfile,
	      "Error: Permission to create temp file %s denied!! (%s)\n",
	      temp_keep_file, "leavembox"));
	    dprint(1, (debugfile, "** %s **\n", error_description(err)));

	    unlock(0,current_folder);

	    unblock_signals();
	    return(-2);
	  }
	  if ((keep_file = fopen(temp_keep_file,"w+")) == NULL) {
	    err = errno;

	    unlock(0,current_folder);

	    dprint(1, (debugfile, "Error: could not create file %s\n", 
	      temp_keep_file));
	    dprint(1, (debugfile, "** %s **\n", error_description(err)));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveCouldNotCreate,
			      "Could not create temp file %s!"), 
		      temp_keep_file);

	    unblock_signals();
	    return(-2);
	  }

	  dprint(10, (debugfile,
		      "!! Copying from %s to %s\n",
		      current_folder->cur_folder,temp_keep_file));	    

	  dprint(2, (debugfile, "Copying to temp file message%s to be kept ",
	    plural(to_keep)));
	  for (i = 0; i < message_count; i++) {
	    if(headers[i]->exit_disposition == KEEP) {
	      current = i+1;
	      dprint(2, (debugfile, "#%d, ", current));
	      copy_message(MAILFILE(current_folder),headers[i],
			   "", keep_file, CM_UPDATE_STATUS);
	    }
	  }
	  if ( fflush(keep_file) == EOF ) {
	    err = errno;
	    unlock(0,current_folder);

	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveFlushFailedTemp,
			      "Flush failed in leavembox: %s: %s"),
		      temp_keep_file,
		      error_description(err));
	    dprint(2, (debugfile, 
		       "\n\rfflush err on temp_keep_file - leavembox\n\r"));
	    unblock_signals();
	    fclose(keep_file);
	    unlink (temp_keep_file);
	    return -2;
	  }
	  if (ferror(MAILFILE(current_folder))) {
	    unlock(0,current_folder);

	    dprint(1,(debugfile,"Failed to read mailfile!"));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorReadMailfile,
			      "Error when reading mailfile %s"),
		      current_folder->cur_folder);
	    sleep_message();

	    unblock_signals();
	    clearerr(MAILFILE(current_folder));
	    fclose(keep_file);
	    unlink (temp_keep_file);

	    return -2;
	  }

	  dprint(2, (debugfile, "\n\n"));

	} else if (current_folder->folder_type == NON_SPOOL && 
		   !keep_empty_files && !resyncing) {

	  /* i.e. if no messages were to be kept and this is not a spool
	   * folder and we aren't keeping empty non-spool folders,
	   * simply remove the old original folder and that's it!
	   */
	  if (0 == unlink(current_folder->cur_folder)) {
	    dprint(3, (debugfile, "Removing folder!\n"));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFolderRemoved,
			      "Folder removed."));	
	  }
	  unblock_signals();
	  return(1);
	}

	dprint(10, (debugfile,
		    "!! Need copy (or link) from %s to %s\n",
		    temp_keep_file, current_folder->cur_folder));	    

	/* Otherwise we have some work left to do! */

	/* Get original permissions and access time of the original
	 * mail folder before we remove it.
	 */
	if(save_file_stats(current_folder->cur_folder) != 0) {
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveProblemsSavingPerms,
			    "Problems saving permissions of folder %s!"), 
		    current_folder->cur_folder);

	  sleep_message();
	}
	  
        if (stat(current_folder->cur_folder, &buf) != 0) {
	  err = errno;
	  dprint(1, (debugfile, "Error: errno %s attempting to stat file %s\n", 
		     error_description(err), 
		     current_folder->cur_folder));
          lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveErrorOnStat,
			    "Error %s on stat(%s)."), 
		    error_description(err), 
		    current_folder->cur_folder);

	  sleep_message();
	}

#ifdef SYMLINK
        if (lstat(current_folder->cur_folder, &lbuf) != 0) {
	  err = errno;
	  dprint(1, (debugfile, "Error: errno %s attempting to stat file %s\n", 
		     error_description(err), 
		     current_folder->cur_folder));
          lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveErrorOnStat,
			    "Error %s on stat(%s)."), 
		    error_description(err), 
		    current_folder->cur_folder);
	  sleep_message();
	}
#endif

	/* Close and remove the original folder.
	 * However, if we are going to copy a temp file of kept messages
	 * to it, and this is a locked (spool) mailbox, we need to keep
	 * it locked during this process. Unfortunately,
	 * if we did our USE_FLOCK_LOCKING or USE_FCNTL_LOCKING unlinking
	 * the original will kill the lock, so we have to resort to copying
	 * the temp file to the original file while keeping the original open.
	 * Also, if the file has a link count > 1, then it has links, so to
	 * prevent destroying the links, we do a copy back, even though its
	 * slower.  If the file is a symlink, then we also need to do a copy
	 * back to prevent destroying the linkage.
	 */

	/*
	 * fclose(mailfile);
	 *
	 * While this fclose is OK for BSD flock file locking, it is
	 * incorrect for SYSV fcntl file locking.  For some reason AT&T
	 * decided to release all file locks when *any* fd to a file
	 * is closed, even if it is not the fd that acquired the lock.
	 * Thus this fclose would release the mailbox file locks.
	 * Instead I am going to just fflush the file here, and do the
	 * individual closes in the subcases to ensure that the
	 * mailbox is locked until we are finished with it.
	 */

	flush_mailfile(current_folder);

#ifdef SYSCALL_LOCKING
	if (current_folder->folder_type == SPOOL) {
	  dprint(10, (debugfile,"* SYSCALL_LOCKING (SPOOL)\n"));
	  need_to_copy = TRUE;
	}
	else
#endif /* SYSCALL_LOCKING */
	  need_to_copy = FALSE;

	if (buf.st_nlink > 1) {
	  dprint(10, (debugfile,"* several links\n"));
	  need_to_copy = TRUE;
	}

	if (buf.st_mode & 07000) { /* copy if special modes set */
	  dprint(10, (debugfile,"* special modes\n"));
	  need_to_copy = TRUE;    /* such as enforcement lock */
	}

#ifdef SYMLINK
#ifdef S_ISLNK
	if (S_ISLNK(lbuf.st_mode)) {
#else
	if ((lbuf.st_mode & S_IFMT) == S_IFLNK) {
#endif
	  dprint(10, (debugfile,"* symlink\n"));
		need_to_copy = TRUE;
		was_symlink = TRUE;
	}
#endif

#ifdef _PC_CHOWN_RESTRICTED
	if (!need_to_copy) {
/*
 * Chown may or may not be restricted to root in SVR4, if it is,
 *	then need to copy must be true, and no restore of permissions
 *	should be performed.
 */
		if (pathconf(current_folder->cur_folder, 
			     _PC_CHOWN_RESTRICTED)) {
		  dprint(10, (debugfile,"* _PC_CHOWN_RESTRICTED\n"));

			need_to_copy = TRUE;
		}
	}
#endif  /* _PC_CHOWN_RESTRICTED */

	if (current_folder -> folder_type != SPOOL && lockfolders) {
	  dprint(10, (debugfile,"* lockfolders\n"));
	  need_to_copy = TRUE;
	}


	dprint(10, (debugfile,
		    "-- need_to_copy=%d\n",
		    need_to_copy));

	if(to_keep) {

#ifdef SAVE_GROUP_MAILBOX_ID
	  if (current_folder->folder_type == SPOOL)
      	    setgid(mailgroupid);
#endif

	  if(!need_to_copy) {
	    unlink(current_folder->cur_folder);
	    dprint(10, (debugfile,
			"!! unlinked current folder: %s\n",
			current_folder->cur_folder));

	    if (link(temp_keep_file, current_folder->cur_folder) != 0) {
	      if(errno == EXDEV || errno == EEXIST) {
		int err = errno;
		/* oops - can't link across file systems - use copy instead */

		dprint(10, (debugfile, "link(%s, %s) failed: %s\n", 
			    temp_keep_file, current_folder->cur_folder,
			    error_description(err)));		
		need_to_copy = TRUE;
	      } else {
		int err = errno;
		dprint(1, (debugfile, "link(%s, %s) failed (leavembox)\n", 
		       temp_keep_file, current_folder->cur_folder));
		dprint(1, (debugfile, "** %s **\n", error_description(err)));
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveLinkFailed,
				  "Link failed! %s.\n"), 
			  error_description(err));
		sleep_message();
		need_to_copy = TRUE;
	      }
	    } else {
	      dprint(10, (debugfile, "!! linked %s to  %s\n", 
			  temp_keep_file, current_folder->cur_folder));
	    }
	    if (current_folder->fh_folder)
	      fclose(current_folder->fh_folder);
	    current_folder->fh_folder = NULL;

	    current_folder->fh_folder = 
	      open_or_create(current_folder->cur_folder);
	    
	    if (NULL == current_folder->fh_folder) {
	      goto PANIC_copy_failed;
	    }
	    dprint(10, (debugfile,
			"!! reopened (created) current folder after unlink: %s\n",
			current_folder->cur_folder));	    
	  }

	  if(need_to_copy) {
	    char new_cur_folder[100];

	    rewind(keep_file);
	    if (copy_to_folder(keep_file, current_folder) != 0) {

	      /* copy to cur_folder failed - try to copy to special file */
	      err = errno;
	      dprint(1, (debugfile, "leavembox: copy(%s, %s) failed;",
		      temp_keep_file, current_folder->cur_folder));
	      dprint(1, (debugfile, "** %s **\n", error_description(err)));
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveCouldntModifyFolder,
				"Couldn't modify folder!"));

	    PANIC_copy_failed:

	      if (sleepmsg > 0)
		    sleep((sleepmsg + 1) / 2);

	      elm_sfprintf(new_cur_folder,sizeof new_cur_folder,
			   FRM("%s/%s"), home, unedited_mail);
	      if (copy1(keep_file, new_cur_folder, FALSE) != 0) {

		/* couldn't copy to special file either */
		err = errno;
		MoveCursor(elm_LINES, 0);
		Raw(OFF);
		dprint(1, (debugfile, 
			"leavembox: couldn't copy to %s either!!  Help;", 
			new_cur_folder));
		dprint(1, (debugfile, "** %s **\n", error_description(err)));
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveCantCopyMailbox,
				  "Can't copy folder, system trouble : contents preserved in %s\n"),
			  temp_keep_file);
#ifdef SAVE_GROUP_MAILBOX_ID
	        if (current_folder->folder_type == SPOOL)
		  setgid(groupid);
#endif
		fclose(keep_file);
		close_folder(current_folder);
		emergency_exit(0);
	      } else {
		dprint(1, (debugfile,
			"\nWoah! Confused - Saved mail in %s (leavembox)\n", 
			current_folder->cur_folder));
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveSavedMailIn,
				  "Saved mail in %s."), 
			  current_folder->cur_folder);
		sleep_message();
	      }
	    }
	  }

	  /* link or copy complete - remove temp keep file */
	  unlink(temp_keep_file);
	  fclose(keep_file);
	  keep_file = NULL;

	} else if(current_folder->folder_type == SPOOL || 
		  keep_empty_files || resyncing) {

	  /* if this is an empty spool file, or if this is an empty non spool 
	   * file and we keep empty non spool files (we always keep empty
	   * spool files), create an empty file */

	  if(current_folder->folder_type == NON_SPOOL)
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepingEmpty,
			      "Keeping empty folder '%s'."), 
		      current_folder->cur_folder);
	  temp = fopen(current_folder->cur_folder, "w");
	  fclose(temp);
	}

	/*
	 * restore permissions and access times of folder only if not
	 * a symlink, as symlinks have no permissions, and not worth
	 * tracking down what it points to.
	 */

	if (!was_symlink) {
	  if(restore_file_stats(current_folder->cur_folder) != 1) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveProblemsRestoringPerms,
			      "Problems restoring permissions of folder %s!"),
		      current_folder->cur_folder);
	    sleep_message();
	  }
	}

#if defined(BSD_TYPE) && !defined(UTIMBUF)
	utime_buffer[0]     = buf.st_atime;
	utime_buffer[1]     = buf.st_mtime;
#else
	utime_buffer.actime = buf.st_atime;
	utime_buffer.modtime= buf.st_mtime;
#endif

#if defined(BSD_TYPE) && !defined(UTIMBUF)
	if (utime(current_folder->cur_folder, utime_buffer) != 0) 
#else
	if (utime(current_folder->cur_folder, &utime_buffer) != 0) 
#endif
	{
	  err = errno;
	  dprint(1, (debugfile, 
		 "Error: encountered error doing utime (leavmbox)\n"));
	  dprint(1, (debugfile, "** %s **\n", error_description(err)));
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveChangingAccessTime,
			    "Error %s trying to change file %s access time."), 
		    error_description(err), 
		    current_folder->cur_folder);
	}
#ifdef SAVE_GROUP_MAILBOX_ID
	if (current_folder->folder_type == SPOOL)
	    setgid(groupid);
#endif

	current_folder->mailfile_size = bytes(current_folder->cur_folder);
	if (resyncing) 
	  /* do not close folder in resyncing,
	   * because it will cause lost of session lock
	   */
	  unlock(0,current_folder);
	else
	  close_folder(current_folder);
	unblock_signals();
	return(1);	
}

#ifdef HASSIGPROCMASK
	sigset_t	toblock, oldset;
#else  /* HASSIGPROCMASK */
#  ifdef HASSIGBLOCK
	int		toblock, oldset;
#  else /* HASSIGBLOCK */
#    ifdef HASSIGHOLD
	/* Nothing required */
#    else /* HASSIGHOLD */
	SIGHAND_TYPE	(*oldhup)();
	SIGHAND_TYPE	(*oldint)();
	SIGHAND_TYPE	(*oldquit)();
	SIGHAND_TYPE	(*oldstop)();
#    endif /* HASSIGHOLD */
#  endif /* HASSIGBLOCK */
#endif /* HASSIGPROCMASK */

/*
 * Block all keyboard generated signals.  Need to do this while
 * rewriting mailboxes to avoid inadvertant corruption.  In
 * particular, a SIGHUP (from logging out under /bin/sh), can
 * corrupt a spool mailbox during an elm autosync.
 */

static void block_signals()
{
	dprint(1,(debugfile, "block_signals\n"));
#ifdef HASSIGPROCMASK
	sigemptyset(&oldset);
	sigemptyset(&toblock);
	sigaddset(&toblock, SIGHUP);
	sigaddset(&toblock, SIGINT);
	sigaddset(&toblock, SIGQUIT);
#ifdef SIGTSTP
	sigaddset(&toblock, SIGTSTP);
#endif /* SIGTSTP */

	sigprocmask(SIG_BLOCK, &toblock, &oldset);

#else /* HASSIGPROCMASK */
#  ifdef HASSIGBLOCK
	toblock = sigmask(SIGHUP) | sigmask(SIGINT) | sigmask(SIGQUIT);
#ifdef SIGTSTP
	toblock |= sigmask(SIGTSTP);
#endif /* SIGTSTP */

	oldset = sigblock(toblock);

#  else /* HASSIGBLOCK */
#    ifdef HASSIGHOLD
	sighold(SIGHUP);
	sighold(SIGINT);
	sighold(SIGQUIT);
#ifdef SIGTSTP
	sighold(SIGTSTP);
#endif /* SIGTSTP */

#    else /* HASSIGHOLD */
	oldhup  = signal(SIGHUP, SIG_IGN);
	oldint  = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
#ifdef SIGTSTP
	oldstop = signal(SIGTSTP, SIG_IGN);
#endif /* SIGTSTP */
#    endif /* HASSIGHOLD */
#  endif /* HASSIGBLOCK */
#endif /* HASSIGPROCMASK */
}

/*
 * Inverse of the previous function.  Restore keyboard generated
 * signals.
 */
static void unblock_signals()
{
	dprint(1,(debugfile, "unblock_signals\n"));
#ifdef HASSIGPROCMASK
	sigprocmask(SIG_SETMASK, &oldset, (sigset_t *)0);

#else  /* HASSIGPROCMASK */
#  ifdef HASSIGBLOCK
	sigsetmask(oldset);

#  else /* HASSIGBLOCK */
#    ifdef HASSIGHOLD
	sigrelse(SIGHUP);
	sigrelse(SIGINT);
	sigrelse(SIGQUIT);
#ifdef SIGTSTP
	sigrelse(SIGTSTP);
#endif /* SIGTSTP */

#    else /* HASSIGHOLD */
	signal(SIGHUP, oldhup);
	signal(SIGINT, oldint);
	signal(SIGQUIT, oldquit);
#ifdef SIGTSTP
	signal(SIGTSTP, oldstop);
#endif /* SIGTSTP */

#    endif /* HASSIGHOLD */
#  endif /* HASSIGBLOCK */
#endif /* HASSIGPROCMASK */
}
