
static char rcsid[] = "@(#)$Id: strtokq.c,v 1.2 1998/10/20 19:57:48 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/


/* Like strtok, but returns quoted strings as one token (quotes removed)
 * if flag is non-null. Quotes and backslahes can be escaped with backslash.
 */

#include "headers.h"

/* Why there is ' -- it is not quote character in mail.
 *    - K E H <hurtta@ozone.FMI.FI>
 */

char *strtokq(source, keys, flag)
     char *source, *keys;
     int flag;
{
	register int  last_ch;
	static   char *sourceptr = NULL;
		 char *return_value;

	if (source != NULL)
	  sourceptr = source;
	
	if (sourceptr == NULL || *sourceptr == '\0') 
	  return(NULL);		/* we hit end-of-string last time!? */

	sourceptr += strspn(sourceptr, keys);	/* skip leading crap */
	
	if (*sourceptr == '\0') 
	  return(NULL);		/* we've hit end-of-string */

	if (flag)
	  if (*sourceptr == '"' || *sourceptr == '\'') {   /* quoted string */
	    register char *sp;
	    char quote = *sourceptr++;

	    for (sp = sourceptr; *sp != '\0' && *sp != quote; sp++)
	      if (*sp == '\\') sp++;	/* skip escaped characters */
					/* expand_macros will fix them later */

	    return_value = sourceptr;
	    sourceptr = sp;
	    if (*sourceptr != '\0') sourceptr++;
	    *sp = '\0';				/* zero at end */

	    return return_value;
	  }

	last_ch = strcspn(sourceptr, keys);	/* end of good stuff */

	return_value = sourceptr;		/* and get the ret   */

	sourceptr += last_ch;			/* ...value 	     */

	if (*sourceptr != '\0')	/* don't forget if we're at END! */
	  sourceptr++;		   /* and skipping for next time */

	return_value[last_ch] = '\0';		/* ..ending right    */
	
	return((char *) return_value);		/* and we're outta here! */
}

