static char rcsid[] = "@(#)$Id: okay_addr.c,v 1.8 1999/05/22 13:49:48 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.8 $   $State: Exp $
 *
 *  Reimplemented by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  This code is mostly reimplemented. Original code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** 

**/

#include "headers.h"


int okay_address_l(address, return_address)
     CONST struct addr_item *address, *return_address;
{
  struct addr_rec  *alternatives;
  char our_address[SLEN]; 
  char *host_part;

 /** This routine checks to ensure that the address we just got
    from the "To:" or "Cc:" line isn't us AND isn't the person	
    who sent the message.  Returns true iff neither is the case **/

  CONST struct addr_item *ptr;

  for (ptr = return_address; ptr && ptr -> addr && ptr->fullname; ptr++) {
    if (0 == strcmp(ptr -> addr, address -> addr)) {
      dprint(25,(debugfile,"okay_address_l=FALSE:\n"));
      dprint(25,(debugfile,
		 "     address{addr=%s,fullname=%s} same as return_address {addr=%s,fullname=%s}\n",
		 address -> addr, address -> fullname,
		 ptr -> addr, ptr -> fullname));
      return(FALSE);
    }
  }

  if (0 == strcmp(username, address -> addr)) {
      dprint(25,(debugfile,"okay_address_l=FALSE:\n"));
      dprint(25,(debugfile,
		 "     address{addr=%s,fullname=%s} same as username=%s\n",
		 address -> addr, address -> fullname,
		 username));

    return(FALSE);
  }

  /* UUCP hostnames are case sensitive */
  elm_sfprintf(our_address, sizeof our_address,
	       FRM("%s!%s"), hostname, username);
  if (0 == strcmp(our_address, address -> addr)) {
      dprint(25,(debugfile,"okay_address_l=FALSE:\n"));
      dprint(25,(debugfile,
		 "     address{addr=%s,fullname=%s} same as UUCP addr=%s\n",
		 address -> addr, address -> fullname,
		 our_address));
    return(FALSE);
  }

  elm_sfprintf(our_address, sizeof our_address,
	       FRM("%s!%s"), hostfullname, username);
  if (0 == strcmp(our_address, address -> addr)) {
    dprint(25,(debugfile,"okay_address_l=FALSE:\n"));
    dprint(25,(debugfile,
	       "     address{addr=%s,fullname=%s} same as UUCP addr=%s\n",
	       address -> addr, address -> fullname,
	       our_address));
    return(FALSE);
  }

  /* Internet hostnames are case insensitive */
  host_part = qstrpbrk(address->addr,"@");
  if (host_part) {
    char * buffer = safe_malloc(host_part - address->addr +1);
    strncpy(buffer,address->addr,host_part - address->addr);
    buffer[host_part - address->addr] = '\0';

    dprint(25,(debugfile,"okay_address_l: user part=%s, host part=%s\n",
	       buffer,host_part+1));
    
    if (0 == strcmp(buffer,username)) {
      if (0 == istrcmp(hostname,host_part+1)) {
	dprint(25,(debugfile,"okay_address_l=FALSE:\n"));
	dprint(25,(debugfile,
		   "     address{addr=%s,fullname=%s} matches username=%s, hostname=%s\n",
		   address -> addr, address -> fullname,
		   username,hostname));
	free(buffer);
	return(FALSE);
      }
      
      if (0 == istrcmp(hostfullname,host_part+1)) {
	dprint(25,(debugfile,"okay_address_l=FALSE:\n"));
	dprint(25,(debugfile,
		   "     address{addr=%s,fullname=%s} matches username=%s, hostname=%s\n",
		   address -> addr, address -> fullname,
		   username,hostfullname));
	free(buffer);
	return(FALSE);
      }
    }
    free(buffer);
  }

  alternatives = alternative_addresses;  
  while (alternatives != NULL) {
    if (0 == strcmp(address->addr,alternatives->address)) {
      dprint(25,(debugfile,"okay_address_l=FALSE:\n"));
      dprint(25,(debugfile,
		 "     address{addr=%s,fullname=%s} matches alternatives=%s\n",
		 address -> addr, address -> fullname,
		 alternatives->address));
      return(FALSE);
    }
    alternatives = alternatives->next;
  }

  dprint(25,(debugfile,"okay_address_l=TRUE:\n"));
  dprint(25,(debugfile,
	     "     address{addr=%s,fullname=%s} is not our address.\n",
	     address -> addr, address -> fullname)); 
  return(TRUE);
}

