/*								-*- C++ -*-
 * $Id: WIN_multitext.cpp,v 1.3 1997-02-28 16:04:10+01 mho Exp $
 *
 * Purpose: multi text panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_multitext.h"
#endif

#define  Uses_XtIntrinsicP
#define  Uses_wxMultiText
#include "wx.h"
#define  Uses_AsciiTextWidgetPrivate
#define  Uses_EnforcerWidget
#define  Uses_ScrollWinWidget
#include <widgets.h>

#define CARET_SIZE 2

//-----------------------------------------------------------------------------
// create and destroy multiText
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxMultiText, wxText)

wxMultiText::wxMultiText(void) : wxText()
{
    __type = wxTYPE_MULTI_TEXT;
}

wxMultiText::wxMultiText(wxPanel *panel, wxFunction function, Const char *label,
			 Constdata char *value, int x, int y, int width, int height,
			 long style, Constdata char *name) : wxText()
{
    __type = wxTYPE_MULTI_TEXT;

    Create(panel, function, label, value, x, y, width, height, style, name);
}

Bool wxMultiText::Create(wxPanel *panel, wxFunction function, Const char *label,
			 Constdata char *value, int x, int y, int width, int height,
			 long style, Constdata char *name)
{
    ChainToPanel(panel, style, name);

    XFontStruct *xfont = font.GetInternalFont();

    // create frame
    FWidget() = XtVaCreateManagedWidget
	(name, xfwfEnforcerWidgetClass, GetParentWidget(parent),
	 XtNlabel,              label,
	 XtNalignment,          ((label_position == wxVERTICAL) ?
				 XfwfTop : XfwfTopLeft),
	 XtNbackground,         bg.GetPixel(&cmap),
	 XtNforeground,         label_fg.GetPixel(&cmap),
	 XtNfont,               label_font.GetInternalFont(),
	 XtNhighlightThickness, 0,
	 XtNlabelOffset,        2,
	 XtNtraversalKeys,      XfwfTraverseKeyTab,
	 NULL);
    // create viewport
    PWidget() = XtVaCreateManagedWidget
	(name, xfwfScrolledWindowWidgetClass, FWidget(),
	 XtNbackground,      bg.GetPixel(&cmap),
	 XtNhideHScrollbar,  !Boolean(style & wxHSCROLL),
	 XtNscrollingPolicy, XfwfVirtualScrolling,
	 XtNtraversalKeys,   XfwfTraverseKeyTab,
	 XtNvIncrement,      xfont->ascent+xfont->descent,
	 XtNhIncrement,      xfont->max_bounds.width,
	 NULL);
    // create multiText widget
    HWidget() = XtVaCreateManagedWidget
	(name, asciiTextWidgetClass, PWidget(),
	 XtNbackground,       bg.GetPixel(&cmap),
	 XtNforeground,       fg.GetPixel(&cmap),
	 XtNfont,             font.GetInternalFont(),
	 XtNtopMargin,        4,
	 XtNrightMargin,      2,
	 XtNborderWidth,      0,
	 XtNstring,           value,
// 	 XtNscrollVertical,   XawtextScrollNever,
// 	 XtNscrollHorizontal, XawtextScrollNever,
// 	 XtNresize,           XawtextResizeNever,
	 XtNwrap,             (style & wxHSCROLL  ? XawtextWrapNever : XawtextWrapLine),
	 XtNeditType,         (style & wxREADONLY ? XawtextRead : XawtextEdit),
	 NULL);
    // callback
    callback = function;
    XtAddCallback(XawTextGetSource(HWidget()), XtNcallback,
		  wxMultiText::EventCallback, (XtPointer)this);

    panel->PositionItem(this, x, y,
			(width  > -1 ? width  : wxMULTI_TEXT_WIDTH),
			(height > -1 ? height : wxMULTI_TEXT_HEIGHT));
    AddEventHandlers();

    return TRUE;
}

//-----------------------------------------------------------------------------
// OnChar overrides actions for cursor up/down and adjusts position of
// of the text widget.
//-----------------------------------------------------------------------------

void wxMultiText::OnChar(wxKeyEvent& event)
{
    switch (event.KeyCode()) {
    case WXK_UP: case WXK_DOWN: // up and down not used for keyb traversal
    case WXK_RETURN:		// return does not start an action
	quoted = FALSE;
	wxItem::OnChar(event);
	break;
    case WXK_NEXT:
	XtCallActionProc(HWidget(), "next-page",
			 (XEvent*)event.eventHandle, NULL, 0);
	break;
    case WXK_PRIOR:
	XtCallActionProc(HWidget(), "previous-page",
			 (XEvent*)event.eventHandle, NULL, 0);
	break;
    default:
	wxText::OnChar(event);
	break;
    }
    // set scrollbars thumbs
    AdjustScrollbars();
}

//-----------------------------------------------------------------------------
// Scroll and OnScroll handle the scrollbars of the text item
//-----------------------------------------------------------------------------

void wxMultiText::Scroll(int WXUNUSED(x), int WXUNUSED(y))
{
    // do nothing
}

void wxMultiText::OnScroll(wxCommandEvent& event)
{
    AsciiWidget ctx = (AsciiWidget)HWidget();

    if (WXSCROLLORIENT(event) == wxHORIZONTAL) {
	// modify left margin
	int old_left = ctx->text.margin.left;
	ctx->text.margin.left = ctx->text.r_margin.left - WXSCROLLPOS(event);
	if (ctx->text.margin.left != old_left) {
	    // redraw textwindow
	    Refresh();
	    // adjust scrollbars
	    if (event.eventType != wxEVENT_TYPE_SCROLL_THUMBTRACK)
		AdjustScrollbars();
	}
    } else {
	char *action = NULL;
	switch (event.eventType) {
	case wxEVENT_TYPE_SCROLL_THUMBTRACK: action = NULL; break;
	case wxEVENT_TYPE_SCROLL_LINEDOWN:   action = "next-line"; break;
	case wxEVENT_TYPE_SCROLL_LINEUP:     action = "previous-line"; break;
	case wxEVENT_TYPE_SCROLL_PAGEDOWN:   action = "next-page"; break;
	case wxEVENT_TYPE_SCROLL_PAGEUP:     action = "previous-page"; break;
	case wxEVENT_TYPE_SCROLL_TOP:        action = "beginning-of-file"; break;
	case wxEVENT_TYPE_SCROLL_BOTTOM:     action = "end-of-file"; break;
	}
	if (action) {
	    XEvent event;
	    memset(&event, 0, sizeof(event));
	    XtCallActionProc(HWidget(), action, (XEvent*)&event, NULL, 0);
	    AdjustScrollbars();
	} else {
	    XfwfScrollInfo *sinfo = (XfwfScrollInfo*)event.eventHandle;
	    XawTextSetInsertionPoint(HWidget(), long(ctx->text.lastPos*sinfo->vpos+.5));
	}
    }
}

void wxMultiText::AdjustScrollbars(void)
{
    AsciiWidget           ctx    = (AsciiWidget)HWidget();
    Widget                sink   =  ctx->text.sink;
    XawTextLineTableEntry *lt    =  ctx->text.lt.info;
    int                   lines  =  ctx->text.lt.lines;
    long                  top    =  ctx->text.lt.top;
    long                  last   =  ctx->text.lastPos;
    int                   margin =  ctx->text.r_margin.left;
    int                   xpos   = -ctx->text.margin.left;

    int  width = 0;
    int  line  = 0;
    long pos   = top;

    // compute maximal width
    for (/**/; line < ctx->text.lt.lines; line++) {
	int rw, rh; long rp;
	XawTextSinkFindDistance(sink, pos, margin, lt[line+1].position-1, &rw, &rp, &rh);
	width = wxMax(width, rw);
	pos   = lt[line+1].position;
    }
    // adjustments of width and "height"
    width += ctx->text.r_margin.right;
    // set scrollbars
    float visible = ((last && lt && lines) ? (float(lt[lines].position - top) / float(last)) : 1.0);
    XfwfSetScrolledWindow(PWidget(), xpos, top, width, last, -1, visible);
}

//-----------------------------------------------------------------------------
// OnSize adjusts the size of the text widget during resize to fit into the
// scrolled window widget
//-----------------------------------------------------------------------------

void wxMultiText::OnSize(int width, int height)
{
    AsciiWidget ctx = (AsciiWidget)HWidget();

    // resize text widget to fit into panel
    Position x, y; Dimension w, h;
    XfwfCallComputeInside(PWidget(), &x, &y, &w, &h);
    XtVaSetValues(HWidget(), XtNwidth,  w, XtNheight, h, NULL);
    // reset horizontal scrolling
    ctx->text.margin.left = ctx->text.r_margin.left;
    // chain to parent method
    wxText::OnSize(width, height);
}

void wxMultiText::OnPaint(void)
{
    // adjust scrollbars
    AdjustScrollbars();
    // chain to ancestor method
    wxText::OnPaint();
}

//-----------------------------------------------------------------------------
// copy value to buffer
//-----------------------------------------------------------------------------

void wxMultiText::GetValue(char *buffer, int size)
{
    *buffer = 0;
    char *s = GetValue();
    if (s) {
	if (strlen(s) > (unsigned)(size-1)) {
	    strncpy(buffer, s, size-1);
	    buffer[size-1] = 0;
	} else
	    strcpy(buffer, s);
    }
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------

long wxMultiText::FirstPosition(void)
{
    return (0L);
}

long wxMultiText::FirstVisiblePosition(void)
{
    AsciiWidget ctx = (AsciiWidget)HWidget();

    return (ctx->text.lt.top);
}

long wxMultiText::LastVisiblePosition(void)
{
    AsciiWidget ctx = (AsciiWidget)HWidget();

    if (!ctx->text.lt.info || !ctx->text.lt.lines)
	return (ctx->text.lastPos);
    return (ctx->text.lt.info[ctx->text.lt.lines].position - 1);
}

long wxMultiText::LastPosition(void)
{
    AsciiWidget ctx = (AsciiWidget)HWidget();

    return (ctx->text.lastPos);
}

//-----------------------------------------------------------------------------
// callback for multiTextWidgetClass
//-----------------------------------------------------------------------------

void wxMultiText::EventCallback(Widget WXUNUSED(w),
				XtPointer clientData, XtPointer WXUNUSED(ptr))
{
    wxMultiText         *multiText = (wxMultiText*)clientData;
    wxCommandEvent event(wxEVENT_TYPE_MULTITEXT_COMMAND);

    event.eventObject   = multiText;
    event.commandString = multiText->GetValue();

    multiText->ProcessCommand(event);
}

//-----------------------------------------------------------------------------
// code taken from the Athena text widget (Xaw/Text.c)
// should work for X11R5 and X11R6
//-----------------------------------------------------------------------------

/*
 * This routine maps a source position in to the corresponding line number
 * of the text that is displayed in the window.
 *
 * NOTE: It is illegal to call this routine unless there is a valid line table!
 */

int wxMultiText::LineForPosition(long position)
{
    AsciiWidget ctx = (AsciiWidget)HWidget();
    int line;

    for (line = 0; line < ctx->text.lt.lines; line++)
	if (position < ctx->text.lt.info[line + 1].position)
	    break;
    return (line);
}

/*
 * This routine maps a source position into the corresponding line number
 * and the x, y coordinates of the text that is displayed in the window.
 *
 * NOTE: It is illegal to call this routine unless there is a valid line table!
 */

Bool wxMultiText::LineAndXYForPosition(long pos, int *line, Position *x, Position *y)
{
    AsciiWidget ctx = (AsciiWidget)HWidget();
    XawTextPosition linePos, endPos;
    Boolean visible;
    int realW, realH;

    *line = 0;
    *x = ctx->text.margin.left;
    *y = ctx->text.margin.top;

    if (ctx->text.lt.lines == 0 || ctx->text.lt.info == NULL)
	return (False);

    if ((visible = IsPositionVisible(ctx, pos))) {
	*line = LineForPosition(pos);
	*y = ctx->text.lt.info[*line].y;
	*x = ctx->text.margin.left;
	linePos = ctx->text.lt.info[*line].position;
	XawTextSinkFindDistance( ctx->text.sink, linePos,
				 *x, pos, &realW, &endPos, &realH);
	*x += realW;
    }
    return (visible);
}

int wxMultiText::LastLine(void)
{
    AsciiWidget ctx = (AsciiWidget)HWidget();
    Widget src = XawTextGetSource(HWidget());

    int line = 0;
    XawTextPosition pos = 0, endpos = 0;

    while (True) {
	endpos = XawTextSourceScan(src, pos, XawstEOL, XawsdRight, 1, TRUE);
	// break, if the end is reached
	if ( endpos == ctx->text.lastPos)
	    if (XawTextSourceScan(src, pos, XawstEOL, XawsdRight, 1, FALSE) == endpos)
		break;
	pos = endpos;
	++line;
    }
    return line;
}

int wxMultiText::TopLine(void)
{
    return LineForPosition(XawTextTopPosition(HWidget()));
}
