#include <stdio.h>
#include <wchar.h>
#include <locale.h>

int main(int argc, char **argv)
{
  char src[BUFSIZ],*p;
  wchar_t dst[BUFSIZ], *wp, *dummy;
  FILE *F;
  char *progname = argv[0];
  size_t srclim,dstlim;
  int i,ret;

  setlocale(LC_CTYPE, "");
  setlocale(LC_MESSAGES, "");
  
  switch (argc) {
  case 3:
    F=stdin;
    break;
  case 4:
    if ((F=fopen(argv[3],"r")) == NULL) {
      fprintf(stderr,"%s:can't open file %s\n",argv[0],argv[1]);
      exit(1);
    }
    break;
  default:
    fprintf(stderr, "usage: %s <srclim> <dstlim> [<filename>]\n", progname);
    exit (0);
  }

  srclim = (size_t)strtol(argv[1],&dummy,0);
  dstlim = (size_t)strtol(argv[2],&dummy,0);

  p=src;
  while (fgets(p, BUFSIZ, F)!=NULL) {
    mbsnrtowcs(NULL,NULL,0,0,NULL);
    if ((ret=mbsnrtowcs(dst,&p,srclim,dstlim,NULL))<0) {
      fprintf(stderr,"%s: wcsnrtombs() error\n",progname);
      exit(1);
    }
    for (i=0; i<ret; i++) {
      printf("0x%08lX\n",dst[i]);
    }

  }

  exit(0);
  return;
}
