/*
 * Copyright (c) 1997, 1998 Akira Yoshiyama <yosshy@debian.or.jp>
 * Copyright (c) 1998 Fumitoshi UKAI <ukai@debian.or.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public Licenses as
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * mbrtowc_locale ()
 * for conversion from multibyte character to UCS-4
 * programed
 *   by A. Yoshiyama (yosshy@jedi.seg.kobe-u.ac.jp)
 *   on Dec.17,1996
 */

#include <wchar.h>
#include <wcsmbs_locale.h>

#if DEBUG
#include <stdio.h>
#include <stdlib.h>
#endif

extern size_t
dll_mbsnrtowcs_locale (wchar_t *, const char **, size_t, size_t, mbstate_t *);

size_t
dll_mbrtowc_locale(pwc, s, n, ps)
     wchar_t *pwc;
     const char *s;
     size_t n;
     mbstate_t *ps;
{
  static mbstate_t internal = {0, (wint_t)0};
  const char *s_orig = s;
  size_t result;

#if DEBUG
  fprintf(stderr,"%s:dll_mbrtowc_locale(pwc, s, n, ps)\n",
	  getenv(MONENV));
  fprintf(stderr,"pwc=%p, s=%p, n=%d, ps=%p)\n", pwc, s, n, ps);
#endif

  if (ps == NULL)
    ps = &internal;

  if (s == NULL)
    {
      result = (size_t)((ps->count != 0) || (ps->value != (wint_t)0));
      ps->count = 0;
      ps->value = (wint_t)0;
    }
  else
    if (*s == '\0')
      {
	if (pwc)
	  *pwc = (wchar_t)0;
	result = 0;
      }
    else
      {
	/* XXX: if pwc == NULL, then dstlim parameter (size_t)1 will be ignored */
	wchar_t pwc_buf[2];
	if (pwc == NULL) 
	  pwc = &pwc_buf[0];

	result = dll_mbsnrtowcs_locale(pwc, &s, n, (size_t)1, ps);
	/* mbrtowc() returns number of bytes, while
	 * mbsrtowcs() returns number of array elements
	 */
	if ((int)result > 0)
	  result = (s - s_orig);
	else if ((int)result < 0)
	  result = (size_t)-1;
      }

#if DEBUG
  fprintf(stderr,"dll_mbrtowc_locale:result = %d\n", result);
#endif

  return result;
}
