#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <Xm/BulletinB.h>
#include <Xm/GrabShell.h>
#include <Xm/List.h>
#include <Xm/PushB.h>
#include "../combobox/XdbPrintTree.c"

/*
This tests the grab shell widget which is a component of the combo box.
*/
void onActivate(Widget w, XtPointer mydata, XtPointer cbs)
{
  Widget grabshell = (Widget) mydata;

  XtPopupSpringLoaded(grabshell);
}

int
main(int argc, char **argv)
{
  Widget toplevel, grabshell, bb, list, pressme;
  XtAppContext app;
  XmString item;

  XtSetLanguageProc(NULL, NULL, NULL);

  toplevel = XtVaAppInitialize(&app, "GrabShell", NULL, 0, &argc, argv, NULL, NULL);

  bb = XmCreateBulletinBoard(toplevel, "bb", NULL, 0);

  
  pressme = XmCreatePushButton(bb,"Press me and let's see what the grab shell does.",NULL,0);
  
  XtManageChild(pressme);

  XtManageChild(bb);

  grabshell = XmCreateGrabShell(bb, "grab", NULL, 0);
  list = XmCreateList(grabshell, "list", NULL, 0);

  /* use list routine to add items */
  item = XmStringCreateSimple("Item 1");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 2");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 3");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 4");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 5");
  XmListAddItem(list,item,0);

  XtManageChild(list);

  /* setup callback for an activate action */
  XtAddCallback(pressme, 
                XmNactivateCallback,
                (XtCallbackProc) onActivate, 
                (XtPointer) grabshell);

  XtRealizeWidget(toplevel);

  #if 1
  XdbPrintCompleteTree(grabshell);
  #endif

  XtAppMainLoop(app);

  exit(0);
}

