/**
 *
 * $Id: PopupUtil.c,v 1.2 1998/09/24 15:37:39 pgw Exp $
 *
 * Copyright (C) 1998 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static const char rcsid[] = "$Id: PopupUtil.c,v 1.2 1998/09/24 15:37:39 pgw Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <XmI/PopupUtil.h>

/* This file contains functions from previous versions that are now obsolete */

/*
  MODULE: PopupUtil.c
  DESCRIPTION:
  This module contains routines that wrap the XtPopup family of 
  routines.  Also a smart placement routine is provided for shells.
  END:
*/

/* Public routine(s): */
/*
  FUNCTION: XmeShellSmartPlacement
  SYNOPSIS: XmeShellSmartPlacement(Widget w)
  DESCRIPTION:
  This function attempts to be smart about placement of the shell on the 
  display.  It adjusts the suggested x and y placement values if possible to
  display shell completely on the screen.
  END:
*/

void
XmeShellSmartPlacement(Widget w)
{
   Display *dpy;
   int x,y,width,height;
   int dpy_width, dpy_height, scr;

   dpy = XtDisplay(w);
   scr = XDefaultScreen(dpy);

   dpy_width = DisplayWidth(dpy,scr);
   dpy_height = DisplayHeight(dpy,scr);

   /* Is shell realized? */
   if(!XtIsRealized(w))
   {  
      /* Force size calculation */
      XtRealizeWidget(w);
   }

   x = XtX(w);
   y = XtY(w);

   width = XtWidth(w);
   height = XtHeight(w);
   
   /* adjust based on default width and height of display */
   if (y+height > dpy_height) y = dpy_height - height; 
   if (x+width > dpy_width) x = dpy_width - width; 

   /* last check always keep x and y visible */
   if (x < 0) x = 0;
   if (y < 0) y = 0;

   /* if we changed something then reset X and Y */
   if(XtX(w) != x || XtY(w) != y) XtVaSetValues(w, XmNx, x, XmNy, y, NULL);
}

/*
  FUNCTION: XmePopup
  SYNOPSIS: void XmePopup(Widget w, XtGrabKind kind)
  DESCRIPTION:
  This function just calls XtPopup for now.
  END:
*/
void
XmePopup(Widget w, XtGrabKind kind)
{
   XtPopup(w, kind);
}

/*
  FUNCTION: XmePopupSpringLoaded
  SYNOPSIS: void XmePopupSpringLoaded(Widget w)
  DESCRIPTION:
  This function just calls XtPopupSpringLoaded for now.
  END:
*/
void
XmePopupSpringLoaded(Widget w)
{
   XtPopupSpringLoaded(w);
}

