#include "obgtkScrolledWindow.h"

@implementation Gtk_ScrolledWindow
- castGtkScrolledWindow:(GtkScrolledWindow *) castitem
{
  gtkscrolledwindow = castitem;
  return [super castGtkContainer:GTK_CONTAINER(castitem)];
}

- init
{
  return [self initWithAdjustments:[Gtk_Adjustment new] adjV:[Gtk_Adjustment new]];
}

- initWithAdjustments:(Gtk_Adjustment *) hadjustment
  adjV:(Gtk_Adjustment *) vadjustment
{
  return [self castGtkScrolledWindow:
		 GTK_SCROLLED_WINDOW(gtk_scrolled_window_new(
							     GTK_ADJUSTMENT([hadjustment getGtkObject]),
							     GTK_ADJUSTMENT([vadjustment getGtkObject])))];
}

- (id)get_hadjustment
{
  return (id)gtk_object_get_data_by_id(GTK_OBJECT(gtk_scrolled_window_get_hadjustment(gtkscrolledwindow)),
				 OBJC_ID());
}

- (id)get_vadjustment
{
  return (id)gtk_object_get_data_by_id(GTK_OBJECT(gtk_scrolled_window_get_vadjustment(gtkscrolledwindow)),
				 OBJC_ID());
}

- set_policy:(GtkPolicyType) hscrollbar_policy
    pVScroll:(GtkPolicyType) vscrollbar_policy
{
  gtk_scrolled_window_set_policy(gtkscrolledwindow,
				 hscrollbar_policy,
				 vscrollbar_policy);
  return self;
}
@end
